// chrome/common/importer/profile_import.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/importer/profile_import.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/importer/profile_import.mojom-params-data.h"
#include "chrome/common/importer/profile_import.mojom-shared-message-ids.h"

#include "chrome/common/importer/profile_import.mojom-import-headers.h"
#include "chrome/common/importer/profile_import.mojom-test-utils.h"
#include "chrome/common/importer/profile_import_process_param_traits.h"
#include "chrome/common/importer/profile_import_process_param_traits_macros.h"


namespace chrome::mojom {
ImportedPasswordForm::ImportedPasswordForm()
    : scheme(),
      signon_realm(),
      url(),
      action(),
      username_element(),
      username_value(),
      password_element(),
      password_value(),
      blocked_by_user() {}

ImportedPasswordForm::ImportedPasswordForm(
    ImportedPasswordForm::Scheme scheme_in,
    const std::string& signon_realm_in,
    const ::GURL& url_in,
    const ::GURL& action_in,
    const ::std::u16string& username_element_in,
    const ::std::u16string& username_value_in,
    const ::std::u16string& password_element_in,
    const ::std::u16string& password_value_in,
    bool blocked_by_user_in)
    : scheme(std::move(scheme_in)),
      signon_realm(std::move(signon_realm_in)),
      url(std::move(url_in)),
      action(std::move(action_in)),
      username_element(std::move(username_element_in)),
      username_value(std::move(username_value_in)),
      password_element(std::move(password_element_in)),
      password_value(std::move(password_value_in)),
      blocked_by_user(std::move(blocked_by_user_in)) {}

ImportedPasswordForm::~ImportedPasswordForm() = default;

void ImportedPasswordForm::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImportedPasswordForm::Scheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signon_realm"), this->signon_realm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_element"), this->username_element,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_value"), this->username_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password_element"), this->password_element,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password_value"), this->password_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_by_user"), this->blocked_by_user,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImportedPasswordForm::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ProfileImportObserver::IPCStableHashFunction ProfileImportObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProfileImportObserver>(message.name())) {
    case messages::ProfileImportObserver::kOnImportStart: {
      return &ProfileImportObserver::OnImportStart_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnImportFinished: {
      return &ProfileImportObserver::OnImportFinished_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnImportItemStart: {
      return &ProfileImportObserver::OnImportItemStart_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnImportItemFinished: {
      return &ProfileImportObserver::OnImportItemFinished_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnHistoryImportStart: {
      return &ProfileImportObserver::OnHistoryImportStart_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnHistoryImportGroup: {
      return &ProfileImportObserver::OnHistoryImportGroup_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnHomePageImportReady: {
      return &ProfileImportObserver::OnHomePageImportReady_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnBookmarksImportStart: {
      return &ProfileImportObserver::OnBookmarksImportStart_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnBookmarksImportGroup: {
      return &ProfileImportObserver::OnBookmarksImportGroup_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnFaviconsImportStart: {
      return &ProfileImportObserver::OnFaviconsImportStart_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnFaviconsImportGroup: {
      return &ProfileImportObserver::OnFaviconsImportGroup_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnPasswordFormImportReady: {
      return &ProfileImportObserver::OnPasswordFormImportReady_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnKeywordsImportReady: {
      return &ProfileImportObserver::OnKeywordsImportReady_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnAutofillFormDataImportStart: {
      return &ProfileImportObserver::OnAutofillFormDataImportStart_Sym::IPCStableHash;
    }
    case messages::ProfileImportObserver::kOnAutofillFormDataImportGroup: {
      return &ProfileImportObserver::OnAutofillFormDataImportGroup_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProfileImportObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProfileImportObserver>(message.name())) {
      case messages::ProfileImportObserver::kOnImportStart:
            return "Receive chrome::mojom::ProfileImportObserver::OnImportStart";
      case messages::ProfileImportObserver::kOnImportFinished:
            return "Receive chrome::mojom::ProfileImportObserver::OnImportFinished";
      case messages::ProfileImportObserver::kOnImportItemStart:
            return "Receive chrome::mojom::ProfileImportObserver::OnImportItemStart";
      case messages::ProfileImportObserver::kOnImportItemFinished:
            return "Receive chrome::mojom::ProfileImportObserver::OnImportItemFinished";
      case messages::ProfileImportObserver::kOnHistoryImportStart:
            return "Receive chrome::mojom::ProfileImportObserver::OnHistoryImportStart";
      case messages::ProfileImportObserver::kOnHistoryImportGroup:
            return "Receive chrome::mojom::ProfileImportObserver::OnHistoryImportGroup";
      case messages::ProfileImportObserver::kOnHomePageImportReady:
            return "Receive chrome::mojom::ProfileImportObserver::OnHomePageImportReady";
      case messages::ProfileImportObserver::kOnBookmarksImportStart:
            return "Receive chrome::mojom::ProfileImportObserver::OnBookmarksImportStart";
      case messages::ProfileImportObserver::kOnBookmarksImportGroup:
            return "Receive chrome::mojom::ProfileImportObserver::OnBookmarksImportGroup";
      case messages::ProfileImportObserver::kOnFaviconsImportStart:
            return "Receive chrome::mojom::ProfileImportObserver::OnFaviconsImportStart";
      case messages::ProfileImportObserver::kOnFaviconsImportGroup:
            return "Receive chrome::mojom::ProfileImportObserver::OnFaviconsImportGroup";
      case messages::ProfileImportObserver::kOnPasswordFormImportReady:
            return "Receive chrome::mojom::ProfileImportObserver::OnPasswordFormImportReady";
      case messages::ProfileImportObserver::kOnKeywordsImportReady:
            return "Receive chrome::mojom::ProfileImportObserver::OnKeywordsImportReady";
      case messages::ProfileImportObserver::kOnAutofillFormDataImportStart:
            return "Receive chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportStart";
      case messages::ProfileImportObserver::kOnAutofillFormDataImportGroup:
            return "Receive chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportGroup";
    }
  } else {
    switch (static_cast<messages::ProfileImportObserver>(message.name())) {
      case messages::ProfileImportObserver::kOnImportStart:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnImportStart";
      case messages::ProfileImportObserver::kOnImportFinished:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnImportFinished";
      case messages::ProfileImportObserver::kOnImportItemStart:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnImportItemStart";
      case messages::ProfileImportObserver::kOnImportItemFinished:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnImportItemFinished";
      case messages::ProfileImportObserver::kOnHistoryImportStart:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnHistoryImportStart";
      case messages::ProfileImportObserver::kOnHistoryImportGroup:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnHistoryImportGroup";
      case messages::ProfileImportObserver::kOnHomePageImportReady:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnHomePageImportReady";
      case messages::ProfileImportObserver::kOnBookmarksImportStart:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnBookmarksImportStart";
      case messages::ProfileImportObserver::kOnBookmarksImportGroup:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnBookmarksImportGroup";
      case messages::ProfileImportObserver::kOnFaviconsImportStart:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnFaviconsImportStart";
      case messages::ProfileImportObserver::kOnFaviconsImportGroup:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnFaviconsImportGroup";
      case messages::ProfileImportObserver::kOnPasswordFormImportReady:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnPasswordFormImportReady";
      case messages::ProfileImportObserver::kOnKeywordsImportReady:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnKeywordsImportReady";
      case messages::ProfileImportObserver::kOnAutofillFormDataImportStart:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportStart";
      case messages::ProfileImportObserver::kOnAutofillFormDataImportGroup:
            return "Receive reply chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportGroup";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProfileImportObserver::OnImportStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7a81ae5;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnImportStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnImportFinished_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78f69f0e;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnImportFinished
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnImportItemStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3bee9e4;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnImportItemStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnImportItemFinished_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05c75162;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnImportItemFinished
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnHistoryImportStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x888c1601;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnHistoryImportStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnHistoryImportGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61dbfa26;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnHistoryImportGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnHomePageImportReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffa310ac;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnHomePageImportReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnBookmarksImportStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad2d4a62;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnBookmarksImportStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnBookmarksImportGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4996c4a;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnBookmarksImportGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnFaviconsImportStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5d33962;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnFaviconsImportStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnFaviconsImportGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a6065b3;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnFaviconsImportGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnPasswordFormImportReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x849a16b5;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnPasswordFormImportReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnKeywordsImportReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7998eb8e;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnKeywordsImportReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnAutofillFormDataImportStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdce221e2;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImportObserver::OnAutofillFormDataImportGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5671e24;  // IPCStableHash for chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProfileImportObserverProxy::ProfileImportObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfileImportObserverProxy::OnImportStart(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ProfileImportObserver::OnImportStart");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnImportStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnImportStart_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnImportStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnImportFinished(
    bool in_succeeded, const std::string& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnImportFinished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("succeeded"), in_succeeded,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msg"), in_error_msg,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnImportFinished), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnImportFinished_Params_Data> params(
          message);
  params.Allocate();

  params->succeeded = in_succeeded;
  mojo::internal::MessageFragment<
      typename decltype(params->error_msg)::BaseType> error_msg_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_msg,
    error_msg_fragment);

  params->error_msg.Set(
      error_msg_fragment.is_null() ? nullptr : error_msg_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_msg.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_msg in ProfileImportObserver.OnImportFinished request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnImportFinished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnImportItemStart(
    ::user_data_importer::ImportItem in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnImportItemStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type ::user_data_importer::ImportItem>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnImportItemStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnImportItemStart_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::ImportItem>(
    in_item,
    &params->item);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnImportItemStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnImportItemFinished(
    ::user_data_importer::ImportItem in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnImportItemFinished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type ::user_data_importer::ImportItem>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnImportItemFinished), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnImportItemFinished_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::ImportItem>(
    in_item,
    &params->item);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnImportItemFinished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnHistoryImportStart(
    uint32_t in_total_history_rows_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnHistoryImportStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_history_rows_count"), in_total_history_rows_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnHistoryImportStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnHistoryImportStart_Params_Data> params(
          message);
  params.Allocate();

  params->total_history_rows_count = in_total_history_rows_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnHistoryImportStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnHistoryImportGroup(
    const std::vector<::user_data_importer::ImporterURLRow>& in_history_rows_group, int32_t in_visit_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnHistoryImportGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("history_rows_group"), in_history_rows_group,
                        "<value of type const std::vector<::user_data_importer::ImporterURLRow>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visit_source"), in_visit_source,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnHistoryImportGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnHistoryImportGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->history_rows_group)::BaseType>
      history_rows_group_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& history_rows_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::ImporterURLRowDataView>>(
    in_history_rows_group,
    history_rows_group_fragment,
    &history_rows_group_validate_params);

  params->history_rows_group.Set(
      history_rows_group_fragment.is_null() ? nullptr : history_rows_group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->history_rows_group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null history_rows_group in ProfileImportObserver.OnHistoryImportGroup request");

  params->visit_source = in_visit_source;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnHistoryImportGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnHomePageImportReady(
    const ::GURL& in_home_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnHomePageImportReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("home_page"), in_home_page,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnHomePageImportReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnHomePageImportReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->home_page)::BaseType> home_page_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_home_page,
    home_page_fragment);

  params->home_page.Set(
      home_page_fragment.is_null() ? nullptr : home_page_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->home_page.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null home_page in ProfileImportObserver.OnHomePageImportReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnHomePageImportReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnBookmarksImportStart(
    const ::std::u16string& in_first_folder_name, uint32_t in_total_bookmarks_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnBookmarksImportStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("first_folder_name"), in_first_folder_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_bookmarks_count"), in_total_bookmarks_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnBookmarksImportStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnBookmarksImportStart_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->first_folder_name)::BaseType> first_folder_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_first_folder_name,
    first_folder_name_fragment);

  params->first_folder_name.Set(
      first_folder_name_fragment.is_null() ? nullptr : first_folder_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->first_folder_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null first_folder_name in ProfileImportObserver.OnBookmarksImportStart request");

  params->total_bookmarks_count = in_total_bookmarks_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnBookmarksImportStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnBookmarksImportGroup(
    const std::vector<::user_data_importer::ImportedBookmarkEntry>& in_bookmarks_group) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnBookmarksImportGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmarks_group"), in_bookmarks_group,
                        "<value of type const std::vector<::user_data_importer::ImportedBookmarkEntry>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnBookmarksImportGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnBookmarksImportGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmarks_group)::BaseType>
      bookmarks_group_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bookmarks_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::ImportedBookmarkEntryDataView>>(
    in_bookmarks_group,
    bookmarks_group_fragment,
    &bookmarks_group_validate_params);

  params->bookmarks_group.Set(
      bookmarks_group_fragment.is_null() ? nullptr : bookmarks_group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmarks_group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmarks_group in ProfileImportObserver.OnBookmarksImportGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnBookmarksImportGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnFaviconsImportStart(
    uint32_t in_total_favicons_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnFaviconsImportStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_favicons_count"), in_total_favicons_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnFaviconsImportStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnFaviconsImportStart_Params_Data> params(
          message);
  params.Allocate();

  params->total_favicons_count = in_total_favicons_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnFaviconsImportStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnFaviconsImportGroup(
    const ::favicon_base::FaviconUsageDataList& in_favicons_group) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnFaviconsImportGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("favicons_group"), in_favicons_group,
                        "<value of type const ::favicon_base::FaviconUsageDataList&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnFaviconsImportGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnFaviconsImportGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->favicons_group)::BaseType> favicons_group_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::FaviconUsageDataListDataView>(
    in_favicons_group,
    favicons_group_fragment);

  params->favicons_group.Set(
      favicons_group_fragment.is_null() ? nullptr : favicons_group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->favicons_group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null favicons_group in ProfileImportObserver.OnFaviconsImportGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnFaviconsImportGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnPasswordFormImportReady(
    const ::user_data_importer::ImportedPasswordForm& in_form) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnPasswordFormImportReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("form"), in_form,
                        "<value of type const ::user_data_importer::ImportedPasswordForm&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnPasswordFormImportReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnPasswordFormImportReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->form)::BaseType> form_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::ImportedPasswordFormDataView>(
    in_form,
    form_fragment);

  params->form.Set(
      form_fragment.is_null() ? nullptr : form_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->form.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null form in ProfileImportObserver.OnPasswordFormImportReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnPasswordFormImportReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnKeywordsImportReady(
    const std::vector<::user_data_importer::SearchEngineInfo>& in_search_engines, bool in_unique_on_host_and_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnKeywordsImportReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("search_engines"), in_search_engines,
                        "<value of type const std::vector<::user_data_importer::SearchEngineInfo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_on_host_and_path"), in_unique_on_host_and_path,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnKeywordsImportReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnKeywordsImportReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->search_engines)::BaseType>
      search_engines_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& search_engines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::SearchEngineInfoDataView>>(
    in_search_engines,
    search_engines_fragment,
    &search_engines_validate_params);

  params->search_engines.Set(
      search_engines_fragment.is_null() ? nullptr : search_engines_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->search_engines.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null search_engines in ProfileImportObserver.OnKeywordsImportReady request");

  params->unique_on_host_and_path = in_unique_on_host_and_path;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnKeywordsImportReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnAutofillFormDataImportStart(
    uint32_t in_total_autofill_form_data_entry_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_autofill_form_data_entry_count"), in_total_autofill_form_data_entry_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnAutofillFormDataImportStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data> params(
          message);
  params.Allocate();

  params->total_autofill_form_data_entry_count = in_total_autofill_form_data_entry_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnAutofillFormDataImportStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportObserverProxy::OnAutofillFormDataImportGroup(
    const std::vector<::ImporterAutofillFormDataEntry>& in_autofill_form_data_entry_group) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImportObserver::OnAutofillFormDataImportGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autofill_form_data_entry_group"), in_autofill_form_data_entry_group,
                        "<value of type const std::vector<::ImporterAutofillFormDataEntry>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImportObserver::kOnAutofillFormDataImportGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->autofill_form_data_entry_group)::BaseType>
      autofill_form_data_entry_group_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& autofill_form_data_entry_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::ImporterAutofillFormDataEntryDataView>>(
    in_autofill_form_data_entry_group,
    autofill_form_data_entry_group_fragment,
    &autofill_form_data_entry_group_validate_params);

  params->autofill_form_data_entry_group.Set(
      autofill_form_data_entry_group_fragment.is_null() ? nullptr : autofill_form_data_entry_group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->autofill_form_data_entry_group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null autofill_form_data_entry_group in ProfileImportObserver.OnAutofillFormDataImportGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImportObserver::Name_);
  message.set_method_name("OnAutofillFormDataImportGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProfileImportObserverStubDispatch::Accept(
    ProfileImportObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProfileImportObserver>(message->header()->name)) {
    case messages::ProfileImportObserver::kOnImportStart: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnImportStart_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnImportStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.0
      bool success = true;
      ProfileImportObserver_OnImportStart_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImportStart(        );
      return true;
    }
    case messages::ProfileImportObserver::kOnImportFinished: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnImportFinished_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnImportFinished_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.1
      bool success = true;
      bool p_succeeded{};
      std::string p_error_msg{};
      ProfileImportObserver_OnImportFinished_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_succeeded = input_data_view.succeeded();
      if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImportFinished(        
        std::move(p_succeeded), 
        std::move(p_error_msg));
      return true;
    }
    case messages::ProfileImportObserver::kOnImportItemStart: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnImportItemStart_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnImportItemStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.2
      bool success = true;
      ::user_data_importer::ImportItem p_item{};
      ProfileImportObserver_OnImportItemStart_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImportItemStart(        
        std::move(p_item));
      return true;
    }
    case messages::ProfileImportObserver::kOnImportItemFinished: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnImportItemFinished_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnImportItemFinished_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.3
      bool success = true;
      ::user_data_importer::ImportItem p_item{};
      ProfileImportObserver_OnImportItemFinished_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImportItemFinished(        
        std::move(p_item));
      return true;
    }
    case messages::ProfileImportObserver::kOnHistoryImportStart: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnHistoryImportStart_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnHistoryImportStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.4
      bool success = true;
      uint32_t p_total_history_rows_count{};
      ProfileImportObserver_OnHistoryImportStart_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_history_rows_count = input_data_view.total_history_rows_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHistoryImportStart(        
        std::move(p_total_history_rows_count));
      return true;
    }
    case messages::ProfileImportObserver::kOnHistoryImportGroup: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnHistoryImportGroup_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnHistoryImportGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.5
      bool success = true;
      std::vector<::user_data_importer::ImporterURLRow> p_history_rows_group{};
      int32_t p_visit_source{};
      ProfileImportObserver_OnHistoryImportGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistoryRowsGroup(&p_history_rows_group))
        success = false;
      if (success)
        p_visit_source = input_data_view.visit_source();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHistoryImportGroup(        
        std::move(p_history_rows_group), 
        std::move(p_visit_source));
      return true;
    }
    case messages::ProfileImportObserver::kOnHomePageImportReady: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnHomePageImportReady_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnHomePageImportReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.6
      bool success = true;
      ::GURL p_home_page{};
      ProfileImportObserver_OnHomePageImportReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHomePage(&p_home_page))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHomePageImportReady(        
        std::move(p_home_page));
      return true;
    }
    case messages::ProfileImportObserver::kOnBookmarksImportStart: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnBookmarksImportStart_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnBookmarksImportStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.7
      bool success = true;
      ::std::u16string p_first_folder_name{};
      uint32_t p_total_bookmarks_count{};
      ProfileImportObserver_OnBookmarksImportStart_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFirstFolderName(&p_first_folder_name))
        success = false;
      if (success)
        p_total_bookmarks_count = input_data_view.total_bookmarks_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarksImportStart(        
        std::move(p_first_folder_name), 
        std::move(p_total_bookmarks_count));
      return true;
    }
    case messages::ProfileImportObserver::kOnBookmarksImportGroup: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnBookmarksImportGroup_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnBookmarksImportGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.8
      bool success = true;
      std::vector<::user_data_importer::ImportedBookmarkEntry> p_bookmarks_group{};
      ProfileImportObserver_OnBookmarksImportGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBookmarksGroup(&p_bookmarks_group))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarksImportGroup(        
        std::move(p_bookmarks_group));
      return true;
    }
    case messages::ProfileImportObserver::kOnFaviconsImportStart: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnFaviconsImportStart_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnFaviconsImportStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.9
      bool success = true;
      uint32_t p_total_favicons_count{};
      ProfileImportObserver_OnFaviconsImportStart_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_favicons_count = input_data_view.total_favicons_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFaviconsImportStart(        
        std::move(p_total_favicons_count));
      return true;
    }
    case messages::ProfileImportObserver::kOnFaviconsImportGroup: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnFaviconsImportGroup_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnFaviconsImportGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.10
      bool success = true;
      ::favicon_base::FaviconUsageDataList p_favicons_group{};
      ProfileImportObserver_OnFaviconsImportGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFaviconsGroup(&p_favicons_group))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFaviconsImportGroup(        
        std::move(p_favicons_group));
      return true;
    }
    case messages::ProfileImportObserver::kOnPasswordFormImportReady: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnPasswordFormImportReady_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnPasswordFormImportReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.11
      bool success = true;
      ::user_data_importer::ImportedPasswordForm p_form{};
      ProfileImportObserver_OnPasswordFormImportReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadForm(&p_form))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPasswordFormImportReady(        
        std::move(p_form));
      return true;
    }
    case messages::ProfileImportObserver::kOnKeywordsImportReady: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnKeywordsImportReady_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnKeywordsImportReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.12
      bool success = true;
      std::vector<::user_data_importer::SearchEngineInfo> p_search_engines{};
      bool p_unique_on_host_and_path{};
      ProfileImportObserver_OnKeywordsImportReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSearchEngines(&p_search_engines))
        success = false;
      if (success)
        p_unique_on_host_and_path = input_data_view.unique_on_host_and_path();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnKeywordsImportReady(        
        std::move(p_search_engines), 
        std::move(p_unique_on_host_and_path));
      return true;
    }
    case messages::ProfileImportObserver::kOnAutofillFormDataImportStart: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.13
      bool success = true;
      uint32_t p_total_autofill_form_data_entry_count{};
      ProfileImportObserver_OnAutofillFormDataImportStart_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_autofill_form_data_entry_count = input_data_view.total_autofill_form_data_entry_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAutofillFormDataImportStart(        
        std::move(p_total_autofill_form_data_entry_count));
      return true;
    }
    case messages::ProfileImportObserver::kOnAutofillFormDataImportGroup: {
      DCHECK(message->is_serialized());
      internal::ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data* params =
          reinterpret_cast<internal::ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImportObserver.14
      bool success = true;
      std::vector<::ImporterAutofillFormDataEntry> p_autofill_form_data_entry_group{};
      ProfileImportObserver_OnAutofillFormDataImportGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAutofillFormDataEntryGroup(&p_autofill_form_data_entry_group))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImportObserver::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAutofillFormDataImportGroup(        
        std::move(p_autofill_form_data_entry_group));
      return true;
    }
  }
  return false;
}

// static
bool ProfileImportObserverStubDispatch::AcceptWithResponder(
    ProfileImportObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProfileImportObserver>(message->header()->name)) {
    case messages::ProfileImportObserver::kOnImportStart: {
      break;
    }
    case messages::ProfileImportObserver::kOnImportFinished: {
      break;
    }
    case messages::ProfileImportObserver::kOnImportItemStart: {
      break;
    }
    case messages::ProfileImportObserver::kOnImportItemFinished: {
      break;
    }
    case messages::ProfileImportObserver::kOnHistoryImportStart: {
      break;
    }
    case messages::ProfileImportObserver::kOnHistoryImportGroup: {
      break;
    }
    case messages::ProfileImportObserver::kOnHomePageImportReady: {
      break;
    }
    case messages::ProfileImportObserver::kOnBookmarksImportStart: {
      break;
    }
    case messages::ProfileImportObserver::kOnBookmarksImportGroup: {
      break;
    }
    case messages::ProfileImportObserver::kOnFaviconsImportStart: {
      break;
    }
    case messages::ProfileImportObserver::kOnFaviconsImportGroup: {
      break;
    }
    case messages::ProfileImportObserver::kOnPasswordFormImportReady: {
      break;
    }
    case messages::ProfileImportObserver::kOnKeywordsImportReady: {
      break;
    }
    case messages::ProfileImportObserver::kOnAutofillFormDataImportStart: {
      break;
    }
    case messages::ProfileImportObserver::kOnAutofillFormDataImportGroup: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfileImportObserverValidationInfo[] = {
    { &internal::ProfileImportObserver_OnImportStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnImportFinished_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnImportItemStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnImportItemFinished_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnHistoryImportStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnHistoryImportGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnHomePageImportReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnBookmarksImportStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnBookmarksImportGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnFaviconsImportStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnFaviconsImportGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnPasswordFormImportReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnKeywordsImportReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnAutofillFormDataImportStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImportObserver_OnAutofillFormDataImportGroup_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProfileImportObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::ProfileImportObserver::Name_,
    kProfileImportObserverValidationInfo);
}

// The declaration includes the definition on other builds.

ProfileImport::IPCStableHashFunction ProfileImport::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProfileImport>(message.name())) {
    case messages::ProfileImport::kStartImport: {
      return &ProfileImport::StartImport_Sym::IPCStableHash;
    }
    case messages::ProfileImport::kCancelImport: {
      return &ProfileImport::CancelImport_Sym::IPCStableHash;
    }
    case messages::ProfileImport::kReportImportItemFinished: {
      return &ProfileImport::ReportImportItemFinished_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProfileImport::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProfileImport>(message.name())) {
      case messages::ProfileImport::kStartImport:
            return "Receive chrome::mojom::ProfileImport::StartImport";
      case messages::ProfileImport::kCancelImport:
            return "Receive chrome::mojom::ProfileImport::CancelImport";
      case messages::ProfileImport::kReportImportItemFinished:
            return "Receive chrome::mojom::ProfileImport::ReportImportItemFinished";
    }
  } else {
    switch (static_cast<messages::ProfileImport>(message.name())) {
      case messages::ProfileImport::kStartImport:
            return "Receive reply chrome::mojom::ProfileImport::StartImport";
      case messages::ProfileImport::kCancelImport:
            return "Receive reply chrome::mojom::ProfileImport::CancelImport";
      case messages::ProfileImport::kReportImportItemFinished:
            return "Receive reply chrome::mojom::ProfileImport::ReportImportItemFinished";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProfileImport::StartImport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6655074d;  // IPCStableHash for chrome::mojom::ProfileImport::StartImport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImport::CancelImport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47a67db8;  // IPCStableHash for chrome::mojom::ProfileImport::CancelImport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileImport::ReportImportItemFinished_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf678a33;  // IPCStableHash for chrome::mojom::ProfileImport::ReportImportItemFinished
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProfileImportProxy::ProfileImportProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfileImportProxy::StartImport(
    const ::user_data_importer::SourceProfile& in_source_profile, uint16_t in_items, const base::flat_map<uint32_t, std::string>& in_localized_strings, ::mojo::PendingRemote<ProfileImportObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImport::StartImport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_profile"), in_source_profile,
                        "<value of type const ::user_data_importer::SourceProfile&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("items"), in_items,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("localized_strings"), in_localized_strings,
                        "<value of type const base::flat_map<uint32_t, std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<ProfileImportObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImport::kStartImport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImport_StartImport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_profile)::BaseType> source_profile_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::SourceProfileDataView>(
    in_source_profile,
    source_profile_fragment);

  params->source_profile.Set(
      source_profile_fragment.is_null() ? nullptr : source_profile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_profile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_profile in ProfileImport.StartImport request");

  params->items = in_items;
  mojo::internal::MessageFragment<
      typename decltype(params->localized_strings)::BaseType>
      localized_strings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& localized_strings_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, mojo::StringDataView>>(
    in_localized_strings,
    localized_strings_fragment,
    &localized_strings_validate_params);

  params->localized_strings.Set(
      localized_strings_fragment.is_null() ? nullptr : localized_strings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->localized_strings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null localized_strings in ProfileImport.StartImport request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::ProfileImportObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in ProfileImport.StartImport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImport::Name_);
  message.set_method_name("StartImport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportProxy::CancelImport(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::ProfileImport::CancelImport");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImport::kCancelImport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImport_CancelImport_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImport::Name_);
  message.set_method_name("CancelImport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileImportProxy::ReportImportItemFinished(
    ::user_data_importer::ImportItem in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::ProfileImport::ReportImportItemFinished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type ::user_data_importer::ImportItem>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileImport::kReportImportItemFinished), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::ProfileImport_ReportImportItemFinished_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::ImportItem>(
    in_item,
    &params->item);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileImport::Name_);
  message.set_method_name("ReportImportItemFinished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProfileImportStubDispatch::Accept(
    ProfileImport* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProfileImport>(message->header()->name)) {
    case messages::ProfileImport::kStartImport: {
      DCHECK(message->is_serialized());
      internal::ProfileImport_StartImport_Params_Data* params =
          reinterpret_cast<internal::ProfileImport_StartImport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImport.0
      bool success = true;
      ::user_data_importer::SourceProfile p_source_profile{};
      uint16_t p_items{};
      base::flat_map<uint32_t, std::string> p_localized_strings{};
      ::mojo::PendingRemote<ProfileImportObserver> p_observer{};
      ProfileImport_StartImport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceProfile(&p_source_profile))
        success = false;
      if (success)
        p_items = input_data_view.items();
      if (success && !input_data_view.ReadLocalizedStrings(&p_localized_strings))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImport::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartImport(        
        std::move(p_source_profile), 
        std::move(p_items), 
        std::move(p_localized_strings), 
        std::move(p_observer));
      return true;
    }
    case messages::ProfileImport::kCancelImport: {
      DCHECK(message->is_serialized());
      internal::ProfileImport_CancelImport_Params_Data* params =
          reinterpret_cast<internal::ProfileImport_CancelImport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImport.1
      bool success = true;
      ProfileImport_CancelImport_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImport::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelImport(        );
      return true;
    }
    case messages::ProfileImport::kReportImportItemFinished: {
      DCHECK(message->is_serialized());
      internal::ProfileImport_ReportImportItemFinished_Params_Data* params =
          reinterpret_cast<internal::ProfileImport_ReportImportItemFinished_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileImport.2
      bool success = true;
      ::user_data_importer::ImportItem p_item{};
      ProfileImport_ReportImportItemFinished_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileImport::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportImportItemFinished(        
        std::move(p_item));
      return true;
    }
  }
  return false;
}

// static
bool ProfileImportStubDispatch::AcceptWithResponder(
    ProfileImport* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProfileImport>(message->header()->name)) {
    case messages::ProfileImport::kStartImport: {
      break;
    }
    case messages::ProfileImport::kCancelImport: {
      break;
    }
    case messages::ProfileImport::kReportImportItemFinished: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfileImportValidationInfo[] = {
    { &internal::ProfileImport_StartImport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImport_CancelImport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileImport_ReportImportItemFinished_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProfileImportRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::ProfileImport::Name_,
    kProfileImportValidationInfo);
}



}  // chrome::mojom


namespace mojo {


// static
bool StructTraits<::chrome::mojom::ImportedPasswordForm::DataView, ::chrome::mojom::ImportedPasswordFormPtr>::Read(
    ::chrome::mojom::ImportedPasswordForm::DataView input,
    ::chrome::mojom::ImportedPasswordFormPtr* output) {
  bool success = true;
  ::chrome::mojom::ImportedPasswordFormPtr result(::chrome::mojom::ImportedPasswordForm::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadSignonRealm(&result->signon_realm))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadUsernameElement(&result->username_element))
        success = false;
      if (success && !input.ReadUsernameValue(&result->username_value))
        success = false;
      if (success && !input.ReadPasswordElement(&result->password_element))
        success = false;
      if (success && !input.ReadPasswordValue(&result->password_value))
        success = false;
      if (success)
        result->blocked_by_user = input.blocked_by_user();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void ProfileImportObserverInterceptorForTesting::OnImportStart() {
  GetForwardingInterface()->OnImportStart();
}
void ProfileImportObserverInterceptorForTesting::OnImportFinished(bool succeeded, const std::string& error_msg) {
  GetForwardingInterface()->OnImportFinished(
    std::move(succeeded)
    , 
    std::move(error_msg)
    );
}
void ProfileImportObserverInterceptorForTesting::OnImportItemStart(::user_data_importer::ImportItem item) {
  GetForwardingInterface()->OnImportItemStart(
    std::move(item)
    );
}
void ProfileImportObserverInterceptorForTesting::OnImportItemFinished(::user_data_importer::ImportItem item) {
  GetForwardingInterface()->OnImportItemFinished(
    std::move(item)
    );
}
void ProfileImportObserverInterceptorForTesting::OnHistoryImportStart(uint32_t total_history_rows_count) {
  GetForwardingInterface()->OnHistoryImportStart(
    std::move(total_history_rows_count)
    );
}
void ProfileImportObserverInterceptorForTesting::OnHistoryImportGroup(const std::vector<::user_data_importer::ImporterURLRow>& history_rows_group, int32_t visit_source) {
  GetForwardingInterface()->OnHistoryImportGroup(
    std::move(history_rows_group)
    , 
    std::move(visit_source)
    );
}
void ProfileImportObserverInterceptorForTesting::OnHomePageImportReady(const ::GURL& home_page) {
  GetForwardingInterface()->OnHomePageImportReady(
    std::move(home_page)
    );
}
void ProfileImportObserverInterceptorForTesting::OnBookmarksImportStart(const ::std::u16string& first_folder_name, uint32_t total_bookmarks_count) {
  GetForwardingInterface()->OnBookmarksImportStart(
    std::move(first_folder_name)
    , 
    std::move(total_bookmarks_count)
    );
}
void ProfileImportObserverInterceptorForTesting::OnBookmarksImportGroup(const std::vector<::user_data_importer::ImportedBookmarkEntry>& bookmarks_group) {
  GetForwardingInterface()->OnBookmarksImportGroup(
    std::move(bookmarks_group)
    );
}
void ProfileImportObserverInterceptorForTesting::OnFaviconsImportStart(uint32_t total_favicons_count) {
  GetForwardingInterface()->OnFaviconsImportStart(
    std::move(total_favicons_count)
    );
}
void ProfileImportObserverInterceptorForTesting::OnFaviconsImportGroup(const ::favicon_base::FaviconUsageDataList& favicons_group) {
  GetForwardingInterface()->OnFaviconsImportGroup(
    std::move(favicons_group)
    );
}
void ProfileImportObserverInterceptorForTesting::OnPasswordFormImportReady(const ::user_data_importer::ImportedPasswordForm& form) {
  GetForwardingInterface()->OnPasswordFormImportReady(
    std::move(form)
    );
}
void ProfileImportObserverInterceptorForTesting::OnKeywordsImportReady(const std::vector<::user_data_importer::SearchEngineInfo>& search_engines, bool unique_on_host_and_path) {
  GetForwardingInterface()->OnKeywordsImportReady(
    std::move(search_engines)
    , 
    std::move(unique_on_host_and_path)
    );
}
void ProfileImportObserverInterceptorForTesting::OnAutofillFormDataImportStart(uint32_t total_autofill_form_data_entry_count) {
  GetForwardingInterface()->OnAutofillFormDataImportStart(
    std::move(total_autofill_form_data_entry_count)
    );
}
void ProfileImportObserverInterceptorForTesting::OnAutofillFormDataImportGroup(const std::vector<::ImporterAutofillFormDataEntry>& autofill_form_data_entry_group) {
  GetForwardingInterface()->OnAutofillFormDataImportGroup(
    std::move(autofill_form_data_entry_group)
    );
}
ProfileImportObserverAsyncWaiter::ProfileImportObserverAsyncWaiter(
    ProfileImportObserver* proxy) : proxy_(proxy) {}

ProfileImportObserverAsyncWaiter::~ProfileImportObserverAsyncWaiter() = default;





void ProfileImportInterceptorForTesting::StartImport(const ::user_data_importer::SourceProfile& source_profile, uint16_t items, const base::flat_map<uint32_t, std::string>& localized_strings, ::mojo::PendingRemote<ProfileImportObserver> observer) {
  GetForwardingInterface()->StartImport(
    std::move(source_profile)
    , 
    std::move(items)
    , 
    std::move(localized_strings)
    , 
    std::move(observer)
    );
}
void ProfileImportInterceptorForTesting::CancelImport() {
  GetForwardingInterface()->CancelImport();
}
void ProfileImportInterceptorForTesting::ReportImportItemFinished(::user_data_importer::ImportItem item) {
  GetForwardingInterface()->ReportImportItemFinished(
    std::move(item)
    );
}
ProfileImportAsyncWaiter::ProfileImportAsyncWaiter(
    ProfileImport* proxy) : proxy_(proxy) {}

ProfileImportAsyncWaiter::~ProfileImportAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif