// chrome/common/compose/compose.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/compose/compose.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/compose/compose.mojom-params-data.h"
#include "chrome/common/compose/compose.mojom-shared-message-ids.h"

#include "chrome/common/compose/compose.mojom-import-headers.h"
#include "chrome/common/compose/compose.mojom-test-utils.h"


namespace compose::mojom {
ComposeResponse::ComposeResponse()
    : status(),
      result(),
      undo_available(),
      redo_available(),
      provided_by_user(),
      on_device_evaluation_used(),
      triggered_from_modifier() {}

ComposeResponse::ComposeResponse(
    ::compose::mojom::ComposeStatus status_in,
    const std::string& result_in,
    bool undo_available_in,
    bool redo_available_in,
    bool provided_by_user_in,
    bool on_device_evaluation_used_in,
    bool triggered_from_modifier_in)
    : status(std::move(status_in)),
      result(std::move(result_in)),
      undo_available(std::move(undo_available_in)),
      redo_available(std::move(redo_available_in)),
      provided_by_user(std::move(provided_by_user_in)),
      on_device_evaluation_used(std::move(on_device_evaluation_used_in)),
      triggered_from_modifier(std::move(triggered_from_modifier_in)) {}

ComposeResponse::~ComposeResponse() = default;
size_t ComposeResponse::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->result);
  seed = mojo::internal::Hash(seed, this->undo_available);
  seed = mojo::internal::Hash(seed, this->redo_available);
  seed = mojo::internal::Hash(seed, this->provided_by_user);
  seed = mojo::internal::Hash(seed, this->on_device_evaluation_used);
  seed = mojo::internal::Hash(seed, this->triggered_from_modifier);
  return seed;
}

void ComposeResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::compose::mojom::ComposeStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "undo_available"), this->undo_available,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redo_available"), this->redo_available,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provided_by_user"), this->provided_by_user,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "on_device_evaluation_used"), this->on_device_evaluation_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "triggered_from_modifier"), this->triggered_from_modifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ComposeResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PartialComposeResponse::PartialComposeResponse()
    : result() {}

PartialComposeResponse::PartialComposeResponse(
    const std::string& result_in)
    : result(std::move(result_in)) {}

PartialComposeResponse::~PartialComposeResponse() = default;
size_t PartialComposeResponse::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->result);
  return seed;
}

void PartialComposeResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PartialComposeResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ComposeState::ComposeState()
    : webui_state(),
      response(),
      has_pending_request(),
      feedback() {}

ComposeState::ComposeState(
    const std::string& webui_state_in,
    ComposeResponsePtr response_in,
    bool has_pending_request_in,
    UserFeedback feedback_in)
    : webui_state(std::move(webui_state_in)),
      response(std::move(response_in)),
      has_pending_request(std::move(has_pending_request_in)),
      feedback(std::move(feedback_in)) {}

ComposeState::~ComposeState() = default;

void ComposeState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webui_state"), this->webui_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ComposeResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_pending_request"), this->has_pending_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feedback"), this->feedback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserFeedback>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ComposeState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConfigurableParams::ConfigurableParams()
    : min_word_limit(),
      max_word_limit(),
      max_character_limit() {}

ConfigurableParams::ConfigurableParams(
    int32_t min_word_limit_in,
    int32_t max_word_limit_in,
    int32_t max_character_limit_in)
    : min_word_limit(std::move(min_word_limit_in)),
      max_word_limit(std::move(max_word_limit_in)),
      max_character_limit(std::move(max_character_limit_in)) {}

ConfigurableParams::~ConfigurableParams() = default;
size_t ConfigurableParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->min_word_limit);
  seed = mojo::internal::Hash(seed, this->max_word_limit);
  seed = mojo::internal::Hash(seed, this->max_character_limit);
  return seed;
}

void ConfigurableParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_word_limit"), this->min_word_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_word_limit"), this->max_word_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_character_limit"), this->max_character_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConfigurableParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenMetadata::OpenMetadata()
    : fre_complete(),
      msbb_state(),
      initial_input(),
      text_selected(),
      compose_state(),
      configurable_params() {}

OpenMetadata::OpenMetadata(
    bool fre_complete_in,
    bool msbb_state_in,
    const std::string& initial_input_in,
    bool text_selected_in,
    ComposeStatePtr compose_state_in,
    ConfigurableParamsPtr configurable_params_in)
    : fre_complete(std::move(fre_complete_in)),
      msbb_state(std::move(msbb_state_in)),
      initial_input(std::move(initial_input_in)),
      text_selected(std::move(text_selected_in)),
      compose_state(std::move(compose_state_in)),
      configurable_params(std::move(configurable_params_in)) {}

OpenMetadata::~OpenMetadata() = default;

void OpenMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fre_complete"), this->fre_complete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "msbb_state"), this->msbb_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_input"), this->initial_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_selected"), this->text_selected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compose_state"), this->compose_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ComposeStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "configurable_params"), this->configurable_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConfigurableParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OpenMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ComposeSessionUntrustedPageHandlerFactory::IPCStableHashFunction ComposeSessionUntrustedPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ComposeSessionUntrustedPageHandlerFactory>(message.name())) {
    case messages::ComposeSessionUntrustedPageHandlerFactory::kCreateComposeSessionUntrustedPageHandler: {
      return &ComposeSessionUntrustedPageHandlerFactory::CreateComposeSessionUntrustedPageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ComposeSessionUntrustedPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ComposeSessionUntrustedPageHandlerFactory>(message.name())) {
      case messages::ComposeSessionUntrustedPageHandlerFactory::kCreateComposeSessionUntrustedPageHandler:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandlerFactory::CreateComposeSessionUntrustedPageHandler";
    }
  } else {
    switch (static_cast<messages::ComposeSessionUntrustedPageHandlerFactory>(message.name())) {
      case messages::ComposeSessionUntrustedPageHandlerFactory::kCreateComposeSessionUntrustedPageHandler:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandlerFactory::CreateComposeSessionUntrustedPageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ComposeSessionUntrustedPageHandlerFactory::CreateComposeSessionUntrustedPageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09ed6728;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandlerFactory::CreateComposeSessionUntrustedPageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ComposeSessionUntrustedPageHandlerFactoryProxy::ComposeSessionUntrustedPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ComposeSessionUntrustedPageHandlerFactoryProxy::CreateComposeSessionUntrustedPageHandler(
    ::mojo::PendingReceiver<ComposeClientUntrustedPageHandler> in_client_handler, ::mojo::PendingReceiver<ComposeSessionUntrustedPageHandler> in_handler, ::mojo::PendingRemote<ComposeUntrustedDialog> in_dialog) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandlerFactory::CreateComposeSessionUntrustedPageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_handler"), in_client_handler,
                        "<value of type ::mojo::PendingReceiver<ComposeClientUntrustedPageHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<ComposeSessionUntrustedPageHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dialog"), in_dialog,
                        "<value of type ::mojo::PendingRemote<ComposeUntrustedDialog>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandlerFactory::kCreateComposeSessionUntrustedPageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::compose::mojom::ComposeClientUntrustedPageHandlerInterfaceBase>>(
    in_client_handler,
    &params->client_handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_handler in ComposeSessionUntrustedPageHandlerFactory.CreateComposeSessionUntrustedPageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::compose::mojom::ComposeSessionUntrustedPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ComposeSessionUntrustedPageHandlerFactory.CreateComposeSessionUntrustedPageHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::compose::mojom::ComposeUntrustedDialogInterfaceBase>>(
    in_dialog,
    &params->dialog,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->dialog)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid dialog in ComposeSessionUntrustedPageHandlerFactory.CreateComposeSessionUntrustedPageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandlerFactory::Name_);
  message.set_method_name("CreateComposeSessionUntrustedPageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ComposeSessionUntrustedPageHandlerFactoryStubDispatch::Accept(
    ComposeSessionUntrustedPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ComposeSessionUntrustedPageHandlerFactory>(message->header()->name)) {
    case messages::ComposeSessionUntrustedPageHandlerFactory::kCreateComposeSessionUntrustedPageHandler: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<ComposeClientUntrustedPageHandler> p_client_handler{};
      ::mojo::PendingReceiver<ComposeSessionUntrustedPageHandler> p_handler{};
      ::mojo::PendingRemote<ComposeUntrustedDialog> p_dialog{};
      ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client_handler =
            input_data_view.TakeClientHandler<decltype(p_client_handler)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (success) {
        p_dialog =
            input_data_view.TakeDialog<decltype(p_dialog)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateComposeSessionUntrustedPageHandler(        
        std::move(p_client_handler), 
        std::move(p_handler), 
        std::move(p_dialog));
      return true;
    }
  }
  return false;
}

// static
bool ComposeSessionUntrustedPageHandlerFactoryStubDispatch::AcceptWithResponder(
    ComposeSessionUntrustedPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ComposeSessionUntrustedPageHandlerFactory>(message->header()->name)) {
    case messages::ComposeSessionUntrustedPageHandlerFactory::kCreateComposeSessionUntrustedPageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kComposeSessionUntrustedPageHandlerFactoryValidationInfo[] = {
    { &internal::ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ComposeSessionUntrustedPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::compose::mojom::ComposeSessionUntrustedPageHandlerFactory::Name_,
    kComposeSessionUntrustedPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ComposeSessionUntrustedPageHandler::IPCStableHashFunction ComposeSessionUntrustedPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ComposeSessionUntrustedPageHandler>(message.name())) {
    case messages::ComposeSessionUntrustedPageHandler::kLogCancelEdit: {
      return &ComposeSessionUntrustedPageHandler::LogCancelEdit_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kCompose: {
      return &ComposeSessionUntrustedPageHandler::Compose_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRewrite: {
      return &ComposeSessionUntrustedPageHandler::Rewrite_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kLogEditInput: {
      return &ComposeSessionUntrustedPageHandler::LogEditInput_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kSaveWebUIState: {
      return &ComposeSessionUntrustedPageHandler::SaveWebUIState_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult: {
      return &ComposeSessionUntrustedPageHandler::AcceptComposeResult_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRequestInitialState: {
      return &ComposeSessionUntrustedPageHandler::RequestInitialState_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kUndo: {
      return &ComposeSessionUntrustedPageHandler::Undo_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState: {
      return &ComposeSessionUntrustedPageHandler::RecoverFromErrorState_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRedo: {
      return &ComposeSessionUntrustedPageHandler::Redo_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenBugReportingLink: {
      return &ComposeSessionUntrustedPageHandler::OpenBugReportingLink_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenComposeLearnMorePage: {
      return &ComposeSessionUntrustedPageHandler::OpenComposeLearnMorePage_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenEnterpriseComposeLearnMorePage: {
      return &ComposeSessionUntrustedPageHandler::OpenEnterpriseComposeLearnMorePage_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenFeedbackSurveyLink: {
      return &ComposeSessionUntrustedPageHandler::OpenFeedbackSurveyLink_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenSignInPage: {
      return &ComposeSessionUntrustedPageHandler::OpenSignInPage_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kSetUserFeedback: {
      return &ComposeSessionUntrustedPageHandler::SetUserFeedback_Sym::IPCStableHash;
    }
    case messages::ComposeSessionUntrustedPageHandler::kEditResult: {
      return &ComposeSessionUntrustedPageHandler::EditResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ComposeSessionUntrustedPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ComposeSessionUntrustedPageHandler>(message.name())) {
      case messages::ComposeSessionUntrustedPageHandler::kLogCancelEdit:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::LogCancelEdit";
      case messages::ComposeSessionUntrustedPageHandler::kCompose:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::Compose";
      case messages::ComposeSessionUntrustedPageHandler::kRewrite:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::Rewrite";
      case messages::ComposeSessionUntrustedPageHandler::kLogEditInput:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::LogEditInput";
      case messages::ComposeSessionUntrustedPageHandler::kSaveWebUIState:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::SaveWebUIState";
      case messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::AcceptComposeResult";
      case messages::ComposeSessionUntrustedPageHandler::kRequestInitialState:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::RequestInitialState";
      case messages::ComposeSessionUntrustedPageHandler::kUndo:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::Undo";
      case messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::RecoverFromErrorState";
      case messages::ComposeSessionUntrustedPageHandler::kRedo:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::Redo";
      case messages::ComposeSessionUntrustedPageHandler::kOpenBugReportingLink:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::OpenBugReportingLink";
      case messages::ComposeSessionUntrustedPageHandler::kOpenComposeLearnMorePage:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::OpenComposeLearnMorePage";
      case messages::ComposeSessionUntrustedPageHandler::kOpenEnterpriseComposeLearnMorePage:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::OpenEnterpriseComposeLearnMorePage";
      case messages::ComposeSessionUntrustedPageHandler::kOpenFeedbackSurveyLink:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::OpenFeedbackSurveyLink";
      case messages::ComposeSessionUntrustedPageHandler::kOpenSignInPage:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::OpenSignInPage";
      case messages::ComposeSessionUntrustedPageHandler::kSetUserFeedback:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::SetUserFeedback";
      case messages::ComposeSessionUntrustedPageHandler::kEditResult:
            return "Receive compose::mojom::ComposeSessionUntrustedPageHandler::EditResult";
    }
  } else {
    switch (static_cast<messages::ComposeSessionUntrustedPageHandler>(message.name())) {
      case messages::ComposeSessionUntrustedPageHandler::kLogCancelEdit:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::LogCancelEdit";
      case messages::ComposeSessionUntrustedPageHandler::kCompose:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::Compose";
      case messages::ComposeSessionUntrustedPageHandler::kRewrite:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::Rewrite";
      case messages::ComposeSessionUntrustedPageHandler::kLogEditInput:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::LogEditInput";
      case messages::ComposeSessionUntrustedPageHandler::kSaveWebUIState:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::SaveWebUIState";
      case messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::AcceptComposeResult";
      case messages::ComposeSessionUntrustedPageHandler::kRequestInitialState:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::RequestInitialState";
      case messages::ComposeSessionUntrustedPageHandler::kUndo:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::Undo";
      case messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::RecoverFromErrorState";
      case messages::ComposeSessionUntrustedPageHandler::kRedo:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::Redo";
      case messages::ComposeSessionUntrustedPageHandler::kOpenBugReportingLink:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::OpenBugReportingLink";
      case messages::ComposeSessionUntrustedPageHandler::kOpenComposeLearnMorePage:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::OpenComposeLearnMorePage";
      case messages::ComposeSessionUntrustedPageHandler::kOpenEnterpriseComposeLearnMorePage:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::OpenEnterpriseComposeLearnMorePage";
      case messages::ComposeSessionUntrustedPageHandler::kOpenFeedbackSurveyLink:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::OpenFeedbackSurveyLink";
      case messages::ComposeSessionUntrustedPageHandler::kOpenSignInPage:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::OpenSignInPage";
      case messages::ComposeSessionUntrustedPageHandler::kSetUserFeedback:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::SetUserFeedback";
      case messages::ComposeSessionUntrustedPageHandler::kEditResult:
            return "Receive reply compose::mojom::ComposeSessionUntrustedPageHandler::EditResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ComposeSessionUntrustedPageHandler::LogCancelEdit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91627105;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::LogCancelEdit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::Compose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89f36b74;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::Compose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::Rewrite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2770cb30;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::Rewrite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::LogEditInput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc95547a;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::LogEditInput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::SaveWebUIState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70122991;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::SaveWebUIState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::AcceptComposeResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24a01b95;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::AcceptComposeResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::RequestInitialState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a991cbc;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::RequestInitialState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8bbc79c3;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::RecoverFromErrorState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea842813;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::RecoverFromErrorState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::Redo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7acb8eb9;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::Redo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::OpenBugReportingLink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xacb560d0;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::OpenBugReportingLink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::OpenComposeLearnMorePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01f3318a;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::OpenComposeLearnMorePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::OpenEnterpriseComposeLearnMorePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb404794;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::OpenEnterpriseComposeLearnMorePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::OpenFeedbackSurveyLink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3fd498fe;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::OpenFeedbackSurveyLink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::OpenSignInPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee5ae255;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::OpenSignInPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::SetUserFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b516ecd;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::SetUserFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeSessionUntrustedPageHandler::EditResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff4f4931;  // IPCStableHash for compose::mojom::ComposeSessionUntrustedPageHandler::EditResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback(
      ComposeSessionUntrustedPageHandler::AcceptComposeResultCallback callback
      ) : callback_(std::move(callback)) {
  }

  ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback(const ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback&) = delete;
  ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback& operator=(const ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ComposeSessionUntrustedPageHandler::AcceptComposeResultCallback callback_;
};

class ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback(
      ComposeSessionUntrustedPageHandler::RequestInitialStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback(const ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback&) = delete;
  ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback& operator=(const ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ComposeSessionUntrustedPageHandler::RequestInitialStateCallback callback_;
};

class ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback(
      ComposeSessionUntrustedPageHandler::UndoCallback callback
      ) : callback_(std::move(callback)) {
  }

  ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback(const ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback&) = delete;
  ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback& operator=(const ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ComposeSessionUntrustedPageHandler::UndoCallback callback_;
};

class ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback(
      ComposeSessionUntrustedPageHandler::RecoverFromErrorStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback(const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback&) = delete;
  ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback& operator=(const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ComposeSessionUntrustedPageHandler::RecoverFromErrorStateCallback callback_;
};

class ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback(
      ComposeSessionUntrustedPageHandler::RedoCallback callback
      ) : callback_(std::move(callback)) {
  }

  ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback(const ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback&) = delete;
  ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback& operator=(const ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ComposeSessionUntrustedPageHandler::RedoCallback callback_;
};

class ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback(
      ComposeSessionUntrustedPageHandler::EditResultCallback callback
      ) : callback_(std::move(callback)) {
  }

  ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback(const ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback&) = delete;
  ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback& operator=(const ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ComposeSessionUntrustedPageHandler::EditResultCallback callback_;
};

ComposeSessionUntrustedPageHandlerProxy::ComposeSessionUntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ComposeSessionUntrustedPageHandlerProxy::LogCancelEdit(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::LogCancelEdit");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kLogCancelEdit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("LogCancelEdit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::Compose(
    const std::string& in_input, InputMode in_mode, bool in_edited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::Compose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type InputMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("edited"), in_edited,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kCompose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_Compose_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in ComposeSessionUntrustedPageHandler.Compose request");

  
  mojo::internal::Serialize<::compose::mojom::InputMode>(
    in_mode,
    &params->mode);

  params->edited = in_edited;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("Compose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::Rewrite(
    StyleModifier in_style) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::Rewrite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("style"), in_style,
                        "<value of type StyleModifier>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRewrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_Rewrite_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::compose::mojom::StyleModifier>(
    in_style,
    &params->style);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("Rewrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::LogEditInput(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::LogEditInput");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kLogEditInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("LogEditInput");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::SaveWebUIState(
    const std::string& in_webui_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::SaveWebUIState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("webui_state"), in_webui_state,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kSaveWebUIState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->webui_state)::BaseType> webui_state_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_webui_state,
    webui_state_fragment);

  params->webui_state.Set(
      webui_state_fragment.is_null() ? nullptr : webui_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->webui_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null webui_state in ComposeSessionUntrustedPageHandler.SaveWebUIState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("SaveWebUIState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::AcceptComposeResult(
    AcceptComposeResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::AcceptComposeResult");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("AcceptComposeResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ComposeSessionUntrustedPageHandlerProxy::RequestInitialState(
    RequestInitialStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::RequestInitialState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRequestInitialState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("RequestInitialState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ComposeSessionUntrustedPageHandlerProxy::Undo(
    UndoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::Undo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("Undo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ComposeSessionUntrustedPageHandlerProxy::RecoverFromErrorState(
    RecoverFromErrorStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::RecoverFromErrorState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("RecoverFromErrorState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ComposeSessionUntrustedPageHandlerProxy::Redo(
    RedoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::Redo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRedo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_Redo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("Redo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ComposeSessionUntrustedPageHandlerProxy::OpenBugReportingLink(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::OpenBugReportingLink");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kOpenBugReportingLink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("OpenBugReportingLink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::OpenComposeLearnMorePage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::OpenComposeLearnMorePage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kOpenComposeLearnMorePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("OpenComposeLearnMorePage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::OpenEnterpriseComposeLearnMorePage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::OpenEnterpriseComposeLearnMorePage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kOpenEnterpriseComposeLearnMorePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("OpenEnterpriseComposeLearnMorePage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::OpenFeedbackSurveyLink(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::OpenFeedbackSurveyLink");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kOpenFeedbackSurveyLink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("OpenFeedbackSurveyLink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::OpenSignInPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::OpenSignInPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kOpenSignInPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("OpenSignInPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::SetUserFeedback(
    UserFeedback in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::SetUserFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type UserFeedback>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kSetUserFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::compose::mojom::UserFeedback>(
    in_feedback,
    &params->feedback);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("SetUserFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeSessionUntrustedPageHandlerProxy::EditResult(
    const std::string& in_new_result, EditResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeSessionUntrustedPageHandler::EditResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_result"), in_new_result,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kEditResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_EditResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_result)::BaseType> new_result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_result,
    new_result_fragment);

  params->new_result.Set(
      new_result_fragment.is_null() ? nullptr : new_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_result in ComposeSessionUntrustedPageHandler.EditResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("EditResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ComposeSessionUntrustedPageHandler::AcceptComposeResultCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder> proxy(
        new ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ComposeSessionUntrustedPageHandler::AcceptComposeResultCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ComposeSessionUntrustedPageHandler_AcceptComposeResult_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ComposeSessionUntrustedPageHandler.5
  bool success = true;
  bool p_success{};
  ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComposeSessionUntrustedPageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply compose::mojom::ComposeSessionUntrustedPageHandler::AcceptComposeResult", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("AcceptComposeResult");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ComposeSessionUntrustedPageHandler::RequestInitialStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder> proxy(
        new ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ComposeSessionUntrustedPageHandler::RequestInitialStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      OpenMetadataPtr in_initial_state);
};

bool ComposeSessionUntrustedPageHandler_RequestInitialState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ComposeSessionUntrustedPageHandler.6
  bool success = true;
  OpenMetadataPtr p_initial_state{};
  ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInitialState(&p_initial_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComposeSessionUntrustedPageHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_initial_state));
  }
  return true;
}

void ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder::Run(
    OpenMetadataPtr in_initial_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply compose::mojom::ComposeSessionUntrustedPageHandler::RequestInitialState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_state"), in_initial_state,
                        "<value of type OpenMetadataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRequestInitialState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->initial_state)::BaseType> initial_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::compose::mojom::OpenMetadataDataView>(
    in_initial_state,
    initial_state_fragment);

  params->initial_state.Set(
      initial_state_fragment.is_null() ? nullptr : initial_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->initial_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null initial_state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("RequestInitialState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ComposeSessionUntrustedPageHandler::UndoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder> proxy(
        new ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ComposeSessionUntrustedPageHandler::UndoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ComposeStatePtr in_last_state);
};

bool ComposeSessionUntrustedPageHandler_Undo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ComposeSessionUntrustedPageHandler.7
  bool success = true;
  ComposeStatePtr p_last_state{};
  ComposeSessionUntrustedPageHandler_Undo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLastState(&p_last_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComposeSessionUntrustedPageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_last_state));
  }
  return true;
}

void ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder::Run(
    ComposeStatePtr in_last_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply compose::mojom::ComposeSessionUntrustedPageHandler::Undo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_state"), in_last_state,
                        "<value of type ComposeStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->last_state)::BaseType> last_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::compose::mojom::ComposeStateDataView>(
    in_last_state,
    last_state_fragment);

  params->last_state.Set(
      last_state_fragment.is_null() ? nullptr : last_state_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("Undo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ComposeSessionUntrustedPageHandler::RecoverFromErrorStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder> proxy(
        new ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ComposeSessionUntrustedPageHandler::RecoverFromErrorStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ComposeStatePtr in_state_before_error);
};

bool ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ComposeSessionUntrustedPageHandler.8
  bool success = true;
  ComposeStatePtr p_state_before_error{};
  ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStateBeforeError(&p_state_before_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComposeSessionUntrustedPageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state_before_error));
  }
  return true;
}

void ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder::Run(
    ComposeStatePtr in_state_before_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply compose::mojom::ComposeSessionUntrustedPageHandler::RecoverFromErrorState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state_before_error"), in_state_before_error,
                        "<value of type ComposeStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state_before_error)::BaseType> state_before_error_fragment(
          params.message());
  
  mojo::internal::Serialize<::compose::mojom::ComposeStateDataView>(
    in_state_before_error,
    state_before_error_fragment);

  params->state_before_error.Set(
      state_before_error_fragment.is_null() ? nullptr : state_before_error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("RecoverFromErrorState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ComposeSessionUntrustedPageHandler::RedoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder> proxy(
        new ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ComposeSessionUntrustedPageHandler::RedoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ComposeStatePtr in_next_state);
};

bool ComposeSessionUntrustedPageHandler_Redo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ComposeSessionUntrustedPageHandler.9
  bool success = true;
  ComposeStatePtr p_next_state{};
  ComposeSessionUntrustedPageHandler_Redo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNextState(&p_next_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComposeSessionUntrustedPageHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_next_state));
  }
  return true;
}

void ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder::Run(
    ComposeStatePtr in_next_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply compose::mojom::ComposeSessionUntrustedPageHandler::Redo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("next_state"), in_next_state,
                        "<value of type ComposeStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kRedo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->next_state)::BaseType> next_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::compose::mojom::ComposeStateDataView>(
    in_next_state,
    next_state_fragment);

  params->next_state.Set(
      next_state_fragment.is_null() ? nullptr : next_state_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("Redo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ComposeSessionUntrustedPageHandler::EditResultCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder> proxy(
        new ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ComposeSessionUntrustedPageHandler::EditResultCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_edited);
};

bool ComposeSessionUntrustedPageHandler_EditResult_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ComposeSessionUntrustedPageHandler.16
  bool success = true;
  bool p_is_edited{};
  ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_edited = input_data_view.is_edited();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ComposeSessionUntrustedPageHandler::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_edited));
  }
  return true;
}

void ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder::Run(
    bool in_is_edited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply compose::mojom::ComposeSessionUntrustedPageHandler::EditResult", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_edited"), in_is_edited,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeSessionUntrustedPageHandler::kEditResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_edited = in_is_edited;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeSessionUntrustedPageHandler::Name_);
  message.set_method_name("EditResult");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ComposeSessionUntrustedPageHandlerStubDispatch::Accept(
    ComposeSessionUntrustedPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ComposeSessionUntrustedPageHandler>(message->header()->name)) {
    case messages::ComposeSessionUntrustedPageHandler::kLogCancelEdit: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.0
      bool success = true;
      ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogCancelEdit(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kCompose: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_Compose_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_Compose_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.1
      bool success = true;
      std::string p_input{};
      InputMode p_mode{};
      bool p_edited{};
      ComposeSessionUntrustedPageHandler_Compose_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success)
        p_edited = input_data_view.edited();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Compose(        
        std::move(p_input), 
        std::move(p_mode), 
        std::move(p_edited));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRewrite: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_Rewrite_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_Rewrite_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.2
      bool success = true;
      StyleModifier p_style{};
      ComposeSessionUntrustedPageHandler_Rewrite_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStyle(&p_style))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Rewrite(        
        std::move(p_style));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kLogEditInput: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.3
      bool success = true;
      ComposeSessionUntrustedPageHandler_LogEditInput_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogEditInput(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kSaveWebUIState: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.4
      bool success = true;
      std::string p_webui_state{};
      ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWebuiState(&p_webui_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveWebUIState(        
        std::move(p_webui_state));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRequestInitialState: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kUndo: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRedo: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenBugReportingLink: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.10
      bool success = true;
      ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenBugReportingLink(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenComposeLearnMorePage: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.11
      bool success = true;
      ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenComposeLearnMorePage(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenEnterpriseComposeLearnMorePage: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.12
      bool success = true;
      ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenEnterpriseComposeLearnMorePage(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenFeedbackSurveyLink: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.13
      bool success = true;
      ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFeedbackSurveyLink(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenSignInPage: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.14
      bool success = true;
      ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenSignInPage(        );
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kSetUserFeedback: {
      DCHECK(message->is_serialized());
      internal::ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data* params =
          reinterpret_cast<internal::ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.15
      bool success = true;
      UserFeedback p_feedback{};
      ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserFeedback(        
        std::move(p_feedback));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kEditResult: {
      break;
    }
  }
  return false;
}

// static
bool ComposeSessionUntrustedPageHandlerStubDispatch::AcceptWithResponder(
    ComposeSessionUntrustedPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ComposeSessionUntrustedPageHandler>(message->header()->name)) {
    case messages::ComposeSessionUntrustedPageHandler::kLogCancelEdit: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kCompose: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRewrite: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kLogEditInput: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kSaveWebUIState: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kAcceptComposeResult: {
      internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data* params =
          reinterpret_cast<
              internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.5
      bool success = true;
      ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          ComposeSessionUntrustedPageHandler_AcceptComposeResult_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptComposeResult(std::move(callback));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRequestInitialState: {
      internal::ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data* params =
          reinterpret_cast<
              internal::ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.6
      bool success = true;
      ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          ComposeSessionUntrustedPageHandler_RequestInitialState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestInitialState(std::move(callback));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kUndo: {
      internal::ComposeSessionUntrustedPageHandler_Undo_Params_Data* params =
          reinterpret_cast<
              internal::ComposeSessionUntrustedPageHandler_Undo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.7
      bool success = true;
      ComposeSessionUntrustedPageHandler_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          ComposeSessionUntrustedPageHandler_Undo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(std::move(callback));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRecoverFromErrorState: {
      internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data* params =
          reinterpret_cast<
              internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.8
      bool success = true;
      ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecoverFromErrorState(std::move(callback));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kRedo: {
      internal::ComposeSessionUntrustedPageHandler_Redo_Params_Data* params =
          reinterpret_cast<
              internal::ComposeSessionUntrustedPageHandler_Redo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.9
      bool success = true;
      ComposeSessionUntrustedPageHandler_Redo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          ComposeSessionUntrustedPageHandler_Redo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Redo(std::move(callback));
      return true;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenBugReportingLink: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenComposeLearnMorePage: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenEnterpriseComposeLearnMorePage: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenFeedbackSurveyLink: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kOpenSignInPage: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kSetUserFeedback: {
      break;
    }
    case messages::ComposeSessionUntrustedPageHandler::kEditResult: {
      internal::ComposeSessionUntrustedPageHandler_EditResult_Params_Data* params =
          reinterpret_cast<
              internal::ComposeSessionUntrustedPageHandler_EditResult_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ComposeSessionUntrustedPageHandler.16
      bool success = true;
      std::string p_new_result{};
      ComposeSessionUntrustedPageHandler_EditResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewResult(&p_new_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeSessionUntrustedPageHandler::Name_, 16, false);
        return false;
      }
      auto callback =
          ComposeSessionUntrustedPageHandler_EditResult_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EditResult(        
        std::move(p_new_result), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kComposeSessionUntrustedPageHandlerValidationInfo[] = {
    { &internal::ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_Compose_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_Rewrite_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data::Validate,
     &internal::ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data::Validate},
    { &internal::ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data::Validate,
     &internal::ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data::Validate},
    { &internal::ComposeSessionUntrustedPageHandler_Undo_Params_Data::Validate,
     &internal::ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data::Validate},
    { &internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data::Validate,
     &internal::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data::Validate},
    { &internal::ComposeSessionUntrustedPageHandler_Redo_Params_Data::Validate,
     &internal::ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data::Validate},
    { &internal::ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeSessionUntrustedPageHandler_EditResult_Params_Data::Validate,
     &internal::ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data::Validate},
};

bool ComposeSessionUntrustedPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::compose::mojom::ComposeSessionUntrustedPageHandler::Name_,
    kComposeSessionUntrustedPageHandlerValidationInfo);
}

bool ComposeSessionUntrustedPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::compose::mojom::ComposeSessionUntrustedPageHandler::Name_,
    kComposeSessionUntrustedPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

ComposeClientUntrustedPageHandler::IPCStableHashFunction ComposeClientUntrustedPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ComposeClientUntrustedPageHandler>(message.name())) {
    case messages::ComposeClientUntrustedPageHandler::kShowUI: {
      return &ComposeClientUntrustedPageHandler::ShowUI_Sym::IPCStableHash;
    }
    case messages::ComposeClientUntrustedPageHandler::kCloseUI: {
      return &ComposeClientUntrustedPageHandler::CloseUI_Sym::IPCStableHash;
    }
    case messages::ComposeClientUntrustedPageHandler::kCompleteFirstRun: {
      return &ComposeClientUntrustedPageHandler::CompleteFirstRun_Sym::IPCStableHash;
    }
    case messages::ComposeClientUntrustedPageHandler::kOpenComposeSettings: {
      return &ComposeClientUntrustedPageHandler::OpenComposeSettings_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ComposeClientUntrustedPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ComposeClientUntrustedPageHandler>(message.name())) {
      case messages::ComposeClientUntrustedPageHandler::kShowUI:
            return "Receive compose::mojom::ComposeClientUntrustedPageHandler::ShowUI";
      case messages::ComposeClientUntrustedPageHandler::kCloseUI:
            return "Receive compose::mojom::ComposeClientUntrustedPageHandler::CloseUI";
      case messages::ComposeClientUntrustedPageHandler::kCompleteFirstRun:
            return "Receive compose::mojom::ComposeClientUntrustedPageHandler::CompleteFirstRun";
      case messages::ComposeClientUntrustedPageHandler::kOpenComposeSettings:
            return "Receive compose::mojom::ComposeClientUntrustedPageHandler::OpenComposeSettings";
    }
  } else {
    switch (static_cast<messages::ComposeClientUntrustedPageHandler>(message.name())) {
      case messages::ComposeClientUntrustedPageHandler::kShowUI:
            return "Receive reply compose::mojom::ComposeClientUntrustedPageHandler::ShowUI";
      case messages::ComposeClientUntrustedPageHandler::kCloseUI:
            return "Receive reply compose::mojom::ComposeClientUntrustedPageHandler::CloseUI";
      case messages::ComposeClientUntrustedPageHandler::kCompleteFirstRun:
            return "Receive reply compose::mojom::ComposeClientUntrustedPageHandler::CompleteFirstRun";
      case messages::ComposeClientUntrustedPageHandler::kOpenComposeSettings:
            return "Receive reply compose::mojom::ComposeClientUntrustedPageHandler::OpenComposeSettings";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ComposeClientUntrustedPageHandler::ShowUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd86e7f3a;  // IPCStableHash for compose::mojom::ComposeClientUntrustedPageHandler::ShowUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeClientUntrustedPageHandler::CloseUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x116e53c4;  // IPCStableHash for compose::mojom::ComposeClientUntrustedPageHandler::CloseUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeClientUntrustedPageHandler::CompleteFirstRun_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb86a00d;  // IPCStableHash for compose::mojom::ComposeClientUntrustedPageHandler::CompleteFirstRun
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeClientUntrustedPageHandler::OpenComposeSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcf5837b;  // IPCStableHash for compose::mojom::ComposeClientUntrustedPageHandler::OpenComposeSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ComposeClientUntrustedPageHandlerProxy::ComposeClientUntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ComposeClientUntrustedPageHandlerProxy::ShowUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeClientUntrustedPageHandler::ShowUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeClientUntrustedPageHandler::kShowUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeClientUntrustedPageHandler_ShowUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeClientUntrustedPageHandler::Name_);
  message.set_method_name("ShowUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeClientUntrustedPageHandlerProxy::CloseUI(
    CloseReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeClientUntrustedPageHandler::CloseUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type CloseReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeClientUntrustedPageHandler::kCloseUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeClientUntrustedPageHandler_CloseUI_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::compose::mojom::CloseReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeClientUntrustedPageHandler::Name_);
  message.set_method_name("CloseUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeClientUntrustedPageHandlerProxy::CompleteFirstRun(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeClientUntrustedPageHandler::CompleteFirstRun");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeClientUntrustedPageHandler::kCompleteFirstRun), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeClientUntrustedPageHandler::Name_);
  message.set_method_name("CompleteFirstRun");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeClientUntrustedPageHandlerProxy::OpenComposeSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send compose::mojom::ComposeClientUntrustedPageHandler::OpenComposeSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeClientUntrustedPageHandler::kOpenComposeSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeClientUntrustedPageHandler::Name_);
  message.set_method_name("OpenComposeSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ComposeClientUntrustedPageHandlerStubDispatch::Accept(
    ComposeClientUntrustedPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ComposeClientUntrustedPageHandler>(message->header()->name)) {
    case messages::ComposeClientUntrustedPageHandler::kShowUI: {
      DCHECK(message->is_serialized());
      internal::ComposeClientUntrustedPageHandler_ShowUI_Params_Data* params =
          reinterpret_cast<internal::ComposeClientUntrustedPageHandler_ShowUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeClientUntrustedPageHandler.0
      bool success = true;
      ComposeClientUntrustedPageHandler_ShowUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeClientUntrustedPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowUI(        );
      return true;
    }
    case messages::ComposeClientUntrustedPageHandler::kCloseUI: {
      DCHECK(message->is_serialized());
      internal::ComposeClientUntrustedPageHandler_CloseUI_Params_Data* params =
          reinterpret_cast<internal::ComposeClientUntrustedPageHandler_CloseUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeClientUntrustedPageHandler.1
      bool success = true;
      CloseReason p_reason{};
      ComposeClientUntrustedPageHandler_CloseUI_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeClientUntrustedPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseUI(        
        std::move(p_reason));
      return true;
    }
    case messages::ComposeClientUntrustedPageHandler::kCompleteFirstRun: {
      DCHECK(message->is_serialized());
      internal::ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data* params =
          reinterpret_cast<internal::ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeClientUntrustedPageHandler.2
      bool success = true;
      ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeClientUntrustedPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompleteFirstRun(        );
      return true;
    }
    case messages::ComposeClientUntrustedPageHandler::kOpenComposeSettings: {
      DCHECK(message->is_serialized());
      internal::ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data* params =
          reinterpret_cast<internal::ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeClientUntrustedPageHandler.3
      bool success = true;
      ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeClientUntrustedPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenComposeSettings(        );
      return true;
    }
  }
  return false;
}

// static
bool ComposeClientUntrustedPageHandlerStubDispatch::AcceptWithResponder(
    ComposeClientUntrustedPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ComposeClientUntrustedPageHandler>(message->header()->name)) {
    case messages::ComposeClientUntrustedPageHandler::kShowUI: {
      break;
    }
    case messages::ComposeClientUntrustedPageHandler::kCloseUI: {
      break;
    }
    case messages::ComposeClientUntrustedPageHandler::kCompleteFirstRun: {
      break;
    }
    case messages::ComposeClientUntrustedPageHandler::kOpenComposeSettings: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kComposeClientUntrustedPageHandlerValidationInfo[] = {
    { &internal::ComposeClientUntrustedPageHandler_ShowUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeClientUntrustedPageHandler_CloseUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data::Validate,
     nullptr /* no response */},
};

bool ComposeClientUntrustedPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::compose::mojom::ComposeClientUntrustedPageHandler::Name_,
    kComposeClientUntrustedPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

ComposeUntrustedDialog::IPCStableHashFunction ComposeUntrustedDialog::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ComposeUntrustedDialog>(message.name())) {
    case messages::ComposeUntrustedDialog::kResponseReceived: {
      return &ComposeUntrustedDialog::ResponseReceived_Sym::IPCStableHash;
    }
    case messages::ComposeUntrustedDialog::kPartialResponseReceived: {
      return &ComposeUntrustedDialog::PartialResponseReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ComposeUntrustedDialog::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ComposeUntrustedDialog>(message.name())) {
      case messages::ComposeUntrustedDialog::kResponseReceived:
            return "Receive compose::mojom::ComposeUntrustedDialog::ResponseReceived";
      case messages::ComposeUntrustedDialog::kPartialResponseReceived:
            return "Receive compose::mojom::ComposeUntrustedDialog::PartialResponseReceived";
    }
  } else {
    switch (static_cast<messages::ComposeUntrustedDialog>(message.name())) {
      case messages::ComposeUntrustedDialog::kResponseReceived:
            return "Receive reply compose::mojom::ComposeUntrustedDialog::ResponseReceived";
      case messages::ComposeUntrustedDialog::kPartialResponseReceived:
            return "Receive reply compose::mojom::ComposeUntrustedDialog::PartialResponseReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ComposeUntrustedDialog::ResponseReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44edbce2;  // IPCStableHash for compose::mojom::ComposeUntrustedDialog::ResponseReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ComposeUntrustedDialog::PartialResponseReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e9e6b3b;  // IPCStableHash for compose::mojom::ComposeUntrustedDialog::PartialResponseReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ComposeUntrustedDialogProxy::ComposeUntrustedDialogProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ComposeUntrustedDialogProxy::ResponseReceived(
    ComposeResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeUntrustedDialog::ResponseReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type ComposeResponsePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeUntrustedDialog::kResponseReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeUntrustedDialog_ResponseReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::compose::mojom::ComposeResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ComposeUntrustedDialog.ResponseReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeUntrustedDialog::Name_);
  message.set_method_name("ResponseReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ComposeUntrustedDialogProxy::PartialResponseReceived(
    PartialComposeResponsePtr in_partial_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send compose::mojom::ComposeUntrustedDialog::PartialResponseReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partial_response"), in_partial_response,
                        "<value of type PartialComposeResponsePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ComposeUntrustedDialog::kPartialResponseReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::compose::mojom::internal::ComposeUntrustedDialog_PartialResponseReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->partial_response)::BaseType> partial_response_fragment(
          params.message());
  
  mojo::internal::Serialize<::compose::mojom::PartialComposeResponseDataView>(
    in_partial_response,
    partial_response_fragment);

  params->partial_response.Set(
      partial_response_fragment.is_null() ? nullptr : partial_response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->partial_response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null partial_response in ComposeUntrustedDialog.PartialResponseReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ComposeUntrustedDialog::Name_);
  message.set_method_name("PartialResponseReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ComposeUntrustedDialogStubDispatch::Accept(
    ComposeUntrustedDialog* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ComposeUntrustedDialog>(message->header()->name)) {
    case messages::ComposeUntrustedDialog::kResponseReceived: {
      DCHECK(message->is_serialized());
      internal::ComposeUntrustedDialog_ResponseReceived_Params_Data* params =
          reinterpret_cast<internal::ComposeUntrustedDialog_ResponseReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeUntrustedDialog.0
      bool success = true;
      ComposeResponsePtr p_response{};
      ComposeUntrustedDialog_ResponseReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeUntrustedDialog::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResponseReceived(        
        std::move(p_response));
      return true;
    }
    case messages::ComposeUntrustedDialog::kPartialResponseReceived: {
      DCHECK(message->is_serialized());
      internal::ComposeUntrustedDialog_PartialResponseReceived_Params_Data* params =
          reinterpret_cast<internal::ComposeUntrustedDialog_PartialResponseReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ComposeUntrustedDialog.1
      bool success = true;
      PartialComposeResponsePtr p_partial_response{};
      ComposeUntrustedDialog_PartialResponseReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPartialResponse(&p_partial_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ComposeUntrustedDialog::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PartialResponseReceived(        
        std::move(p_partial_response));
      return true;
    }
  }
  return false;
}

// static
bool ComposeUntrustedDialogStubDispatch::AcceptWithResponder(
    ComposeUntrustedDialog* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ComposeUntrustedDialog>(message->header()->name)) {
    case messages::ComposeUntrustedDialog::kResponseReceived: {
      break;
    }
    case messages::ComposeUntrustedDialog::kPartialResponseReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kComposeUntrustedDialogValidationInfo[] = {
    { &internal::ComposeUntrustedDialog_ResponseReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ComposeUntrustedDialog_PartialResponseReceived_Params_Data::Validate,
     nullptr /* no response */},
};

bool ComposeUntrustedDialogRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::compose::mojom::ComposeUntrustedDialog::Name_,
    kComposeUntrustedDialogValidationInfo);
}



}  // compose::mojom


namespace mojo {


// static
bool StructTraits<::compose::mojom::ComposeResponse::DataView, ::compose::mojom::ComposeResponsePtr>::Read(
    ::compose::mojom::ComposeResponse::DataView input,
    ::compose::mojom::ComposeResponsePtr* output) {
  bool success = true;
  ::compose::mojom::ComposeResponsePtr result(::compose::mojom::ComposeResponse::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadResult(&result->result))
        success = false;
      if (success)
        result->undo_available = input.undo_available();
      if (success)
        result->redo_available = input.redo_available();
      if (success)
        result->provided_by_user = input.provided_by_user();
      if (success)
        result->on_device_evaluation_used = input.on_device_evaluation_used();
      if (success)
        result->triggered_from_modifier = input.triggered_from_modifier();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::compose::mojom::PartialComposeResponse::DataView, ::compose::mojom::PartialComposeResponsePtr>::Read(
    ::compose::mojom::PartialComposeResponse::DataView input,
    ::compose::mojom::PartialComposeResponsePtr* output) {
  bool success = true;
  ::compose::mojom::PartialComposeResponsePtr result(::compose::mojom::PartialComposeResponse::New());
  
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::compose::mojom::ComposeState::DataView, ::compose::mojom::ComposeStatePtr>::Read(
    ::compose::mojom::ComposeState::DataView input,
    ::compose::mojom::ComposeStatePtr* output) {
  bool success = true;
  ::compose::mojom::ComposeStatePtr result(::compose::mojom::ComposeState::New());
  
      if (success && !input.ReadWebuiState(&result->webui_state))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
      if (success)
        result->has_pending_request = input.has_pending_request();
      if (success && !input.ReadFeedback(&result->feedback))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::compose::mojom::ConfigurableParams::DataView, ::compose::mojom::ConfigurableParamsPtr>::Read(
    ::compose::mojom::ConfigurableParams::DataView input,
    ::compose::mojom::ConfigurableParamsPtr* output) {
  bool success = true;
  ::compose::mojom::ConfigurableParamsPtr result(::compose::mojom::ConfigurableParams::New());
  
      if (success)
        result->min_word_limit = input.min_word_limit();
      if (success)
        result->max_word_limit = input.max_word_limit();
      if (success)
        result->max_character_limit = input.max_character_limit();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::compose::mojom::OpenMetadata::DataView, ::compose::mojom::OpenMetadataPtr>::Read(
    ::compose::mojom::OpenMetadata::DataView input,
    ::compose::mojom::OpenMetadataPtr* output) {
  bool success = true;
  ::compose::mojom::OpenMetadataPtr result(::compose::mojom::OpenMetadata::New());
  
      if (success)
        result->fre_complete = input.fre_complete();
      if (success)
        result->msbb_state = input.msbb_state();
      if (success && !input.ReadInitialInput(&result->initial_input))
        success = false;
      if (success)
        result->text_selected = input.text_selected();
      if (success && !input.ReadComposeState(&result->compose_state))
        success = false;
      if (success && !input.ReadConfigurableParams(&result->configurable_params))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace compose::mojom {


void ComposeSessionUntrustedPageHandlerFactoryInterceptorForTesting::CreateComposeSessionUntrustedPageHandler(::mojo::PendingReceiver<ComposeClientUntrustedPageHandler> client_handler, ::mojo::PendingReceiver<ComposeSessionUntrustedPageHandler> handler, ::mojo::PendingRemote<ComposeUntrustedDialog> dialog) {
  GetForwardingInterface()->CreateComposeSessionUntrustedPageHandler(
    std::move(client_handler)
    , 
    std::move(handler)
    , 
    std::move(dialog)
    );
}
ComposeSessionUntrustedPageHandlerFactoryAsyncWaiter::ComposeSessionUntrustedPageHandlerFactoryAsyncWaiter(
    ComposeSessionUntrustedPageHandlerFactory* proxy) : proxy_(proxy) {}

ComposeSessionUntrustedPageHandlerFactoryAsyncWaiter::~ComposeSessionUntrustedPageHandlerFactoryAsyncWaiter() = default;





void ComposeSessionUntrustedPageHandlerInterceptorForTesting::LogCancelEdit() {
  GetForwardingInterface()->LogCancelEdit();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::Compose(const std::string& input, InputMode mode, bool edited) {
  GetForwardingInterface()->Compose(
    std::move(input)
    , 
    std::move(mode)
    , 
    std::move(edited)
    );
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::Rewrite(StyleModifier style) {
  GetForwardingInterface()->Rewrite(
    std::move(style)
    );
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::LogEditInput() {
  GetForwardingInterface()->LogEditInput();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::SaveWebUIState(const std::string& webui_state) {
  GetForwardingInterface()->SaveWebUIState(
    std::move(webui_state)
    );
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::AcceptComposeResult(AcceptComposeResultCallback callback) {
  GetForwardingInterface()->AcceptComposeResult(std::move(callback));
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::RequestInitialState(RequestInitialStateCallback callback) {
  GetForwardingInterface()->RequestInitialState(std::move(callback));
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::Undo(UndoCallback callback) {
  GetForwardingInterface()->Undo(std::move(callback));
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::RecoverFromErrorState(RecoverFromErrorStateCallback callback) {
  GetForwardingInterface()->RecoverFromErrorState(std::move(callback));
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::Redo(RedoCallback callback) {
  GetForwardingInterface()->Redo(std::move(callback));
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::OpenBugReportingLink() {
  GetForwardingInterface()->OpenBugReportingLink();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::OpenComposeLearnMorePage() {
  GetForwardingInterface()->OpenComposeLearnMorePage();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::OpenEnterpriseComposeLearnMorePage() {
  GetForwardingInterface()->OpenEnterpriseComposeLearnMorePage();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::OpenFeedbackSurveyLink() {
  GetForwardingInterface()->OpenFeedbackSurveyLink();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::OpenSignInPage() {
  GetForwardingInterface()->OpenSignInPage();
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::SetUserFeedback(UserFeedback feedback) {
  GetForwardingInterface()->SetUserFeedback(
    std::move(feedback)
    );
}
void ComposeSessionUntrustedPageHandlerInterceptorForTesting::EditResult(const std::string& new_result, EditResultCallback callback) {
  GetForwardingInterface()->EditResult(
    std::move(new_result)
    , std::move(callback));
}
ComposeSessionUntrustedPageHandlerAsyncWaiter::ComposeSessionUntrustedPageHandlerAsyncWaiter(
    ComposeSessionUntrustedPageHandler* proxy) : proxy_(proxy) {}

ComposeSessionUntrustedPageHandlerAsyncWaiter::~ComposeSessionUntrustedPageHandlerAsyncWaiter() = default;


void ComposeSessionUntrustedPageHandlerAsyncWaiter::AcceptComposeResult(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->AcceptComposeResult(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ComposeSessionUntrustedPageHandlerAsyncWaiter::AcceptComposeResult(
    ) {
  bool async_wait_result;
  AcceptComposeResult(&async_wait_result);
  return async_wait_result;
}

void ComposeSessionUntrustedPageHandlerAsyncWaiter::RequestInitialState(
    OpenMetadataPtr* out_initial_state) {
  base::RunLoop loop;
  proxy_->RequestInitialState(
      base::BindOnce(
          [](base::RunLoop* loop,
             OpenMetadataPtr* out_initial_state
,
             OpenMetadataPtr initial_state) {*out_initial_state = std::move(initial_state);
            loop->Quit();
          },
          &loop,
          out_initial_state));
  loop.Run();
}

OpenMetadataPtr ComposeSessionUntrustedPageHandlerAsyncWaiter::RequestInitialState(
    ) {
  OpenMetadataPtr async_wait_result;
  RequestInitialState(&async_wait_result);
  return async_wait_result;
}

void ComposeSessionUntrustedPageHandlerAsyncWaiter::Undo(
    ComposeStatePtr* out_last_state) {
  base::RunLoop loop;
  proxy_->Undo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ComposeStatePtr* out_last_state
,
             ComposeStatePtr last_state) {*out_last_state = std::move(last_state);
            loop->Quit();
          },
          &loop,
          out_last_state));
  loop.Run();
}

ComposeStatePtr ComposeSessionUntrustedPageHandlerAsyncWaiter::Undo(
    ) {
  ComposeStatePtr async_wait_result;
  Undo(&async_wait_result);
  return async_wait_result;
}

void ComposeSessionUntrustedPageHandlerAsyncWaiter::RecoverFromErrorState(
    ComposeStatePtr* out_state_before_error) {
  base::RunLoop loop;
  proxy_->RecoverFromErrorState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ComposeStatePtr* out_state_before_error
,
             ComposeStatePtr state_before_error) {*out_state_before_error = std::move(state_before_error);
            loop->Quit();
          },
          &loop,
          out_state_before_error));
  loop.Run();
}

ComposeStatePtr ComposeSessionUntrustedPageHandlerAsyncWaiter::RecoverFromErrorState(
    ) {
  ComposeStatePtr async_wait_result;
  RecoverFromErrorState(&async_wait_result);
  return async_wait_result;
}

void ComposeSessionUntrustedPageHandlerAsyncWaiter::Redo(
    ComposeStatePtr* out_next_state) {
  base::RunLoop loop;
  proxy_->Redo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ComposeStatePtr* out_next_state
,
             ComposeStatePtr next_state) {*out_next_state = std::move(next_state);
            loop->Quit();
          },
          &loop,
          out_next_state));
  loop.Run();
}

ComposeStatePtr ComposeSessionUntrustedPageHandlerAsyncWaiter::Redo(
    ) {
  ComposeStatePtr async_wait_result;
  Redo(&async_wait_result);
  return async_wait_result;
}

void ComposeSessionUntrustedPageHandlerAsyncWaiter::EditResult(
    const std::string& new_result, bool* out_is_edited) {
  base::RunLoop loop;
  proxy_->EditResult(
      std::move(new_result),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_edited
,
             bool is_edited) {*out_is_edited = std::move(is_edited);
            loop->Quit();
          },
          &loop,
          out_is_edited));
  loop.Run();
}

bool ComposeSessionUntrustedPageHandlerAsyncWaiter::EditResult(
    const std::string& new_result) {
  bool async_wait_result;
  EditResult(std::move(new_result),&async_wait_result);
  return async_wait_result;
}




void ComposeClientUntrustedPageHandlerInterceptorForTesting::ShowUI() {
  GetForwardingInterface()->ShowUI();
}
void ComposeClientUntrustedPageHandlerInterceptorForTesting::CloseUI(CloseReason reason) {
  GetForwardingInterface()->CloseUI(
    std::move(reason)
    );
}
void ComposeClientUntrustedPageHandlerInterceptorForTesting::CompleteFirstRun() {
  GetForwardingInterface()->CompleteFirstRun();
}
void ComposeClientUntrustedPageHandlerInterceptorForTesting::OpenComposeSettings() {
  GetForwardingInterface()->OpenComposeSettings();
}
ComposeClientUntrustedPageHandlerAsyncWaiter::ComposeClientUntrustedPageHandlerAsyncWaiter(
    ComposeClientUntrustedPageHandler* proxy) : proxy_(proxy) {}

ComposeClientUntrustedPageHandlerAsyncWaiter::~ComposeClientUntrustedPageHandlerAsyncWaiter() = default;





void ComposeUntrustedDialogInterceptorForTesting::ResponseReceived(ComposeResponsePtr response) {
  GetForwardingInterface()->ResponseReceived(
    std::move(response)
    );
}
void ComposeUntrustedDialogInterceptorForTesting::PartialResponseReceived(PartialComposeResponsePtr partial_response) {
  GetForwardingInterface()->PartialResponseReceived(
    std::move(partial_response)
    );
}
ComposeUntrustedDialogAsyncWaiter::ComposeUntrustedDialogAsyncWaiter(
    ComposeUntrustedDialog* proxy) : proxy_(proxy) {}

ComposeUntrustedDialogAsyncWaiter::~ComposeUntrustedDialogAsyncWaiter() = default;







}  // compose::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif