// chrome/common/compose/compose.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SHARED_H_
#define CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/compose/compose.mojom-shared-internal.h"
#include "components/compose/core/browser/compose_enums.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/compose/compose.mojom-data-view.h"




namespace std {

template <>
struct hash<::compose::mojom::InputMode>
    : public mojo::internal::EnumHashImpl<::compose::mojom::InputMode> {};

template <>
struct hash<::compose::mojom::StyleModifier>
    : public mojo::internal::EnumHashImpl<::compose::mojom::StyleModifier> {};

template <>
struct hash<::compose::mojom::CloseReason>
    : public mojo::internal::EnumHashImpl<::compose::mojom::CloseReason> {};

template <>
struct hash<::compose::mojom::UserFeedback>
    : public mojo::internal::EnumHashImpl<::compose::mojom::UserFeedback> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::InputMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::compose::mojom::InputMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::compose::mojom::InputMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::StyleModifier, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::compose::mojom::StyleModifier, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::compose::mojom::StyleModifier>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::CloseReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::compose::mojom::CloseReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::compose::mojom::CloseReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::UserFeedback, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::compose::mojom::UserFeedback, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::compose::mojom::UserFeedback>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::ComposeResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::ComposeResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::ComposeResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::compose::mojom::ComposeStatus>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::result(input)) in_result = Traits::result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->result)::BaseType> result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_result,
      result_fragment);

    fragment->result.Set(
        result_fragment.is_null() ? nullptr : result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ComposeResponse struct");

    fragment->undo_available = Traits::undo_available(input);

    fragment->redo_available = Traits::redo_available(input);

    fragment->provided_by_user = Traits::provided_by_user(input);

    fragment->on_device_evaluation_used = Traits::on_device_evaluation_used(input);

    fragment->triggered_from_modifier = Traits::triggered_from_modifier(input);
  }

  static bool Deserialize(::compose::mojom::internal::ComposeResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::compose::mojom::ComposeResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::PartialComposeResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::PartialComposeResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::PartialComposeResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::result(input)) in_result = Traits::result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->result)::BaseType> result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_result,
      result_fragment);

    fragment->result.Set(
        result_fragment.is_null() ? nullptr : result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in PartialComposeResponse struct");
  }

  static bool Deserialize(::compose::mojom::internal::PartialComposeResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::compose::mojom::PartialComposeResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::ComposeStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::ComposeStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::ComposeState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::webui_state(input)) in_webui_state = Traits::webui_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->webui_state)::BaseType> webui_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_webui_state,
      webui_state_fragment);

    fragment->webui_state.Set(
        webui_state_fragment.is_null() ? nullptr : webui_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->webui_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null webui_state in ComposeState struct");

    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::compose::mojom::ComposeResponseDataView>(
      in_response,
      response_fragment);

    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());

    fragment->has_pending_request = Traits::has_pending_request(input);

    
    mojo::internal::Serialize<::compose::mojom::UserFeedback>(
      Traits::feedback(input),
      &fragment->feedback);
  }

  static bool Deserialize(::compose::mojom::internal::ComposeState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::compose::mojom::ComposeStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::ConfigurableParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::ConfigurableParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::ConfigurableParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->min_word_limit = Traits::min_word_limit(input);

    fragment->max_word_limit = Traits::max_word_limit(input);

    fragment->max_character_limit = Traits::max_character_limit(input);
  }

  static bool Deserialize(::compose::mojom::internal::ConfigurableParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::compose::mojom::ConfigurableParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::compose::mojom::OpenMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::OpenMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::OpenMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->fre_complete = Traits::fre_complete(input);

    fragment->msbb_state = Traits::msbb_state(input);

    decltype(Traits::initial_input(input)) in_initial_input = Traits::initial_input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_input)::BaseType> initial_input_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_initial_input,
      initial_input_fragment);

    fragment->initial_input.Set(
        initial_input_fragment.is_null() ? nullptr : initial_input_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->initial_input.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initial_input in OpenMetadata struct");

    fragment->text_selected = Traits::text_selected(input);

    decltype(Traits::compose_state(input)) in_compose_state = Traits::compose_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->compose_state)::BaseType> compose_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::compose::mojom::ComposeStateDataView>(
      in_compose_state,
      compose_state_fragment);

    fragment->compose_state.Set(
        compose_state_fragment.is_null() ? nullptr : compose_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->compose_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null compose_state in OpenMetadata struct");

    decltype(Traits::configurable_params(input)) in_configurable_params = Traits::configurable_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->configurable_params)::BaseType> configurable_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::compose::mojom::ConfigurableParamsDataView>(
      in_configurable_params,
      configurable_params_fragment);

    fragment->configurable_params.Set(
        configurable_params_fragment.is_null() ? nullptr : configurable_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->configurable_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null configurable_params in OpenMetadata struct");
  }

  static bool Deserialize(::compose::mojom::internal::OpenMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::compose::mojom::OpenMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace compose::mojom {

inline void ComposeResponseDataView::GetResultDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->result.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PartialComposeResponseDataView::GetResultDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->result.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ComposeStateDataView::GetWebuiStateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->webui_state.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ComposeStateDataView::GetResponseDataView(
    ComposeResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = ComposeResponseDataView(pointer, message_);
}




inline void OpenMetadataDataView::GetInitialInputDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->initial_input.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OpenMetadataDataView::GetComposeStateDataView(
    ComposeStateDataView* output) {
  auto pointer = data_->compose_state.Get();
  *output = ComposeStateDataView(pointer, message_);
}
inline void OpenMetadataDataView::GetConfigurableParamsDataView(
    ConfigurableParamsDataView* output) {
  auto pointer = data_->configurable_params.Get();
  *output = ConfigurableParamsDataView(pointer, message_);
}



}  // compose::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::compose::mojom::InputMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::compose::mojom::InputMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::compose::mojom::StyleModifier> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::compose::mojom::StyleModifier value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::compose::mojom::CloseReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::compose::mojom::CloseReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::compose::mojom::UserFeedback> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::compose::mojom::UserFeedback value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SHARED_H_