// chrome/common/compose/compose.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/compose/compose.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/compose/compose.mojom-params-data.h"
namespace compose {
namespace mojom {

NOINLINE static const char* InputModeToStringHelper(InputMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputMode::kUnset:
      return "kUnset";
    case InputMode::kPolish:
      return "kPolish";
    case InputMode::kElaborate:
      return "kElaborate";
    case InputMode::kFormalize:
      return "kFormalize";
    default:
      return nullptr;
  }
}

std::string InputModeToString(InputMode value) {
  const char *str = InputModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputMode value) {
  return os << InputModeToString(value);
}

NOINLINE static const char* StyleModifierToStringHelper(StyleModifier value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StyleModifier::kUnset:
      return "kUnset";
    case StyleModifier::kFormal:
      return "kFormal";
    case StyleModifier::kCasual:
      return "kCasual";
    case StyleModifier::kLonger:
      return "kLonger";
    case StyleModifier::kShorter:
      return "kShorter";
    case StyleModifier::kRetry:
      return "kRetry";
    default:
      return nullptr;
  }
}

std::string StyleModifierToString(StyleModifier value) {
  const char *str = StyleModifierToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StyleModifier value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StyleModifier value) {
  return os << StyleModifierToString(value);
}

NOINLINE static const char* CloseReasonToStringHelper(CloseReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CloseReason::kFirstRunCloseButton:
      return "kFirstRunCloseButton";
    case CloseReason::kCloseButton:
      return "kCloseButton";
    case CloseReason::kInsertButton:
      return "kInsertButton";
    case CloseReason::kMSBBCloseButton:
      return "kMSBBCloseButton";
    default:
      return nullptr;
  }
}

std::string CloseReasonToString(CloseReason value) {
  const char *str = CloseReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CloseReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CloseReason value) {
  return os << CloseReasonToString(value);
}

NOINLINE static const char* UserFeedbackToStringHelper(UserFeedback value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserFeedback::kUserFeedbackUnspecified:
      return "kUserFeedbackUnspecified";
    case UserFeedback::kUserFeedbackNegative:
      return "kUserFeedbackNegative";
    case UserFeedback::kUserFeedbackPositive:
      return "kUserFeedbackPositive";
    default:
      return nullptr;
  }
}

std::string UserFeedbackToString(UserFeedback value) {
  const char *str = UserFeedbackToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserFeedback value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserFeedback value) {
  return os << UserFeedbackToString(value);
}

namespace internal {


// static
bool ComposeResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeResponse_Data* object =
      static_cast<const ComposeResponse_Data*>(data);


  if (!::compose::mojom::internal::ComposeStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

ComposeResponse_Data::ComposeResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PartialComposeResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PartialComposeResponse_Data* object =
      static_cast<const PartialComposeResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

PartialComposeResponse_Data::PartialComposeResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeState_Data* object =
      static_cast<const ComposeState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->webui_state, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& webui_state_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->webui_state, validation_context,
                                         &webui_state_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;


  if (!::compose::mojom::internal::UserFeedback_Data
        ::Validate(object->feedback, validation_context))
    return false;

  return true;
}

ComposeState_Data::ComposeState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConfigurableParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConfigurableParams_Data* object =
      static_cast<const ConfigurableParams_Data*>(data);

  return true;
}

ConfigurableParams_Data::ConfigurableParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpenMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OpenMetadata_Data* object =
      static_cast<const OpenMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_input, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& initial_input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->initial_input, validation_context,
                                         &initial_input_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->compose_state, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->compose_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configurable_params, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configurable_params, validation_context))
    return false;

  return true;
}

OpenMetadata_Data::OpenMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->dialog, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->dialog,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data::ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data::ComposeSessionUntrustedPageHandler_LogCancelEdit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_Compose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_Compose_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_Compose_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }


  if (!::compose::mojom::internal::InputMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_Compose_Params_Data::ComposeSessionUntrustedPageHandler_Compose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_Rewrite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_Rewrite_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_Rewrite_Params_Data*>(data);


  if (!::compose::mojom::internal::StyleModifier_Data
        ::Validate(object->style, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_Rewrite_Params_Data::ComposeSessionUntrustedPageHandler_Rewrite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data::ComposeSessionUntrustedPageHandler_LogEditInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->webui_state, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& webui_state_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->webui_state, validation_context,
                                         &webui_state_validate_params)) {
    return false;
  }

  return true;
}

ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data::ComposeSessionUntrustedPageHandler_SaveWebUIState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data::ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data::ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data::ComposeSessionUntrustedPageHandler_RequestInitialState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initial_state, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data::ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_Undo_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_Undo_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_Undo_Params_Data::ComposeSessionUntrustedPageHandler_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->last_state, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data::ComposeSessionUntrustedPageHandler_Undo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->state_before_error, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data::ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_Redo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_Redo_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_Redo_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_Redo_Params_Data::ComposeSessionUntrustedPageHandler_Redo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->next_state, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data::ComposeSessionUntrustedPageHandler_Redo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data::ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data::ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data::ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data::ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data::ComposeSessionUntrustedPageHandler_OpenSignInPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data*>(data);


  if (!::compose::mojom::internal::UserFeedback_Data
        ::Validate(object->feedback, validation_context))
    return false;

  return true;
}

ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data::ComposeSessionUntrustedPageHandler_SetUserFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_EditResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_EditResult_Params_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_EditResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_result, validation_context,
                                         &new_result_validate_params)) {
    return false;
  }

  return true;
}

ComposeSessionUntrustedPageHandler_EditResult_Params_Data::ComposeSessionUntrustedPageHandler_EditResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data* object =
      static_cast<const ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data*>(data);

  return true;
}

ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data::ComposeSessionUntrustedPageHandler_EditResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeClientUntrustedPageHandler_ShowUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeClientUntrustedPageHandler_ShowUI_Params_Data* object =
      static_cast<const ComposeClientUntrustedPageHandler_ShowUI_Params_Data*>(data);

  return true;
}

ComposeClientUntrustedPageHandler_ShowUI_Params_Data::ComposeClientUntrustedPageHandler_ShowUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeClientUntrustedPageHandler_CloseUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeClientUntrustedPageHandler_CloseUI_Params_Data* object =
      static_cast<const ComposeClientUntrustedPageHandler_CloseUI_Params_Data*>(data);


  if (!::compose::mojom::internal::CloseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

ComposeClientUntrustedPageHandler_CloseUI_Params_Data::ComposeClientUntrustedPageHandler_CloseUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data* object =
      static_cast<const ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data*>(data);

  return true;
}

ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data::ComposeClientUntrustedPageHandler_CompleteFirstRun_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data* object =
      static_cast<const ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data*>(data);

  return true;
}

ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data::ComposeClientUntrustedPageHandler_OpenComposeSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeUntrustedDialog_ResponseReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeUntrustedDialog_ResponseReceived_Params_Data* object =
      static_cast<const ComposeUntrustedDialog_ResponseReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

ComposeUntrustedDialog_ResponseReceived_Params_Data::ComposeUntrustedDialog_ResponseReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComposeUntrustedDialog_PartialResponseReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComposeUntrustedDialog_PartialResponseReceived_Params_Data* object =
      static_cast<const ComposeUntrustedDialog_PartialResponseReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partial_response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->partial_response, validation_context))
    return false;

  return true;
}

ComposeUntrustedDialog_PartialResponseReceived_Params_Data::ComposeUntrustedDialog_PartialResponseReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace compose

namespace perfetto {

// static
void TraceFormatTraits<::compose::mojom::InputMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::compose::mojom::InputMode value) {
  return std::move(context).WriteString(::compose::mojom::InputModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::compose::mojom::StyleModifier>::WriteIntoTrace(
   perfetto::TracedValue context, ::compose::mojom::StyleModifier value) {
  return std::move(context).WriteString(::compose::mojom::StyleModifierToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::compose::mojom::CloseReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::compose::mojom::CloseReason value) {
  return std::move(context).WriteString(::compose::mojom::CloseReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::compose::mojom::UserFeedback>::WriteIntoTrace(
   perfetto::TracedValue context, ::compose::mojom::UserFeedback value) {
  return std::move(context).WriteString(::compose::mojom::UserFeedbackToString(value));
}

} // namespace perfetto