// chrome/common/compose/compose.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SHARED_INTERNAL_H_
#define CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "components/compose/core/browser/compose_enums.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace compose::mojom {
namespace internal {
class ComposeResponse_Data;
class PartialComposeResponse_Data;
class ComposeState_Data;
class ConfigurableParams_Data;
class OpenMetadata_Data;

struct InputMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct StyleModifier_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CloseReason_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct UserFeedback_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  ComposeResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t undo_available : 1;
  uint8_t redo_available : 1;
  uint8_t provided_by_user : 1;
  uint8_t on_device_evaluation_used : 1;
  uint8_t triggered_from_modifier : 1;
  uint8_t pad5_[3];
  mojo::internal::Pointer<mojo::internal::String_Data> result;

 private:
  friend class mojo::internal::MessageFragment<ComposeResponse_Data>;

  ComposeResponse_Data();
  ~ComposeResponse_Data() = delete;
};
static_assert(sizeof(ComposeResponse_Data) == 24,
              "Bad sizeof(ComposeResponse_Data)");
// Used by ComposeResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ComposeResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ComposeResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ComposeResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ComposeResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ComposeResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PartialComposeResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> result;

 private:
  friend class mojo::internal::MessageFragment<PartialComposeResponse_Data>;

  PartialComposeResponse_Data();
  ~PartialComposeResponse_Data() = delete;
};
static_assert(sizeof(PartialComposeResponse_Data) == 16,
              "Bad sizeof(PartialComposeResponse_Data)");
// Used by PartialComposeResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PartialComposeResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PartialComposeResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PartialComposeResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PartialComposeResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PartialComposeResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ComposeState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> webui_state;
  mojo::internal::Pointer<internal::ComposeResponse_Data> response;
  uint8_t has_pending_request : 1;
  uint8_t pad2_[3];
  int32_t feedback;

 private:
  friend class mojo::internal::MessageFragment<ComposeState_Data>;

  ComposeState_Data();
  ~ComposeState_Data() = delete;
};
static_assert(sizeof(ComposeState_Data) == 32,
              "Bad sizeof(ComposeState_Data)");
// Used by ComposeState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ComposeState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ComposeState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ComposeState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ComposeState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ComposeState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ConfigurableParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t min_word_limit;
  int32_t max_word_limit;
  int32_t max_character_limit;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ConfigurableParams_Data>;

  ConfigurableParams_Data();
  ~ConfigurableParams_Data() = delete;
};
static_assert(sizeof(ConfigurableParams_Data) == 24,
              "Bad sizeof(ConfigurableParams_Data)");
// Used by ConfigurableParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ConfigurableParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ConfigurableParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ConfigurableParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ConfigurableParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ConfigurableParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  OpenMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t fre_complete : 1;
  uint8_t msbb_state : 1;
  uint8_t text_selected : 1;
  uint8_t pad2_[7];
  mojo::internal::Pointer<mojo::internal::String_Data> initial_input;
  mojo::internal::Pointer<internal::ComposeState_Data> compose_state;
  mojo::internal::Pointer<internal::ConfigurableParams_Data> configurable_params;

 private:
  friend class mojo::internal::MessageFragment<OpenMetadata_Data>;

  OpenMetadata_Data();
  ~OpenMetadata_Data() = delete;
};
static_assert(sizeof(OpenMetadata_Data) == 40,
              "Bad sizeof(OpenMetadata_Data)");
// Used by OpenMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OpenMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OpenMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OpenMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<OpenMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OpenMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // compose::mojom

#endif  // CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SHARED_INTERNAL_H_