// chrome/common/compose/compose.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/compose/compose.mojom-shared-internal.h"
#include "components/compose/core/browser/compose_enums.mojom-shared.h"

#include "chrome/common/compose/compose.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::compose::mojom::InputMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::compose::mojom::StyleModifier, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::compose::mojom::CloseReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::compose::mojom::UserFeedback, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::compose::mojom::ComposeResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::ComposeResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::ComposeResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::compose::mojom::ComposeStatus>(
        Traits::status(input),
        &fragment->status);

      decltype(Traits::result(input)) in_result = Traits::result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->result)::BaseType> result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_result,
        result_fragment);

      fragment->result.Set(
          result_fragment.is_null() ? nullptr : result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null result in ComposeResponse struct");

      fragment->undo_available = Traits::undo_available(input);

      fragment->redo_available = Traits::redo_available(input);

      fragment->provided_by_user = Traits::provided_by_user(input);

      fragment->on_device_evaluation_used = Traits::on_device_evaluation_used(input);

      fragment->triggered_from_modifier = Traits::triggered_from_modifier(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::compose::mojom::PartialComposeResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::PartialComposeResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::PartialComposeResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::result(input)) in_result = Traits::result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->result)::BaseType> result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_result,
        result_fragment);

      fragment->result.Set(
          result_fragment.is_null() ? nullptr : result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null result in PartialComposeResponse struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::compose::mojom::ComposeStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::ComposeStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::ComposeState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::webui_state(input)) in_webui_state = Traits::webui_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->webui_state)::BaseType> webui_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_webui_state,
        webui_state_fragment);

      fragment->webui_state.Set(
          webui_state_fragment.is_null() ? nullptr : webui_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->webui_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webui_state in ComposeState struct");

      decltype(Traits::response(input)) in_response = Traits::response(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response)::BaseType> response_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::compose::mojom::ComposeResponseDataView, send_validation>(
        in_response,
        response_fragment);

      fragment->response.Set(
          response_fragment.is_null() ? nullptr : response_fragment.data());

      fragment->has_pending_request = Traits::has_pending_request(input);

      
      mojo::internal::Serialize<::compose::mojom::UserFeedback>(
        Traits::feedback(input),
        &fragment->feedback);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::compose::mojom::ConfigurableParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::ConfigurableParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::ConfigurableParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->min_word_limit = Traits::min_word_limit(input);

      fragment->max_word_limit = Traits::max_word_limit(input);

      fragment->max_character_limit = Traits::max_character_limit(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::compose::mojom::OpenMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::compose::mojom::OpenMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::compose::mojom::internal::OpenMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->fre_complete = Traits::fre_complete(input);

      fragment->msbb_state = Traits::msbb_state(input);

      decltype(Traits::initial_input(input)) in_initial_input = Traits::initial_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_input)::BaseType> initial_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_initial_input,
        initial_input_fragment);

      fragment->initial_input.Set(
          initial_input_fragment.is_null() ? nullptr : initial_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->initial_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initial_input in OpenMetadata struct");

      fragment->text_selected = Traits::text_selected(input);

      decltype(Traits::compose_state(input)) in_compose_state = Traits::compose_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->compose_state)::BaseType> compose_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::compose::mojom::ComposeStateDataView, send_validation>(
        in_compose_state,
        compose_state_fragment);

      fragment->compose_state.Set(
          compose_state_fragment.is_null() ? nullptr : compose_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->compose_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null compose_state in OpenMetadata struct");

      decltype(Traits::configurable_params(input)) in_configurable_params = Traits::configurable_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->configurable_params)::BaseType> configurable_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::compose::mojom::ConfigurableParamsDataView, send_validation>(
        in_configurable_params,
        configurable_params_fragment);

      fragment->configurable_params.Set(
          configurable_params_fragment.is_null() ? nullptr : configurable_params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->configurable_params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null configurable_params in OpenMetadata struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_SEND_VALIDATION_H_