// chrome/common/actor_webui.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/actor_webui.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/actor_webui.mojom-data-view.h"




namespace std {

template <>
struct hash<::actor::webui::mojom::UserGrantedPermissionDuration>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::UserGrantedPermissionDuration> {};

template <>
struct hash<::actor::webui::mojom::SelectCredentialDialogErrorReason>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::SelectCredentialDialogErrorReason> {};

template <>
struct hash<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason> {};

template <>
struct hash<::actor::webui::mojom::ConfirmationRequestErrorReason>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::ConfirmationRequestErrorReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserGrantedPermissionDuration, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::UserGrantedPermissionDuration, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::UserGrantedPermissionDuration>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectCredentialDialogErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::SelectCredentialDialogErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::SelectCredentialDialogErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::ConfirmationRequestErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::ConfirmationRequestErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::ConfirmationRequestErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::TaskOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::TaskOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::TaskOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
  }

  static bool Deserialize(::actor::webui::mojom::internal::TaskOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::TaskOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::CredentialDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::CredentialDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::Credential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::username(input)) in_username = Traits::username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username)::BaseType> username_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_username,
      username_fragment);

    fragment->username.Set(
        username_fragment.is_null() ? nullptr : username_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username in Credential struct");

    decltype(Traits::source_site_or_app(input)) in_source_site_or_app = Traits::source_site_or_app(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_site_or_app)::BaseType> source_site_or_app_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_source_site_or_app,
      source_site_or_app_fragment);

    fragment->source_site_or_app.Set(
        source_site_or_app_fragment.is_null() ? nullptr : source_site_or_app_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_site_or_app.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_site_or_app in Credential struct");

    decltype(Traits::request_origin(input)) in_request_origin = Traits::request_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_origin)::BaseType> request_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_request_origin,
      request_origin_fragment);

    fragment->request_origin.Set(
        request_origin_fragment.is_null() ? nullptr : request_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_origin in Credential struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::Credential_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::CredentialDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectCredentialDialogRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectCredentialDialogRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);

    fragment->show_dialog = Traits::show_dialog(input);

    decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credentials)::BaseType>
        credentials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::actor::webui::mojom::CredentialDataView>>(
      in_credentials,
      credentials_fragment,
      &credentials_validate_params);

    fragment->credentials.Set(
        credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credentials.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credentials in SelectCredentialDialogRequest struct");

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in SelectCredentialDialogRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectCredentialDialogRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectCredentialDialogResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectCredentialDialogResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);
    fragment->error_reason_$flag = Traits::error_reason(input).has_value();
    if (Traits::error_reason(input).has_value()) {
      
      mojo::internal::Serialize<::actor::webui::mojom::SelectCredentialDialogErrorReason>(
        Traits::error_reason(input).value(),
        &fragment->error_reason_$value);
    } else {
      fragment->error_reason_$value =
          static_cast<int32_t>(::actor::webui::mojom::SelectCredentialDialogErrorReason::kMinValue);
    }
    fragment->permission_duration_$flag = Traits::permission_duration(input).has_value();
    if (Traits::permission_duration(input).has_value()) {
      
      mojo::internal::Serialize<::actor::webui::mojom::UserGrantedPermissionDuration>(
        Traits::permission_duration(input).value(),
        &fragment->permission_duration_$value);
    } else {
      fragment->permission_duration_$value =
          static_cast<int32_t>(::actor::webui::mojom::UserGrantedPermissionDuration::kMinValue);
    }
    fragment->selected_credential_id_$flag = Traits::selected_credential_id(input).has_value();
    if (Traits::selected_credential_id(input).has_value()) {
      fragment->selected_credential_id_$value = Traits::selected_credential_id(input).value();
    }
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectCredentialDialogResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::AutofillSuggestionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::AutofillSuggestionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::AutofillSuggestion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in AutofillSuggestion struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in AutofillSuggestion struct");

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType> details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_details,
      details_fragment);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in AutofillSuggestion struct");

    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_icon,
      icon_fragment);

    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
  }

  static bool Deserialize(::actor::webui::mojom::internal::AutofillSuggestion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::AutofillSuggestionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::FormFillingRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::FormFillingRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::FormFillingRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->requested_data = Traits::requested_data(input);

    decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestions)::BaseType>
        suggestions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::actor::webui::mojom::AutofillSuggestionDataView>>(
      in_suggestions,
      suggestions_fragment,
      &suggestions_validate_params);

    fragment->suggestions.Set(
        suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions in FormFillingRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::FormFillingRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::FormFillingRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);

    decltype(Traits::form_filling_requests(input)) in_form_filling_requests = Traits::form_filling_requests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_filling_requests)::BaseType>
        form_filling_requests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& form_filling_requests_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::actor::webui::mojom::FormFillingRequestDataView>>(
      in_form_filling_requests,
      form_filling_requests_fragment,
      &form_filling_requests_validate_params);

    fragment->form_filling_requests.Set(
        form_filling_requests_fragment.is_null() ? nullptr : form_filling_requests_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->form_filling_requests.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null form_filling_requests in SelectAutofillSuggestionsDialogRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::FormFillingResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::FormFillingResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::FormFillingResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::selected_suggestion_id(input)) in_selected_suggestion_id = Traits::selected_suggestion_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_suggestion_id)::BaseType> selected_suggestion_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_selected_suggestion_id,
      selected_suggestion_id_fragment);

    fragment->selected_suggestion_id.Set(
        selected_suggestion_id_fragment.is_null() ? nullptr : selected_suggestion_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selected_suggestion_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selected_suggestion_id in FormFillingResponse struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::FormFillingResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::FormFillingResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectAutofillSuggestionsDialogResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);

    decltype(Traits::result(input)) in_result = Traits::result(input);
    mojo::internal::MessageFragment<decltype(fragment->result)>
        result_fragment(fragment.message());
    result_fragment.Claim(&fragment->result);
    
    mojo::internal::Serialize<::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView>(
      in_result,
      result_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in SelectAutofillSuggestionsDialogResponse struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::navigation_origin(input)) in_navigation_origin = Traits::navigation_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_origin)::BaseType> navigation_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_navigation_origin,
      navigation_origin_fragment);

    fragment->navigation_origin.Set(
        navigation_origin_fragment.is_null() ? nullptr : navigation_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_origin in UserConfirmationDialogPayload struct");

    fragment->for_blocklisted_origin = Traits::for_blocklisted_origin(input);
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogPayloadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::payload(input)) in_payload = Traits::payload(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payload)::BaseType> payload_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogPayloadDataView>(
      in_payload,
      payload_fragment);

    fragment->payload.Set(
        payload_fragment.is_null() ? nullptr : payload_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payload.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payload in UserConfirmationDialogRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::result(input)) in_result = Traits::result(input);
    mojo::internal::MessageFragment<decltype(fragment->result)>
        result_fragment(fragment.message());
    result_fragment.Claim(&fragment->result);
    
    mojo::internal::Serialize<::actor::webui::mojom::ConfirmationRequestResultDataView>(
      in_result,
      result_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in UserConfirmationDialogResponse struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::NavigationConfirmationRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::NavigationConfirmationRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::NavigationConfirmationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);

    decltype(Traits::navigation_origin(input)) in_navigation_origin = Traits::navigation_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_origin)::BaseType> navigation_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_navigation_origin,
      navigation_origin_fragment);

    fragment->navigation_origin.Set(
        navigation_origin_fragment.is_null() ? nullptr : navigation_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_origin in NavigationConfirmationRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::NavigationConfirmationRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::NavigationConfirmationRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::NavigationConfirmationResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::NavigationConfirmationResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::NavigationConfirmationResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::result(input)) in_result = Traits::result(input);
    mojo::internal::MessageFragment<decltype(fragment->result)>
        result_fragment(fragment.message());
    result_fragment.Claim(&fragment->result);
    
    mojo::internal::Serialize<::actor::webui::mojom::ConfirmationRequestResultDataView>(
      in_result,
      result_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in NavigationConfirmationResponse struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::NavigationConfirmationResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::NavigationConfirmationResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
  case ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView::Tag::kSelectedSuggestions: {
    decltype(Traits::selected_suggestions(input))
    in_selected_suggestions = Traits::selected_suggestions(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_selected_suggestions)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& selected_suggestions_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::actor::webui::mojom::FormFillingResponseDataView>>(
  in_selected_suggestions,
  value_fragment,
  &selected_suggestions_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null selected_suggestions in SelectAutofillSuggestionsDialogResult union");
    fragment->data.f_selected_suggestions.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::UserConfirmationDialogResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::UserConfirmationDialogResultDataView::Tag::kPermissionGranted: {
    decltype(Traits::permission_granted(input))
    in_permission_granted = Traits::permission_granted(input);
    fragment->data.f_permission_granted = in_permission_granted;
    break;
  }
  case ::actor::webui::mojom::UserConfirmationDialogResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::actor::webui::mojom::ConfirmationRequestErrorReason>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
}
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::ConfirmationRequestResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::ConfirmationRequestResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::ConfirmationRequestResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::ConfirmationRequestResultDataView::Tag::kPermissionGranted: {
    decltype(Traits::permission_granted(input))
    in_permission_granted = Traits::permission_granted(input);
    fragment->data.f_permission_granted = in_permission_granted;
    break;
  }
  case ::actor::webui::mojom::ConfirmationRequestResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::actor::webui::mojom::ConfirmationRequestErrorReason>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
}
  }

  static bool Deserialize(::actor::webui::mojom::internal::ConfirmationRequestResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::ConfirmationRequestResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace actor::webui::mojom {

inline void TaskOptionsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CredentialDataView::GetUsernameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->username.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CredentialDataView::GetSourceSiteOrAppDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source_site_or_app.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CredentialDataView::GetRequestOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void SelectCredentialDialogRequestDataView::GetCredentialsDataView(
    mojo::ArrayDataView<CredentialDataView>* output) {
  auto pointer = data_->credentials.Get();
  *output = mojo::ArrayDataView<CredentialDataView>(pointer, message_);
}
inline void SelectCredentialDialogRequestDataView::GetIconsDataView(
    mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>(pointer, message_);
}




inline void AutofillSuggestionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutofillSuggestionDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutofillSuggestionDataView::GetDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->details.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutofillSuggestionDataView::GetIconDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}


inline void FormFillingRequestDataView::GetSuggestionsDataView(
    mojo::ArrayDataView<AutofillSuggestionDataView>* output) {
  auto pointer = data_->suggestions.Get();
  *output = mojo::ArrayDataView<AutofillSuggestionDataView>(pointer, message_);
}


inline void SelectAutofillSuggestionsDialogRequestDataView::GetFormFillingRequestsDataView(
    mojo::ArrayDataView<FormFillingRequestDataView>* output) {
  auto pointer = data_->form_filling_requests.Get();
  *output = mojo::ArrayDataView<FormFillingRequestDataView>(pointer, message_);
}


inline void FormFillingResponseDataView::GetSelectedSuggestionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->selected_suggestion_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SelectAutofillSuggestionsDialogResponseDataView::GetResultDataView(
    SelectAutofillSuggestionsDialogResultDataView* output) {
  auto pointer = &data_->result;
  *output = SelectAutofillSuggestionsDialogResultDataView(pointer, message_);
}


inline void UserConfirmationDialogPayloadDataView::GetNavigationOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->navigation_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void UserConfirmationDialogRequestDataView::GetPayloadDataView(
    UserConfirmationDialogPayloadDataView* output) {
  auto pointer = data_->payload.Get();
  *output = UserConfirmationDialogPayloadDataView(pointer, message_);
}


inline void UserConfirmationDialogResponseDataView::GetResultDataView(
    ConfirmationRequestResultDataView* output) {
  auto pointer = &data_->result;
  *output = ConfirmationRequestResultDataView(pointer, message_);
}


inline void NavigationConfirmationRequestDataView::GetNavigationOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->navigation_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void NavigationConfirmationResponseDataView::GetResultDataView(
    ConfirmationRequestResultDataView* output) {
  auto pointer = &data_->result;
  *output = ConfirmationRequestResultDataView(pointer, message_);
}


inline void SelectAutofillSuggestionsDialogResultDataView::GetSelectedSuggestionsDataView(
    mojo::ArrayDataView<FormFillingResponseDataView>* output) const {
  CHECK(is_selected_suggestions());
  *output = mojo::ArrayDataView<FormFillingResponseDataView>(data_->data.f_selected_suggestions.Get(), message_);
}




}  // actor::webui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::UserGrantedPermissionDuration> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::UserGrantedPermissionDuration value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::SelectCredentialDialogErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::SelectCredentialDialogErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::ConfirmationRequestErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::ConfirmationRequestErrorReason value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_H_