// chrome/common/actor_webui.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/common/actor_webui.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace actor::webui::mojom {
class TaskOptionsDataView;

class CredentialDataView;

class SelectCredentialDialogRequestDataView;

class SelectCredentialDialogResponseDataView;

class AutofillSuggestionDataView;

class FormFillingRequestDataView;

class SelectAutofillSuggestionsDialogRequestDataView;

class FormFillingResponseDataView;

class SelectAutofillSuggestionsDialogResponseDataView;

class UserConfirmationDialogPayloadDataView;

class UserConfirmationDialogRequestDataView;

class UserConfirmationDialogResponseDataView;

class NavigationConfirmationRequestDataView;

class NavigationConfirmationResponseDataView;

class SelectAutofillSuggestionsDialogResultDataView;
class UserConfirmationDialogResultDataView;
class ConfirmationRequestResultDataView;


}  // actor::webui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::actor::webui::mojom::TaskOptionsDataView> {
  using Data = ::actor::webui::mojom::internal::TaskOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::CredentialDataView> {
  using Data = ::actor::webui::mojom::internal::Credential_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectCredentialDialogRequestDataView> {
  using Data = ::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectCredentialDialogResponseDataView> {
  using Data = ::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::AutofillSuggestionDataView> {
  using Data = ::actor::webui::mojom::internal::AutofillSuggestion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::FormFillingRequestDataView> {
  using Data = ::actor::webui::mojom::internal::FormFillingRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestDataView> {
  using Data = ::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::FormFillingResponseDataView> {
  using Data = ::actor::webui::mojom::internal::FormFillingResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResponseDataView> {
  using Data = ::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogPayloadDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogRequestDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogResponseDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::NavigationConfirmationRequestDataView> {
  using Data = ::actor::webui::mojom::internal::NavigationConfirmationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::NavigationConfirmationResponseDataView> {
  using Data = ::actor::webui::mojom::internal::NavigationConfirmationResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView> {
  using Data = ::actor::webui::mojom::internal::SelectAutofillSuggestionsDialogResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::UserConfirmationDialogResultDataView> {
  using Data = ::actor::webui::mojom::internal::UserConfirmationDialogResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::actor::webui::mojom::ConfirmationRequestResultDataView> {
  using Data = ::actor::webui::mojom::internal::ConfirmationRequestResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace actor::webui::mojom {


enum class UserGrantedPermissionDuration : int32_t {
  
  kOneTime = 0,
  
  kAlwaysAllow = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, UserGrantedPermissionDuration value);
inline bool IsKnownEnumValue(UserGrantedPermissionDuration value) {
  return internal::UserGrantedPermissionDuration_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UserGrantedPermissionDuration ToKnownEnumValue(UserGrantedPermissionDuration value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UserGrantedPermissionDuration::kDefaultValue;
}


enum class SelectCredentialDialogErrorReason : int32_t {
  
  kDialogPromiseNoSubscriber = 0,
  kMinValue = 0,
  kMaxValue = 0,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SelectCredentialDialogErrorReason value);
inline bool IsKnownEnumValue(SelectCredentialDialogErrorReason value) {
  return internal::SelectCredentialDialogErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SelectCredentialDialogErrorReason ToKnownEnumValue(SelectCredentialDialogErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SelectCredentialDialogErrorReason::kDefaultValue;
}


enum class SelectAutofillSuggestionsDialogErrorReason : int32_t {
  
  kDialogPromiseNoSubscriber = 0,
  
  kMismatchedTaskId = 1,
  
  kNoActorTaskDelegate = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SelectAutofillSuggestionsDialogErrorReason value);
inline bool IsKnownEnumValue(SelectAutofillSuggestionsDialogErrorReason value) {
  return internal::SelectAutofillSuggestionsDialogErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ConfirmationRequestErrorReason : int32_t {
  
  kRequestPromiseNoSubscriber = 0,
  
  kPreemptedByNewRequest = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ConfirmationRequestErrorReason value);
inline bool IsKnownEnumValue(ConfirmationRequestErrorReason value) {
  return internal::ConfirmationRequestErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ConfirmationRequestErrorReason ToKnownEnumValue(ConfirmationRequestErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ConfirmationRequestErrorReason::kDefaultValue;
}


class TaskOptionsDataView {
 public:
  TaskOptionsDataView() = default;

  TaskOptionsDataView(
      internal::TaskOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TaskOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CredentialDataView {
 public:
  CredentialDataView() = default;

  CredentialDataView(
      internal::Credential_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetUsernameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsername(UserType* output) {
    
    auto* pointer = data_->username.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceSiteOrAppDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceSiteOrApp(UserType* output) {
    
    auto* pointer = data_->source_site_or_app.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRequestOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestOrigin(UserType* output) {
    
    auto* pointer = data_->request_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::Credential_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectCredentialDialogRequestDataView {
 public:
  SelectCredentialDialogRequestDataView() = default;

  SelectCredentialDialogRequestDataView(
      internal::SelectCredentialDialogRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  bool show_dialog() const {
    return data_->show_dialog;
  }
  inline void GetCredentialsDataView(
      mojo::ArrayDataView<CredentialDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::actor::webui::mojom::CredentialDataView>>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>>(
        pointer, output, message_);
  }
 private:
  internal::SelectCredentialDialogRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectCredentialDialogResponseDataView {
 public:
  SelectCredentialDialogResponseDataView() = default;

  SelectCredentialDialogResponseDataView(
      internal::SelectCredentialDialogResponse_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    if (!data_->error_reason_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::actor::webui::mojom::SelectCredentialDialogErrorReason>(
        data_->error_reason_$value, &output->emplace());
  }
  std::optional<SelectCredentialDialogErrorReason> error_reason() const {
    if (!data_->error_reason_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::webui::mojom::SelectCredentialDialogErrorReason>(data_->error_reason_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPermissionDuration(UserType* output) const {
    if (!data_->permission_duration_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::actor::webui::mojom::UserGrantedPermissionDuration>(
        data_->permission_duration_$value, &output->emplace());
  }
  std::optional<UserGrantedPermissionDuration> permission_duration() const {
    if (!data_->permission_duration_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::actor::webui::mojom::UserGrantedPermissionDuration>(data_->permission_duration_$value));
  }
  std::optional<int32_t> selected_credential_id() const {

    return data_->selected_credential_id_$flag
        ? std::make_optional(data_->selected_credential_id_$value)
        : std::nullopt;
  }
 private:
  internal::SelectCredentialDialogResponse_Data* data_ = nullptr;
};


class AutofillSuggestionDataView {
 public:
  AutofillSuggestionDataView() = default;

  AutofillSuggestionDataView(
      internal::AutofillSuggestion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIcon` instead "
    "of `ReadIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
 private:
  internal::AutofillSuggestion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFillingRequestDataView {
 public:
  FormFillingRequestDataView() = default;

  FormFillingRequestDataView(
      internal::FormFillingRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t requested_data() const {
    return data_->requested_data;
  }
  inline void GetSuggestionsDataView(
      mojo::ArrayDataView<AutofillSuggestionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestions(UserType* output) {
    
    auto* pointer = data_->suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::actor::webui::mojom::AutofillSuggestionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FormFillingRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectAutofillSuggestionsDialogRequestDataView {
 public:
  SelectAutofillSuggestionsDialogRequestDataView() = default;

  SelectAutofillSuggestionsDialogRequestDataView(
      internal::SelectAutofillSuggestionsDialogRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  inline void GetFormFillingRequestsDataView(
      mojo::ArrayDataView<FormFillingRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormFillingRequests(UserType* output) {
    
    auto* pointer = data_->form_filling_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::actor::webui::mojom::FormFillingRequestDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SelectAutofillSuggestionsDialogRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormFillingResponseDataView {
 public:
  FormFillingResponseDataView() = default;

  FormFillingResponseDataView(
      internal::FormFillingResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSelectedSuggestionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedSuggestionId(UserType* output) {
    
    auto* pointer = data_->selected_suggestion_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FormFillingResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectAutofillSuggestionsDialogResponseDataView {
 public:
  SelectAutofillSuggestionsDialogResponseDataView() = default;

  SelectAutofillSuggestionsDialogResponseDataView(
      internal::SelectAutofillSuggestionsDialogResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  inline void GetResultDataView(
      SelectAutofillSuggestionsDialogResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::actor::webui::mojom::SelectAutofillSuggestionsDialogResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectAutofillSuggestionsDialogResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserConfirmationDialogPayloadDataView {
 public:
  UserConfirmationDialogPayloadDataView() = default;

  UserConfirmationDialogPayloadDataView(
      internal::UserConfirmationDialogPayload_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNavigationOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationOrigin(UserType* output) {
    
    auto* pointer = data_->navigation_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool for_blocklisted_origin() const {
    return data_->for_blocklisted_origin;
  }
 private:
  internal::UserConfirmationDialogPayload_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserConfirmationDialogRequestDataView {
 public:
  UserConfirmationDialogRequestDataView() = default;

  UserConfirmationDialogRequestDataView(
      internal::UserConfirmationDialogRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPayloadDataView(
      UserConfirmationDialogPayloadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayload(UserType* output) {
    
    auto* pointer = data_->payload.Get();
    return mojo::internal::Deserialize<::actor::webui::mojom::UserConfirmationDialogPayloadDataView>(
        pointer, output, message_);
  }
 private:
  internal::UserConfirmationDialogRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserConfirmationDialogResponseDataView {
 public:
  UserConfirmationDialogResponseDataView() = default;

  UserConfirmationDialogResponseDataView(
      internal::UserConfirmationDialogResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ConfirmationRequestResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::actor::webui::mojom::ConfirmationRequestResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::UserConfirmationDialogResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationConfirmationRequestDataView {
 public:
  NavigationConfirmationRequestDataView() = default;

  NavigationConfirmationRequestDataView(
      internal::NavigationConfirmationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t task_id() const {
    return data_->task_id;
  }
  inline void GetNavigationOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationOrigin(UserType* output) {
    
    auto* pointer = data_->navigation_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationConfirmationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationConfirmationResponseDataView {
 public:
  NavigationConfirmationResponseDataView() = default;

  NavigationConfirmationResponseDataView(
      internal::NavigationConfirmationResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ConfirmationRequestResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::actor::webui::mojom::ConfirmationRequestResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationConfirmationResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectAutofillSuggestionsDialogResultDataView {
 public:
  using Tag = internal::SelectAutofillSuggestionsDialogResult_Data::SelectAutofillSuggestionsDialogResult_Tag;

  SelectAutofillSuggestionsDialogResultDataView() = default;

  SelectAutofillSuggestionsDialogResultDataView(
      internal::SelectAutofillSuggestionsDialogResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_reason() const { return data_->tag == Tag::kErrorReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    CHECK(is_error_reason());
    return mojo::internal::Deserialize<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason>(
        data_->data.f_error_reason, output);
  }
  SelectAutofillSuggestionsDialogErrorReason error_reason() const {
    CHECK(is_error_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::SelectAutofillSuggestionsDialogErrorReason>(data_->data.f_error_reason));
  }
  bool is_selected_suggestions() const { return data_->tag == Tag::kSelectedSuggestions; }
  inline void GetSelectedSuggestionsDataView(
      mojo::ArrayDataView<FormFillingResponseDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedSuggestions(UserType* output) const {
    
    CHECK(is_selected_suggestions());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::actor::webui::mojom::FormFillingResponseDataView>>(
        data_->data.f_selected_suggestions.Get(), output, message_);
  }

 private:
  internal::SelectAutofillSuggestionsDialogResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UserConfirmationDialogResultDataView {
 public:
  using Tag = internal::UserConfirmationDialogResult_Data::UserConfirmationDialogResult_Tag;

  UserConfirmationDialogResultDataView() = default;

  UserConfirmationDialogResultDataView(
      internal::UserConfirmationDialogResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_permission_granted() const { return data_->tag == Tag::kPermissionGranted; }
  bool permission_granted() const {
    CHECK(is_permission_granted());
    return data_->data.f_permission_granted;
  }
  bool is_error_reason() const { return data_->tag == Tag::kErrorReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    CHECK(is_error_reason());
    return mojo::internal::Deserialize<::actor::webui::mojom::ConfirmationRequestErrorReason>(
        data_->data.f_error_reason, output);
  }
  ConfirmationRequestErrorReason error_reason() const {
    CHECK(is_error_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::ConfirmationRequestErrorReason>(data_->data.f_error_reason));
  }

 private:
  internal::UserConfirmationDialogResult_Data* data_ = nullptr;
};



class ConfirmationRequestResultDataView {
 public:
  using Tag = internal::ConfirmationRequestResult_Data::ConfirmationRequestResult_Tag;

  ConfirmationRequestResultDataView() = default;

  ConfirmationRequestResultDataView(
      internal::ConfirmationRequestResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_permission_granted() const { return data_->tag == Tag::kPermissionGranted; }
  bool permission_granted() const {
    CHECK(is_permission_granted());
    return data_->data.f_permission_granted;
  }
  bool is_error_reason() const { return data_->tag == Tag::kErrorReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    CHECK(is_error_reason());
    return mojo::internal::Deserialize<::actor::webui::mojom::ConfirmationRequestErrorReason>(
        data_->data.f_error_reason, output);
  }
  ConfirmationRequestErrorReason error_reason() const {
    CHECK(is_error_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::ConfirmationRequestErrorReason>(data_->data.f_error_reason));
  }

 private:
  internal::ConfirmationRequestResult_Data* data_ = nullptr;
};



}  // actor::webui::mojom

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_DATA_VIEW_H_