// chrome/common/actor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_MOJOM_H_
#define CHROME_COMMON_ACTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/actor.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/actor.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/actor.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/common/actor/task_id.h"
#include "chrome/common/actor_mojom_traits.h"




namespace actor::mojom {

class JournalClientProxy;

template <typename ImplRefTraits>
class JournalClientStub;

class JournalClientRequestValidator;


class JournalClient
    : public JournalClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.mojom.JournalClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = JournalClientInterfaceBase;
  using Proxy_ = JournalClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = JournalClientStub<ImplRefTraits>;

  using RequestValidator_ = JournalClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddEntriesToJournalMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddEntriesToJournal_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~JournalClient() = default;

  virtual void AddEntriesToJournal(std::vector<JournalEntryPtr> entries) = 0;
};

class PageStabilityMonitorProxy;

template <typename ImplRefTraits>
class PageStabilityMonitorStub;

class PageStabilityMonitorRequestValidator;
class PageStabilityMonitorResponseValidator;


class PageStabilityMonitor
    : public PageStabilityMonitorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.mojom.PageStabilityMonitor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageStabilityMonitorInterfaceBase;
  using Proxy_ = PageStabilityMonitorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStabilityMonitorStub<ImplRefTraits>;

  using RequestValidator_ = PageStabilityMonitorRequestValidator;
  using ResponseValidator_ = PageStabilityMonitorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNotifyWhenStableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyWhenStable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageStabilityMonitor() = default;

  using NotifyWhenStableCallback = base::OnceCallback<void()>;
  using NotifyWhenStableMojoCallback = base::OnceCallback<void()>;

  virtual void NotifyWhenStable(::base::TimeDelta observation_delay, NotifyWhenStableCallback callback) = 0;
};



class  JournalClientProxy
    : public JournalClient {
 public:
  using InterfaceType = JournalClient;

  explicit JournalClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddEntriesToJournal(std::vector<JournalEntryPtr> entries) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageStabilityMonitorProxy
    : public PageStabilityMonitor {
 public:
  using InterfaceType = PageStabilityMonitor;

  explicit PageStabilityMonitorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyWhenStable(::base::TimeDelta observation_delay, NotifyWhenStableCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  JournalClientStubDispatch {
 public:
  static bool Accept(JournalClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      JournalClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<JournalClient>>
class JournalClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  JournalClientStub() = default;
  ~JournalClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return JournalClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return JournalClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStabilityMonitorStubDispatch {
 public:
  static bool Accept(PageStabilityMonitor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageStabilityMonitor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageStabilityMonitor>>
class PageStabilityMonitorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStabilityMonitorStub() = default;
  ~PageStabilityMonitorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStabilityMonitorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStabilityMonitorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  JournalClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageStabilityMonitorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageStabilityMonitorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  ClickAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClickAction, T>::value>;
  using DataView = ClickActionDataView;
  using Data_ = internal::ClickAction_Data;
  using Type = ClickAction_Type;
  using Count = ClickAction_Count;

  template <typename... Args>
  static ClickActionPtr New(Args&&... args) {
    return ClickActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClickActionPtr From(const U& u) {
    return mojo::TypeConverter<ClickActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClickAction>::Convert(*this);
  }


  ClickAction();

  ClickAction(
      ClickAction::Type type,
      ClickAction::Count count);


  ~ClickAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClickActionPtr>
  ClickActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClickAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClickAction_UnserializedMessageContext<
            UserType, ClickAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClickAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClickAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClickAction_UnserializedMessageContext<
            UserType, ClickAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClickAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ClickAction::Type type;
  
  ClickAction::Count count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClickAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MouseMoveAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MouseMoveAction, T>::value>;
  using DataView = MouseMoveActionDataView;
  using Data_ = internal::MouseMoveAction_Data;

  template <typename... Args>
  static MouseMoveActionPtr New(Args&&... args) {
    return MouseMoveActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MouseMoveActionPtr From(const U& u) {
    return mojo::TypeConverter<MouseMoveActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MouseMoveAction>::Convert(*this);
  }


  MouseMoveAction();


  ~MouseMoveAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MouseMoveActionPtr>
  MouseMoveActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MouseMoveAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MouseMoveAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MouseMoveAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MouseMoveAction_UnserializedMessageContext<
            UserType, MouseMoveAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MouseMoveAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MouseMoveAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MouseMoveAction_UnserializedMessageContext<
            UserType, MouseMoveAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MouseMoveAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MouseMoveAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScrollToAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollToAction, T>::value>;
  using DataView = ScrollToActionDataView;
  using Data_ = internal::ScrollToAction_Data;

  template <typename... Args>
  static ScrollToActionPtr New(Args&&... args) {
    return ScrollToActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollToActionPtr From(const U& u) {
    return mojo::TypeConverter<ScrollToActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollToAction>::Convert(*this);
  }


  ScrollToAction();


  ~ScrollToAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollToActionPtr>
  ScrollToActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollToAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollToAction_UnserializedMessageContext<
            UserType, ScrollToAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollToAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollToAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollToAction_UnserializedMessageContext<
            UserType, ScrollToAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollToAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollToAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TypeAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TypeAction, T>::value>;
  using DataView = TypeActionDataView;
  using Data_ = internal::TypeAction_Data;
  using Mode = TypeAction_Mode;

  template <typename... Args>
  static TypeActionPtr New(Args&&... args) {
    return TypeActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TypeActionPtr From(const U& u) {
    return mojo::TypeConverter<TypeActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TypeAction>::Convert(*this);
  }


  TypeAction();

  TypeAction(
      TypeAction::Mode mode,
      const std::string& text,
      bool follow_by_enter);


  ~TypeAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TypeActionPtr>
  TypeActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypeAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TypeAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TypeAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TypeAction_UnserializedMessageContext<
            UserType, TypeAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TypeAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TypeAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TypeAction_UnserializedMessageContext<
            UserType, TypeAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TypeAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TypeAction::Mode mode;
  
  std::string text;
  
  bool follow_by_enter;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TypeAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScrollAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollAction, T>::value>;
  using DataView = ScrollActionDataView;
  using Data_ = internal::ScrollAction_Data;
  using ScrollDirection = ScrollAction_ScrollDirection;

  template <typename... Args>
  static ScrollActionPtr New(Args&&... args) {
    return ScrollActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollActionPtr From(const U& u) {
    return mojo::TypeConverter<ScrollActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollAction>::Convert(*this);
  }


  ScrollAction();

  ScrollAction(
      ScrollAction::ScrollDirection direction,
      float distance);


  ~ScrollAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollActionPtr>
  ScrollActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollAction_UnserializedMessageContext<
            UserType, ScrollAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollAction_UnserializedMessageContext<
            UserType, ScrollAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollAction::ScrollDirection direction;
  
  float distance;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SelectAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectAction, T>::value>;
  using DataView = SelectActionDataView;
  using Data_ = internal::SelectAction_Data;

  template <typename... Args>
  static SelectActionPtr New(Args&&... args) {
    return SelectActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectActionPtr From(const U& u) {
    return mojo::TypeConverter<SelectActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectAction>::Convert(*this);
  }


  SelectAction();

  explicit SelectAction(
      const std::string& value);


  ~SelectAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectActionPtr>
  SelectActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectAction_UnserializedMessageContext<
            UserType, SelectAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectAction_UnserializedMessageContext<
            UserType, SelectAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ScriptToolAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScriptToolAction, T>::value>;
  using DataView = ScriptToolActionDataView;
  using Data_ = internal::ScriptToolAction_Data;

  template <typename... Args>
  static ScriptToolActionPtr New(Args&&... args) {
    return ScriptToolActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScriptToolActionPtr From(const U& u) {
    return mojo::TypeConverter<ScriptToolActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScriptToolAction>::Convert(*this);
  }


  ScriptToolAction();

  ScriptToolAction(
      const std::string& name,
      const std::string& input_arguments);


  ~ScriptToolAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScriptToolActionPtr>
  ScriptToolActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptToolAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptToolAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScriptToolAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScriptToolAction_UnserializedMessageContext<
            UserType, ScriptToolAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScriptToolAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScriptToolAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScriptToolAction_UnserializedMessageContext<
            UserType, ScriptToolAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScriptToolAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string input_arguments;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScriptToolAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TaskId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TaskId, T>::value>;
  using DataView = TaskIdDataView;
  using Data_ = internal::TaskId_Data;

  template <typename... Args>
  static TaskIdPtr New(Args&&... args) {
    return TaskIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TaskIdPtr From(const U& u) {
    return mojo::TypeConverter<TaskIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TaskId>::Convert(*this);
  }


  TaskId();

  explicit TaskId(
      int32_t id);


  ~TaskId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TaskIdPtr>
  TaskIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TaskId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TaskId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TaskId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TaskId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TaskId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TaskId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TaskId_UnserializedMessageContext<
            UserType, TaskId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TaskId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TaskId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TaskId_UnserializedMessageContext<
            UserType, TaskId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TaskId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TaskId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TaskId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TaskId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TaskId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  JournalDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JournalDetails, T>::value>;
  using DataView = JournalDetailsDataView;
  using Data_ = internal::JournalDetails_Data;

  template <typename... Args>
  static JournalDetailsPtr New(Args&&... args) {
    return JournalDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JournalDetailsPtr From(const U& u) {
    return mojo::TypeConverter<JournalDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JournalDetails>::Convert(*this);
  }


  JournalDetails();

  JournalDetails(
      const std::string& key,
      const std::string& value);


  ~JournalDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JournalDetailsPtr>
  JournalDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JournalDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JournalDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JournalDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JournalDetails_UnserializedMessageContext<
            UserType, JournalDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JournalDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JournalDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JournalDetails_UnserializedMessageContext<
            UserType, JournalDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JournalDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JournalDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ToolTarget {
 public:
  using DataView = ToolTargetDataView;
  using Data_ = internal::ToolTarget_Data;
  using Tag = Data_::ToolTarget_Tag;

  template <typename... Args>
  static ToolTargetPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |dom_node_id|.
  static ToolTargetPtr NewDomNodeId(
      int32_t value);
  // Construct an instance holding |coordinate_dip|.
  static ToolTargetPtr NewCoordinateDip(
      const ::gfx::Point& value);

  template <typename U>
  static ToolTargetPtr From(const U& u) {
    return mojo::TypeConverter<ToolTargetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ToolTarget>::Convert(*this);
  }
  ~ToolTarget();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ToolTarget(const ToolTarget& other) = delete;
  ToolTarget& operator=(const ToolTarget& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ToolTargetPtr>
  ToolTargetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ToolTarget>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ToolTarget>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_dom_node_id() const { return tag_ == Tag::kDomNodeId; }
  int32_t get_dom_node_id() const {
    CHECK(tag_ == Tag::kDomNodeId);
    return data_.dom_node_id;
  }
  void set_dom_node_id(int32_t dom_node_id);

  bool is_coordinate_dip() const { return tag_ == Tag::kCoordinateDip; }
  const ::gfx::Point& get_coordinate_dip() const {
    CHECK(tag_ == Tag::kCoordinateDip);
    return data_.coordinate_dip;
  }
  ::gfx::Point& get_coordinate_dip() {
    CHECK(tag_ == Tag::kCoordinateDip);
    return data_.coordinate_dip;
  }
  void set_coordinate_dip(const ::gfx::Point& coordinate_dip);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ToolTarget::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ToolTarget::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDomNodeId)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCoordinateDip)>,
        const ::gfx::Point& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int32_t dom_node_id;
    ::gfx::Point coordinate_dip;
  };

  ToolTarget(
      std::in_place_index_t<static_cast<size_t>(Tag::kDomNodeId)>,
      int32_t value);
  ToolTarget(
      std::in_place_index_t<static_cast<size_t>(Tag::kCoordinateDip)>,
      const ::gfx::Point& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ToolAction {
 public:
  using DataView = ToolActionDataView;
  using Data_ = internal::ToolAction_Data;
  using Tag = Data_::ToolAction_Tag;

  template <typename... Args>
  static ToolActionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |click|.
  static ToolActionPtr NewClick(
      ClickActionPtr value);
  // Construct an instance holding |drag_and_release|.
  static ToolActionPtr NewDragAndRelease(
      DragAndReleaseActionPtr value);
  // Construct an instance holding |mouse_move|.
  static ToolActionPtr NewMouseMove(
      MouseMoveActionPtr value);
  // Construct an instance holding |scroll|.
  static ToolActionPtr NewScroll(
      ScrollActionPtr value);
  // Construct an instance holding |select|.
  static ToolActionPtr NewSelect(
      SelectActionPtr value);
  // Construct an instance holding |type|.
  static ToolActionPtr NewType(
      TypeActionPtr value);
  // Construct an instance holding |script_tool|.
  static ToolActionPtr NewScriptTool(
      ScriptToolActionPtr value);
  // Construct an instance holding |scroll_to|.
  static ToolActionPtr NewScrollTo(
      ScrollToActionPtr value);

  template <typename U>
  static ToolActionPtr From(const U& u) {
    return mojo::TypeConverter<ToolActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ToolAction>::Convert(*this);
  }
  ~ToolAction();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ToolAction(const ToolAction& other) = delete;
  ToolAction& operator=(const ToolAction& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ToolActionPtr>
  ToolActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ToolAction>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ToolAction>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_click() const { return tag_ == Tag::kClick; }
  const ClickActionPtr& get_click() const {
    CHECK(tag_ == Tag::kClick);
    return data_.click;
  }
  ClickActionPtr& get_click() {
    CHECK(tag_ == Tag::kClick);
    return data_.click;
  }
  void set_click(ClickActionPtr click);

  bool is_drag_and_release() const { return tag_ == Tag::kDragAndRelease; }
  const DragAndReleaseActionPtr& get_drag_and_release() const {
    CHECK(tag_ == Tag::kDragAndRelease);
    return data_.drag_and_release;
  }
  DragAndReleaseActionPtr& get_drag_and_release() {
    CHECK(tag_ == Tag::kDragAndRelease);
    return data_.drag_and_release;
  }
  void set_drag_and_release(DragAndReleaseActionPtr drag_and_release);

  bool is_mouse_move() const { return tag_ == Tag::kMouseMove; }
  const MouseMoveActionPtr& get_mouse_move() const {
    CHECK(tag_ == Tag::kMouseMove);
    return data_.mouse_move;
  }
  MouseMoveActionPtr& get_mouse_move() {
    CHECK(tag_ == Tag::kMouseMove);
    return data_.mouse_move;
  }
  void set_mouse_move(MouseMoveActionPtr mouse_move);

  bool is_scroll() const { return tag_ == Tag::kScroll; }
  const ScrollActionPtr& get_scroll() const {
    CHECK(tag_ == Tag::kScroll);
    return data_.scroll;
  }
  ScrollActionPtr& get_scroll() {
    CHECK(tag_ == Tag::kScroll);
    return data_.scroll;
  }
  void set_scroll(ScrollActionPtr scroll);

  bool is_select() const { return tag_ == Tag::kSelect; }
  const SelectActionPtr& get_select() const {
    CHECK(tag_ == Tag::kSelect);
    return data_.select;
  }
  SelectActionPtr& get_select() {
    CHECK(tag_ == Tag::kSelect);
    return data_.select;
  }
  void set_select(SelectActionPtr select);

  bool is_type() const { return tag_ == Tag::kType; }
  const TypeActionPtr& get_type() const {
    CHECK(tag_ == Tag::kType);
    return data_.type;
  }
  TypeActionPtr& get_type() {
    CHECK(tag_ == Tag::kType);
    return data_.type;
  }
  void set_type(TypeActionPtr type);

  bool is_script_tool() const { return tag_ == Tag::kScriptTool; }
  const ScriptToolActionPtr& get_script_tool() const {
    CHECK(tag_ == Tag::kScriptTool);
    return data_.script_tool;
  }
  ScriptToolActionPtr& get_script_tool() {
    CHECK(tag_ == Tag::kScriptTool);
    return data_.script_tool;
  }
  void set_script_tool(ScriptToolActionPtr script_tool);

  bool is_scroll_to() const { return tag_ == Tag::kScrollTo; }
  const ScrollToActionPtr& get_scroll_to() const {
    CHECK(tag_ == Tag::kScrollTo);
    return data_.scroll_to;
  }
  ScrollToActionPtr& get_scroll_to() {
    CHECK(tag_ == Tag::kScrollTo);
    return data_.scroll_to;
  }
  void set_scroll_to(ScrollToActionPtr scroll_to);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ToolAction::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ToolAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kClick)>,
        ClickActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDragAndRelease)>,
        DragAndReleaseActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMouseMove)>,
        MouseMoveActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScroll)>,
        ScrollActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSelect)>,
        SelectActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kType)>,
        TypeActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScriptTool)>,
        ScriptToolActionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScrollTo)>,
        ScrollToActionPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ClickActionPtr click;
    DragAndReleaseActionPtr drag_and_release;
    MouseMoveActionPtr mouse_move;
    ScrollActionPtr scroll;
    SelectActionPtr select;
    TypeActionPtr type;
    ScriptToolActionPtr script_tool;
    ScrollToActionPtr scroll_to;
  };

  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kClick)>,
      ClickActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kDragAndRelease)>,
      DragAndReleaseActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kMouseMove)>,
      MouseMoveActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kScroll)>,
      ScrollActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kSelect)>,
      SelectActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kType)>,
      TypeActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kScriptTool)>,
      ScriptToolActionPtr value);
  ToolAction(
      std::in_place_index_t<static_cast<size_t>(Tag::kScrollTo)>,
      ScrollToActionPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  ObservedToolTarget {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ObservedToolTarget, T>::value>;
  using DataView = ObservedToolTargetDataView;
  using Data_ = internal::ObservedToolTarget_Data;

  template <typename... Args>
  static ObservedToolTargetPtr New(Args&&... args) {
    return ObservedToolTargetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ObservedToolTargetPtr From(const U& u) {
    return mojo::TypeConverter<ObservedToolTargetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ObservedToolTarget>::Convert(*this);
  }


  ObservedToolTarget();

  explicit ObservedToolTarget(
      ::blink::mojom::AIPageContentAttributesPtr node_attribute);

ObservedToolTarget(const ObservedToolTarget&) = delete;
ObservedToolTarget& operator=(const ObservedToolTarget&) = delete;

  ~ObservedToolTarget();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ObservedToolTargetPtr>
  ObservedToolTargetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObservedToolTarget::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObservedToolTarget::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ObservedToolTarget::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ObservedToolTarget_UnserializedMessageContext<
            UserType, ObservedToolTarget::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ObservedToolTarget::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ObservedToolTarget::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ObservedToolTarget_UnserializedMessageContext<
            UserType, ObservedToolTarget::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ObservedToolTarget::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::AIPageContentAttributesPtr node_attribute;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ObservedToolTarget::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  DragAndReleaseAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragAndReleaseAction, T>::value>;
  using DataView = DragAndReleaseActionDataView;
  using Data_ = internal::DragAndReleaseAction_Data;

  template <typename... Args>
  static DragAndReleaseActionPtr New(Args&&... args) {
    return DragAndReleaseActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragAndReleaseActionPtr From(const U& u) {
    return mojo::TypeConverter<DragAndReleaseActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragAndReleaseAction>::Convert(*this);
  }


  DragAndReleaseAction();

  explicit DragAndReleaseAction(
      ToolTargetPtr to_target);

DragAndReleaseAction(const DragAndReleaseAction&) = delete;
DragAndReleaseAction& operator=(const DragAndReleaseAction&) = delete;

  ~DragAndReleaseAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragAndReleaseActionPtr>
  DragAndReleaseActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragAndReleaseAction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragAndReleaseAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragAndReleaseAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragAndReleaseAction_UnserializedMessageContext<
            UserType, DragAndReleaseAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DragAndReleaseAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DragAndReleaseAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragAndReleaseAction_UnserializedMessageContext<
            UserType, DragAndReleaseAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragAndReleaseAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ToolTargetPtr to_target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragAndReleaseAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ToolInvocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ToolInvocation, T>::value>;
  using DataView = ToolInvocationDataView;
  using Data_ = internal::ToolInvocation_Data;

  template <typename... Args>
  static ToolInvocationPtr New(Args&&... args) {
    return ToolInvocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ToolInvocationPtr From(const U& u) {
    return mojo::TypeConverter<ToolInvocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ToolInvocation>::Convert(*this);
  }


  ToolInvocation();

  ToolInvocation(
      const ::actor::TaskId& task_id,
      ToolActionPtr action,
      ToolTargetPtr target,
      ObservedToolTargetPtr observed_target);

ToolInvocation(const ToolInvocation&) = delete;
ToolInvocation& operator=(const ToolInvocation&) = delete;

  ~ToolInvocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ToolInvocationPtr>
  ToolInvocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ToolInvocation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ToolInvocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ToolInvocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ToolInvocation_UnserializedMessageContext<
            UserType, ToolInvocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ToolInvocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ToolInvocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ToolInvocation_UnserializedMessageContext<
            UserType, ToolInvocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ToolInvocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::actor::TaskId task_id;
  
  ToolActionPtr action;
  
  ToolTargetPtr target;
  
  ObservedToolTargetPtr observed_target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ToolInvocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ActionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ActionResult, T>::value>;
  using DataView = ActionResultDataView;
  using Data_ = internal::ActionResult_Data;

  template <typename... Args>
  static ActionResultPtr New(Args&&... args) {
    return ActionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ActionResultPtr From(const U& u) {
    return mojo::TypeConverter<ActionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ActionResult>::Convert(*this);
  }


  ActionResult();

  ActionResult(
      ActionResultCode code,
      bool requires_page_stabilization,
      const std::string& message,
      const std::optional<std::string>& script_tool_response,
      std::optional<::base::TimeTicks> execution_end_time);


  ~ActionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ActionResultPtr>
  ActionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ActionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ActionResult_UnserializedMessageContext<
            UserType, ActionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ActionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ActionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ActionResult_UnserializedMessageContext<
            UserType, ActionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ActionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ActionResultCode code;
  
  bool requires_page_stabilization;
  
  std::string message;
  
  std::optional<std::string> script_tool_response;
  
  std::optional<::base::TimeTicks> execution_end_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ActionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  JournalEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JournalEntry, T>::value>;
  using DataView = JournalEntryDataView;
  using Data_ = internal::JournalEntry_Data;

  template <typename... Args>
  static JournalEntryPtr New(Args&&... args) {
    return JournalEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JournalEntryPtr From(const U& u) {
    return mojo::TypeConverter<JournalEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JournalEntry>::Convert(*this);
  }


  JournalEntry();

  JournalEntry(
      JournalEntryType type,
      const ::actor::TaskId& task_id,
      ::base::Time timestamp,
      const std::string& event,
      uint64_t track_uuid,
      std::vector<JournalDetailsPtr> details);

JournalEntry(const JournalEntry&) = delete;
JournalEntry& operator=(const JournalEntry&) = delete;

  ~JournalEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JournalEntryPtr>
  JournalEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JournalEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JournalEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JournalEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JournalEntry_UnserializedMessageContext<
            UserType, JournalEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JournalEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JournalEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JournalEntry_UnserializedMessageContext<
            UserType, JournalEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JournalEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  JournalEntryType type;
  
  ::actor::TaskId task_id;
  
  ::base::Time timestamp;
  
  std::string event;
  
  uint64_t track_uuid;
  
  std::vector<JournalDetailsPtr> details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ToolTargetPtr ToolTarget::Clone() const {
  switch (tag_) {
    case Tag::kDomNodeId:
      return NewDomNodeId(
          mojo::Clone(data_.dom_node_id));
    case Tag::kCoordinateDip:
      return NewCoordinateDip(
          mojo::Clone(data_.coordinate_dip));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ToolTarget>::value>::type*>
bool ToolTarget::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDomNodeId:
      return mojo::Equals(data_.dom_node_id, other.data_.dom_node_id);
    case Tag::kCoordinateDip:
      return mojo::Equals(data_.coordinate_dip, other.data_.coordinate_dip);
  }

  return false;
}
template <typename UnionPtrType>
ToolActionPtr ToolAction::Clone() const {
  switch (tag_) {
    case Tag::kClick:
      return NewClick(
          mojo::Clone(data_.click));
    case Tag::kDragAndRelease:
      return NewDragAndRelease(
          mojo::Clone(data_.drag_and_release));
    case Tag::kMouseMove:
      return NewMouseMove(
          mojo::Clone(data_.mouse_move));
    case Tag::kScroll:
      return NewScroll(
          mojo::Clone(data_.scroll));
    case Tag::kSelect:
      return NewSelect(
          mojo::Clone(data_.select));
    case Tag::kType:
      return NewType(
          mojo::Clone(data_.type));
    case Tag::kScriptTool:
      return NewScriptTool(
          mojo::Clone(data_.script_tool));
    case Tag::kScrollTo:
      return NewScrollTo(
          mojo::Clone(data_.scroll_to));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ToolAction>::value>::type*>
bool ToolAction::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kClick:
      return mojo::Equals(data_.click, other.data_.click);
    case Tag::kDragAndRelease:
      return mojo::Equals(data_.drag_and_release, other.data_.drag_and_release);
    case Tag::kMouseMove:
      return mojo::Equals(data_.mouse_move, other.data_.mouse_move);
    case Tag::kScroll:
      return mojo::Equals(data_.scroll, other.data_.scroll);
    case Tag::kSelect:
      return mojo::Equals(data_.select, other.data_.select);
    case Tag::kType:
      return mojo::Equals(data_.type, other.data_.type);
    case Tag::kScriptTool:
      return mojo::Equals(data_.script_tool, other.data_.script_tool);
    case Tag::kScrollTo:
      return mojo::Equals(data_.scroll_to, other.data_.scroll_to);
  }

  return false;
}
template <typename StructPtrType>
ObservedToolTargetPtr ObservedToolTarget::Clone() const {
  return New(
      mojo::Clone(node_attribute)
  );
}

template <typename T, ObservedToolTarget::EnableIfSame<T>*>
bool ObservedToolTarget::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_attribute, other_struct.node_attribute))
    return false;
  return true;
}

template <typename T, ObservedToolTarget::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_attribute < rhs.node_attribute)
    return true;
  if (rhs.node_attribute < lhs.node_attribute)
    return false;
  return false;
}
template <typename StructPtrType>
ClickActionPtr ClickAction::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(count)
  );
}

template <typename T, ClickAction::EnableIfSame<T>*>
bool ClickAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->count, other_struct.count))
    return false;
  return true;
}

template <typename T, ClickAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.count < rhs.count)
    return true;
  if (rhs.count < lhs.count)
    return false;
  return false;
}
template <typename StructPtrType>
MouseMoveActionPtr MouseMoveAction::Clone() const {
  return New(
  );
}

template <typename T, MouseMoveAction::EnableIfSame<T>*>
bool MouseMoveAction::Equals(const T& other_struct) const {
  return true;
}

template <typename T, MouseMoveAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ScrollToActionPtr ScrollToAction::Clone() const {
  return New(
  );
}

template <typename T, ScrollToAction::EnableIfSame<T>*>
bool ScrollToAction::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ScrollToAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
TypeActionPtr TypeAction::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(text),
      mojo::Clone(follow_by_enter)
  );
}

template <typename T, TypeAction::EnableIfSame<T>*>
bool TypeAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->follow_by_enter, other_struct.follow_by_enter))
    return false;
  return true;
}

template <typename T, TypeAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.follow_by_enter < rhs.follow_by_enter)
    return true;
  if (rhs.follow_by_enter < lhs.follow_by_enter)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollActionPtr ScrollAction::Clone() const {
  return New(
      mojo::Clone(direction),
      mojo::Clone(distance)
  );
}

template <typename T, ScrollAction::EnableIfSame<T>*>
bool ScrollAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  if (!mojo::Equals(this->distance, other_struct.distance))
    return false;
  return true;
}

template <typename T, ScrollAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  if (lhs.distance < rhs.distance)
    return true;
  if (rhs.distance < lhs.distance)
    return false;
  return false;
}
template <typename StructPtrType>
SelectActionPtr SelectAction::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, SelectAction::EnableIfSame<T>*>
bool SelectAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SelectAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
DragAndReleaseActionPtr DragAndReleaseAction::Clone() const {
  return New(
      mojo::Clone(to_target)
  );
}

template <typename T, DragAndReleaseAction::EnableIfSame<T>*>
bool DragAndReleaseAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->to_target, other_struct.to_target))
    return false;
  return true;
}

template <typename T, DragAndReleaseAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.to_target < rhs.to_target)
    return true;
  if (rhs.to_target < lhs.to_target)
    return false;
  return false;
}
template <typename StructPtrType>
ScriptToolActionPtr ScriptToolAction::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(input_arguments)
  );
}

template <typename T, ScriptToolAction::EnableIfSame<T>*>
bool ScriptToolAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->input_arguments, other_struct.input_arguments))
    return false;
  return true;
}

template <typename T, ScriptToolAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.input_arguments < rhs.input_arguments)
    return true;
  if (rhs.input_arguments < lhs.input_arguments)
    return false;
  return false;
}
template <typename StructPtrType>
TaskIdPtr TaskId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, TaskId::EnableIfSame<T>*>
bool TaskId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, TaskId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
ToolInvocationPtr ToolInvocation::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(action),
      mojo::Clone(target),
      mojo::Clone(observed_target)
  );
}

template <typename T, ToolInvocation::EnableIfSame<T>*>
bool ToolInvocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->target, other_struct.target))
    return false;
  if (!mojo::Equals(this->observed_target, other_struct.observed_target))
    return false;
  return true;
}

template <typename T, ToolInvocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.target < rhs.target)
    return true;
  if (rhs.target < lhs.target)
    return false;
  if (lhs.observed_target < rhs.observed_target)
    return true;
  if (rhs.observed_target < lhs.observed_target)
    return false;
  return false;
}
template <typename StructPtrType>
ActionResultPtr ActionResult::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(requires_page_stabilization),
      mojo::Clone(message),
      mojo::Clone(script_tool_response),
      mojo::Clone(execution_end_time)
  );
}

template <typename T, ActionResult::EnableIfSame<T>*>
bool ActionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->requires_page_stabilization, other_struct.requires_page_stabilization))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->script_tool_response, other_struct.script_tool_response))
    return false;
  if (!mojo::Equals(this->execution_end_time, other_struct.execution_end_time))
    return false;
  return true;
}

template <typename T, ActionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.requires_page_stabilization < rhs.requires_page_stabilization)
    return true;
  if (rhs.requires_page_stabilization < lhs.requires_page_stabilization)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.script_tool_response < rhs.script_tool_response)
    return true;
  if (rhs.script_tool_response < lhs.script_tool_response)
    return false;
  if (lhs.execution_end_time < rhs.execution_end_time)
    return true;
  if (rhs.execution_end_time < lhs.execution_end_time)
    return false;
  return false;
}
template <typename StructPtrType>
JournalDetailsPtr JournalDetails::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, JournalDetails::EnableIfSame<T>*>
bool JournalDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, JournalDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
JournalEntryPtr JournalEntry::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(task_id),
      mojo::Clone(timestamp),
      mojo::Clone(event),
      mojo::Clone(track_uuid),
      mojo::Clone(details)
  );
}

template <typename T, JournalEntry::EnableIfSame<T>*>
bool JournalEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->event, other_struct.event))
    return false;
  if (!mojo::Equals(this->track_uuid, other_struct.track_uuid))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, JournalEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.event < rhs.event)
    return true;
  if (rhs.event < lhs.event)
    return false;
  if (lhs.track_uuid < rhs.track_uuid)
    return true;
  if (rhs.track_uuid < lhs.track_uuid)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}


}  // actor::mojom

namespace mojo {


template <>
struct  StructTraits<::actor::mojom::ObservedToolTarget::DataView,
                                         ::actor::mojom::ObservedToolTargetPtr> {
  static bool IsNull(const ::actor::mojom::ObservedToolTargetPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ObservedToolTargetPtr* output) { output->reset(); }

  static const decltype(::actor::mojom::ObservedToolTarget::node_attribute)& node_attribute(
      const ::actor::mojom::ObservedToolTargetPtr& input) {
    return input->node_attribute;
  }

  static bool Read(::actor::mojom::ObservedToolTarget::DataView input, ::actor::mojom::ObservedToolTargetPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::ClickAction::DataView,
                                         ::actor::mojom::ClickActionPtr> {
  static bool IsNull(const ::actor::mojom::ClickActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ClickActionPtr* output) { output->reset(); }

  static decltype(::actor::mojom::ClickAction::type) type(
      const ::actor::mojom::ClickActionPtr& input) {
    return input->type;
  }

  static decltype(::actor::mojom::ClickAction::count) count(
      const ::actor::mojom::ClickActionPtr& input) {
    return input->count;
  }

  static bool Read(::actor::mojom::ClickAction::DataView input, ::actor::mojom::ClickActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::MouseMoveAction::DataView,
                                         ::actor::mojom::MouseMoveActionPtr> {
  static bool IsNull(const ::actor::mojom::MouseMoveActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::MouseMoveActionPtr* output) { output->reset(); }

  static bool Read(::actor::mojom::MouseMoveAction::DataView input, ::actor::mojom::MouseMoveActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::ScrollToAction::DataView,
                                         ::actor::mojom::ScrollToActionPtr> {
  static bool IsNull(const ::actor::mojom::ScrollToActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ScrollToActionPtr* output) { output->reset(); }

  static bool Read(::actor::mojom::ScrollToAction::DataView input, ::actor::mojom::ScrollToActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::TypeAction::DataView,
                                         ::actor::mojom::TypeActionPtr> {
  static bool IsNull(const ::actor::mojom::TypeActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::TypeActionPtr* output) { output->reset(); }

  static decltype(::actor::mojom::TypeAction::mode) mode(
      const ::actor::mojom::TypeActionPtr& input) {
    return input->mode;
  }

  static const decltype(::actor::mojom::TypeAction::text)& text(
      const ::actor::mojom::TypeActionPtr& input) {
    return input->text;
  }

  static decltype(::actor::mojom::TypeAction::follow_by_enter) follow_by_enter(
      const ::actor::mojom::TypeActionPtr& input) {
    return input->follow_by_enter;
  }

  static bool Read(::actor::mojom::TypeAction::DataView input, ::actor::mojom::TypeActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::ScrollAction::DataView,
                                         ::actor::mojom::ScrollActionPtr> {
  static bool IsNull(const ::actor::mojom::ScrollActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ScrollActionPtr* output) { output->reset(); }

  static decltype(::actor::mojom::ScrollAction::direction) direction(
      const ::actor::mojom::ScrollActionPtr& input) {
    return input->direction;
  }

  static decltype(::actor::mojom::ScrollAction::distance) distance(
      const ::actor::mojom::ScrollActionPtr& input) {
    return input->distance;
  }

  static bool Read(::actor::mojom::ScrollAction::DataView input, ::actor::mojom::ScrollActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::SelectAction::DataView,
                                         ::actor::mojom::SelectActionPtr> {
  static bool IsNull(const ::actor::mojom::SelectActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::SelectActionPtr* output) { output->reset(); }

  static const decltype(::actor::mojom::SelectAction::value)& value(
      const ::actor::mojom::SelectActionPtr& input) {
    return input->value;
  }

  static bool Read(::actor::mojom::SelectAction::DataView input, ::actor::mojom::SelectActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::DragAndReleaseAction::DataView,
                                         ::actor::mojom::DragAndReleaseActionPtr> {
  static bool IsNull(const ::actor::mojom::DragAndReleaseActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::DragAndReleaseActionPtr* output) { output->reset(); }

  static const decltype(::actor::mojom::DragAndReleaseAction::to_target)& to_target(
      const ::actor::mojom::DragAndReleaseActionPtr& input) {
    return input->to_target;
  }

  static bool Read(::actor::mojom::DragAndReleaseAction::DataView input, ::actor::mojom::DragAndReleaseActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::ScriptToolAction::DataView,
                                         ::actor::mojom::ScriptToolActionPtr> {
  static bool IsNull(const ::actor::mojom::ScriptToolActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ScriptToolActionPtr* output) { output->reset(); }

  static const decltype(::actor::mojom::ScriptToolAction::name)& name(
      const ::actor::mojom::ScriptToolActionPtr& input) {
    return input->name;
  }

  static const decltype(::actor::mojom::ScriptToolAction::input_arguments)& input_arguments(
      const ::actor::mojom::ScriptToolActionPtr& input) {
    return input->input_arguments;
  }

  static bool Read(::actor::mojom::ScriptToolAction::DataView input, ::actor::mojom::ScriptToolActionPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::TaskId::DataView,
                                         ::actor::mojom::TaskIdPtr> {
  static bool IsNull(const ::actor::mojom::TaskIdPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::TaskIdPtr* output) { output->reset(); }

  static decltype(::actor::mojom::TaskId::id) id(
      const ::actor::mojom::TaskIdPtr& input) {
    return input->id;
  }

  static bool Read(::actor::mojom::TaskId::DataView input, ::actor::mojom::TaskIdPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::ToolInvocation::DataView,
                                         ::actor::mojom::ToolInvocationPtr> {
  static bool IsNull(const ::actor::mojom::ToolInvocationPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ToolInvocationPtr* output) { output->reset(); }

  static const decltype(::actor::mojom::ToolInvocation::task_id)& task_id(
      const ::actor::mojom::ToolInvocationPtr& input) {
    return input->task_id;
  }

  static const decltype(::actor::mojom::ToolInvocation::action)& action(
      const ::actor::mojom::ToolInvocationPtr& input) {
    return input->action;
  }

  static const decltype(::actor::mojom::ToolInvocation::target)& target(
      const ::actor::mojom::ToolInvocationPtr& input) {
    return input->target;
  }

  static const decltype(::actor::mojom::ToolInvocation::observed_target)& observed_target(
      const ::actor::mojom::ToolInvocationPtr& input) {
    return input->observed_target;
  }

  static bool Read(::actor::mojom::ToolInvocation::DataView input, ::actor::mojom::ToolInvocationPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::ActionResult::DataView,
                                         ::actor::mojom::ActionResultPtr> {
  static bool IsNull(const ::actor::mojom::ActionResultPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ActionResultPtr* output) { output->reset(); }

  static decltype(::actor::mojom::ActionResult::code) code(
      const ::actor::mojom::ActionResultPtr& input) {
    return input->code;
  }

  static decltype(::actor::mojom::ActionResult::requires_page_stabilization) requires_page_stabilization(
      const ::actor::mojom::ActionResultPtr& input) {
    return input->requires_page_stabilization;
  }

  static const decltype(::actor::mojom::ActionResult::message)& message(
      const ::actor::mojom::ActionResultPtr& input) {
    return input->message;
  }

  static const decltype(::actor::mojom::ActionResult::script_tool_response)& script_tool_response(
      const ::actor::mojom::ActionResultPtr& input) {
    return input->script_tool_response;
  }

  static const decltype(::actor::mojom::ActionResult::execution_end_time)& execution_end_time(
      const ::actor::mojom::ActionResultPtr& input) {
    return input->execution_end_time;
  }

  static bool Read(::actor::mojom::ActionResult::DataView input, ::actor::mojom::ActionResultPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::JournalDetails::DataView,
                                         ::actor::mojom::JournalDetailsPtr> {
  static bool IsNull(const ::actor::mojom::JournalDetailsPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::JournalDetailsPtr* output) { output->reset(); }

  static const decltype(::actor::mojom::JournalDetails::key)& key(
      const ::actor::mojom::JournalDetailsPtr& input) {
    return input->key;
  }

  static const decltype(::actor::mojom::JournalDetails::value)& value(
      const ::actor::mojom::JournalDetailsPtr& input) {
    return input->value;
  }

  static bool Read(::actor::mojom::JournalDetails::DataView input, ::actor::mojom::JournalDetailsPtr* output);
};


template <>
struct  StructTraits<::actor::mojom::JournalEntry::DataView,
                                         ::actor::mojom::JournalEntryPtr> {
  static bool IsNull(const ::actor::mojom::JournalEntryPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::JournalEntryPtr* output) { output->reset(); }

  static decltype(::actor::mojom::JournalEntry::type) type(
      const ::actor::mojom::JournalEntryPtr& input) {
    return input->type;
  }

  static const decltype(::actor::mojom::JournalEntry::task_id)& task_id(
      const ::actor::mojom::JournalEntryPtr& input) {
    return input->task_id;
  }

  static const decltype(::actor::mojom::JournalEntry::timestamp)& timestamp(
      const ::actor::mojom::JournalEntryPtr& input) {
    return input->timestamp;
  }

  static const decltype(::actor::mojom::JournalEntry::event)& event(
      const ::actor::mojom::JournalEntryPtr& input) {
    return input->event;
  }

  static decltype(::actor::mojom::JournalEntry::track_uuid) track_uuid(
      const ::actor::mojom::JournalEntryPtr& input) {
    return input->track_uuid;
  }

  static const decltype(::actor::mojom::JournalEntry::details)& details(
      const ::actor::mojom::JournalEntryPtr& input) {
    return input->details;
  }

  static bool Read(::actor::mojom::JournalEntry::DataView input, ::actor::mojom::JournalEntryPtr* output);
};


template <>
struct  UnionTraits<::actor::mojom::ToolTarget::DataView,
                                        ::actor::mojom::ToolTargetPtr> {
  static bool IsNull(const ::actor::mojom::ToolTargetPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ToolTargetPtr* output) { output->reset(); }

  static ::actor::mojom::ToolTarget::Tag GetTag(const ::actor::mojom::ToolTargetPtr& input) {
    return input->which();
  }

  static  int32_t dom_node_id(const ::actor::mojom::ToolTargetPtr& input) {
    return input->get_dom_node_id();
  }

  static const ::gfx::Point& coordinate_dip(const ::actor::mojom::ToolTargetPtr& input) {
    return input->get_coordinate_dip();
  }

  static bool Read(::actor::mojom::ToolTarget::DataView input, ::actor::mojom::ToolTargetPtr* output);
};


template <>
struct  UnionTraits<::actor::mojom::ToolAction::DataView,
                                        ::actor::mojom::ToolActionPtr> {
  static bool IsNull(const ::actor::mojom::ToolActionPtr& input) { return !input; }
  static void SetToNull(::actor::mojom::ToolActionPtr* output) { output->reset(); }

  static ::actor::mojom::ToolAction::Tag GetTag(const ::actor::mojom::ToolActionPtr& input) {
    return input->which();
  }

  static const ::actor::mojom::ClickActionPtr& click(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_click();
  }

  static const ::actor::mojom::DragAndReleaseActionPtr& drag_and_release(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_drag_and_release();
  }

  static const ::actor::mojom::MouseMoveActionPtr& mouse_move(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_mouse_move();
  }

  static const ::actor::mojom::ScrollActionPtr& scroll(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_scroll();
  }

  static const ::actor::mojom::SelectActionPtr& select(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_select();
  }

  static const ::actor::mojom::TypeActionPtr& type(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_type();
  }

  static const ::actor::mojom::ScriptToolActionPtr& script_tool(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_script_tool();
  }

  static const ::actor::mojom::ScrollToActionPtr& scroll_to(const ::actor::mojom::ToolActionPtr& input) {
    return input->get_scroll_to();
  }

  static bool Read(::actor::mojom::ToolAction::DataView input, ::actor::mojom::ToolActionPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_ACTOR_MOJOM_H_