// chrome/browser/ui/webui_browser/extensions_bar.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_EXTENSIONS_BAR_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_EXTENSIONS_BAR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include "ui/base/mojom/menu_source_type.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions_bar::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions_bar.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions_bar.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kExecuteUserActionMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kToggleExtensionsMenuFromWebUIMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ExecuteUserAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleExtensionsMenuFromWebUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void ExecuteUserAction(const std::string& id) = 0;

  virtual void ShowContextMenu(::ui::mojom::MenuSourceType source, const std::string& id) = 0;

  virtual void ToggleExtensionsMenuFromWebUI() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;
class PageResponseValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions_bar.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = PageResponseValidator;
  enum MethodMinVersions : uint32_t {
    kActionsAddedOrUpdatedMinVersion = 0,
    kActionRemovedMinVersion = 0,
    kActionPoppedOutMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ActionsAddedOrUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActionRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActionPoppedOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void ActionsAddedOrUpdated(std::vector<ExtensionActionInfoPtr> actions) = 0;

  virtual void ActionRemoved(const std::string& id) = 0;

  using ActionPoppedOutCallback = base::OnceCallback<void()>;
  using ActionPoppedOutMojoCallback = base::OnceCallback<void()>;

  virtual void ActionPoppedOut(ActionPoppedOutCallback callback) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ExecuteUserAction(const std::string& id) final;
  
  void ShowContextMenu(::ui::mojom::MenuSourceType source, const std::string& id) final;
  
  void ToggleExtensionsMenuFromWebUI() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ActionsAddedOrUpdated(std::vector<ExtensionActionInfoPtr> actions) final;
  
  void ActionRemoved(const std::string& id) final;
  
  void ActionPoppedOut(ActionPoppedOutCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  ExtensionActionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionActionInfo, T>::value>;
  using DataView = ExtensionActionInfoDataView;
  using Data_ = internal::ExtensionActionInfo_Data;

  template <typename... Args>
  static ExtensionActionInfoPtr New(Args&&... args) {
    return ExtensionActionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionActionInfoPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionActionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionActionInfo>::Convert(*this);
  }


  ExtensionActionInfo();

  ExtensionActionInfo(
      const std::string& id,
      const std::string& accessible_name,
      const std::string& tooltip,
      bool is_visible,
      const ::GURL& data_url_for_icon);


  ~ExtensionActionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionActionInfoPtr>
  ExtensionActionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionActionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionActionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionActionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionActionInfo_UnserializedMessageContext<
            UserType, ExtensionActionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionActionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionActionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionActionInfo_UnserializedMessageContext<
            UserType, ExtensionActionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionActionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string accessible_name;
  
  std::string tooltip;
  
  bool is_visible;
  
  ::GURL data_url_for_icon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionActionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExtensionActionInfoPtr ExtensionActionInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(accessible_name),
      mojo::Clone(tooltip),
      mojo::Clone(is_visible),
      mojo::Clone(data_url_for_icon)
  );
}

template <typename T, ExtensionActionInfo::EnableIfSame<T>*>
bool ExtensionActionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->accessible_name, other_struct.accessible_name))
    return false;
  if (!mojo::Equals(this->tooltip, other_struct.tooltip))
    return false;
  if (!mojo::Equals(this->is_visible, other_struct.is_visible))
    return false;
  if (!mojo::Equals(this->data_url_for_icon, other_struct.data_url_for_icon))
    return false;
  return true;
}

template <typename T, ExtensionActionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.accessible_name < rhs.accessible_name)
    return true;
  if (rhs.accessible_name < lhs.accessible_name)
    return false;
  if (lhs.tooltip < rhs.tooltip)
    return true;
  if (rhs.tooltip < lhs.tooltip)
    return false;
  if (lhs.is_visible < rhs.is_visible)
    return true;
  if (rhs.is_visible < lhs.is_visible)
    return false;
  if (lhs.data_url_for_icon < rhs.data_url_for_icon)
    return true;
  if (rhs.data_url_for_icon < lhs.data_url_for_icon)
    return false;
  return false;
}


}  // extensions_bar::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions_bar::mojom::ExtensionActionInfo::DataView,
                                         ::extensions_bar::mojom::ExtensionActionInfoPtr> {
  static bool IsNull(const ::extensions_bar::mojom::ExtensionActionInfoPtr& input) { return !input; }
  static void SetToNull(::extensions_bar::mojom::ExtensionActionInfoPtr* output) { output->reset(); }

  static const decltype(::extensions_bar::mojom::ExtensionActionInfo::id)& id(
      const ::extensions_bar::mojom::ExtensionActionInfoPtr& input) {
    return input->id;
  }

  static const decltype(::extensions_bar::mojom::ExtensionActionInfo::accessible_name)& accessible_name(
      const ::extensions_bar::mojom::ExtensionActionInfoPtr& input) {
    return input->accessible_name;
  }

  static const decltype(::extensions_bar::mojom::ExtensionActionInfo::tooltip)& tooltip(
      const ::extensions_bar::mojom::ExtensionActionInfoPtr& input) {
    return input->tooltip;
  }

  static decltype(::extensions_bar::mojom::ExtensionActionInfo::is_visible) is_visible(
      const ::extensions_bar::mojom::ExtensionActionInfoPtr& input) {
    return input->is_visible;
  }

  static const decltype(::extensions_bar::mojom::ExtensionActionInfo::data_url_for_icon)& data_url_for_icon(
      const ::extensions_bar::mojom::ExtensionActionInfoPtr& input) {
    return input->data_url_for_icon;
  }

  static bool Read(::extensions_bar::mojom::ExtensionActionInfo::DataView input, ::extensions_bar::mojom::ExtensionActionInfoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_EXTENSIONS_BAR_MOJOM_H_