// chrome/browser/ui/webui_browser/extensions_bar.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  MenuSourceTypeSpec as ui_mojom_MenuSourceTypeSpec,
  MenuSourceType as ui_mojom_MenuSourceType
} from '//resources/mojo/ui/base/mojom/menu_source_type.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'extensions_bar.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "extensions_bar.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'extensions_bar.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  executeUserAction(id: string): void;
  showContextMenu(source: ui_mojom_MenuSourceType, id: string): void;
  toggleExtensionsMenuFromWebUI(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  executeUserAction(
      id: string): void {
    this.proxy.sendMessage(
        0,
        PageHandler_ExecuteUserAction_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  showContextMenu(
      source: ui_mojom_MenuSourceType,
      id: string): void {
    this.proxy.sendMessage(
        1,
        PageHandler_ShowContextMenu_ParamsSpec.$,
        null,
        [
          source,
          id
        ],
        false);
  }

  toggleExtensionsMenuFromWebUI(): void {
    this.proxy.sendMessage(
        2,
        PageHandler_ToggleExtensionsMenuFromWebUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_ExecuteUserAction_ParamsSpec.$,
        null,
        impl.executeUserAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_ShowContextMenu_ParamsSpec.$,
        null,
        impl.showContextMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_ToggleExtensionsMenuFromWebUI_ParamsSpec.$,
        null,
        impl.toggleExtensionsMenuFromWebUI.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "extensions_bar.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  executeUserAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showContextMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleExtensionsMenuFromWebUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.executeUserAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_ExecuteUserAction_ParamsSpec.$,
        null,
        this.executeUserAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showContextMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_ShowContextMenu_ParamsSpec.$,
        null,
        this.showContextMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleExtensionsMenuFromWebUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_ToggleExtensionsMenuFromWebUI_ParamsSpec.$,
        null,
        this.toggleExtensionsMenuFromWebUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'extensions_bar.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  actionsAddedOrUpdated(actions: ExtensionActionInfo[]): void;
  actionRemoved(id: string): void;
  actionPoppedOut(): Promise<void>;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  actionsAddedOrUpdated(
      actions: ExtensionActionInfo[]): void {
    this.proxy.sendMessage(
        0,
        Page_ActionsAddedOrUpdated_ParamsSpec.$,
        null,
        [
          actions
        ],
        false);
  }

  actionRemoved(
      id: string): void {
    this.proxy.sendMessage(
        1,
        Page_ActionRemoved_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  actionPoppedOut(): Promise<void> {
    return this.proxy.sendMessage(
        2,
        Page_ActionPoppedOut_ParamsSpec.$,
        Page_ActionPoppedOut_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_ActionsAddedOrUpdated_ParamsSpec.$,
        null,
        impl.actionsAddedOrUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_ActionRemoved_ParamsSpec.$,
        null,
        impl.actionRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_ActionPoppedOut_ParamsSpec.$,
        Page_ActionPoppedOut_ResponseParamsSpec.$,
        impl.actionPoppedOut.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "extensions_bar.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  actionsAddedOrUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  actionRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  actionPoppedOut: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.actionsAddedOrUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_ActionsAddedOrUpdated_ParamsSpec.$,
        null,
        this.actionsAddedOrUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.actionRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_ActionRemoved_ParamsSpec.$,
        null,
        this.actionRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.actionPoppedOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_ActionPoppedOut_ParamsSpec.$,
        Page_ActionPoppedOut_ResponseParamsSpec.$,
        this.actionPoppedOut.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ExtensionActionInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ExecuteUserAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowContextMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ToggleExtensionsMenuFromWebUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ActionsAddedOrUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ActionRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ActionPoppedOut_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ActionPoppedOut_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ExtensionActionInfoMojoType {
  id: string;
  accessibleName: string;
  tooltip: string;
  isVisible: boolean;
  dataUrlForIcon: url_mojom_Url;
}


export type ExtensionActionInfo = ExtensionActionInfoMojoType;
mojo.internal.Struct<ExtensionActionInfoMojoType>(
    ExtensionActionInfoSpec.$,
    'ExtensionActionInfo',
    [
      mojo.internal.StructField<ExtensionActionInfoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ExtensionActionInfoMojoType, string>(
        'accessibleName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ExtensionActionInfoMojoType, string>(
        'tooltip', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ExtensionActionInfoMojoType, boolean>(
        'isVisible', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ExtensionActionInfoMojoType, url_mojom_Url>(
        'dataUrlForIcon', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ExecuteUserAction_ParamsMojoType {
  id: string;
}


export type PageHandler_ExecuteUserAction_Params = PageHandler_ExecuteUserAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_ExecuteUserAction_ParamsMojoType>(
    PageHandler_ExecuteUserAction_ParamsSpec.$,
    'PageHandler_ExecuteUserAction_Params',
    [
      mojo.internal.StructField<PageHandler_ExecuteUserAction_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowContextMenu_ParamsMojoType {
  source: ui_mojom_MenuSourceType;
  id: string;
}


export type PageHandler_ShowContextMenu_Params = PageHandler_ShowContextMenu_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowContextMenu_ParamsMojoType>(
    PageHandler_ShowContextMenu_ParamsSpec.$,
    'PageHandler_ShowContextMenu_Params',
    [
      mojo.internal.StructField<PageHandler_ShowContextMenu_ParamsMojoType, ui_mojom_MenuSourceType>(
        'source', 0,
        0,
        ui_mojom_MenuSourceTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ShowContextMenu_ParamsMojoType, string>(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ToggleExtensionsMenuFromWebUI_ParamsMojoType {
}


export type PageHandler_ToggleExtensionsMenuFromWebUI_Params = PageHandler_ToggleExtensionsMenuFromWebUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_ToggleExtensionsMenuFromWebUI_ParamsMojoType>(
    PageHandler_ToggleExtensionsMenuFromWebUI_ParamsSpec.$,
    'PageHandler_ToggleExtensionsMenuFromWebUI_Params',
    [
    ],
    [[0, 8],]);





export interface Page_ActionsAddedOrUpdated_ParamsMojoType {
  actions: ExtensionActionInfo[];
}


export type Page_ActionsAddedOrUpdated_Params = Page_ActionsAddedOrUpdated_ParamsMojoType;
mojo.internal.Struct<Page_ActionsAddedOrUpdated_ParamsMojoType>(
    Page_ActionsAddedOrUpdated_ParamsSpec.$,
    'Page_ActionsAddedOrUpdated_Params',
    [
      mojo.internal.StructField<Page_ActionsAddedOrUpdated_ParamsMojoType, ExtensionActionInfo[]>(
        'actions', 0,
        0,
        mojo.internal.Array(ExtensionActionInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ActionRemoved_ParamsMojoType {
  id: string;
}


export type Page_ActionRemoved_Params = Page_ActionRemoved_ParamsMojoType;
mojo.internal.Struct<Page_ActionRemoved_ParamsMojoType>(
    Page_ActionRemoved_ParamsSpec.$,
    'Page_ActionRemoved_Params',
    [
      mojo.internal.StructField<Page_ActionRemoved_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ActionPoppedOut_ParamsMojoType {
}


export type Page_ActionPoppedOut_Params = Page_ActionPoppedOut_ParamsMojoType;
mojo.internal.Struct<Page_ActionPoppedOut_ParamsMojoType>(
    Page_ActionPoppedOut_ParamsSpec.$,
    'Page_ActionPoppedOut_Params',
    [
    ],
    [[0, 8],]);





export interface Page_ActionPoppedOut_ResponseParamsMojoType {
}


export type Page_ActionPoppedOut_ResponseParams = Page_ActionPoppedOut_ResponseParamsMojoType;
mojo.internal.Struct<Page_ActionPoppedOut_ResponseParamsMojoType>(
    Page_ActionPoppedOut_ResponseParamsSpec.$,
    'Page_ActionPoppedOut_ResponseParams',
    [
    ],
    [[0, 8],]);



