// chrome/browser/ui/webui_browser/extensions_bar.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_EXTENSIONS_BAR_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_EXTENSIONS_BAR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/base/mojom/menu_source_type.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui_browser/extensions_bar.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions_bar::mojom::ExtensionActionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions_bar::mojom::ExtensionActionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions_bar::mojom::internal::ExtensionActionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ExtensionActionInfo struct");

    decltype(Traits::accessible_name(input)) in_accessible_name = Traits::accessible_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accessible_name)::BaseType> accessible_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_accessible_name,
      accessible_name_fragment);

    fragment->accessible_name.Set(
        accessible_name_fragment.is_null() ? nullptr : accessible_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accessible_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessible_name in ExtensionActionInfo struct");

    decltype(Traits::tooltip(input)) in_tooltip = Traits::tooltip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tooltip)::BaseType> tooltip_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tooltip,
      tooltip_fragment);

    fragment->tooltip.Set(
        tooltip_fragment.is_null() ? nullptr : tooltip_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tooltip.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tooltip in ExtensionActionInfo struct");

    fragment->is_visible = Traits::is_visible(input);

    decltype(Traits::data_url_for_icon(input)) in_data_url_for_icon = Traits::data_url_for_icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data_url_for_icon)::BaseType> data_url_for_icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_data_url_for_icon,
      data_url_for_icon_fragment);

    fragment->data_url_for_icon.Set(
        data_url_for_icon_fragment.is_null() ? nullptr : data_url_for_icon_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data_url_for_icon.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_url_for_icon in ExtensionActionInfo struct");
  }

  static bool Deserialize(::extensions_bar::mojom::internal::ExtensionActionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions_bar::mojom::ExtensionActionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions_bar::mojom {

inline void ExtensionActionInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionActionInfoDataView::GetAccessibleNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->accessible_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionActionInfoDataView::GetTooltipDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tooltip.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionActionInfoDataView::GetDataUrlForIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->data_url_for_icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // extensions_bar::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_EXTENSIONS_BAR_MOJOM_SHARED_H_