// chrome/browser/ui/webui_browser/browser.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_BROWSER_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_BROWSER_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui_browser/browser.mojom.h"


namespace webui_browser::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
  void GetTabStripInset(GetTabStripInsetCallback callback) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();
  void GetTabStripInset(
      int32_t* out_width);
  int32_t GetTabStripInset();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void SetFocusToLocationBar(bool is_user_initiated) override;
  void SetReloadStopState(bool is_loading) override;
  void ShowSidePanel(int32_t guest_contents_id, const std::string& title) override;
  void CloseSidePanel() override;
  void OnFullscreenModeChanged(bool is_fullscreen, std::optional<FullscreenContext> context) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetGuestIdForTabId(const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler, GetGuestIdForTabIdCallback callback) override;
  void LoadTabSearch(LoadTabSearchCallback callback) override;
  void ShowTabSearchBubble(const std::string& anchor_name) override;
  void OpenAppMenu() override;
  void OpenProfileMenu() override;
  void LaunchDevToolsForBrowser() override;
  void OnSidePanelClosed() override;
  void Minimize() override;
  void Maximize() override;
  void Restore() override;
  void Close() override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetGuestIdForTabId(
      const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler, int32_t* out_guest_id);
  int32_t GetGuestIdForTabId(const ::tabs_api::NodeId& tab_id, ::mojo::PendingReceiver<GuestHandler> handler);
  void LoadTabSearch(
      int32_t* out_guest_id);
  int32_t LoadTabSearch();

 private:
  PageHandler* const proxy_;
};


class  GuestHandlerInterceptorForTesting : public GuestHandler {
  virtual GuestHandler* GetForwardingInterface() = 0;
  void Navigate(const ::GURL& src) override;
  void CanGoBack(CanGoBackCallback callback) override;
  void GoBack() override;
  void CanGoForward(CanGoForwardCallback callback) override;
  void GoForward() override;
  void Reload() override;
  void StopLoading() override;
  void OpenPageInfoMenu() override;
  void GetSecurityIcon(GetSecurityIconCallback callback) override;
};
class  GuestHandlerAsyncWaiter {
 public:
  explicit GuestHandlerAsyncWaiter(GuestHandler* proxy);

  GuestHandlerAsyncWaiter(const GuestHandlerAsyncWaiter&) = delete;
  GuestHandlerAsyncWaiter& operator=(const GuestHandlerAsyncWaiter&) = delete;

  ~GuestHandlerAsyncWaiter();
  void CanGoBack(
      bool* out_can_go_back);
  bool CanGoBack();
  void CanGoForward(
      bool* out_can_go_forward);
  bool CanGoForward();
  void GetSecurityIcon(
      SecurityIcon* out_security_icon);
  SecurityIcon GetSecurityIcon();

 private:
  GuestHandler* const proxy_;
};




}  // webui_browser::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_BROWSER_MOJOM_TEST_UTILS_H_