// chrome/browser/ui/webui_browser/bookmark_bar.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui_browser/bookmark_bar.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui_browser/bookmark_bar.mojom-params-data.h"
namespace bookmark_bar {
namespace mojom {

NOINLINE static const char* BookmarkTypeToStringHelper(BookmarkType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BookmarkType::URL:
      return "URL";
    case BookmarkType::FOLDER:
      return "FOLDER";
    case BookmarkType::BOOKMARK_BAR:
      return "BOOKMARK_BAR";
    case BookmarkType::OTHER_NODE:
      return "OTHER_NODE";
    case BookmarkType::MOBILE:
      return "MOBILE";
    default:
      return nullptr;
  }
}

std::string BookmarkTypeToString(BookmarkType value) {
  const char *str = BookmarkTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BookmarkType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BookmarkType value) {
  return os << BookmarkTypeToString(value);
}

namespace internal {


// static
bool BookmarkData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkData_Data* object =
      static_cast<const BookmarkData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }


  if (!::bookmark_bar::mojom::internal::BookmarkType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->page_url_for_favicon, validation_context))
    return false;

  return true;
}

BookmarkData_Data::BookmarkData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBookmarkBar_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBookmarkBar_Params_Data* object =
      static_cast<const PageHandler_GetBookmarkBar_Params_Data*>(data);

  return true;
}

PageHandler_GetBookmarkBar_Params_Data::PageHandler_GetBookmarkBar_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetBookmarkBar_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetBookmarkBar_ResponseParams_Data* object =
      static_cast<const PageHandler_GetBookmarkBar_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmarks, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bookmarks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bookmarks, validation_context,
                                         &bookmarks_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetBookmarkBar_ResponseParams_Data::PageHandler_GetBookmarkBar_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenInNewTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenInNewTab_Params_Data* object =
      static_cast<const PageHandler_OpenInNewTab_Params_Data*>(data);

  return true;
}

PageHandler_OpenInNewTab_Params_Data::PageHandler_OpenInNewTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_BookmarkLoaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_BookmarkLoaded_Params_Data* object =
      static_cast<const Page_BookmarkLoaded_Params_Data*>(data);

  return true;
}

Page_BookmarkLoaded_Params_Data::Page_BookmarkLoaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_FavIconChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_FavIconChanged_Params_Data* object =
      static_cast<const Page_FavIconChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmark_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bookmark_data, validation_context))
    return false;

  return true;
}

Page_FavIconChanged_Params_Data::Page_FavIconChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_Show_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_Show_Params_Data* object =
      static_cast<const Page_Show_Params_Data*>(data);

  return true;
}

Page_Show_Params_Data::Page_Show_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_Hide_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_Hide_Params_Data* object =
      static_cast<const Page_Hide_Params_Data*>(data);

  return true;
}

Page_Hide_Params_Data::Page_Hide_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace bookmark_bar

namespace perfetto {

// static
void TraceFormatTraits<::bookmark_bar::mojom::BookmarkType>::WriteIntoTrace(
   perfetto::TracedValue context, ::bookmark_bar::mojom::BookmarkType value) {
  return std::move(context).WriteString(::bookmark_bar::mojom::BookmarkTypeToString(value));
}

} // namespace perfetto