// chrome/browser/ui/webui_browser/bookmark_bar.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/ui/webui_browser/bookmark_bar.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"

#include "chrome/browser/ui/webui_browser/bookmark_bar.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::bookmark_bar::mojom::BookmarkType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bookmark_bar::mojom::BookmarkDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bookmark_bar::mojom::BookmarkDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bookmark_bar::mojom::internal::BookmarkData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in BookmarkData struct");

      
      mojo::internal::Serialize<::bookmark_bar::mojom::BookmarkType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::page_url_for_favicon(input)) in_page_url_for_favicon = Traits::page_url_for_favicon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->page_url_for_favicon)::BaseType> page_url_for_favicon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_page_url_for_favicon,
        page_url_for_favicon_fragment);

      fragment->page_url_for_favicon.Set(
          page_url_for_favicon_fragment.is_null() ? nullptr : page_url_for_favicon_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_UI_WEBUI_BROWSER_BOOKMARK_BAR_MOJOM_SEND_VALIDATION_H_