// chrome/browser/ui/webui/whats_new/whats_new.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  JSTimeSpec as mojoBase_mojom_JSTimeSpec,
  JSTime as mojoBase_mojom_JSTime,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ScrollDepthSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ScrollDepth {

  MIN_VALUE = 0,
  MAX_VALUE = 100,
  k0 = 0,
  k25 = 25,
  k50 = 50,
  k75 = 75,
  k100 = 100,
}

export const ModulePositionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ModulePosition {

  MIN_VALUE = 1,
  MAX_VALUE = 11,
  kSpotlight1 = 1,
  kSpotlight2 = 2,
  kSpotlight3 = 3,
  kSpotlight4 = 4,
  kExploreMore1 = 5,
  kExploreMore2 = 6,
  kExploreMore3 = 7,
  kExploreMore4 = 8,
  kExploreMore5 = 9,
  kExploreMore6 = 10,
  kUndefined = 11,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'whats_new.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "whats_new.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'whats_new.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getServerUrl(isStaging: boolean): Promise<{
        url: url_mojom_Url, }>;
  recordTimeToLoadContent(time: mojoBase_mojom_JSTime): void;
  recordVersionPageLoaded(isAutoOpen: boolean): void;
  recordEditionPageLoaded(pageUid: string, isAutoOpen: boolean): void;
  recordModuleImpression(moduleName: string, position: ModulePosition): void;
  recordExploreMoreToggled(expanded: boolean): void;
  recordScrollDepth(depth: ScrollDepth): void;
  recordTimeOnPage(time: mojoBase_mojom_TimeDelta): void;
  recordModuleLinkClicked(moduleName: string, position: ModulePosition): void;
  recordModuleVideoStarted(moduleName: string, position: ModulePosition): void;
  recordModuleVideoEnded(moduleName: string, position: ModulePosition): void;
  recordModulePlayClicked(moduleName: string, position: ModulePosition): void;
  recordModulePauseClicked(moduleName: string, position: ModulePosition): void;
  recordModuleRestartClicked(moduleName: string, position: ModulePosition): void;
  recordBrowserCommandExecuted(): void;
  recordQrCodeToggled(expanded: boolean): void;
  recordNavClick(): void;
  recordFeatureTileNavigation(): void;
  recordCarouselScrollButtonClick(): void;
  recordExpandMediaToggled(moduleName: string, expanded: boolean): void;
  recordCtaClick(): void;
  recordNextButtonClick(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getServerUrl(
      isStaging: boolean): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetServerUrl_ParamsSpec.$,
        PageHandler_GetServerUrl_ResponseParamsSpec.$,
        [
          isStaging
        ],
        false);
  }

  recordTimeToLoadContent(
      time: mojoBase_mojom_JSTime): void {
    this.proxy.sendMessage(
        1,
        PageHandler_RecordTimeToLoadContent_ParamsSpec.$,
        null,
        [
          time
        ],
        false);
  }

  recordVersionPageLoaded(
      isAutoOpen: boolean): void {
    this.proxy.sendMessage(
        2,
        PageHandler_RecordVersionPageLoaded_ParamsSpec.$,
        null,
        [
          isAutoOpen
        ],
        false);
  }

  recordEditionPageLoaded(
      pageUid: string,
      isAutoOpen: boolean): void {
    this.proxy.sendMessage(
        3,
        PageHandler_RecordEditionPageLoaded_ParamsSpec.$,
        null,
        [
          pageUid,
          isAutoOpen
        ],
        false);
  }

  recordModuleImpression(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        4,
        PageHandler_RecordModuleImpression_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordExploreMoreToggled(
      expanded: boolean): void {
    this.proxy.sendMessage(
        5,
        PageHandler_RecordExploreMoreToggled_ParamsSpec.$,
        null,
        [
          expanded
        ],
        false);
  }

  recordScrollDepth(
      depth: ScrollDepth): void {
    this.proxy.sendMessage(
        6,
        PageHandler_RecordScrollDepth_ParamsSpec.$,
        null,
        [
          depth
        ],
        false);
  }

  recordTimeOnPage(
      time: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        7,
        PageHandler_RecordTimeOnPage_ParamsSpec.$,
        null,
        [
          time
        ],
        false);
  }

  recordModuleLinkClicked(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        8,
        PageHandler_RecordModuleLinkClicked_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordModuleVideoStarted(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        9,
        PageHandler_RecordModuleVideoStarted_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordModuleVideoEnded(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        10,
        PageHandler_RecordModuleVideoEnded_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordModulePlayClicked(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        11,
        PageHandler_RecordModulePlayClicked_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordModulePauseClicked(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        12,
        PageHandler_RecordModulePauseClicked_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordModuleRestartClicked(
      moduleName: string,
      position: ModulePosition): void {
    this.proxy.sendMessage(
        13,
        PageHandler_RecordModuleRestartClicked_ParamsSpec.$,
        null,
        [
          moduleName,
          position
        ],
        false);
  }

  recordBrowserCommandExecuted(): void {
    this.proxy.sendMessage(
        14,
        PageHandler_RecordBrowserCommandExecuted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordQrCodeToggled(
      expanded: boolean): void {
    this.proxy.sendMessage(
        15,
        PageHandler_RecordQrCodeToggled_ParamsSpec.$,
        null,
        [
          expanded
        ],
        false);
  }

  recordNavClick(): void {
    this.proxy.sendMessage(
        16,
        PageHandler_RecordNavClick_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordFeatureTileNavigation(): void {
    this.proxy.sendMessage(
        17,
        PageHandler_RecordFeatureTileNavigation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordCarouselScrollButtonClick(): void {
    this.proxy.sendMessage(
        18,
        PageHandler_RecordCarouselScrollButtonClick_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordExpandMediaToggled(
      moduleName: string,
      expanded: boolean): void {
    this.proxy.sendMessage(
        19,
        PageHandler_RecordExpandMediaToggled_ParamsSpec.$,
        null,
        [
          moduleName,
          expanded
        ],
        false);
  }

  recordCtaClick(): void {
    this.proxy.sendMessage(
        20,
        PageHandler_RecordCtaClick_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordNextButtonClick(): void {
    this.proxy.sendMessage(
        21,
        PageHandler_RecordNextButtonClick_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetServerUrl_ParamsSpec.$,
        PageHandler_GetServerUrl_ResponseParamsSpec.$,
        impl.getServerUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_RecordTimeToLoadContent_ParamsSpec.$,
        null,
        impl.recordTimeToLoadContent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_RecordVersionPageLoaded_ParamsSpec.$,
        null,
        impl.recordVersionPageLoaded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_RecordEditionPageLoaded_ParamsSpec.$,
        null,
        impl.recordEditionPageLoaded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_RecordModuleImpression_ParamsSpec.$,
        null,
        impl.recordModuleImpression.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_RecordExploreMoreToggled_ParamsSpec.$,
        null,
        impl.recordExploreMoreToggled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_RecordScrollDepth_ParamsSpec.$,
        null,
        impl.recordScrollDepth.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_RecordTimeOnPage_ParamsSpec.$,
        null,
        impl.recordTimeOnPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_RecordModuleLinkClicked_ParamsSpec.$,
        null,
        impl.recordModuleLinkClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_RecordModuleVideoStarted_ParamsSpec.$,
        null,
        impl.recordModuleVideoStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_RecordModuleVideoEnded_ParamsSpec.$,
        null,
        impl.recordModuleVideoEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_RecordModulePlayClicked_ParamsSpec.$,
        null,
        impl.recordModulePlayClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_RecordModulePauseClicked_ParamsSpec.$,
        null,
        impl.recordModulePauseClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_RecordModuleRestartClicked_ParamsSpec.$,
        null,
        impl.recordModuleRestartClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_RecordBrowserCommandExecuted_ParamsSpec.$,
        null,
        impl.recordBrowserCommandExecuted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_RecordQrCodeToggled_ParamsSpec.$,
        null,
        impl.recordQrCodeToggled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        PageHandler_RecordNavClick_ParamsSpec.$,
        null,
        impl.recordNavClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        PageHandler_RecordFeatureTileNavigation_ParamsSpec.$,
        null,
        impl.recordFeatureTileNavigation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        PageHandler_RecordCarouselScrollButtonClick_ParamsSpec.$,
        null,
        impl.recordCarouselScrollButtonClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        PageHandler_RecordExpandMediaToggled_ParamsSpec.$,
        null,
        impl.recordExpandMediaToggled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        PageHandler_RecordCtaClick_ParamsSpec.$,
        null,
        impl.recordCtaClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        PageHandler_RecordNextButtonClick_ParamsSpec.$,
        null,
        impl.recordNextButtonClick.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "whats_new.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getServerUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordTimeToLoadContent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordVersionPageLoaded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordEditionPageLoaded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModuleImpression: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordExploreMoreToggled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordScrollDepth: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordTimeOnPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModuleLinkClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModuleVideoStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModuleVideoEnded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModulePlayClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModulePauseClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordModuleRestartClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordBrowserCommandExecuted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordQrCodeToggled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordNavClick: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordFeatureTileNavigation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordCarouselScrollButtonClick: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordExpandMediaToggled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordCtaClick: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordNextButtonClick: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getServerUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetServerUrl_ParamsSpec.$,
        PageHandler_GetServerUrl_ResponseParamsSpec.$,
        this.getServerUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.recordTimeToLoadContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_RecordTimeToLoadContent_ParamsSpec.$,
        null,
        this.recordTimeToLoadContent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordVersionPageLoaded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_RecordVersionPageLoaded_ParamsSpec.$,
        null,
        this.recordVersionPageLoaded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordEditionPageLoaded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_RecordEditionPageLoaded_ParamsSpec.$,
        null,
        this.recordEditionPageLoaded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModuleImpression =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_RecordModuleImpression_ParamsSpec.$,
        null,
        this.recordModuleImpression.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordExploreMoreToggled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_RecordExploreMoreToggled_ParamsSpec.$,
        null,
        this.recordExploreMoreToggled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordScrollDepth =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_RecordScrollDepth_ParamsSpec.$,
        null,
        this.recordScrollDepth.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordTimeOnPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_RecordTimeOnPage_ParamsSpec.$,
        null,
        this.recordTimeOnPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModuleLinkClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_RecordModuleLinkClicked_ParamsSpec.$,
        null,
        this.recordModuleLinkClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModuleVideoStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_RecordModuleVideoStarted_ParamsSpec.$,
        null,
        this.recordModuleVideoStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModuleVideoEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_RecordModuleVideoEnded_ParamsSpec.$,
        null,
        this.recordModuleVideoEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModulePlayClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_RecordModulePlayClicked_ParamsSpec.$,
        null,
        this.recordModulePlayClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModulePauseClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_RecordModulePauseClicked_ParamsSpec.$,
        null,
        this.recordModulePauseClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordModuleRestartClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_RecordModuleRestartClicked_ParamsSpec.$,
        null,
        this.recordModuleRestartClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordBrowserCommandExecuted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_RecordBrowserCommandExecuted_ParamsSpec.$,
        null,
        this.recordBrowserCommandExecuted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordQrCodeToggled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_RecordQrCodeToggled_ParamsSpec.$,
        null,
        this.recordQrCodeToggled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordNavClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        PageHandler_RecordNavClick_ParamsSpec.$,
        null,
        this.recordNavClick.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordFeatureTileNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        PageHandler_RecordFeatureTileNavigation_ParamsSpec.$,
        null,
        this.recordFeatureTileNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordCarouselScrollButtonClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        PageHandler_RecordCarouselScrollButtonClick_ParamsSpec.$,
        null,
        this.recordCarouselScrollButtonClick.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordExpandMediaToggled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        PageHandler_RecordExpandMediaToggled_ParamsSpec.$,
        null,
        this.recordExpandMediaToggled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordCtaClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        PageHandler_RecordCtaClick_ParamsSpec.$,
        null,
        this.recordCtaClick.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordNextButtonClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        PageHandler_RecordNextButtonClick_ParamsSpec.$,
        null,
        this.recordNextButtonClick.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'whats_new.mojom.Page',
        scope);
  }
}

export interface PageInterface {
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(_impl: PageInterface) {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "whats_new.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetServerUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetServerUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordTimeToLoadContent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordVersionPageLoaded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordEditionPageLoaded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModuleImpression_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordExploreMoreToggled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordScrollDepth_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordTimeOnPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModuleLinkClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModuleVideoStarted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModuleVideoEnded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModulePlayClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModulePauseClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordModuleRestartClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordBrowserCommandExecuted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordQrCodeToggled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordNavClick_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordFeatureTileNavigation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordCarouselScrollButtonClick_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordExpandMediaToggled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordCtaClick_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordNextButtonClick_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetServerUrl_ParamsMojoType {
  isStaging: boolean;
}


export type PageHandler_GetServerUrl_Params = PageHandler_GetServerUrl_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetServerUrl_ParamsMojoType>(
    PageHandler_GetServerUrl_ParamsSpec.$,
    'PageHandler_GetServerUrl_Params',
    [
      mojo.internal.StructField<PageHandler_GetServerUrl_ParamsMojoType, boolean>(
        'isStaging', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetServerUrl_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_GetServerUrl_ResponseParams = PageHandler_GetServerUrl_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetServerUrl_ResponseParamsMojoType>(
    PageHandler_GetServerUrl_ResponseParamsSpec.$,
    'PageHandler_GetServerUrl_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetServerUrl_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordTimeToLoadContent_ParamsMojoType {
  time: mojoBase_mojom_JSTime;
}


export type PageHandler_RecordTimeToLoadContent_Params = PageHandler_RecordTimeToLoadContent_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordTimeToLoadContent_ParamsMojoType>(
    PageHandler_RecordTimeToLoadContent_ParamsSpec.$,
    'PageHandler_RecordTimeToLoadContent_Params',
    [
      mojo.internal.StructField<PageHandler_RecordTimeToLoadContent_ParamsMojoType, mojoBase_mojom_JSTime>(
        'time', 0,
        0,
        mojoBase_mojom_JSTimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordVersionPageLoaded_ParamsMojoType {
  isAutoOpen: boolean;
}


export type PageHandler_RecordVersionPageLoaded_Params = PageHandler_RecordVersionPageLoaded_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordVersionPageLoaded_ParamsMojoType>(
    PageHandler_RecordVersionPageLoaded_ParamsSpec.$,
    'PageHandler_RecordVersionPageLoaded_Params',
    [
      mojo.internal.StructField<PageHandler_RecordVersionPageLoaded_ParamsMojoType, boolean>(
        'isAutoOpen', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordEditionPageLoaded_ParamsMojoType {
  pageUid: string;
  isAutoOpen: boolean;
}


export type PageHandler_RecordEditionPageLoaded_Params = PageHandler_RecordEditionPageLoaded_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordEditionPageLoaded_ParamsMojoType>(
    PageHandler_RecordEditionPageLoaded_ParamsSpec.$,
    'PageHandler_RecordEditionPageLoaded_Params',
    [
      mojo.internal.StructField<PageHandler_RecordEditionPageLoaded_ParamsMojoType, string>(
        'pageUid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordEditionPageLoaded_ParamsMojoType, boolean>(
        'isAutoOpen', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordModuleImpression_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModuleImpression_Params = PageHandler_RecordModuleImpression_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModuleImpression_ParamsMojoType>(
    PageHandler_RecordModuleImpression_ParamsSpec.$,
    'PageHandler_RecordModuleImpression_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModuleImpression_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModuleImpression_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordExploreMoreToggled_ParamsMojoType {
  expanded: boolean;
}


export type PageHandler_RecordExploreMoreToggled_Params = PageHandler_RecordExploreMoreToggled_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordExploreMoreToggled_ParamsMojoType>(
    PageHandler_RecordExploreMoreToggled_ParamsSpec.$,
    'PageHandler_RecordExploreMoreToggled_Params',
    [
      mojo.internal.StructField<PageHandler_RecordExploreMoreToggled_ParamsMojoType, boolean>(
        'expanded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordScrollDepth_ParamsMojoType {
  depth: ScrollDepth;
}


export type PageHandler_RecordScrollDepth_Params = PageHandler_RecordScrollDepth_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordScrollDepth_ParamsMojoType>(
    PageHandler_RecordScrollDepth_ParamsSpec.$,
    'PageHandler_RecordScrollDepth_Params',
    [
      mojo.internal.StructField<PageHandler_RecordScrollDepth_ParamsMojoType, ScrollDepth>(
        'depth', 0,
        0,
        ScrollDepthSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordTimeOnPage_ParamsMojoType {
  time: mojoBase_mojom_TimeDelta;
}


export type PageHandler_RecordTimeOnPage_Params = PageHandler_RecordTimeOnPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordTimeOnPage_ParamsMojoType>(
    PageHandler_RecordTimeOnPage_ParamsSpec.$,
    'PageHandler_RecordTimeOnPage_Params',
    [
      mojo.internal.StructField<PageHandler_RecordTimeOnPage_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'time', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordModuleLinkClicked_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModuleLinkClicked_Params = PageHandler_RecordModuleLinkClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModuleLinkClicked_ParamsMojoType>(
    PageHandler_RecordModuleLinkClicked_ParamsSpec.$,
    'PageHandler_RecordModuleLinkClicked_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModuleLinkClicked_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModuleLinkClicked_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordModuleVideoStarted_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModuleVideoStarted_Params = PageHandler_RecordModuleVideoStarted_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModuleVideoStarted_ParamsMojoType>(
    PageHandler_RecordModuleVideoStarted_ParamsSpec.$,
    'PageHandler_RecordModuleVideoStarted_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModuleVideoStarted_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModuleVideoStarted_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordModuleVideoEnded_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModuleVideoEnded_Params = PageHandler_RecordModuleVideoEnded_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModuleVideoEnded_ParamsMojoType>(
    PageHandler_RecordModuleVideoEnded_ParamsSpec.$,
    'PageHandler_RecordModuleVideoEnded_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModuleVideoEnded_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModuleVideoEnded_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordModulePlayClicked_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModulePlayClicked_Params = PageHandler_RecordModulePlayClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModulePlayClicked_ParamsMojoType>(
    PageHandler_RecordModulePlayClicked_ParamsSpec.$,
    'PageHandler_RecordModulePlayClicked_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModulePlayClicked_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModulePlayClicked_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordModulePauseClicked_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModulePauseClicked_Params = PageHandler_RecordModulePauseClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModulePauseClicked_ParamsMojoType>(
    PageHandler_RecordModulePauseClicked_ParamsSpec.$,
    'PageHandler_RecordModulePauseClicked_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModulePauseClicked_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModulePauseClicked_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordModuleRestartClicked_ParamsMojoType {
  moduleName: string;
  position: ModulePosition;
}


export type PageHandler_RecordModuleRestartClicked_Params = PageHandler_RecordModuleRestartClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordModuleRestartClicked_ParamsMojoType>(
    PageHandler_RecordModuleRestartClicked_ParamsSpec.$,
    'PageHandler_RecordModuleRestartClicked_Params',
    [
      mojo.internal.StructField<PageHandler_RecordModuleRestartClicked_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordModuleRestartClicked_ParamsMojoType, ModulePosition>(
        'position', 8,
        0,
        ModulePositionSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordBrowserCommandExecuted_ParamsMojoType {
}


export type PageHandler_RecordBrowserCommandExecuted_Params = PageHandler_RecordBrowserCommandExecuted_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordBrowserCommandExecuted_ParamsMojoType>(
    PageHandler_RecordBrowserCommandExecuted_ParamsSpec.$,
    'PageHandler_RecordBrowserCommandExecuted_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RecordQrCodeToggled_ParamsMojoType {
  expanded: boolean;
}


export type PageHandler_RecordQrCodeToggled_Params = PageHandler_RecordQrCodeToggled_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordQrCodeToggled_ParamsMojoType>(
    PageHandler_RecordQrCodeToggled_ParamsSpec.$,
    'PageHandler_RecordQrCodeToggled_Params',
    [
      mojo.internal.StructField<PageHandler_RecordQrCodeToggled_ParamsMojoType, boolean>(
        'expanded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordNavClick_ParamsMojoType {
}


export type PageHandler_RecordNavClick_Params = PageHandler_RecordNavClick_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordNavClick_ParamsMojoType>(
    PageHandler_RecordNavClick_ParamsSpec.$,
    'PageHandler_RecordNavClick_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RecordFeatureTileNavigation_ParamsMojoType {
}


export type PageHandler_RecordFeatureTileNavigation_Params = PageHandler_RecordFeatureTileNavigation_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordFeatureTileNavigation_ParamsMojoType>(
    PageHandler_RecordFeatureTileNavigation_ParamsSpec.$,
    'PageHandler_RecordFeatureTileNavigation_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RecordCarouselScrollButtonClick_ParamsMojoType {
}


export type PageHandler_RecordCarouselScrollButtonClick_Params = PageHandler_RecordCarouselScrollButtonClick_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordCarouselScrollButtonClick_ParamsMojoType>(
    PageHandler_RecordCarouselScrollButtonClick_ParamsSpec.$,
    'PageHandler_RecordCarouselScrollButtonClick_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RecordExpandMediaToggled_ParamsMojoType {
  moduleName: string;
  expanded: boolean;
}


export type PageHandler_RecordExpandMediaToggled_Params = PageHandler_RecordExpandMediaToggled_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordExpandMediaToggled_ParamsMojoType>(
    PageHandler_RecordExpandMediaToggled_ParamsSpec.$,
    'PageHandler_RecordExpandMediaToggled_Params',
    [
      mojo.internal.StructField<PageHandler_RecordExpandMediaToggled_ParamsMojoType, string>(
        'moduleName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordExpandMediaToggled_ParamsMojoType, boolean>(
        'expanded', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordCtaClick_ParamsMojoType {
}


export type PageHandler_RecordCtaClick_Params = PageHandler_RecordCtaClick_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordCtaClick_ParamsMojoType>(
    PageHandler_RecordCtaClick_ParamsSpec.$,
    'PageHandler_RecordCtaClick_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RecordNextButtonClick_ParamsMojoType {
}


export type PageHandler_RecordNextButtonClick_Params = PageHandler_RecordNextButtonClick_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordNextButtonClick_ParamsMojoType>(
    PageHandler_RecordNextButtonClick_ParamsSpec.$,
    'PageHandler_RecordNextButtonClick_Params',
    [
    ],
    [[0, 8],]);



