// chrome/browser/ui/webui/whats_new/whats_new.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-params-data.h"
namespace whats_new {
namespace mojom {

NOINLINE static const char* ScrollDepthToStringHelper(ScrollDepth value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollDepth::k0:
      return "k0";
    case ScrollDepth::k25:
      return "k25";
    case ScrollDepth::k50:
      return "k50";
    case ScrollDepth::k75:
      return "k75";
    case ScrollDepth::k100:
      return "k100";
    default:
      return nullptr;
  }
}

std::string ScrollDepthToString(ScrollDepth value) {
  const char *str = ScrollDepthToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollDepth value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollDepth value) {
  return os << ScrollDepthToString(value);
}

NOINLINE static const char* ModulePositionToStringHelper(ModulePosition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModulePosition::kSpotlight1:
      return "kSpotlight1";
    case ModulePosition::kSpotlight2:
      return "kSpotlight2";
    case ModulePosition::kSpotlight3:
      return "kSpotlight3";
    case ModulePosition::kSpotlight4:
      return "kSpotlight4";
    case ModulePosition::kExploreMore1:
      return "kExploreMore1";
    case ModulePosition::kExploreMore2:
      return "kExploreMore2";
    case ModulePosition::kExploreMore3:
      return "kExploreMore3";
    case ModulePosition::kExploreMore4:
      return "kExploreMore4";
    case ModulePosition::kExploreMore5:
      return "kExploreMore5";
    case ModulePosition::kExploreMore6:
      return "kExploreMore6";
    case ModulePosition::kUndefined:
      return "kUndefined";
    default:
      return nullptr;
  }
}

std::string ModulePositionToString(ModulePosition value) {
  const char *str = ModulePositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModulePosition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModulePosition value) {
  return os << ModulePositionToString(value);
}

namespace internal {


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetServerUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetServerUrl_Params_Data* object =
      static_cast<const PageHandler_GetServerUrl_Params_Data*>(data);

  return true;
}

PageHandler_GetServerUrl_Params_Data::PageHandler_GetServerUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetServerUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetServerUrl_ResponseParams_Data* object =
      static_cast<const PageHandler_GetServerUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_GetServerUrl_ResponseParams_Data::PageHandler_GetServerUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordTimeToLoadContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordTimeToLoadContent_Params_Data* object =
      static_cast<const PageHandler_RecordTimeToLoadContent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  return true;
}

PageHandler_RecordTimeToLoadContent_Params_Data::PageHandler_RecordTimeToLoadContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordVersionPageLoaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordVersionPageLoaded_Params_Data* object =
      static_cast<const PageHandler_RecordVersionPageLoaded_Params_Data*>(data);

  return true;
}

PageHandler_RecordVersionPageLoaded_Params_Data::PageHandler_RecordVersionPageLoaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordEditionPageLoaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordEditionPageLoaded_Params_Data* object =
      static_cast<const PageHandler_RecordEditionPageLoaded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_uid, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& page_uid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->page_uid, validation_context,
                                         &page_uid_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_RecordEditionPageLoaded_Params_Data::PageHandler_RecordEditionPageLoaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModuleImpression_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModuleImpression_Params_Data* object =
      static_cast<const PageHandler_RecordModuleImpression_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModuleImpression_Params_Data::PageHandler_RecordModuleImpression_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordExploreMoreToggled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordExploreMoreToggled_Params_Data* object =
      static_cast<const PageHandler_RecordExploreMoreToggled_Params_Data*>(data);

  return true;
}

PageHandler_RecordExploreMoreToggled_Params_Data::PageHandler_RecordExploreMoreToggled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordScrollDepth_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordScrollDepth_Params_Data* object =
      static_cast<const PageHandler_RecordScrollDepth_Params_Data*>(data);


  if (!::whats_new::mojom::internal::ScrollDepth_Data
        ::Validate(object->depth, validation_context))
    return false;

  return true;
}

PageHandler_RecordScrollDepth_Params_Data::PageHandler_RecordScrollDepth_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordTimeOnPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordTimeOnPage_Params_Data* object =
      static_cast<const PageHandler_RecordTimeOnPage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  return true;
}

PageHandler_RecordTimeOnPage_Params_Data::PageHandler_RecordTimeOnPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModuleLinkClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModuleLinkClicked_Params_Data* object =
      static_cast<const PageHandler_RecordModuleLinkClicked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModuleLinkClicked_Params_Data::PageHandler_RecordModuleLinkClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModuleVideoStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModuleVideoStarted_Params_Data* object =
      static_cast<const PageHandler_RecordModuleVideoStarted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModuleVideoStarted_Params_Data::PageHandler_RecordModuleVideoStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModuleVideoEnded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModuleVideoEnded_Params_Data* object =
      static_cast<const PageHandler_RecordModuleVideoEnded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModuleVideoEnded_Params_Data::PageHandler_RecordModuleVideoEnded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModulePlayClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModulePlayClicked_Params_Data* object =
      static_cast<const PageHandler_RecordModulePlayClicked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModulePlayClicked_Params_Data::PageHandler_RecordModulePlayClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModulePauseClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModulePauseClicked_Params_Data* object =
      static_cast<const PageHandler_RecordModulePauseClicked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModulePauseClicked_Params_Data::PageHandler_RecordModulePauseClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordModuleRestartClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordModuleRestartClicked_Params_Data* object =
      static_cast<const PageHandler_RecordModuleRestartClicked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }


  if (!::whats_new::mojom::internal::ModulePosition_Data
        ::Validate(object->position, validation_context))
    return false;

  return true;
}

PageHandler_RecordModuleRestartClicked_Params_Data::PageHandler_RecordModuleRestartClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordBrowserCommandExecuted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordBrowserCommandExecuted_Params_Data* object =
      static_cast<const PageHandler_RecordBrowserCommandExecuted_Params_Data*>(data);

  return true;
}

PageHandler_RecordBrowserCommandExecuted_Params_Data::PageHandler_RecordBrowserCommandExecuted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordQrCodeToggled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordQrCodeToggled_Params_Data* object =
      static_cast<const PageHandler_RecordQrCodeToggled_Params_Data*>(data);

  return true;
}

PageHandler_RecordQrCodeToggled_Params_Data::PageHandler_RecordQrCodeToggled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordNavClick_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordNavClick_Params_Data* object =
      static_cast<const PageHandler_RecordNavClick_Params_Data*>(data);

  return true;
}

PageHandler_RecordNavClick_Params_Data::PageHandler_RecordNavClick_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordFeatureTileNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordFeatureTileNavigation_Params_Data* object =
      static_cast<const PageHandler_RecordFeatureTileNavigation_Params_Data*>(data);

  return true;
}

PageHandler_RecordFeatureTileNavigation_Params_Data::PageHandler_RecordFeatureTileNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordCarouselScrollButtonClick_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordCarouselScrollButtonClick_Params_Data* object =
      static_cast<const PageHandler_RecordCarouselScrollButtonClick_Params_Data*>(data);

  return true;
}

PageHandler_RecordCarouselScrollButtonClick_Params_Data::PageHandler_RecordCarouselScrollButtonClick_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordExpandMediaToggled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordExpandMediaToggled_Params_Data* object =
      static_cast<const PageHandler_RecordExpandMediaToggled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_name, validation_context,
                                         &module_name_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_RecordExpandMediaToggled_Params_Data::PageHandler_RecordExpandMediaToggled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordCtaClick_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordCtaClick_Params_Data* object =
      static_cast<const PageHandler_RecordCtaClick_Params_Data*>(data);

  return true;
}

PageHandler_RecordCtaClick_Params_Data::PageHandler_RecordCtaClick_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordNextButtonClick_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordNextButtonClick_Params_Data* object =
      static_cast<const PageHandler_RecordNextButtonClick_Params_Data*>(data);

  return true;
}

PageHandler_RecordNextButtonClick_Params_Data::PageHandler_RecordNextButtonClick_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace whats_new

namespace perfetto {

// static
void TraceFormatTraits<::whats_new::mojom::ScrollDepth>::WriteIntoTrace(
   perfetto::TracedValue context, ::whats_new::mojom::ScrollDepth value) {
  return std::move(context).WriteString(::whats_new::mojom::ScrollDepthToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::whats_new::mojom::ModulePosition>::WriteIntoTrace(
   perfetto::TracedValue context, ::whats_new::mojom::ModulePosition value) {
  return std::move(context).WriteString(::whats_new::mojom::ModulePositionToString(value));
}

} // namespace perfetto