// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mojom {

class WebAppInternalsHandlerProxy;

template <typename ImplRefTraits>
class WebAppInternalsHandlerStub;

class WebAppInternalsHandlerRequestValidator;
class WebAppInternalsHandlerResponseValidator;


class WebAppInternalsHandler
    : public WebAppInternalsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.WebAppInternalsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebAppInternalsHandlerInterfaceBase;
  using Proxy_ = WebAppInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebAppInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = WebAppInternalsHandlerRequestValidator;
  using ResponseValidator_ = WebAppInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDebugInfoAsJsonStringMinVersion = 0,
    kInstallIsolatedWebAppFromDevProxyMinVersion = 0,
    kSelectFileAndInstallIsolatedWebAppFromDevBundleMinVersion = 0,
    kParseUpdateManifestFromUrlMinVersion = 0,
    kInstallIsolatedWebAppFromBundleUrlMinVersion = 0,
    kUpdateDevProxyIsolatedWebAppMinVersion = 0,
    kSelectFileAndUpdateIsolatedWebAppFromDevBundleMinVersion = 0,
    kUpdateManifestInstalledIsolatedWebAppMinVersion = 0,
    kDeleteIsolatedWebAppMinVersion = 0,
    kSetUpdateChannelForIsolatedWebAppMinVersion = 0,
    kSetPinnedVersionForIsolatedWebAppMinVersion = 0,
    kResetPinnedVersionForIsolatedWebAppMinVersion = 0,
    kSetAllowDowngradesForIsolatedWebAppMinVersion = 0,
    kSearchForIsolatedWebAppUpdatesMinVersion = 0,
    kGetIsolatedWebAppDevModeAppInfoMinVersion = 0,
    kRotateKeyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDebugInfoAsJsonString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallIsolatedWebAppFromDevProxy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectFileAndInstallIsolatedWebAppFromDevBundle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseUpdateManifestFromUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallIsolatedWebAppFromBundleUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDevProxyIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectFileAndUpdateIsolatedWebAppFromDevBundle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateManifestInstalledIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUpdateChannelForIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPinnedVersionForIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetPinnedVersionForIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAllowDowngradesForIsolatedWebApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SearchForIsolatedWebAppUpdates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsolatedWebAppDevModeAppInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RotateKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebAppInternalsHandler() = default;

  using GetDebugInfoAsJsonStringCallback = base::OnceCallback<void(const std::string&)>;
  using GetDebugInfoAsJsonStringMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetDebugInfoAsJsonString(GetDebugInfoAsJsonStringCallback callback) = 0;

  using InstallIsolatedWebAppFromDevProxyCallback = base::OnceCallback<void(InstallIsolatedWebAppResultPtr)>;
  using InstallIsolatedWebAppFromDevProxyMojoCallback = base::OnceCallback<void(InstallIsolatedWebAppResultPtr)>;

  virtual void InstallIsolatedWebAppFromDevProxy(const ::GURL& url, InstallIsolatedWebAppFromDevProxyCallback callback) = 0;

  using SelectFileAndInstallIsolatedWebAppFromDevBundleCallback = base::OnceCallback<void(InstallIsolatedWebAppResultPtr)>;
  using SelectFileAndInstallIsolatedWebAppFromDevBundleMojoCallback = base::OnceCallback<void(InstallIsolatedWebAppResultPtr)>;

  virtual void SelectFileAndInstallIsolatedWebAppFromDevBundle(SelectFileAndInstallIsolatedWebAppFromDevBundleCallback callback) = 0;

  using ParseUpdateManifestFromUrlCallback = base::OnceCallback<void(ParseUpdateManifestFromUrlResultPtr)>;
  using ParseUpdateManifestFromUrlMojoCallback = base::OnceCallback<void(ParseUpdateManifestFromUrlResultPtr)>;

  virtual void ParseUpdateManifestFromUrl(const ::GURL& update_manifest_url, ParseUpdateManifestFromUrlCallback callback) = 0;

  using InstallIsolatedWebAppFromBundleUrlCallback = base::OnceCallback<void(InstallIsolatedWebAppResultPtr)>;
  using InstallIsolatedWebAppFromBundleUrlMojoCallback = base::OnceCallback<void(InstallIsolatedWebAppResultPtr)>;

  virtual void InstallIsolatedWebAppFromBundleUrl(InstallFromBundleUrlParamsPtr params, InstallIsolatedWebAppFromBundleUrlCallback callback) = 0;

  using UpdateDevProxyIsolatedWebAppCallback = base::OnceCallback<void(const std::string&)>;
  using UpdateDevProxyIsolatedWebAppMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void UpdateDevProxyIsolatedWebApp(const std::string& app_id, UpdateDevProxyIsolatedWebAppCallback callback) = 0;

  using SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback = base::OnceCallback<void(const std::string&)>;
  using SelectFileAndUpdateIsolatedWebAppFromDevBundleMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void SelectFileAndUpdateIsolatedWebAppFromDevBundle(const std::string& app_id, SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback callback) = 0;

  using UpdateManifestInstalledIsolatedWebAppCallback = base::OnceCallback<void(const std::string&)>;
  using UpdateManifestInstalledIsolatedWebAppMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void UpdateManifestInstalledIsolatedWebApp(const std::string& app_id, UpdateManifestInstalledIsolatedWebAppCallback callback) = 0;

  using DeleteIsolatedWebAppCallback = base::OnceCallback<void(bool)>;
  using DeleteIsolatedWebAppMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteIsolatedWebApp(const std::string& app_id, DeleteIsolatedWebAppCallback callback) = 0;

  using SetUpdateChannelForIsolatedWebAppCallback = base::OnceCallback<void(bool)>;
  using SetUpdateChannelForIsolatedWebAppMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetUpdateChannelForIsolatedWebApp(const std::string& app_id, const std::string& update_channel, SetUpdateChannelForIsolatedWebAppCallback callback) = 0;

  using SetPinnedVersionForIsolatedWebAppCallback = base::OnceCallback<void(bool)>;
  using SetPinnedVersionForIsolatedWebAppMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetPinnedVersionForIsolatedWebApp(const std::string& app_id, const std::string& pinned_version, SetPinnedVersionForIsolatedWebAppCallback callback) = 0;

  virtual void ResetPinnedVersionForIsolatedWebApp(const std::string& app_id) = 0;

  virtual void SetAllowDowngradesForIsolatedWebApp(bool allow_downgrades, const std::string& app_id) = 0;

  using SearchForIsolatedWebAppUpdatesCallback = base::OnceCallback<void(const std::string&)>;
  using SearchForIsolatedWebAppUpdatesMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void SearchForIsolatedWebAppUpdates(SearchForIsolatedWebAppUpdatesCallback callback) = 0;

  using GetIsolatedWebAppDevModeAppInfoCallback = base::OnceCallback<void(std::vector<IwaDevModeAppInfoPtr>)>;
  using GetIsolatedWebAppDevModeAppInfoMojoCallback = base::OnceCallback<void(std::vector<IwaDevModeAppInfoPtr>)>;

  virtual void GetIsolatedWebAppDevModeAppInfo(GetIsolatedWebAppDevModeAppInfoCallback callback) = 0;

  virtual void RotateKey(const std::string& web_bundle_id, const std::optional<std::vector<uint8_t>>& rotated_key) = 0;
};



class  WebAppInternalsHandlerProxy
    : public WebAppInternalsHandler {
 public:
  using InterfaceType = WebAppInternalsHandler;

  explicit WebAppInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDebugInfoAsJsonString(GetDebugInfoAsJsonStringCallback callback) final;
  
  void InstallIsolatedWebAppFromDevProxy(const ::GURL& url, InstallIsolatedWebAppFromDevProxyCallback callback) final;
  
  void SelectFileAndInstallIsolatedWebAppFromDevBundle(SelectFileAndInstallIsolatedWebAppFromDevBundleCallback callback) final;
  
  void ParseUpdateManifestFromUrl(const ::GURL& update_manifest_url, ParseUpdateManifestFromUrlCallback callback) final;
  
  void InstallIsolatedWebAppFromBundleUrl(InstallFromBundleUrlParamsPtr params, InstallIsolatedWebAppFromBundleUrlCallback callback) final;
  
  void UpdateDevProxyIsolatedWebApp(const std::string& app_id, UpdateDevProxyIsolatedWebAppCallback callback) final;
  
  void SelectFileAndUpdateIsolatedWebAppFromDevBundle(const std::string& app_id, SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback callback) final;
  
  void UpdateManifestInstalledIsolatedWebApp(const std::string& app_id, UpdateManifestInstalledIsolatedWebAppCallback callback) final;
  
  void DeleteIsolatedWebApp(const std::string& app_id, DeleteIsolatedWebAppCallback callback) final;
  
  void SetUpdateChannelForIsolatedWebApp(const std::string& app_id, const std::string& update_channel, SetUpdateChannelForIsolatedWebAppCallback callback) final;
  
  void SetPinnedVersionForIsolatedWebApp(const std::string& app_id, const std::string& pinned_version, SetPinnedVersionForIsolatedWebAppCallback callback) final;
  
  void ResetPinnedVersionForIsolatedWebApp(const std::string& app_id) final;
  
  void SetAllowDowngradesForIsolatedWebApp(bool allow_downgrades, const std::string& app_id) final;
  
  void SearchForIsolatedWebAppUpdates(SearchForIsolatedWebAppUpdatesCallback callback) final;
  
  void GetIsolatedWebAppDevModeAppInfo(GetIsolatedWebAppDevModeAppInfoCallback callback) final;
  
  void RotateKey(const std::string& web_bundle_id, const std::optional<std::vector<uint8_t>>& rotated_key) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebAppInternalsHandlerStubDispatch {
 public:
  static bool Accept(WebAppInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebAppInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebAppInternalsHandler>>
class WebAppInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebAppInternalsHandlerStub() = default;
  ~WebAppInternalsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebAppInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebAppInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebAppInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebAppInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  InstallIsolatedWebAppSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InstallIsolatedWebAppSuccess, T>::value>;
  using DataView = InstallIsolatedWebAppSuccessDataView;
  using Data_ = internal::InstallIsolatedWebAppSuccess_Data;

  template <typename... Args>
  static InstallIsolatedWebAppSuccessPtr New(Args&&... args) {
    return InstallIsolatedWebAppSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InstallIsolatedWebAppSuccessPtr From(const U& u) {
    return mojo::TypeConverter<InstallIsolatedWebAppSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InstallIsolatedWebAppSuccess>::Convert(*this);
  }


  InstallIsolatedWebAppSuccess();

  explicit InstallIsolatedWebAppSuccess(
      const std::string& web_bundle_id);


  ~InstallIsolatedWebAppSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InstallIsolatedWebAppSuccessPtr>
  InstallIsolatedWebAppSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstallIsolatedWebAppSuccess::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstallIsolatedWebAppSuccess::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InstallIsolatedWebAppSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InstallIsolatedWebAppSuccess_UnserializedMessageContext<
            UserType, InstallIsolatedWebAppSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InstallIsolatedWebAppSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InstallIsolatedWebAppSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InstallIsolatedWebAppSuccess_UnserializedMessageContext<
            UserType, InstallIsolatedWebAppSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InstallIsolatedWebAppSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string web_bundle_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  InstallIsolatedWebAppResult {
 public:
  using DataView = InstallIsolatedWebAppResultDataView;
  using Data_ = internal::InstallIsolatedWebAppResult_Data;
  using Tag = Data_::InstallIsolatedWebAppResult_Tag;

  template <typename... Args>
  static InstallIsolatedWebAppResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static InstallIsolatedWebAppResultPtr NewSuccess(
      InstallIsolatedWebAppSuccessPtr value);
  // Construct an instance holding |error|.
  static InstallIsolatedWebAppResultPtr NewError(
      const std::string& value);

  template <typename U>
  static InstallIsolatedWebAppResultPtr From(const U& u) {
    return mojo::TypeConverter<InstallIsolatedWebAppResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InstallIsolatedWebAppResult>::Convert(*this);
  }
  ~InstallIsolatedWebAppResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  InstallIsolatedWebAppResult(const InstallIsolatedWebAppResult& other) = delete;
  InstallIsolatedWebAppResult& operator=(const InstallIsolatedWebAppResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = InstallIsolatedWebAppResultPtr>
  InstallIsolatedWebAppResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, InstallIsolatedWebAppResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, InstallIsolatedWebAppResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const InstallIsolatedWebAppSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  InstallIsolatedWebAppSuccessPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(InstallIsolatedWebAppSuccessPtr success);

  bool is_error() const { return tag_ == Tag::kError; }
  const std::string& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  std::string& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(const std::string& error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InstallIsolatedWebAppResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<InstallIsolatedWebAppResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        InstallIsolatedWebAppSuccessPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    InstallIsolatedWebAppSuccessPtr success;
    std::string error;
  };

  InstallIsolatedWebAppResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      InstallIsolatedWebAppSuccessPtr value);
  InstallIsolatedWebAppResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  IwaDevModeLocation {
 public:
  using DataView = IwaDevModeLocationDataView;
  using Data_ = internal::IwaDevModeLocation_Data;
  using Tag = Data_::IwaDevModeLocation_Tag;

  template <typename... Args>
  static IwaDevModeLocationPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |proxy_origin|.
  static IwaDevModeLocationPtr NewProxyOrigin(
      const ::url::Origin& value);
  // Construct an instance holding |bundle_path|.
  static IwaDevModeLocationPtr NewBundlePath(
      const ::base::FilePath& value);

  template <typename U>
  static IwaDevModeLocationPtr From(const U& u) {
    return mojo::TypeConverter<IwaDevModeLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IwaDevModeLocation>::Convert(*this);
  }
  ~IwaDevModeLocation();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IwaDevModeLocation(const IwaDevModeLocation& other) = delete;
  IwaDevModeLocation& operator=(const IwaDevModeLocation& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IwaDevModeLocationPtr>
  IwaDevModeLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IwaDevModeLocation>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IwaDevModeLocation>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_proxy_origin() const { return tag_ == Tag::kProxyOrigin; }
  const ::url::Origin& get_proxy_origin() const {
    CHECK(tag_ == Tag::kProxyOrigin);
    return data_.proxy_origin;
  }
  ::url::Origin& get_proxy_origin() {
    CHECK(tag_ == Tag::kProxyOrigin);
    return data_.proxy_origin;
  }
  void set_proxy_origin(const ::url::Origin& proxy_origin);

  bool is_bundle_path() const { return tag_ == Tag::kBundlePath; }
  const ::base::FilePath& get_bundle_path() const {
    CHECK(tag_ == Tag::kBundlePath);
    return data_.bundle_path;
  }
  ::base::FilePath& get_bundle_path() {
    CHECK(tag_ == Tag::kBundlePath);
    return data_.bundle_path;
  }
  void set_bundle_path(const ::base::FilePath& bundle_path);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IwaDevModeLocation::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IwaDevModeLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kProxyOrigin)>,
        const ::url::Origin& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBundlePath)>,
        const ::base::FilePath& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::url::Origin proxy_origin;
    ::base::FilePath bundle_path;
  };

  IwaDevModeLocation(
      std::in_place_index_t<static_cast<size_t>(Tag::kProxyOrigin)>,
      const ::url::Origin& value);
  IwaDevModeLocation(
      std::in_place_index_t<static_cast<size_t>(Tag::kBundlePath)>,
      const ::base::FilePath& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ParseUpdateManifestFromUrlResult {
 public:
  using DataView = ParseUpdateManifestFromUrlResultDataView;
  using Data_ = internal::ParseUpdateManifestFromUrlResult_Data;
  using Tag = Data_::ParseUpdateManifestFromUrlResult_Tag;

  template <typename... Args>
  static ParseUpdateManifestFromUrlResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |update_manifest|.
  static ParseUpdateManifestFromUrlResultPtr NewUpdateManifest(
      UpdateManifestPtr value);
  // Construct an instance holding |error|.
  static ParseUpdateManifestFromUrlResultPtr NewError(
      const std::string& value);

  template <typename U>
  static ParseUpdateManifestFromUrlResultPtr From(const U& u) {
    return mojo::TypeConverter<ParseUpdateManifestFromUrlResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParseUpdateManifestFromUrlResult>::Convert(*this);
  }
  ~ParseUpdateManifestFromUrlResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ParseUpdateManifestFromUrlResult(const ParseUpdateManifestFromUrlResult& other) = delete;
  ParseUpdateManifestFromUrlResult& operator=(const ParseUpdateManifestFromUrlResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ParseUpdateManifestFromUrlResultPtr>
  ParseUpdateManifestFromUrlResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ParseUpdateManifestFromUrlResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ParseUpdateManifestFromUrlResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_update_manifest() const { return tag_ == Tag::kUpdateManifest; }
  const UpdateManifestPtr& get_update_manifest() const {
    CHECK(tag_ == Tag::kUpdateManifest);
    return data_.update_manifest;
  }
  UpdateManifestPtr& get_update_manifest() {
    CHECK(tag_ == Tag::kUpdateManifest);
    return data_.update_manifest;
  }
  void set_update_manifest(UpdateManifestPtr update_manifest);

  bool is_error() const { return tag_ == Tag::kError; }
  const std::string& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  std::string& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(const std::string& error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParseUpdateManifestFromUrlResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ParseUpdateManifestFromUrlResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUpdateManifest)>,
        UpdateManifestPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    UpdateManifestPtr update_manifest;
    std::string error;
  };

  ParseUpdateManifestFromUrlResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kUpdateManifest)>,
      UpdateManifestPtr value);
  ParseUpdateManifestFromUrlResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  UpdateInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateInfo, T>::value>;
  using DataView = UpdateInfoDataView;
  using Data_ = internal::UpdateInfo_Data;

  template <typename... Args>
  static UpdateInfoPtr New(Args&&... args) {
    return UpdateInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateInfoPtr From(const U& u) {
    return mojo::TypeConverter<UpdateInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateInfo>::Convert(*this);
  }


  UpdateInfo();

  UpdateInfo(
      const ::GURL& update_manifest_url,
      const std::string& update_channel,
      const std::optional<std::string>& pinned_version,
      bool allow_downgrades);


  ~UpdateInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateInfoPtr>
  UpdateInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateInfo_UnserializedMessageContext<
            UserType, UpdateInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UpdateInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UpdateInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateInfo_UnserializedMessageContext<
            UserType, UpdateInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL update_manifest_url;
  
  std::string update_channel;
  
  std::optional<std::string> pinned_version;
  
  bool allow_downgrades;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  IwaDevModeAppInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IwaDevModeAppInfo, T>::value>;
  using DataView = IwaDevModeAppInfoDataView;
  using Data_ = internal::IwaDevModeAppInfo_Data;

  template <typename... Args>
  static IwaDevModeAppInfoPtr New(Args&&... args) {
    return IwaDevModeAppInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IwaDevModeAppInfoPtr From(const U& u) {
    return mojo::TypeConverter<IwaDevModeAppInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IwaDevModeAppInfo>::Convert(*this);
  }


  IwaDevModeAppInfo();

  IwaDevModeAppInfo(
      const std::string& app_id,
      const std::string& web_bundle_id,
      const std::string& name,
      IwaDevModeLocationPtr location,
      const std::string& installed_version,
      UpdateInfoPtr update_info);

IwaDevModeAppInfo(const IwaDevModeAppInfo&) = delete;
IwaDevModeAppInfo& operator=(const IwaDevModeAppInfo&) = delete;

  ~IwaDevModeAppInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IwaDevModeAppInfoPtr>
  IwaDevModeAppInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IwaDevModeAppInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IwaDevModeAppInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IwaDevModeAppInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IwaDevModeAppInfo_UnserializedMessageContext<
            UserType, IwaDevModeAppInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IwaDevModeAppInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IwaDevModeAppInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IwaDevModeAppInfo_UnserializedMessageContext<
            UserType, IwaDevModeAppInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IwaDevModeAppInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string app_id;
  
  std::string web_bundle_id;
  
  std::string name;
  
  IwaDevModeLocationPtr location;
  
  std::string installed_version;
  
  UpdateInfoPtr update_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IwaDevModeAppInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VersionEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VersionEntry, T>::value>;
  using DataView = VersionEntryDataView;
  using Data_ = internal::VersionEntry_Data;

  template <typename... Args>
  static VersionEntryPtr New(Args&&... args) {
    return VersionEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VersionEntryPtr From(const U& u) {
    return mojo::TypeConverter<VersionEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VersionEntry>::Convert(*this);
  }


  VersionEntry();

  VersionEntry(
      const std::string& version,
      const ::GURL& web_bundle_url);


  ~VersionEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VersionEntryPtr>
  VersionEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VersionEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VersionEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VersionEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VersionEntry_UnserializedMessageContext<
            UserType, VersionEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VersionEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VersionEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VersionEntry_UnserializedMessageContext<
            UserType, VersionEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VersionEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string version;
  
  ::GURL web_bundle_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VersionEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UpdateManifest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateManifest, T>::value>;
  using DataView = UpdateManifestDataView;
  using Data_ = internal::UpdateManifest_Data;

  template <typename... Args>
  static UpdateManifestPtr New(Args&&... args) {
    return UpdateManifestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateManifestPtr From(const U& u) {
    return mojo::TypeConverter<UpdateManifestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateManifest>::Convert(*this);
  }


  UpdateManifest();

  explicit UpdateManifest(
      std::vector<VersionEntryPtr> versions);

UpdateManifest(const UpdateManifest&) = delete;
UpdateManifest& operator=(const UpdateManifest&) = delete;

  ~UpdateManifest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateManifestPtr>
  UpdateManifestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateManifest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateManifest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateManifest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateManifest_UnserializedMessageContext<
            UserType, UpdateManifest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UpdateManifest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UpdateManifest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateManifest_UnserializedMessageContext<
            UserType, UpdateManifest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateManifest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<VersionEntryPtr> versions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateManifest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InstallFromBundleUrlParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InstallFromBundleUrlParams, T>::value>;
  using DataView = InstallFromBundleUrlParamsDataView;
  using Data_ = internal::InstallFromBundleUrlParams_Data;

  template <typename... Args>
  static InstallFromBundleUrlParamsPtr New(Args&&... args) {
    return InstallFromBundleUrlParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InstallFromBundleUrlParamsPtr From(const U& u) {
    return mojo::TypeConverter<InstallFromBundleUrlParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InstallFromBundleUrlParams>::Convert(*this);
  }


  InstallFromBundleUrlParams();

  InstallFromBundleUrlParams(
      const ::GURL& web_bundle_url,
      UpdateInfoPtr update_info);

InstallFromBundleUrlParams(const InstallFromBundleUrlParams&) = delete;
InstallFromBundleUrlParams& operator=(const InstallFromBundleUrlParams&) = delete;

  ~InstallFromBundleUrlParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InstallFromBundleUrlParamsPtr>
  InstallFromBundleUrlParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstallFromBundleUrlParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstallFromBundleUrlParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InstallFromBundleUrlParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InstallFromBundleUrlParams_UnserializedMessageContext<
            UserType, InstallFromBundleUrlParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InstallFromBundleUrlParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InstallFromBundleUrlParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InstallFromBundleUrlParams_UnserializedMessageContext<
            UserType, InstallFromBundleUrlParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InstallFromBundleUrlParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL web_bundle_url;
  
  UpdateInfoPtr update_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
InstallIsolatedWebAppResultPtr InstallIsolatedWebAppResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, InstallIsolatedWebAppResult>::value>::type*>
bool InstallIsolatedWebAppResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
IwaDevModeLocationPtr IwaDevModeLocation::Clone() const {
  switch (tag_) {
    case Tag::kProxyOrigin:
      return NewProxyOrigin(
          mojo::Clone(data_.proxy_origin));
    case Tag::kBundlePath:
      return NewBundlePath(
          mojo::Clone(data_.bundle_path));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IwaDevModeLocation>::value>::type*>
bool IwaDevModeLocation::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kProxyOrigin:
      return mojo::Equals(data_.proxy_origin, other.data_.proxy_origin);
    case Tag::kBundlePath:
      return mojo::Equals(data_.bundle_path, other.data_.bundle_path);
  }

  return false;
}
template <typename UnionPtrType>
ParseUpdateManifestFromUrlResultPtr ParseUpdateManifestFromUrlResult::Clone() const {
  switch (tag_) {
    case Tag::kUpdateManifest:
      return NewUpdateManifest(
          mojo::Clone(data_.update_manifest));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ParseUpdateManifestFromUrlResult>::value>::type*>
bool ParseUpdateManifestFromUrlResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kUpdateManifest:
      return mojo::Equals(data_.update_manifest, other.data_.update_manifest);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
InstallIsolatedWebAppSuccessPtr InstallIsolatedWebAppSuccess::Clone() const {
  return New(
      mojo::Clone(web_bundle_id)
  );
}

template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>*>
bool InstallIsolatedWebAppSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_bundle_id, other_struct.web_bundle_id))
    return false;
  return true;
}

template <typename T, InstallIsolatedWebAppSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_bundle_id < rhs.web_bundle_id)
    return true;
  if (rhs.web_bundle_id < lhs.web_bundle_id)
    return false;
  return false;
}
template <typename StructPtrType>
UpdateInfoPtr UpdateInfo::Clone() const {
  return New(
      mojo::Clone(update_manifest_url),
      mojo::Clone(update_channel),
      mojo::Clone(pinned_version),
      mojo::Clone(allow_downgrades)
  );
}

template <typename T, UpdateInfo::EnableIfSame<T>*>
bool UpdateInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->update_manifest_url, other_struct.update_manifest_url))
    return false;
  if (!mojo::Equals(this->update_channel, other_struct.update_channel))
    return false;
  if (!mojo::Equals(this->pinned_version, other_struct.pinned_version))
    return false;
  if (!mojo::Equals(this->allow_downgrades, other_struct.allow_downgrades))
    return false;
  return true;
}

template <typename T, UpdateInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.update_manifest_url < rhs.update_manifest_url)
    return true;
  if (rhs.update_manifest_url < lhs.update_manifest_url)
    return false;
  if (lhs.update_channel < rhs.update_channel)
    return true;
  if (rhs.update_channel < lhs.update_channel)
    return false;
  if (lhs.pinned_version < rhs.pinned_version)
    return true;
  if (rhs.pinned_version < lhs.pinned_version)
    return false;
  if (lhs.allow_downgrades < rhs.allow_downgrades)
    return true;
  if (rhs.allow_downgrades < lhs.allow_downgrades)
    return false;
  return false;
}
template <typename StructPtrType>
IwaDevModeAppInfoPtr IwaDevModeAppInfo::Clone() const {
  return New(
      mojo::Clone(app_id),
      mojo::Clone(web_bundle_id),
      mojo::Clone(name),
      mojo::Clone(location),
      mojo::Clone(installed_version),
      mojo::Clone(update_info)
  );
}

template <typename T, IwaDevModeAppInfo::EnableIfSame<T>*>
bool IwaDevModeAppInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->app_id, other_struct.app_id))
    return false;
  if (!mojo::Equals(this->web_bundle_id, other_struct.web_bundle_id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->installed_version, other_struct.installed_version))
    return false;
  if (!mojo::Equals(this->update_info, other_struct.update_info))
    return false;
  return true;
}

template <typename T, IwaDevModeAppInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.app_id < rhs.app_id)
    return true;
  if (rhs.app_id < lhs.app_id)
    return false;
  if (lhs.web_bundle_id < rhs.web_bundle_id)
    return true;
  if (rhs.web_bundle_id < lhs.web_bundle_id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.installed_version < rhs.installed_version)
    return true;
  if (rhs.installed_version < lhs.installed_version)
    return false;
  if (lhs.update_info < rhs.update_info)
    return true;
  if (rhs.update_info < lhs.update_info)
    return false;
  return false;
}
template <typename StructPtrType>
VersionEntryPtr VersionEntry::Clone() const {
  return New(
      mojo::Clone(version),
      mojo::Clone(web_bundle_url)
  );
}

template <typename T, VersionEntry::EnableIfSame<T>*>
bool VersionEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->web_bundle_url, other_struct.web_bundle_url))
    return false;
  return true;
}

template <typename T, VersionEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.web_bundle_url < rhs.web_bundle_url)
    return true;
  if (rhs.web_bundle_url < lhs.web_bundle_url)
    return false;
  return false;
}
template <typename StructPtrType>
UpdateManifestPtr UpdateManifest::Clone() const {
  return New(
      mojo::Clone(versions)
  );
}

template <typename T, UpdateManifest::EnableIfSame<T>*>
bool UpdateManifest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->versions, other_struct.versions))
    return false;
  return true;
}

template <typename T, UpdateManifest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.versions < rhs.versions)
    return true;
  if (rhs.versions < lhs.versions)
    return false;
  return false;
}
template <typename StructPtrType>
InstallFromBundleUrlParamsPtr InstallFromBundleUrlParams::Clone() const {
  return New(
      mojo::Clone(web_bundle_url),
      mojo::Clone(update_info)
  );
}

template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>*>
bool InstallFromBundleUrlParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_bundle_url, other_struct.web_bundle_url))
    return false;
  if (!mojo::Equals(this->update_info, other_struct.update_info))
    return false;
  return true;
}

template <typename T, InstallFromBundleUrlParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_bundle_url < rhs.web_bundle_url)
    return true;
  if (rhs.web_bundle_url < lhs.web_bundle_url)
    return false;
  if (lhs.update_info < rhs.update_info)
    return true;
  if (rhs.update_info < lhs.update_info)
    return false;
  return false;
}


}  // mojom

namespace mojo {


template <>
struct  StructTraits<::mojom::InstallIsolatedWebAppSuccess::DataView,
                                         ::mojom::InstallIsolatedWebAppSuccessPtr> {
  static bool IsNull(const ::mojom::InstallIsolatedWebAppSuccessPtr& input) { return !input; }
  static void SetToNull(::mojom::InstallIsolatedWebAppSuccessPtr* output) { output->reset(); }

  static const decltype(::mojom::InstallIsolatedWebAppSuccess::web_bundle_id)& web_bundle_id(
      const ::mojom::InstallIsolatedWebAppSuccessPtr& input) {
    return input->web_bundle_id;
  }

  static bool Read(::mojom::InstallIsolatedWebAppSuccess::DataView input, ::mojom::InstallIsolatedWebAppSuccessPtr* output);
};


template <>
struct  StructTraits<::mojom::UpdateInfo::DataView,
                                         ::mojom::UpdateInfoPtr> {
  static bool IsNull(const ::mojom::UpdateInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::UpdateInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::UpdateInfo::update_manifest_url)& update_manifest_url(
      const ::mojom::UpdateInfoPtr& input) {
    return input->update_manifest_url;
  }

  static const decltype(::mojom::UpdateInfo::update_channel)& update_channel(
      const ::mojom::UpdateInfoPtr& input) {
    return input->update_channel;
  }

  static const decltype(::mojom::UpdateInfo::pinned_version)& pinned_version(
      const ::mojom::UpdateInfoPtr& input) {
    return input->pinned_version;
  }

  static decltype(::mojom::UpdateInfo::allow_downgrades) allow_downgrades(
      const ::mojom::UpdateInfoPtr& input) {
    return input->allow_downgrades;
  }

  static bool Read(::mojom::UpdateInfo::DataView input, ::mojom::UpdateInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::IwaDevModeAppInfo::DataView,
                                         ::mojom::IwaDevModeAppInfoPtr> {
  static bool IsNull(const ::mojom::IwaDevModeAppInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::IwaDevModeAppInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::IwaDevModeAppInfo::app_id)& app_id(
      const ::mojom::IwaDevModeAppInfoPtr& input) {
    return input->app_id;
  }

  static const decltype(::mojom::IwaDevModeAppInfo::web_bundle_id)& web_bundle_id(
      const ::mojom::IwaDevModeAppInfoPtr& input) {
    return input->web_bundle_id;
  }

  static const decltype(::mojom::IwaDevModeAppInfo::name)& name(
      const ::mojom::IwaDevModeAppInfoPtr& input) {
    return input->name;
  }

  static const decltype(::mojom::IwaDevModeAppInfo::location)& location(
      const ::mojom::IwaDevModeAppInfoPtr& input) {
    return input->location;
  }

  static const decltype(::mojom::IwaDevModeAppInfo::installed_version)& installed_version(
      const ::mojom::IwaDevModeAppInfoPtr& input) {
    return input->installed_version;
  }

  static const decltype(::mojom::IwaDevModeAppInfo::update_info)& update_info(
      const ::mojom::IwaDevModeAppInfoPtr& input) {
    return input->update_info;
  }

  static bool Read(::mojom::IwaDevModeAppInfo::DataView input, ::mojom::IwaDevModeAppInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::VersionEntry::DataView,
                                         ::mojom::VersionEntryPtr> {
  static bool IsNull(const ::mojom::VersionEntryPtr& input) { return !input; }
  static void SetToNull(::mojom::VersionEntryPtr* output) { output->reset(); }

  static const decltype(::mojom::VersionEntry::version)& version(
      const ::mojom::VersionEntryPtr& input) {
    return input->version;
  }

  static const decltype(::mojom::VersionEntry::web_bundle_url)& web_bundle_url(
      const ::mojom::VersionEntryPtr& input) {
    return input->web_bundle_url;
  }

  static bool Read(::mojom::VersionEntry::DataView input, ::mojom::VersionEntryPtr* output);
};


template <>
struct  StructTraits<::mojom::UpdateManifest::DataView,
                                         ::mojom::UpdateManifestPtr> {
  static bool IsNull(const ::mojom::UpdateManifestPtr& input) { return !input; }
  static void SetToNull(::mojom::UpdateManifestPtr* output) { output->reset(); }

  static const decltype(::mojom::UpdateManifest::versions)& versions(
      const ::mojom::UpdateManifestPtr& input) {
    return input->versions;
  }

  static bool Read(::mojom::UpdateManifest::DataView input, ::mojom::UpdateManifestPtr* output);
};


template <>
struct  StructTraits<::mojom::InstallFromBundleUrlParams::DataView,
                                         ::mojom::InstallFromBundleUrlParamsPtr> {
  static bool IsNull(const ::mojom::InstallFromBundleUrlParamsPtr& input) { return !input; }
  static void SetToNull(::mojom::InstallFromBundleUrlParamsPtr* output) { output->reset(); }

  static const decltype(::mojom::InstallFromBundleUrlParams::web_bundle_url)& web_bundle_url(
      const ::mojom::InstallFromBundleUrlParamsPtr& input) {
    return input->web_bundle_url;
  }

  static const decltype(::mojom::InstallFromBundleUrlParams::update_info)& update_info(
      const ::mojom::InstallFromBundleUrlParamsPtr& input) {
    return input->update_info;
  }

  static bool Read(::mojom::InstallFromBundleUrlParams::DataView input, ::mojom::InstallFromBundleUrlParamsPtr* output);
};


template <>
struct  UnionTraits<::mojom::InstallIsolatedWebAppResult::DataView,
                                        ::mojom::InstallIsolatedWebAppResultPtr> {
  static bool IsNull(const ::mojom::InstallIsolatedWebAppResultPtr& input) { return !input; }
  static void SetToNull(::mojom::InstallIsolatedWebAppResultPtr* output) { output->reset(); }

  static ::mojom::InstallIsolatedWebAppResult::Tag GetTag(const ::mojom::InstallIsolatedWebAppResultPtr& input) {
    return input->which();
  }

  static const ::mojom::InstallIsolatedWebAppSuccessPtr& success(const ::mojom::InstallIsolatedWebAppResultPtr& input) {
    return input->get_success();
  }

  static const std::string& error(const ::mojom::InstallIsolatedWebAppResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::mojom::InstallIsolatedWebAppResult::DataView input, ::mojom::InstallIsolatedWebAppResultPtr* output);
};


template <>
struct  UnionTraits<::mojom::IwaDevModeLocation::DataView,
                                        ::mojom::IwaDevModeLocationPtr> {
  static bool IsNull(const ::mojom::IwaDevModeLocationPtr& input) { return !input; }
  static void SetToNull(::mojom::IwaDevModeLocationPtr* output) { output->reset(); }

  static ::mojom::IwaDevModeLocation::Tag GetTag(const ::mojom::IwaDevModeLocationPtr& input) {
    return input->which();
  }

  static const ::url::Origin& proxy_origin(const ::mojom::IwaDevModeLocationPtr& input) {
    return input->get_proxy_origin();
  }

  static const ::base::FilePath& bundle_path(const ::mojom::IwaDevModeLocationPtr& input) {
    return input->get_bundle_path();
  }

  static bool Read(::mojom::IwaDevModeLocation::DataView input, ::mojom::IwaDevModeLocationPtr* output);
};


template <>
struct  UnionTraits<::mojom::ParseUpdateManifestFromUrlResult::DataView,
                                        ::mojom::ParseUpdateManifestFromUrlResultPtr> {
  static bool IsNull(const ::mojom::ParseUpdateManifestFromUrlResultPtr& input) { return !input; }
  static void SetToNull(::mojom::ParseUpdateManifestFromUrlResultPtr* output) { output->reset(); }

  static ::mojom::ParseUpdateManifestFromUrlResult::Tag GetTag(const ::mojom::ParseUpdateManifestFromUrlResultPtr& input) {
    return input->which();
  }

  static const ::mojom::UpdateManifestPtr& update_manifest(const ::mojom::ParseUpdateManifestFromUrlResultPtr& input) {
    return input->get_update_manifest();
  }

  static const std::string& error(const ::mojom::ParseUpdateManifestFromUrlResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::mojom::ParseUpdateManifestFromUrlResult::DataView input, ::mojom::ParseUpdateManifestFromUrlResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_H_