// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  FilePathSpec as mojoBase_mojom_FilePathSpec,
  FilePath as mojoBase_mojom_FilePath
} from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import {
  OriginSpec as url_mojom_OriginSpec,
  Origin as url_mojom_Origin
} from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type WebAppInternalsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<WebAppInternalsHandlerPendingReceiver>;

export class WebAppInternalsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<WebAppInternalsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<WebAppInternalsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|WebAppInternalsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'mojom.WebAppInternalsHandler',
        scope);
  }
}

export interface WebAppInternalsHandlerInterface {
  getDebugInfoAsJsonString(): Promise<{
        result: string, }>;
  installIsolatedWebAppFromDevProxy(url: url_mojom_Url): Promise<{
        result: InstallIsolatedWebAppResult, }>;
  selectFileAndInstallIsolatedWebAppFromDevBundle(): Promise<{
        result: InstallIsolatedWebAppResult, }>;
  parseUpdateManifestFromUrl(updateManifestUrl: url_mojom_Url): Promise<{
        result: ParseUpdateManifestFromUrlResult, }>;
  installIsolatedWebAppFromBundleUrl(params: InstallFromBundleUrlParams): Promise<{
        result: InstallIsolatedWebAppResult, }>;
  updateDevProxyIsolatedWebApp(appId: string): Promise<{
        result: string, }>;
  selectFileAndUpdateIsolatedWebAppFromDevBundle(appId: string): Promise<{
        result: string, }>;
  updateManifestInstalledIsolatedWebApp(appId: string): Promise<{
        result: string, }>;
  deleteIsolatedWebApp(appId: string): Promise<{
        success: boolean, }>;
  setUpdateChannelForIsolatedWebApp(appId: string, updateChannel: string): Promise<{
        success: boolean, }>;
  setPinnedVersionForIsolatedWebApp(appId: string, pinnedVersion: string): Promise<{
        success: boolean, }>;
  resetPinnedVersionForIsolatedWebApp(appId: string): void;
  setAllowDowngradesForIsolatedWebApp(allowDowngrades: boolean, appId: string): void;
  searchForIsolatedWebAppUpdates(): Promise<{
        result: string, }>;
  getIsolatedWebAppDevModeAppInfo(): Promise<{
        apps: IwaDevModeAppInfo[], }>;
  rotateKey(webBundleId: string, rotatedKey: (number[] | null)): void;
}

export class WebAppInternalsHandlerRemote implements WebAppInternalsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<WebAppInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WebAppInternalsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|WebAppInternalsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebAppInternalsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getDebugInfoAsJsonString(): Promise<{
        result: string, }> {
    return this.proxy.sendMessage(
        0,
        WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$,
        WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  installIsolatedWebAppFromDevProxy(
      url: url_mojom_Url): Promise<{
        result: InstallIsolatedWebAppResult, }> {
    return this.proxy.sendMessage(
        1,
        WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$,
        WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  selectFileAndInstallIsolatedWebAppFromDevBundle(): Promise<{
        result: InstallIsolatedWebAppResult, }> {
    return this.proxy.sendMessage(
        2,
        WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$,
        WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  parseUpdateManifestFromUrl(
      updateManifestUrl: url_mojom_Url): Promise<{
        result: ParseUpdateManifestFromUrlResult, }> {
    return this.proxy.sendMessage(
        3,
        WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$,
        WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$,
        [
          updateManifestUrl
        ],
        false);
  }

  installIsolatedWebAppFromBundleUrl(
      params: InstallFromBundleUrlParams): Promise<{
        result: InstallIsolatedWebAppResult, }> {
    return this.proxy.sendMessage(
        4,
        WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$,
        WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  updateDevProxyIsolatedWebApp(
      appId: string): Promise<{
        result: string, }> {
    return this.proxy.sendMessage(
        5,
        WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  selectFileAndUpdateIsolatedWebAppFromDevBundle(
      appId: string): Promise<{
        result: string, }> {
    return this.proxy.sendMessage(
        6,
        WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$,
        WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  updateManifestInstalledIsolatedWebApp(
      appId: string): Promise<{
        result: string, }> {
    return this.proxy.sendMessage(
        7,
        WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  deleteIsolatedWebApp(
      appId: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        8,
        WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  setUpdateChannelForIsolatedWebApp(
      appId: string,
      updateChannel: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        9,
        WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$,
        [
          appId,
          updateChannel
        ],
        false);
  }

  setPinnedVersionForIsolatedWebApp(
      appId: string,
      pinnedVersion: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        10,
        WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$,
        [
          appId,
          pinnedVersion
        ],
        false);
  }

  resetPinnedVersionForIsolatedWebApp(
      appId: string): void {
    this.proxy.sendMessage(
        11,
        WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  setAllowDowngradesForIsolatedWebApp(
      allowDowngrades: boolean,
      appId: string): void {
    this.proxy.sendMessage(
        12,
        WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$,
        null,
        [
          allowDowngrades,
          appId
        ],
        false);
  }

  searchForIsolatedWebAppUpdates(): Promise<{
        result: string, }> {
    return this.proxy.sendMessage(
        13,
        WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$,
        WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getIsolatedWebAppDevModeAppInfo(): Promise<{
        apps: IwaDevModeAppInfo[], }> {
    return this.proxy.sendMessage(
        14,
        WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$,
        WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  rotateKey(
      webBundleId: string,
      rotatedKey: (number[] | null)): void {
    this.proxy.sendMessage(
        15,
        WebAppInternalsHandler_RotateKey_ParamsSpec.$,
        null,
        [
          webBundleId,
          rotatedKey
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebAppInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebAppInternalsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WebAppInternalsHandlerRemote, WebAppInternalsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WebAppInternalsHandlerRemote, WebAppInternalsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: WebAppInternalsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebAppInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$,
        WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$,
        impl.getDebugInfoAsJsonString.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$,
        WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$,
        impl.installIsolatedWebAppFromDevProxy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$,
        WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
        impl.selectFileAndInstallIsolatedWebAppFromDevBundle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$,
        WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$,
        impl.parseUpdateManifestFromUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$,
        WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$,
        impl.installIsolatedWebAppFromBundleUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$,
        impl.updateDevProxyIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$,
        WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
        impl.selectFileAndUpdateIsolatedWebAppFromDevBundle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$,
        impl.updateManifestInstalledIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsSpec.$,
        impl.deleteIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$,
        impl.setUpdateChannelForIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$,
        impl.setPinnedVersionForIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
        null,
        impl.resetPinnedVersionForIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$,
        null,
        impl.setAllowDowngradesForIsolatedWebApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$,
        WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$,
        impl.searchForIsolatedWebAppUpdates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$,
        WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$,
        impl.getIsolatedWebAppDevModeAppInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        WebAppInternalsHandler_RotateKey_ParamsSpec.$,
        null,
        impl.rotateKey.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebAppInternalsHandler {
  static get $interfaceName(): string {
    return "mojom.WebAppInternalsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): WebAppInternalsHandlerRemote {
    let remote = new WebAppInternalsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the WebAppInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebAppInternalsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WebAppInternalsHandlerRemote, WebAppInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WebAppInternalsHandlerRemote, WebAppInternalsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getDebugInfoAsJsonString: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  installIsolatedWebAppFromDevProxy: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  selectFileAndInstallIsolatedWebAppFromDevBundle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  parseUpdateManifestFromUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  installIsolatedWebAppFromBundleUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateDevProxyIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  selectFileAndUpdateIsolatedWebAppFromDevBundle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateManifestInstalledIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUpdateChannelForIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPinnedVersionForIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resetPinnedVersionForIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAllowDowngradesForIsolatedWebApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  searchForIsolatedWebAppUpdates: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getIsolatedWebAppDevModeAppInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  rotateKey: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebAppInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getDebugInfoAsJsonString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$,
        WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$,
        this.getDebugInfoAsJsonString.createReceiverHandler(true /* expectsResponse */),
        false);
    this.installIsolatedWebAppFromDevProxy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$,
        WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$,
        this.installIsolatedWebAppFromDevProxy.createReceiverHandler(true /* expectsResponse */),
        false);
    this.selectFileAndInstallIsolatedWebAppFromDevBundle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$,
        WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
        this.selectFileAndInstallIsolatedWebAppFromDevBundle.createReceiverHandler(true /* expectsResponse */),
        false);
    this.parseUpdateManifestFromUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$,
        WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$,
        this.parseUpdateManifestFromUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.installIsolatedWebAppFromBundleUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$,
        WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$,
        this.installIsolatedWebAppFromBundleUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updateDevProxyIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$,
        this.updateDevProxyIsolatedWebApp.createReceiverHandler(true /* expectsResponse */),
        false);
    this.selectFileAndUpdateIsolatedWebAppFromDevBundle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$,
        WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
        this.selectFileAndUpdateIsolatedWebAppFromDevBundle.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updateManifestInstalledIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$,
        this.updateManifestInstalledIsolatedWebApp.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsSpec.$,
        this.deleteIsolatedWebApp.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setUpdateChannelForIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$,
        this.setUpdateChannelForIsolatedWebApp.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setPinnedVersionForIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
        WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$,
        this.setPinnedVersionForIsolatedWebApp.createReceiverHandler(true /* expectsResponse */),
        false);
    this.resetPinnedVersionForIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
        null,
        this.resetPinnedVersionForIsolatedWebApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setAllowDowngradesForIsolatedWebApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$,
        null,
        this.setAllowDowngradesForIsolatedWebApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.searchForIsolatedWebAppUpdates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$,
        WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$,
        this.searchForIsolatedWebAppUpdates.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getIsolatedWebAppDevModeAppInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$,
        WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$,
        this.getIsolatedWebAppDevModeAppInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.rotateKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        WebAppInternalsHandler_RotateKey_ParamsSpec.$,
        null,
        this.rotateKey.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const InstallIsolatedWebAppSuccessSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UpdateInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IwaDevModeAppInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const VersionEntrySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UpdateManifestSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InstallFromBundleUrlParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebAppInternalsHandler_RotateKey_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InstallIsolatedWebAppResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const IwaDevModeLocationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ParseUpdateManifestFromUrlResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface InstallIsolatedWebAppSuccessMojoType {
  webBundleId: string;
}


export type InstallIsolatedWebAppSuccess = InstallIsolatedWebAppSuccessMojoType;
mojo.internal.Struct<InstallIsolatedWebAppSuccessMojoType>(
    InstallIsolatedWebAppSuccessSpec.$,
    'InstallIsolatedWebAppSuccess',
    [
      mojo.internal.StructField<InstallIsolatedWebAppSuccessMojoType, string>(
        'webBundleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UpdateInfoMojoType {
  updateManifestUrl: url_mojom_Url;
  updateChannel: string;
  pinnedVersion: (string | null);
  allowDowngrades: boolean;
}


export type UpdateInfo = UpdateInfoMojoType;
mojo.internal.Struct<UpdateInfoMojoType>(
    UpdateInfoSpec.$,
    'UpdateInfo',
    [
      mojo.internal.StructField<UpdateInfoMojoType, url_mojom_Url>(
        'updateManifestUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UpdateInfoMojoType, string>(
        'updateChannel', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UpdateInfoMojoType, string>(
        'pinnedVersion', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UpdateInfoMojoType, boolean>(
        'allowDowngrades', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface IwaDevModeAppInfoMojoType {
  appId: string;
  webBundleId: string;
  name: string;
  location: IwaDevModeLocation;
  installedVersion: string;
  updateInfo: (UpdateInfo | null);
}


export type IwaDevModeAppInfo = IwaDevModeAppInfoMojoType;
mojo.internal.Struct<IwaDevModeAppInfoMojoType>(
    IwaDevModeAppInfoSpec.$,
    'IwaDevModeAppInfo',
    [
      mojo.internal.StructField<IwaDevModeAppInfoMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IwaDevModeAppInfoMojoType, string>(
        'webBundleId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IwaDevModeAppInfoMojoType, string>(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IwaDevModeAppInfoMojoType, IwaDevModeLocation>(
        'location', 24,
        0,
        IwaDevModeLocationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IwaDevModeAppInfoMojoType, string>(
        'installedVersion', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<IwaDevModeAppInfoMojoType, UpdateInfo>(
        'updateInfo', 48,
        0,
        UpdateInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface VersionEntryMojoType {
  version: string;
  webBundleUrl: url_mojom_Url;
}


export type VersionEntry = VersionEntryMojoType;
mojo.internal.Struct<VersionEntryMojoType>(
    VersionEntrySpec.$,
    'VersionEntry',
    [
      mojo.internal.StructField<VersionEntryMojoType, string>(
        'version', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<VersionEntryMojoType, url_mojom_Url>(
        'webBundleUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UpdateManifestMojoType {
  versions: VersionEntry[];
}


export type UpdateManifest = UpdateManifestMojoType;
mojo.internal.Struct<UpdateManifestMojoType>(
    UpdateManifestSpec.$,
    'UpdateManifest',
    [
      mojo.internal.StructField<UpdateManifestMojoType, VersionEntry[]>(
        'versions', 0,
        0,
        mojo.internal.Array(VersionEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface InstallFromBundleUrlParamsMojoType {
  webBundleUrl: url_mojom_Url;
  updateInfo: UpdateInfo;
}


export type InstallFromBundleUrlParams = InstallFromBundleUrlParamsMojoType;
mojo.internal.Struct<InstallFromBundleUrlParamsMojoType>(
    InstallFromBundleUrlParamsSpec.$,
    'InstallFromBundleUrlParams',
    [
      mojo.internal.StructField<InstallFromBundleUrlParamsMojoType, url_mojom_Url>(
        'webBundleUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InstallFromBundleUrlParamsMojoType, UpdateInfo>(
        'updateInfo', 8,
        0,
        UpdateInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsMojoType {
}


export type WebAppInternalsHandler_GetDebugInfoAsJsonString_Params = WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsMojoType>(
    WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$,
    'WebAppInternalsHandler_GetDebugInfoAsJsonString_Params',
    [
    ],
    [[0, 8],]);





export interface WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsMojoType {
  result: string;
}


export type WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams = WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsMojoType>(
    WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$,
    'WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsMojoType {
  url: url_mojom_Url;
}


export type WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params = WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsMojoType>(
    WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$,
    'WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsMojoType {
  result: InstallIsolatedWebAppResult;
}


export type WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams = WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsMojoType>(
    WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$,
    'WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsMojoType, InstallIsolatedWebAppResult>(
        'result', 0,
        0,
        InstallIsolatedWebAppResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsMojoType {
}


export type WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params = WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsMojoType>(
    WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$,
    'WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params',
    [
    ],
    [[0, 8],]);





export interface WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsMojoType {
  result: InstallIsolatedWebAppResult;
}


export type WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams = WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsMojoType>(
    WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
    'WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsMojoType, InstallIsolatedWebAppResult>(
        'result', 0,
        0,
        InstallIsolatedWebAppResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsMojoType {
  updateManifestUrl: url_mojom_Url;
}


export type WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params = WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsMojoType>(
    WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$,
    'WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsMojoType, url_mojom_Url>(
        'updateManifestUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsMojoType {
  result: ParseUpdateManifestFromUrlResult;
}


export type WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams = WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsMojoType>(
    WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$,
    'WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsMojoType, ParseUpdateManifestFromUrlResult>(
        'result', 0,
        0,
        ParseUpdateManifestFromUrlResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsMojoType {
  params: InstallFromBundleUrlParams;
}


export type WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params = WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsMojoType>(
    WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$,
    'WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsMojoType, InstallFromBundleUrlParams>(
        'params', 0,
        0,
        InstallFromBundleUrlParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsMojoType {
  result: InstallIsolatedWebAppResult;
}


export type WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams = WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsMojoType>(
    WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$,
    'WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsMojoType, InstallIsolatedWebAppResult>(
        'result', 0,
        0,
        InstallIsolatedWebAppResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsMojoType {
  appId: string;
}


export type WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params = WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsMojoType {
  result: string;
}


export type WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams = WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsMojoType>(
    WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$,
    'WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsMojoType {
  appId: string;
}


export type WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params = WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsMojoType>(
    WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$,
    'WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsMojoType {
  result: string;
}


export type WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams = WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsMojoType>(
    WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$,
    'WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsMojoType {
  appId: string;
}


export type WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params = WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsMojoType {
  result: string;
}


export type WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams = WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsMojoType>(
    WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$,
    'WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsMojoType {
  appId: string;
}


export type WebAppInternalsHandler_DeleteIsolatedWebApp_Params = WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_DeleteIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_DeleteIsolatedWebApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsMojoType {
  success: boolean;
}


export type WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParams = WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsMojoType>(
    WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsSpec.$,
    'WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_DeleteIsolatedWebApp_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsMojoType {
  appId: string;
  updateChannel: string;
}


export type WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params = WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsMojoType, string>(
        'updateChannel', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsMojoType {
  success: boolean;
}


export type WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams = WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsMojoType>(
    WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$,
    'WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsMojoType {
  appId: string;
  pinnedVersion: string;
}


export type WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params = WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsMojoType, string>(
        'pinnedVersion', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsMojoType {
  success: boolean;
}


export type WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams = WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsMojoType>(
    WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$,
    'WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsMojoType {
  appId: string;
}


export type WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params = WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsMojoType {
  allowDowngrades: boolean;
  appId: string;
}


export type WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params = WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsMojoType>(
    WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$,
    'WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsMojoType, boolean>(
        'allowDowngrades', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsMojoType, string>(
        'appId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsMojoType {
}


export type WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params = WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsMojoType>(
    WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$,
    'WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params',
    [
    ],
    [[0, 8],]);





export interface WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsMojoType {
  result: string;
}


export type WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams = WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsMojoType>(
    WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$,
    'WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsMojoType {
}


export type WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params = WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsMojoType>(
    WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$,
    'WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params',
    [
    ],
    [[0, 8],]);





export interface WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsMojoType {
  apps: IwaDevModeAppInfo[];
}


export type WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams = WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsMojoType>(
    WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$,
    'WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams',
    [
      mojo.internal.StructField<WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsMojoType, IwaDevModeAppInfo[]>(
        'apps', 0,
        0,
        mojo.internal.Array(IwaDevModeAppInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebAppInternalsHandler_RotateKey_ParamsMojoType {
  webBundleId: string;
  rotatedKey: (number[] | null);
}


export type WebAppInternalsHandler_RotateKey_Params = WebAppInternalsHandler_RotateKey_ParamsMojoType;
mojo.internal.Struct<WebAppInternalsHandler_RotateKey_ParamsMojoType>(
    WebAppInternalsHandler_RotateKey_ParamsSpec.$,
    'WebAppInternalsHandler_RotateKey_Params',
    [
      mojo.internal.StructField<WebAppInternalsHandler_RotateKey_ParamsMojoType, string>(
        'webBundleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebAppInternalsHandler_RotateKey_ParamsMojoType, number[]>(
        'rotatedKey', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



mojo.internal.Union(
    InstallIsolatedWebAppResultSpec.$, 'InstallIsolatedWebAppResult',
    {
      'success': {
        'ordinal': 0,
        'type': InstallIsolatedWebAppSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

export interface InstallIsolatedWebAppResult {
  success?: InstallIsolatedWebAppSuccess,
  error?: string,
}

export enum InstallIsolatedWebAppResultFieldTags {
  SUCCESS,
  ERROR,
}

export function whichInstallIsolatedWebAppResult(u: InstallIsolatedWebAppResult): InstallIsolatedWebAppResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return InstallIsolatedWebAppResultFieldTags.SUCCESS;
  }
  if (u.error !== null && u.error !== undefined) {
    return InstallIsolatedWebAppResultFieldTags.ERROR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    IwaDevModeLocationSpec.$, 'IwaDevModeLocation',
    {
      'proxyOrigin': {
        'ordinal': 0,
        'type': url_mojom_OriginSpec.$,
      },
      'bundlePath': {
        'ordinal': 1,
        'type': mojoBase_mojom_FilePathSpec.$,
      },
    });

export interface IwaDevModeLocation {
  proxyOrigin?: url_mojom_Origin,
  bundlePath?: mojoBase_mojom_FilePath,
}

export enum IwaDevModeLocationFieldTags {
  PROXY_ORIGIN,
  BUNDLE_PATH,
}

export function whichIwaDevModeLocation(u: IwaDevModeLocation): IwaDevModeLocationFieldTags {
  if (u.proxyOrigin !== null && u.proxyOrigin !== undefined) {
    return IwaDevModeLocationFieldTags.PROXY_ORIGIN;
  }
  if (u.bundlePath !== null && u.bundlePath !== undefined) {
    return IwaDevModeLocationFieldTags.BUNDLE_PATH;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    ParseUpdateManifestFromUrlResultSpec.$, 'ParseUpdateManifestFromUrlResult',
    {
      'updateManifest': {
        'ordinal': 0,
        'type': UpdateManifestSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

export interface ParseUpdateManifestFromUrlResult {
  updateManifest?: UpdateManifest,
  error?: string,
}

export enum ParseUpdateManifestFromUrlResultFieldTags {
  UPDATE_MANIFEST,
  ERROR,
}

export function whichParseUpdateManifestFromUrlResult(u: ParseUpdateManifestFromUrlResult): ParseUpdateManifestFromUrlResultFieldTags {
  if (u.updateManifest !== null && u.updateManifest !== undefined) {
    return ParseUpdateManifestFromUrlResultFieldTags.UPDATE_MANIFEST;
  }
  if (u.error !== null && u.error !== undefined) {
    return ParseUpdateManifestFromUrlResultFieldTags.ERROR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
