// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace mojom {
class InstallIsolatedWebAppSuccessDataView;

class UpdateInfoDataView;

class IwaDevModeAppInfoDataView;

class VersionEntryDataView;

class UpdateManifestDataView;

class InstallFromBundleUrlParamsDataView;

class InstallIsolatedWebAppResultDataView;
class IwaDevModeLocationDataView;
class ParseUpdateManifestFromUrlResultDataView;


}  // mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::InstallIsolatedWebAppSuccessDataView> {
  using Data = ::mojom::internal::InstallIsolatedWebAppSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::UpdateInfoDataView> {
  using Data = ::mojom::internal::UpdateInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::IwaDevModeAppInfoDataView> {
  using Data = ::mojom::internal::IwaDevModeAppInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::VersionEntryDataView> {
  using Data = ::mojom::internal::VersionEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::UpdateManifestDataView> {
  using Data = ::mojom::internal::UpdateManifest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::InstallFromBundleUrlParamsDataView> {
  using Data = ::mojom::internal::InstallFromBundleUrlParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::InstallIsolatedWebAppResultDataView> {
  using Data = ::mojom::internal::InstallIsolatedWebAppResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::mojom::IwaDevModeLocationDataView> {
  using Data = ::mojom::internal::IwaDevModeLocation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::mojom::ParseUpdateManifestFromUrlResultDataView> {
  using Data = ::mojom::internal::ParseUpdateManifestFromUrlResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace mojom {
// Interface base classes. They are used for type safety check.
class WebAppInternalsHandlerInterfaceBase {};

using WebAppInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<WebAppInternalsHandlerInterfaceBase>;
using WebAppInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WebAppInternalsHandlerInterfaceBase>;
using WebAppInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebAppInternalsHandlerInterfaceBase>;
using WebAppInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebAppInternalsHandlerInterfaceBase>;


class InstallIsolatedWebAppSuccessDataView {
 public:
  InstallIsolatedWebAppSuccessDataView() = default;

  InstallIsolatedWebAppSuccessDataView(
      internal::InstallIsolatedWebAppSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWebBundleIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleId(UserType* output) {
    
    auto* pointer = data_->web_bundle_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::InstallIsolatedWebAppSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UpdateInfoDataView {
 public:
  UpdateInfoDataView() = default;

  UpdateInfoDataView(
      internal::UpdateInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUpdateManifestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateManifestUrl(UserType* output) {
    
    auto* pointer = data_->update_manifest_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateChannelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateChannel(UserType* output) {
    
    auto* pointer = data_->update_channel.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPinnedVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinnedVersion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `pinned_version` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinnedVersion` instead "
    "of `ReadPinnedVersion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinned_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool allow_downgrades() const {
    return data_->allow_downgrades;
  }
 private:
  internal::UpdateInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IwaDevModeAppInfoDataView {
 public:
  IwaDevModeAppInfoDataView() = default;

  IwaDevModeAppInfoDataView(
      internal::IwaDevModeAppInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetWebBundleIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleId(UserType* output) {
    
    auto* pointer = data_->web_bundle_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLocationDataView(
      IwaDevModeLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = !data_->location.is_null() ? &data_->location : nullptr;
    return mojo::internal::Deserialize<::mojom::IwaDevModeLocationDataView>(
        pointer, output, message_);
  }
  inline void GetInstalledVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstalledVersion(UserType* output) {
    
    auto* pointer = data_->installed_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateInfoDataView(
      UpdateInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojom::UpdateInfoDataView, UserType>(),
    "Attempting to read the optional `update_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateInfo` instead "
    "of `ReadUpdateInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_info.Get();
    return mojo::internal::Deserialize<::mojom::UpdateInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::IwaDevModeAppInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VersionEntryDataView {
 public:
  VersionEntryDataView() = default;

  VersionEntryDataView(
      internal::VersionEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetWebBundleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleUrl(UserType* output) {
    
    auto* pointer = data_->web_bundle_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::VersionEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UpdateManifestDataView {
 public:
  UpdateManifestDataView() = default;

  UpdateManifestDataView(
      internal::UpdateManifest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVersionsDataView(
      mojo::ArrayDataView<VersionEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersions(UserType* output) {
    
    auto* pointer = data_->versions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::VersionEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UpdateManifest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InstallFromBundleUrlParamsDataView {
 public:
  InstallFromBundleUrlParamsDataView() = default;

  InstallFromBundleUrlParamsDataView(
      internal::InstallFromBundleUrlParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWebBundleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleUrl(UserType* output) {
    
    auto* pointer = data_->web_bundle_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateInfoDataView(
      UpdateInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateInfo(UserType* output) {
    
    auto* pointer = data_->update_info.Get();
    return mojo::internal::Deserialize<::mojom::UpdateInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::InstallFromBundleUrlParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InstallIsolatedWebAppResultDataView {
 public:
  using Tag = internal::InstallIsolatedWebAppResult_Data::InstallIsolatedWebAppResult_Tag;

  InstallIsolatedWebAppResultDataView() = default;

  InstallIsolatedWebAppResultDataView(
      internal::InstallIsolatedWebAppResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      InstallIsolatedWebAppSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::mojom::InstallIsolatedWebAppSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::InstallIsolatedWebAppResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class IwaDevModeLocationDataView {
 public:
  using Tag = internal::IwaDevModeLocation_Data::IwaDevModeLocation_Tag;

  IwaDevModeLocationDataView() = default;

  IwaDevModeLocationDataView(
      internal::IwaDevModeLocation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_proxy_origin() const { return data_->tag == Tag::kProxyOrigin; }
  inline void GetProxyOriginDataView(
      ::url::mojom::OriginDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadProxyOrigin(UserType* output) const {
    
    CHECK(is_proxy_origin());
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        data_->data.f_proxy_origin.Get(), output, message_);
  }
  bool is_bundle_path() const { return data_->tag == Tag::kBundlePath; }
  inline void GetBundlePathDataView(
      ::mojo_base::mojom::FilePathDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBundlePath(UserType* output) const {
    
    CHECK(is_bundle_path());
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        data_->data.f_bundle_path.Get(), output, message_);
  }

 private:
  internal::IwaDevModeLocation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ParseUpdateManifestFromUrlResultDataView {
 public:
  using Tag = internal::ParseUpdateManifestFromUrlResult_Data::ParseUpdateManifestFromUrlResult_Tag;

  ParseUpdateManifestFromUrlResultDataView() = default;

  ParseUpdateManifestFromUrlResultDataView(
      internal::ParseUpdateManifestFromUrlResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_update_manifest() const { return data_->tag == Tag::kUpdateManifest; }
  inline void GetUpdateManifestDataView(
      UpdateManifestDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateManifest(UserType* output) const {
    
    CHECK(is_update_manifest());
    return mojo::internal::Deserialize<::mojom::UpdateManifestDataView>(
        data_->data.f_update_manifest.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::ParseUpdateManifestFromUrlResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // mojom

#endif  // CHROME_BROWSER_UI_WEBUI_WEB_APP_INTERNALS_WEB_APP_INTERNALS_MOJOM_DATA_VIEW_H_