// chrome/browser/ui/webui/user_education_internals/user_education_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_USER_EDUCATION_INTERNALS_USER_EDUCATION_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_USER_EDUCATION_INTERNALS_USER_EDUCATION_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/user_education_internals/user_education_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/user_education_internals/user_education_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/user_education_internals/user_education_internals.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mojom::user_education_internals {

class UserEducationInternalsPageHandlerProxy;

template <typename ImplRefTraits>
class UserEducationInternalsPageHandlerStub;

class UserEducationInternalsPageHandlerRequestValidator;
class UserEducationInternalsPageHandlerResponseValidator;


class UserEducationInternalsPageHandler
    : public UserEducationInternalsPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.user_education_internals.UserEducationInternalsPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UserEducationInternalsPageHandlerInterfaceBase;
  using Proxy_ = UserEducationInternalsPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = UserEducationInternalsPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = UserEducationInternalsPageHandlerRequestValidator;
  using ResponseValidator_ = UserEducationInternalsPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTutorialsMinVersion = 0,
    kStartTutorialMinVersion = 0,
    kGetSessionDataMinVersion = 0,
    kGetFeaturePromosMinVersion = 0,
    kShowFeaturePromoMinVersion = 0,
    kClearFeaturePromoDataMinVersion = 0,
    kClearSessionDataMinVersion = 0,
    kForceNewSessionMinVersion = 0,
    kRemoveGracePeriodsMinVersion = 0,
    kGetNewBadgesMinVersion = 0,
    kGetWhatsNewModulesMinVersion = 0,
    kGetWhatsNewEditionsMinVersion = 0,
    kGetNtpPromosMinVersion = 0,
    kGetNtpPromoPreferencesMinVersion = 0,
    kClearNewBadgeDataMinVersion = 0,
    kClearWhatsNewDataMinVersion = 0,
    kClearNtpPromoDataMinVersion = 0,
    kClearNtpPromoPreferencesMinVersion = 0,
    kLaunchWhatsNewStagingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTutorials_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartTutorial_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSessionData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFeaturePromos_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowFeaturePromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearFeaturePromoData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearSessionData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceNewSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveGracePeriods_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNewBadges_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWhatsNewModules_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWhatsNewEditions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNtpPromos_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNtpPromoPreferences_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearNewBadgeData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearWhatsNewData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearNtpPromoData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearNtpPromoPreferences_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LaunchWhatsNewStaging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UserEducationInternalsPageHandler() = default;

  using GetTutorialsCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;
  using GetTutorialsMojoCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;

  virtual void GetTutorials(GetTutorialsCallback callback) = 0;

  using StartTutorialCallback = base::OnceCallback<void(const std::string&)>;
  using StartTutorialMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void StartTutorial(const std::string& tutorial_id, StartTutorialCallback callback) = 0;

  using GetSessionDataCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageDataPtr>)>;
  using GetSessionDataMojoCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageDataPtr>)>;

  virtual void GetSessionData(GetSessionDataCallback callback) = 0;

  using GetFeaturePromosCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;
  using GetFeaturePromosMojoCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;

  virtual void GetFeaturePromos(GetFeaturePromosCallback callback) = 0;

  using ShowFeaturePromoCallback = base::OnceCallback<void(const std::string&)>;
  using ShowFeaturePromoMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ShowFeaturePromo(const std::string& feature_name, ShowFeaturePromoCallback callback) = 0;

  using ClearFeaturePromoDataCallback = base::OnceCallback<void(const std::string&)>;
  using ClearFeaturePromoDataMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ClearFeaturePromoData(const std::string& feature_name, ClearFeaturePromoDataCallback callback) = 0;

  using ClearSessionDataCallback = base::OnceCallback<void(const std::string&)>;
  using ClearSessionDataMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ClearSessionData(ClearSessionDataCallback callback) = 0;

  using ForceNewSessionCallback = base::OnceCallback<void(const std::string&)>;
  using ForceNewSessionMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ForceNewSession(ForceNewSessionCallback callback) = 0;

  using RemoveGracePeriodsCallback = base::OnceCallback<void(const std::string&)>;
  using RemoveGracePeriodsMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void RemoveGracePeriods(RemoveGracePeriodsCallback callback) = 0;

  using GetNewBadgesCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;
  using GetNewBadgesMojoCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;

  virtual void GetNewBadges(GetNewBadgesCallback callback) = 0;

  using GetWhatsNewModulesCallback = base::OnceCallback<void(std::vector<WhatsNewModuleDemoPageInfoPtr>)>;
  using GetWhatsNewModulesMojoCallback = base::OnceCallback<void(std::vector<WhatsNewModuleDemoPageInfoPtr>)>;

  virtual void GetWhatsNewModules(GetWhatsNewModulesCallback callback) = 0;

  using GetWhatsNewEditionsCallback = base::OnceCallback<void(std::vector<WhatsNewEditionDemoPageInfoPtr>)>;
  using GetWhatsNewEditionsMojoCallback = base::OnceCallback<void(std::vector<WhatsNewEditionDemoPageInfoPtr>)>;

  virtual void GetWhatsNewEditions(GetWhatsNewEditionsCallback callback) = 0;

  using GetNtpPromosCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;
  using GetNtpPromosMojoCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageInfoPtr>)>;

  virtual void GetNtpPromos(GetNtpPromosCallback callback) = 0;

  using GetNtpPromoPreferencesCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageDataPtr>)>;
  using GetNtpPromoPreferencesMojoCallback = base::OnceCallback<void(std::vector<FeaturePromoDemoPageDataPtr>)>;

  virtual void GetNtpPromoPreferences(GetNtpPromoPreferencesCallback callback) = 0;

  using ClearNewBadgeDataCallback = base::OnceCallback<void(const std::string&)>;
  using ClearNewBadgeDataMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ClearNewBadgeData(const std::string& feature_name, ClearNewBadgeDataCallback callback) = 0;

  using ClearWhatsNewDataCallback = base::OnceCallback<void(const std::string&)>;
  using ClearWhatsNewDataMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ClearWhatsNewData(ClearWhatsNewDataCallback callback) = 0;

  using ClearNtpPromoDataCallback = base::OnceCallback<void(const std::string&)>;
  using ClearNtpPromoDataMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ClearNtpPromoData(const std::string& id, ClearNtpPromoDataCallback callback) = 0;

  using ClearNtpPromoPreferencesCallback = base::OnceCallback<void(const std::string&)>;
  using ClearNtpPromoPreferencesMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ClearNtpPromoPreferences(ClearNtpPromoPreferencesCallback callback) = 0;

  virtual void LaunchWhatsNewStaging() = 0;
};



class  UserEducationInternalsPageHandlerProxy
    : public UserEducationInternalsPageHandler {
 public:
  using InterfaceType = UserEducationInternalsPageHandler;

  explicit UserEducationInternalsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTutorials(GetTutorialsCallback callback) final;
  
  void StartTutorial(const std::string& tutorial_id, StartTutorialCallback callback) final;
  
  void GetSessionData(GetSessionDataCallback callback) final;
  
  void GetFeaturePromos(GetFeaturePromosCallback callback) final;
  
  void ShowFeaturePromo(const std::string& feature_name, ShowFeaturePromoCallback callback) final;
  
  void ClearFeaturePromoData(const std::string& feature_name, ClearFeaturePromoDataCallback callback) final;
  
  void ClearSessionData(ClearSessionDataCallback callback) final;
  
  void ForceNewSession(ForceNewSessionCallback callback) final;
  
  void RemoveGracePeriods(RemoveGracePeriodsCallback callback) final;
  
  void GetNewBadges(GetNewBadgesCallback callback) final;
  
  void GetWhatsNewModules(GetWhatsNewModulesCallback callback) final;
  
  void GetWhatsNewEditions(GetWhatsNewEditionsCallback callback) final;
  
  void GetNtpPromos(GetNtpPromosCallback callback) final;
  
  void GetNtpPromoPreferences(GetNtpPromoPreferencesCallback callback) final;
  
  void ClearNewBadgeData(const std::string& feature_name, ClearNewBadgeDataCallback callback) final;
  
  void ClearWhatsNewData(ClearWhatsNewDataCallback callback) final;
  
  void ClearNtpPromoData(const std::string& id, ClearNtpPromoDataCallback callback) final;
  
  void ClearNtpPromoPreferences(ClearNtpPromoPreferencesCallback callback) final;
  
  void LaunchWhatsNewStaging() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UserEducationInternalsPageHandlerStubDispatch {
 public:
  static bool Accept(UserEducationInternalsPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UserEducationInternalsPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UserEducationInternalsPageHandler>>
class UserEducationInternalsPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UserEducationInternalsPageHandlerStub() = default;
  ~UserEducationInternalsPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UserEducationInternalsPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UserEducationInternalsPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UserEducationInternalsPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UserEducationInternalsPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  FeaturePromoDemoPageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FeaturePromoDemoPageData, T>::value>;
  using DataView = FeaturePromoDemoPageDataDataView;
  using Data_ = internal::FeaturePromoDemoPageData_Data;

  template <typename... Args>
  static FeaturePromoDemoPageDataPtr New(Args&&... args) {
    return FeaturePromoDemoPageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FeaturePromoDemoPageDataPtr From(const U& u) {
    return mojo::TypeConverter<FeaturePromoDemoPageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FeaturePromoDemoPageData>::Convert(*this);
  }


  FeaturePromoDemoPageData();

  FeaturePromoDemoPageData(
      const std::string& name,
      const std::string& value);


  ~FeaturePromoDemoPageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FeaturePromoDemoPageDataPtr>
  FeaturePromoDemoPageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeaturePromoDemoPageData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeaturePromoDemoPageData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FeaturePromoDemoPageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FeaturePromoDemoPageData_UnserializedMessageContext<
            UserType, FeaturePromoDemoPageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FeaturePromoDemoPageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FeaturePromoDemoPageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FeaturePromoDemoPageData_UnserializedMessageContext<
            UserType, FeaturePromoDemoPageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FeaturePromoDemoPageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  FeaturePromoDemoPageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FeaturePromoDemoPageInfo, T>::value>;
  using DataView = FeaturePromoDemoPageInfoDataView;
  using Data_ = internal::FeaturePromoDemoPageInfo_Data;

  template <typename... Args>
  static FeaturePromoDemoPageInfoPtr New(Args&&... args) {
    return FeaturePromoDemoPageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FeaturePromoDemoPageInfoPtr From(const U& u) {
    return mojo::TypeConverter<FeaturePromoDemoPageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FeaturePromoDemoPageInfo>::Convert(*this);
  }


  FeaturePromoDemoPageInfo();

  FeaturePromoDemoPageInfo(
      const std::string& display_title,
      const std::string& display_description,
      const std::string& internal_name,
      const std::string& type,
      int32_t added_milestone,
      std::vector<std::string> supported_platforms,
      std::vector<std::string> required_features,
      std::vector<std::string> instructions,
      const std::string& followed_by_internal_name,
      std::vector<FeaturePromoDemoPageDataPtr> data);

FeaturePromoDemoPageInfo(const FeaturePromoDemoPageInfo&) = delete;
FeaturePromoDemoPageInfo& operator=(const FeaturePromoDemoPageInfo&) = delete;

  ~FeaturePromoDemoPageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FeaturePromoDemoPageInfoPtr>
  FeaturePromoDemoPageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeaturePromoDemoPageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeaturePromoDemoPageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FeaturePromoDemoPageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FeaturePromoDemoPageInfo_UnserializedMessageContext<
            UserType, FeaturePromoDemoPageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FeaturePromoDemoPageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FeaturePromoDemoPageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FeaturePromoDemoPageInfo_UnserializedMessageContext<
            UserType, FeaturePromoDemoPageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FeaturePromoDemoPageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_title;
  
  std::string display_description;
  
  std::string internal_name;
  
  std::string type;
  
  int32_t added_milestone;
  
  std::vector<std::string> supported_platforms;
  
  std::vector<std::string> required_features;
  
  std::vector<std::string> instructions;
  
  std::string followed_by_internal_name;
  
  std::vector<FeaturePromoDemoPageDataPtr> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WhatsNewModuleDemoPageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WhatsNewModuleDemoPageInfo, T>::value>;
  using DataView = WhatsNewModuleDemoPageInfoDataView;
  using Data_ = internal::WhatsNewModuleDemoPageInfo_Data;

  template <typename... Args>
  static WhatsNewModuleDemoPageInfoPtr New(Args&&... args) {
    return WhatsNewModuleDemoPageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WhatsNewModuleDemoPageInfoPtr From(const U& u) {
    return mojo::TypeConverter<WhatsNewModuleDemoPageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WhatsNewModuleDemoPageInfo>::Convert(*this);
  }


  WhatsNewModuleDemoPageInfo();

  WhatsNewModuleDemoPageInfo(
      const std::string& display_title,
      const std::string& module_name,
      bool has_browser_command,
      bool is_feature_enabled,
      int32_t queue_position);


  ~WhatsNewModuleDemoPageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WhatsNewModuleDemoPageInfoPtr>
  WhatsNewModuleDemoPageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WhatsNewModuleDemoPageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WhatsNewModuleDemoPageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WhatsNewModuleDemoPageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WhatsNewModuleDemoPageInfo_UnserializedMessageContext<
            UserType, WhatsNewModuleDemoPageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WhatsNewModuleDemoPageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WhatsNewModuleDemoPageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WhatsNewModuleDemoPageInfo_UnserializedMessageContext<
            UserType, WhatsNewModuleDemoPageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WhatsNewModuleDemoPageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_title;
  
  std::string module_name;
  
  bool has_browser_command;
  
  bool is_feature_enabled;
  
  int32_t queue_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WhatsNewEditionDemoPageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WhatsNewEditionDemoPageInfo, T>::value>;
  using DataView = WhatsNewEditionDemoPageInfoDataView;
  using Data_ = internal::WhatsNewEditionDemoPageInfo_Data;

  template <typename... Args>
  static WhatsNewEditionDemoPageInfoPtr New(Args&&... args) {
    return WhatsNewEditionDemoPageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WhatsNewEditionDemoPageInfoPtr From(const U& u) {
    return mojo::TypeConverter<WhatsNewEditionDemoPageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WhatsNewEditionDemoPageInfo>::Convert(*this);
  }


  WhatsNewEditionDemoPageInfo();

  WhatsNewEditionDemoPageInfo(
      const std::string& display_title,
      const std::string& edition_name,
      bool is_feature_enabled,
      bool has_been_used,
      int32_t version_used);


  ~WhatsNewEditionDemoPageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WhatsNewEditionDemoPageInfoPtr>
  WhatsNewEditionDemoPageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WhatsNewEditionDemoPageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WhatsNewEditionDemoPageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WhatsNewEditionDemoPageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WhatsNewEditionDemoPageInfo_UnserializedMessageContext<
            UserType, WhatsNewEditionDemoPageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WhatsNewEditionDemoPageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WhatsNewEditionDemoPageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WhatsNewEditionDemoPageInfo_UnserializedMessageContext<
            UserType, WhatsNewEditionDemoPageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WhatsNewEditionDemoPageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_title;
  
  std::string edition_name;
  
  bool is_feature_enabled;
  
  bool has_been_used;
  
  int32_t version_used;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FeaturePromoDemoPageDataPtr FeaturePromoDemoPageData::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>*>
bool FeaturePromoDemoPageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, FeaturePromoDemoPageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
FeaturePromoDemoPageInfoPtr FeaturePromoDemoPageInfo::Clone() const {
  return New(
      mojo::Clone(display_title),
      mojo::Clone(display_description),
      mojo::Clone(internal_name),
      mojo::Clone(type),
      mojo::Clone(added_milestone),
      mojo::Clone(supported_platforms),
      mojo::Clone(required_features),
      mojo::Clone(instructions),
      mojo::Clone(followed_by_internal_name),
      mojo::Clone(data)
  );
}

template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>*>
bool FeaturePromoDemoPageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_title, other_struct.display_title))
    return false;
  if (!mojo::Equals(this->display_description, other_struct.display_description))
    return false;
  if (!mojo::Equals(this->internal_name, other_struct.internal_name))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->added_milestone, other_struct.added_milestone))
    return false;
  if (!mojo::Equals(this->supported_platforms, other_struct.supported_platforms))
    return false;
  if (!mojo::Equals(this->required_features, other_struct.required_features))
    return false;
  if (!mojo::Equals(this->instructions, other_struct.instructions))
    return false;
  if (!mojo::Equals(this->followed_by_internal_name, other_struct.followed_by_internal_name))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, FeaturePromoDemoPageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_title < rhs.display_title)
    return true;
  if (rhs.display_title < lhs.display_title)
    return false;
  if (lhs.display_description < rhs.display_description)
    return true;
  if (rhs.display_description < lhs.display_description)
    return false;
  if (lhs.internal_name < rhs.internal_name)
    return true;
  if (rhs.internal_name < lhs.internal_name)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.added_milestone < rhs.added_milestone)
    return true;
  if (rhs.added_milestone < lhs.added_milestone)
    return false;
  if (lhs.supported_platforms < rhs.supported_platforms)
    return true;
  if (rhs.supported_platforms < lhs.supported_platforms)
    return false;
  if (lhs.required_features < rhs.required_features)
    return true;
  if (rhs.required_features < lhs.required_features)
    return false;
  if (lhs.instructions < rhs.instructions)
    return true;
  if (rhs.instructions < lhs.instructions)
    return false;
  if (lhs.followed_by_internal_name < rhs.followed_by_internal_name)
    return true;
  if (rhs.followed_by_internal_name < lhs.followed_by_internal_name)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
WhatsNewModuleDemoPageInfoPtr WhatsNewModuleDemoPageInfo::Clone() const {
  return New(
      mojo::Clone(display_title),
      mojo::Clone(module_name),
      mojo::Clone(has_browser_command),
      mojo::Clone(is_feature_enabled),
      mojo::Clone(queue_position)
  );
}

template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>*>
bool WhatsNewModuleDemoPageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_title, other_struct.display_title))
    return false;
  if (!mojo::Equals(this->module_name, other_struct.module_name))
    return false;
  if (!mojo::Equals(this->has_browser_command, other_struct.has_browser_command))
    return false;
  if (!mojo::Equals(this->is_feature_enabled, other_struct.is_feature_enabled))
    return false;
  if (!mojo::Equals(this->queue_position, other_struct.queue_position))
    return false;
  return true;
}

template <typename T, WhatsNewModuleDemoPageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_title < rhs.display_title)
    return true;
  if (rhs.display_title < lhs.display_title)
    return false;
  if (lhs.module_name < rhs.module_name)
    return true;
  if (rhs.module_name < lhs.module_name)
    return false;
  if (lhs.has_browser_command < rhs.has_browser_command)
    return true;
  if (rhs.has_browser_command < lhs.has_browser_command)
    return false;
  if (lhs.is_feature_enabled < rhs.is_feature_enabled)
    return true;
  if (rhs.is_feature_enabled < lhs.is_feature_enabled)
    return false;
  if (lhs.queue_position < rhs.queue_position)
    return true;
  if (rhs.queue_position < lhs.queue_position)
    return false;
  return false;
}
template <typename StructPtrType>
WhatsNewEditionDemoPageInfoPtr WhatsNewEditionDemoPageInfo::Clone() const {
  return New(
      mojo::Clone(display_title),
      mojo::Clone(edition_name),
      mojo::Clone(is_feature_enabled),
      mojo::Clone(has_been_used),
      mojo::Clone(version_used)
  );
}

template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>*>
bool WhatsNewEditionDemoPageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_title, other_struct.display_title))
    return false;
  if (!mojo::Equals(this->edition_name, other_struct.edition_name))
    return false;
  if (!mojo::Equals(this->is_feature_enabled, other_struct.is_feature_enabled))
    return false;
  if (!mojo::Equals(this->has_been_used, other_struct.has_been_used))
    return false;
  if (!mojo::Equals(this->version_used, other_struct.version_used))
    return false;
  return true;
}

template <typename T, WhatsNewEditionDemoPageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_title < rhs.display_title)
    return true;
  if (rhs.display_title < lhs.display_title)
    return false;
  if (lhs.edition_name < rhs.edition_name)
    return true;
  if (rhs.edition_name < lhs.edition_name)
    return false;
  if (lhs.is_feature_enabled < rhs.is_feature_enabled)
    return true;
  if (rhs.is_feature_enabled < lhs.is_feature_enabled)
    return false;
  if (lhs.has_been_used < rhs.has_been_used)
    return true;
  if (rhs.has_been_used < lhs.has_been_used)
    return false;
  if (lhs.version_used < rhs.version_used)
    return true;
  if (rhs.version_used < lhs.version_used)
    return false;
  return false;
}


}  // mojom::user_education_internals

namespace mojo {


template <>
struct  StructTraits<::mojom::user_education_internals::FeaturePromoDemoPageData::DataView,
                                         ::mojom::user_education_internals::FeaturePromoDemoPageDataPtr> {
  static bool IsNull(const ::mojom::user_education_internals::FeaturePromoDemoPageDataPtr& input) { return !input; }
  static void SetToNull(::mojom::user_education_internals::FeaturePromoDemoPageDataPtr* output) { output->reset(); }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageData::name)& name(
      const ::mojom::user_education_internals::FeaturePromoDemoPageDataPtr& input) {
    return input->name;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageData::value)& value(
      const ::mojom::user_education_internals::FeaturePromoDemoPageDataPtr& input) {
    return input->value;
  }

  static bool Read(::mojom::user_education_internals::FeaturePromoDemoPageData::DataView input, ::mojom::user_education_internals::FeaturePromoDemoPageDataPtr* output);
};


template <>
struct  StructTraits<::mojom::user_education_internals::FeaturePromoDemoPageInfo::DataView,
                                         ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr> {
  static bool IsNull(const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::display_title)& display_title(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->display_title;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::display_description)& display_description(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->display_description;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::internal_name)& internal_name(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->internal_name;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::type)& type(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->type;
  }

  static decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::added_milestone) added_milestone(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->added_milestone;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::supported_platforms)& supported_platforms(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->supported_platforms;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::required_features)& required_features(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->required_features;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::instructions)& instructions(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->instructions;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::followed_by_internal_name)& followed_by_internal_name(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->followed_by_internal_name;
  }

  static const decltype(::mojom::user_education_internals::FeaturePromoDemoPageInfo::data)& data(
      const ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr& input) {
    return input->data;
  }

  static bool Read(::mojom::user_education_internals::FeaturePromoDemoPageInfo::DataView input, ::mojom::user_education_internals::FeaturePromoDemoPageInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::DataView,
                                         ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr> {
  static bool IsNull(const ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::display_title)& display_title(
      const ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr& input) {
    return input->display_title;
  }

  static const decltype(::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::module_name)& module_name(
      const ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr& input) {
    return input->module_name;
  }

  static decltype(::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::has_browser_command) has_browser_command(
      const ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr& input) {
    return input->has_browser_command;
  }

  static decltype(::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::is_feature_enabled) is_feature_enabled(
      const ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr& input) {
    return input->is_feature_enabled;
  }

  static decltype(::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::queue_position) queue_position(
      const ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr& input) {
    return input->queue_position;
  }

  static bool Read(::mojom::user_education_internals::WhatsNewModuleDemoPageInfo::DataView input, ::mojom::user_education_internals::WhatsNewModuleDemoPageInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::DataView,
                                         ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr> {
  static bool IsNull(const ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::display_title)& display_title(
      const ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr& input) {
    return input->display_title;
  }

  static const decltype(::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::edition_name)& edition_name(
      const ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr& input) {
    return input->edition_name;
  }

  static decltype(::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::is_feature_enabled) is_feature_enabled(
      const ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr& input) {
    return input->is_feature_enabled;
  }

  static decltype(::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::has_been_used) has_been_used(
      const ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr& input) {
    return input->has_been_used;
  }

  static decltype(::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::version_used) version_used(
      const ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr& input) {
    return input->version_used;
  }

  static bool Read(::mojom::user_education_internals::WhatsNewEditionDemoPageInfo::DataView input, ::mojom::user_education_internals::WhatsNewEditionDemoPageInfoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_USER_EDUCATION_INTERNALS_USER_EDUCATION_INTERNALS_MOJOM_H_