// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tabs/tabs.mojom.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace tab_strip_internals::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_strip_internals.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_strip_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTabStripDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTabStripData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetTabStripDataCallback = base::OnceCallback<void(ContainerPtr)>;
  using GetTabStripDataMojoCallback = base::OnceCallback<void(ContainerPtr)>;

  virtual void GetTabStripData(GetTabStripDataCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_strip_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTabStripUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTabStripUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnTabStripUpdated(ContainerPtr data) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTabStripData(GetTabStripDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTabStripUpdated(ContainerPtr data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  NodeId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NodeId, T>::value>;
  using DataView = NodeIdDataView;
  using Data_ = internal::NodeId_Data;
  using Type = NodeId_Type;

  template <typename... Args>
  static NodeIdPtr New(Args&&... args) {
    return NodeIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NodeIdPtr From(const U& u) {
    return mojo::TypeConverter<NodeIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NodeId>::Convert(*this);
  }


  NodeId();

  NodeId(
      const std::string& node_id,
      NodeId::Type type);


  ~NodeId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NodeIdPtr>
  NodeIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NodeId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NodeId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NodeId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NodeId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NodeId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NodeId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NodeId_UnserializedMessageContext<
            UserType, NodeId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NodeId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NodeId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NodeId_UnserializedMessageContext<
            UserType, NodeId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NodeId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string node_id;
  
  NodeId::Type type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  TabGroupVisualData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabGroupVisualData, T>::value>;
  using DataView = TabGroupVisualDataDataView;
  using Data_ = internal::TabGroupVisualData_Data;

  template <typename... Args>
  static TabGroupVisualDataPtr New(Args&&... args) {
    return TabGroupVisualDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabGroupVisualDataPtr From(const U& u) {
    return mojo::TypeConverter<TabGroupVisualDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabGroupVisualData>::Convert(*this);
  }


  TabGroupVisualData();

  TabGroupVisualData(
      const std::string& title,
      ::tab_groups::TabGroupColorId color,
      bool is_collapsed);


  ~TabGroupVisualData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabGroupVisualDataPtr>
  TabGroupVisualDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroupVisualData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroupVisualData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabGroupVisualData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabGroupVisualData_UnserializedMessageContext<
            UserType, TabGroupVisualData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabGroupVisualData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabGroupVisualData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabGroupVisualData_UnserializedMessageContext<
            UserType, TabGroupVisualData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabGroupVisualData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::tab_groups::TabGroupColorId color;
  
  bool is_collapsed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SplitTabVisualData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SplitTabVisualData, T>::value>;
  using DataView = SplitTabVisualDataDataView;
  using Data_ = internal::SplitTabVisualData_Data;
  using Layout = SplitTabVisualData_Layout;

  template <typename... Args>
  static SplitTabVisualDataPtr New(Args&&... args) {
    return SplitTabVisualDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SplitTabVisualDataPtr From(const U& u) {
    return mojo::TypeConverter<SplitTabVisualDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SplitTabVisualData>::Convert(*this);
  }


  SplitTabVisualData();

  SplitTabVisualData(
      SplitTabVisualData::Layout layout,
      double split_ratio);


  ~SplitTabVisualData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SplitTabVisualDataPtr>
  SplitTabVisualDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitTabVisualData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitTabVisualData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SplitTabVisualData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SplitTabVisualData_UnserializedMessageContext<
            UserType, SplitTabVisualData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SplitTabVisualData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SplitTabVisualData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SplitTabVisualData_UnserializedMessageContext<
            UserType, SplitTabVisualData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SplitTabVisualData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SplitTabVisualData::Layout layout;
  
  double split_ratio;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  Data {
 public:
  using DataView = DataDataView;
  using Data_ = internal::Data_Data;
  using Tag = Data_::Data_Tag;

  template <typename... Args>
  static DataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |tab|.
  static DataPtr NewTab(
      TabPtr value);
  // Construct an instance holding |tab_strip_collection|.
  static DataPtr NewTabStripCollection(
      TabStripCollectionPtr value);
  // Construct an instance holding |pinned_tab_collection|.
  static DataPtr NewPinnedTabCollection(
      PinnedCollectionPtr value);
  // Construct an instance holding |unpinned_tab_collection|.
  static DataPtr NewUnpinnedTabCollection(
      UnpinnedCollectionPtr value);
  // Construct an instance holding |tab_group_collection|.
  static DataPtr NewTabGroupCollection(
      GroupCollectionPtr value);
  // Construct an instance holding |split_tab_collection|.
  static DataPtr NewSplitTabCollection(
      SplitCollectionPtr value);

  template <typename U>
  static DataPtr From(const U& u) {
    return mojo::TypeConverter<DataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Data>::Convert(*this);
  }
  ~Data();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Data(const Data& other) = delete;
  Data& operator=(const Data& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DataPtr>
  DataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Data>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Data>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_tab() const { return tag_ == Tag::kTab; }
  const TabPtr& get_tab() const {
    CHECK(tag_ == Tag::kTab);
    return data_.tab;
  }
  TabPtr& get_tab() {
    CHECK(tag_ == Tag::kTab);
    return data_.tab;
  }
  void set_tab(TabPtr tab);

  bool is_tab_strip_collection() const { return tag_ == Tag::kTabStripCollection; }
  const TabStripCollectionPtr& get_tab_strip_collection() const {
    CHECK(tag_ == Tag::kTabStripCollection);
    return data_.tab_strip_collection;
  }
  TabStripCollectionPtr& get_tab_strip_collection() {
    CHECK(tag_ == Tag::kTabStripCollection);
    return data_.tab_strip_collection;
  }
  void set_tab_strip_collection(TabStripCollectionPtr tab_strip_collection);

  bool is_pinned_tab_collection() const { return tag_ == Tag::kPinnedTabCollection; }
  const PinnedCollectionPtr& get_pinned_tab_collection() const {
    CHECK(tag_ == Tag::kPinnedTabCollection);
    return data_.pinned_tab_collection;
  }
  PinnedCollectionPtr& get_pinned_tab_collection() {
    CHECK(tag_ == Tag::kPinnedTabCollection);
    return data_.pinned_tab_collection;
  }
  void set_pinned_tab_collection(PinnedCollectionPtr pinned_tab_collection);

  bool is_unpinned_tab_collection() const { return tag_ == Tag::kUnpinnedTabCollection; }
  const UnpinnedCollectionPtr& get_unpinned_tab_collection() const {
    CHECK(tag_ == Tag::kUnpinnedTabCollection);
    return data_.unpinned_tab_collection;
  }
  UnpinnedCollectionPtr& get_unpinned_tab_collection() {
    CHECK(tag_ == Tag::kUnpinnedTabCollection);
    return data_.unpinned_tab_collection;
  }
  void set_unpinned_tab_collection(UnpinnedCollectionPtr unpinned_tab_collection);

  bool is_tab_group_collection() const { return tag_ == Tag::kTabGroupCollection; }
  const GroupCollectionPtr& get_tab_group_collection() const {
    CHECK(tag_ == Tag::kTabGroupCollection);
    return data_.tab_group_collection;
  }
  GroupCollectionPtr& get_tab_group_collection() {
    CHECK(tag_ == Tag::kTabGroupCollection);
    return data_.tab_group_collection;
  }
  void set_tab_group_collection(GroupCollectionPtr tab_group_collection);

  bool is_split_tab_collection() const { return tag_ == Tag::kSplitTabCollection; }
  const SplitCollectionPtr& get_split_tab_collection() const {
    CHECK(tag_ == Tag::kSplitTabCollection);
    return data_.split_tab_collection;
  }
  SplitCollectionPtr& get_split_tab_collection() {
    CHECK(tag_ == Tag::kSplitTabCollection);
    return data_.split_tab_collection;
  }
  void set_split_tab_collection(SplitCollectionPtr split_tab_collection);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Data::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Data::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
        TabPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabStripCollection)>,
        TabStripCollectionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabCollection)>,
        PinnedCollectionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabCollection)>,
        UnpinnedCollectionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabGroupCollection)>,
        GroupCollectionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSplitTabCollection)>,
        SplitCollectionPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TabPtr tab;
    TabStripCollectionPtr tab_strip_collection;
    PinnedCollectionPtr pinned_tab_collection;
    UnpinnedCollectionPtr unpinned_tab_collection;
    GroupCollectionPtr tab_group_collection;
    SplitCollectionPtr split_tab_collection;
  };

  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
      TabPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabStripCollection)>,
      TabStripCollectionPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabCollection)>,
      PinnedCollectionPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabCollection)>,
      UnpinnedCollectionPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabGroupCollection)>,
      GroupCollectionPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kSplitTabCollection)>,
      SplitCollectionPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  TabRestoreEntry {
 public:
  using DataView = TabRestoreEntryDataView;
  using Data_ = internal::TabRestoreEntry_Data;
  using Tag = Data_::TabRestoreEntry_Tag;

  template <typename... Args>
  static TabRestoreEntryPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |tab|.
  static TabRestoreEntryPtr NewTab(
      TabRestoreTabPtr value);
  // Construct an instance holding |window|.
  static TabRestoreEntryPtr NewWindow(
      TabRestoreWindowPtr value);
  // Construct an instance holding |group|.
  static TabRestoreEntryPtr NewGroup(
      TabRestoreGroupPtr value);

  template <typename U>
  static TabRestoreEntryPtr From(const U& u) {
    return mojo::TypeConverter<TabRestoreEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRestoreEntry>::Convert(*this);
  }
  ~TabRestoreEntry();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabRestoreEntry(const TabRestoreEntry& other) = delete;
  TabRestoreEntry& operator=(const TabRestoreEntry& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabRestoreEntryPtr>
  TabRestoreEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabRestoreEntry>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabRestoreEntry>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_tab() const { return tag_ == Tag::kTab; }
  const TabRestoreTabPtr& get_tab() const {
    CHECK(tag_ == Tag::kTab);
    return data_.tab;
  }
  TabRestoreTabPtr& get_tab() {
    CHECK(tag_ == Tag::kTab);
    return data_.tab;
  }
  void set_tab(TabRestoreTabPtr tab);

  bool is_window() const { return tag_ == Tag::kWindow; }
  const TabRestoreWindowPtr& get_window() const {
    CHECK(tag_ == Tag::kWindow);
    return data_.window;
  }
  TabRestoreWindowPtr& get_window() {
    CHECK(tag_ == Tag::kWindow);
    return data_.window;
  }
  void set_window(TabRestoreWindowPtr window);

  bool is_group() const { return tag_ == Tag::kGroup; }
  const TabRestoreGroupPtr& get_group() const {
    CHECK(tag_ == Tag::kGroup);
    return data_.group;
  }
  TabRestoreGroupPtr& get_group() {
    CHECK(tag_ == Tag::kGroup);
    return data_.group;
  }
  void set_group(TabRestoreGroupPtr group);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRestoreEntry::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabRestoreEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
        TabRestoreTabPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kWindow)>,
        TabRestoreWindowPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGroup)>,
        TabRestoreGroupPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TabRestoreTabPtr tab;
    TabRestoreWindowPtr window;
    TabRestoreGroupPtr group;
  };

  TabRestoreEntry(
      std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
      TabRestoreTabPtr value);
  TabRestoreEntry(
      std::in_place_index_t<static_cast<size_t>(Tag::kWindow)>,
      TabRestoreWindowPtr value);
  TabRestoreEntry(
      std::in_place_index_t<static_cast<size_t>(Tag::kGroup)>,
      TabRestoreGroupPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Container {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Container, T>::value>;
  using DataView = ContainerDataView;
  using Data_ = internal::Container_Data;

  template <typename... Args>
  static ContainerPtr New(Args&&... args) {
    return ContainerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContainerPtr From(const U& u) {
    return mojo::TypeConverter<ContainerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Container>::Convert(*this);
  }


  Container();

  Container(
      TabStripTreePtr tabstrip_tree,
      TabRestoreDataPtr tab_restore);

Container(const Container&) = delete;
Container& operator=(const Container&) = delete;

  ~Container();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContainerPtr>
  ContainerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Container::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Container::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Container::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Container::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Container::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Container::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Container_UnserializedMessageContext<
            UserType, Container::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Container::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Container::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Container_UnserializedMessageContext<
            UserType, Container::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Container::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TabStripTreePtr tabstrip_tree;
  
  TabRestoreDataPtr tab_restore;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabStripTree {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabStripTree, T>::value>;
  using DataView = TabStripTreeDataView;
  using Data_ = internal::TabStripTree_Data;

  template <typename... Args>
  static TabStripTreePtr New(Args&&... args) {
    return TabStripTreePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabStripTreePtr From(const U& u) {
    return mojo::TypeConverter<TabStripTreePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripTree>::Convert(*this);
  }


  TabStripTree();

  explicit TabStripTree(
      std::vector<WindowNodePtr> windows);

TabStripTree(const TabStripTree&) = delete;
TabStripTree& operator=(const TabStripTree&) = delete;

  ~TabStripTree();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabStripTreePtr>
  TabStripTreePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStripTree::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStripTree::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripTree::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabStripTree_UnserializedMessageContext<
            UserType, TabStripTree::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabStripTree::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabStripTree::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabStripTree_UnserializedMessageContext<
            UserType, TabStripTree::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabStripTree::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WindowNodePtr> windows;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabStripTree::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WindowNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WindowNode, T>::value>;
  using DataView = WindowNodeDataView;
  using Data_ = internal::WindowNode_Data;

  template <typename... Args>
  static WindowNodePtr New(Args&&... args) {
    return WindowNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WindowNodePtr From(const U& u) {
    return mojo::TypeConverter<WindowNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WindowNode>::Convert(*this);
  }


  WindowNode();

  WindowNode(
      NodeIdPtr id,
      TabStripModelPtr tabstrip_model,
      SelectionModelPtr selection_model);

WindowNode(const WindowNode&) = delete;
WindowNode& operator=(const WindowNode&) = delete;

  ~WindowNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WindowNodePtr>
  WindowNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowNode::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowNode::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WindowNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WindowNode_UnserializedMessageContext<
            UserType, WindowNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WindowNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WindowNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WindowNode_UnserializedMessageContext<
            UserType, WindowNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WindowNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  TabStripModelPtr tabstrip_model;
  
  SelectionModelPtr selection_model;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WindowNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  TabStripModel {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabStripModel, T>::value>;
  using DataView = TabStripModelDataView;
  using Data_ = internal::TabStripModel_Data;

  template <typename... Args>
  static TabStripModelPtr New(Args&&... args) {
    return TabStripModelPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabStripModelPtr From(const U& u) {
    return mojo::TypeConverter<TabStripModelPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripModel>::Convert(*this);
  }


  TabStripModel();

  explicit TabStripModel(
      NodePtr root);

TabStripModel(const TabStripModel&) = delete;
TabStripModel& operator=(const TabStripModel&) = delete;

  ~TabStripModel();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabStripModelPtr>
  TabStripModelPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStripModel::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStripModel::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripModel::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabStripModel_UnserializedMessageContext<
            UserType, TabStripModel::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabStripModel::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabStripModel::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabStripModel_UnserializedMessageContext<
            UserType, TabStripModel::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabStripModel::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodePtr root;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabStripModel::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Node {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Node, T>::value>;
  using DataView = NodeDataView;
  using Data_ = internal::Node_Data;

  template <typename... Args>
  static NodePtr New(Args&&... args) {
    return NodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NodePtr From(const U& u) {
    return mojo::TypeConverter<NodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Node>::Convert(*this);
  }


  Node();

  Node(
      DataPtr data,
      std::vector<NodePtr> children);

Node(const Node&) = delete;
Node& operator=(const Node&) = delete;

  ~Node();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NodePtr>
  NodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Node::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Node::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Node::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Node::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Node::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Node::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Node_UnserializedMessageContext<
            UserType, Node::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Node::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Node::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Node_UnserializedMessageContext<
            UserType, Node::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Node::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DataPtr data;
  
  std::vector<NodePtr> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Node::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Node::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Node::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Node::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Tab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tab, T>::value>;
  using DataView = TabDataView;
  using Data_ = internal::Tab_Data;

  template <typename... Args>
  static TabPtr New(Args&&... args) {
    return TabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabPtr From(const U& u) {
    return mojo::TypeConverter<TabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tab>::Convert(*this);
  }


  Tab();

  Tab(
      NodeIdPtr id,
      const std::string& title,
      const ::GURL& url,
      bool active,
      bool visible,
      bool selected,
      bool pinned,
      bool split,
      std::vector<::tabs::TabAlert> alert_states);

Tab(const Tab&) = delete;
Tab& operator=(const Tab&) = delete;

  ~Tab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabPtr>
  TabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  std::string title;
  
  ::GURL url;
  
  bool active;
  
  bool visible;
  
  bool selected;
  
  bool pinned;
  
  bool split;
  
  std::vector<::tabs::TabAlert> alert_states;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabStripCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabStripCollection, T>::value>;
  using DataView = TabStripCollectionDataView;
  using Data_ = internal::TabStripCollection_Data;

  template <typename... Args>
  static TabStripCollectionPtr New(Args&&... args) {
    return TabStripCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabStripCollectionPtr From(const U& u) {
    return mojo::TypeConverter<TabStripCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripCollection>::Convert(*this);
  }


  TabStripCollection();

  explicit TabStripCollection(
      NodeIdPtr id);

TabStripCollection(const TabStripCollection&) = delete;
TabStripCollection& operator=(const TabStripCollection&) = delete;

  ~TabStripCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabStripCollectionPtr>
  TabStripCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStripCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStripCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabStripCollection_UnserializedMessageContext<
            UserType, TabStripCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabStripCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabStripCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabStripCollection_UnserializedMessageContext<
            UserType, TabStripCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabStripCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabStripCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PinnedCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinnedCollection, T>::value>;
  using DataView = PinnedCollectionDataView;
  using Data_ = internal::PinnedCollection_Data;

  template <typename... Args>
  static PinnedCollectionPtr New(Args&&... args) {
    return PinnedCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinnedCollectionPtr From(const U& u) {
    return mojo::TypeConverter<PinnedCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinnedCollection>::Convert(*this);
  }


  PinnedCollection();

  explicit PinnedCollection(
      NodeIdPtr id);

PinnedCollection(const PinnedCollection&) = delete;
PinnedCollection& operator=(const PinnedCollection&) = delete;

  ~PinnedCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinnedCollectionPtr>
  PinnedCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinnedCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinnedCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinnedCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinnedCollection_UnserializedMessageContext<
            UserType, PinnedCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PinnedCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PinnedCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinnedCollection_UnserializedMessageContext<
            UserType, PinnedCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinnedCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinnedCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UnpinnedCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnpinnedCollection, T>::value>;
  using DataView = UnpinnedCollectionDataView;
  using Data_ = internal::UnpinnedCollection_Data;

  template <typename... Args>
  static UnpinnedCollectionPtr New(Args&&... args) {
    return UnpinnedCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnpinnedCollectionPtr From(const U& u) {
    return mojo::TypeConverter<UnpinnedCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnpinnedCollection>::Convert(*this);
  }


  UnpinnedCollection();

  explicit UnpinnedCollection(
      NodeIdPtr id);

UnpinnedCollection(const UnpinnedCollection&) = delete;
UnpinnedCollection& operator=(const UnpinnedCollection&) = delete;

  ~UnpinnedCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnpinnedCollectionPtr>
  UnpinnedCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnpinnedCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnpinnedCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnpinnedCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnpinnedCollection_UnserializedMessageContext<
            UserType, UnpinnedCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnpinnedCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnpinnedCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnpinnedCollection_UnserializedMessageContext<
            UserType, UnpinnedCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnpinnedCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnpinnedCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GroupCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GroupCollection, T>::value>;
  using DataView = GroupCollectionDataView;
  using Data_ = internal::GroupCollection_Data;

  template <typename... Args>
  static GroupCollectionPtr New(Args&&... args) {
    return GroupCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GroupCollectionPtr From(const U& u) {
    return mojo::TypeConverter<GroupCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GroupCollection>::Convert(*this);
  }


  GroupCollection();

  GroupCollection(
      NodeIdPtr id,
      TabGroupVisualDataPtr visualData);

GroupCollection(const GroupCollection&) = delete;
GroupCollection& operator=(const GroupCollection&) = delete;

  ~GroupCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GroupCollectionPtr>
  GroupCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GroupCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GroupCollection_UnserializedMessageContext<
            UserType, GroupCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GroupCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GroupCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GroupCollection_UnserializedMessageContext<
            UserType, GroupCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GroupCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  TabGroupVisualDataPtr visualData;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GroupCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SplitCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SplitCollection, T>::value>;
  using DataView = SplitCollectionDataView;
  using Data_ = internal::SplitCollection_Data;

  template <typename... Args>
  static SplitCollectionPtr New(Args&&... args) {
    return SplitCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SplitCollectionPtr From(const U& u) {
    return mojo::TypeConverter<SplitCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SplitCollection>::Convert(*this);
  }


  SplitCollection();

  SplitCollection(
      NodeIdPtr id,
      SplitTabVisualDataPtr visualData);

SplitCollection(const SplitCollection&) = delete;
SplitCollection& operator=(const SplitCollection&) = delete;

  ~SplitCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SplitCollectionPtr>
  SplitCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SplitCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SplitCollection_UnserializedMessageContext<
            UserType, SplitCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SplitCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SplitCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SplitCollection_UnserializedMessageContext<
            UserType, SplitCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SplitCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  SplitTabVisualDataPtr visualData;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SplitCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SelectionModel {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectionModel, T>::value>;
  using DataView = SelectionModelDataView;
  using Data_ = internal::SelectionModel_Data;

  template <typename... Args>
  static SelectionModelPtr New(Args&&... args) {
    return SelectionModelPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectionModelPtr From(const U& u) {
    return mojo::TypeConverter<SelectionModelPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectionModel>::Convert(*this);
  }


  SelectionModel();

  SelectionModel(
      int32_t active_index,
      int32_t anchor_index,
      std::vector<int32_t> selected_indices);


  ~SelectionModel();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectionModelPtr>
  SelectionModelPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectionModel::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectionModel::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectionModel::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectionModel_UnserializedMessageContext<
            UserType, SelectionModel::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectionModel::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectionModel::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectionModel_UnserializedMessageContext<
            UserType, SelectionModel::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectionModel::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t active_index;
  
  int32_t anchor_index;
  
  std::vector<int32_t> selected_indices;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectionModel::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabRestoreData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabRestoreData, T>::value>;
  using DataView = TabRestoreDataDataView;
  using Data_ = internal::TabRestoreData_Data;

  template <typename... Args>
  static TabRestoreDataPtr New(Args&&... args) {
    return TabRestoreDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabRestoreDataPtr From(const U& u) {
    return mojo::TypeConverter<TabRestoreDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRestoreData>::Convert(*this);
  }


  TabRestoreData();

  explicit TabRestoreData(
      std::vector<TabRestoreEntryPtr> entries);

TabRestoreData(const TabRestoreData&) = delete;
TabRestoreData& operator=(const TabRestoreData&) = delete;

  ~TabRestoreData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabRestoreDataPtr>
  TabRestoreDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRestoreData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabRestoreData_UnserializedMessageContext<
            UserType, TabRestoreData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabRestoreData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabRestoreData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabRestoreData_UnserializedMessageContext<
            UserType, TabRestoreData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabRestoreData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<TabRestoreEntryPtr> entries;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabRestoreData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabRestoreEntryBase {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabRestoreEntryBase, T>::value>;
  using DataView = TabRestoreEntryBaseDataView;
  using Data_ = internal::TabRestoreEntryBase_Data;

  template <typename... Args>
  static TabRestoreEntryBasePtr New(Args&&... args) {
    return TabRestoreEntryBasePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabRestoreEntryBasePtr From(const U& u) {
    return mojo::TypeConverter<TabRestoreEntryBasePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRestoreEntryBase>::Convert(*this);
  }


  TabRestoreEntryBase();

  TabRestoreEntryBase(
      int32_t original_id,
      std::optional<::base::Time> timestamp);


  ~TabRestoreEntryBase();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabRestoreEntryBasePtr>
  TabRestoreEntryBasePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreEntryBase::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreEntryBase::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRestoreEntryBase::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabRestoreEntryBase_UnserializedMessageContext<
            UserType, TabRestoreEntryBase::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabRestoreEntryBase::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabRestoreEntryBase::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabRestoreEntryBase_UnserializedMessageContext<
            UserType, TabRestoreEntryBase::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabRestoreEntryBase::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t original_id;
  
  std::optional<::base::Time> timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabRestoreEntryBase::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabRestoreTab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabRestoreTab, T>::value>;
  using DataView = TabRestoreTabDataView;
  using Data_ = internal::TabRestoreTab_Data;

  template <typename... Args>
  static TabRestoreTabPtr New(Args&&... args) {
    return TabRestoreTabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabRestoreTabPtr From(const U& u) {
    return mojo::TypeConverter<TabRestoreTabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRestoreTab>::Convert(*this);
  }


  TabRestoreTab();

  TabRestoreTab(
      NodeIdPtr id,
      TabRestoreEntryBasePtr restore_entry,
      int32_t browser_id,
      int32_t tabstrip_index,
      bool pinned,
      const std::optional<::base::Token>& group_id,
      TabGroupVisualDataPtr group_visual_data,
      const std::string& title,
      const ::GURL& url);

TabRestoreTab(const TabRestoreTab&) = delete;
TabRestoreTab& operator=(const TabRestoreTab&) = delete;

  ~TabRestoreTab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabRestoreTabPtr>
  TabRestoreTabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreTab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreTab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRestoreTab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabRestoreTab_UnserializedMessageContext<
            UserType, TabRestoreTab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabRestoreTab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabRestoreTab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabRestoreTab_UnserializedMessageContext<
            UserType, TabRestoreTab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabRestoreTab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  TabRestoreEntryBasePtr restore_entry;
  
  int32_t browser_id;
  
  int32_t tabstrip_index;
  
  bool pinned;
  
  std::optional<::base::Token> group_id;
  
  TabGroupVisualDataPtr group_visual_data;
  
  std::string title;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabRestoreTab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabRestoreGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabRestoreGroup, T>::value>;
  using DataView = TabRestoreGroupDataView;
  using Data_ = internal::TabRestoreGroup_Data;

  template <typename... Args>
  static TabRestoreGroupPtr New(Args&&... args) {
    return TabRestoreGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabRestoreGroupPtr From(const U& u) {
    return mojo::TypeConverter<TabRestoreGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRestoreGroup>::Convert(*this);
  }


  TabRestoreGroup();

  TabRestoreGroup(
      NodeIdPtr id,
      TabRestoreEntryBasePtr restore_entry,
      int32_t browser_id,
      const ::base::Token& group_id,
      TabGroupVisualDataPtr visual_data,
      std::vector<TabRestoreTabPtr> tabs);

TabRestoreGroup(const TabRestoreGroup&) = delete;
TabRestoreGroup& operator=(const TabRestoreGroup&) = delete;

  ~TabRestoreGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabRestoreGroupPtr>
  TabRestoreGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRestoreGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabRestoreGroup_UnserializedMessageContext<
            UserType, TabRestoreGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabRestoreGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabRestoreGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabRestoreGroup_UnserializedMessageContext<
            UserType, TabRestoreGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabRestoreGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  TabRestoreEntryBasePtr restore_entry;
  
  int32_t browser_id;
  
  ::base::Token group_id;
  
  TabGroupVisualDataPtr visual_data;
  
  std::vector<TabRestoreTabPtr> tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabRestoreGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabRestoreWindow {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabRestoreWindow, T>::value>;
  using DataView = TabRestoreWindowDataView;
  using Data_ = internal::TabRestoreWindow_Data;

  template <typename... Args>
  static TabRestoreWindowPtr New(Args&&... args) {
    return TabRestoreWindowPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabRestoreWindowPtr From(const U& u) {
    return mojo::TypeConverter<TabRestoreWindowPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabRestoreWindow>::Convert(*this);
  }


  TabRestoreWindow();

  TabRestoreWindow(
      NodeIdPtr id,
      TabRestoreEntryBasePtr restore_entry,
      int32_t selected_tab_index,
      std::vector<TabRestoreTabPtr> tabs);

TabRestoreWindow(const TabRestoreWindow&) = delete;
TabRestoreWindow& operator=(const TabRestoreWindow&) = delete;

  ~TabRestoreWindow();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabRestoreWindowPtr>
  TabRestoreWindowPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreWindow::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabRestoreWindow::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabRestoreWindow::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabRestoreWindow_UnserializedMessageContext<
            UserType, TabRestoreWindow::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabRestoreWindow::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabRestoreWindow::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabRestoreWindow_UnserializedMessageContext<
            UserType, TabRestoreWindow::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabRestoreWindow::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NodeIdPtr id;
  
  TabRestoreEntryBasePtr restore_entry;
  
  int32_t selected_tab_index;
  
  std::vector<TabRestoreTabPtr> tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabRestoreWindow::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DataPtr Data::Clone() const {
  switch (tag_) {
    case Tag::kTab:
      return NewTab(
          mojo::Clone(data_.tab));
    case Tag::kTabStripCollection:
      return NewTabStripCollection(
          mojo::Clone(data_.tab_strip_collection));
    case Tag::kPinnedTabCollection:
      return NewPinnedTabCollection(
          mojo::Clone(data_.pinned_tab_collection));
    case Tag::kUnpinnedTabCollection:
      return NewUnpinnedTabCollection(
          mojo::Clone(data_.unpinned_tab_collection));
    case Tag::kTabGroupCollection:
      return NewTabGroupCollection(
          mojo::Clone(data_.tab_group_collection));
    case Tag::kSplitTabCollection:
      return NewSplitTabCollection(
          mojo::Clone(data_.split_tab_collection));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Data>::value>::type*>
bool Data::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTab:
      return mojo::Equals(data_.tab, other.data_.tab);
    case Tag::kTabStripCollection:
      return mojo::Equals(data_.tab_strip_collection, other.data_.tab_strip_collection);
    case Tag::kPinnedTabCollection:
      return mojo::Equals(data_.pinned_tab_collection, other.data_.pinned_tab_collection);
    case Tag::kUnpinnedTabCollection:
      return mojo::Equals(data_.unpinned_tab_collection, other.data_.unpinned_tab_collection);
    case Tag::kTabGroupCollection:
      return mojo::Equals(data_.tab_group_collection, other.data_.tab_group_collection);
    case Tag::kSplitTabCollection:
      return mojo::Equals(data_.split_tab_collection, other.data_.split_tab_collection);
  }

  return false;
}
template <typename UnionPtrType>
TabRestoreEntryPtr TabRestoreEntry::Clone() const {
  switch (tag_) {
    case Tag::kTab:
      return NewTab(
          mojo::Clone(data_.tab));
    case Tag::kWindow:
      return NewWindow(
          mojo::Clone(data_.window));
    case Tag::kGroup:
      return NewGroup(
          mojo::Clone(data_.group));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabRestoreEntry>::value>::type*>
bool TabRestoreEntry::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTab:
      return mojo::Equals(data_.tab, other.data_.tab);
    case Tag::kWindow:
      return mojo::Equals(data_.window, other.data_.window);
    case Tag::kGroup:
      return mojo::Equals(data_.group, other.data_.group);
  }

  return false;
}
template <typename StructPtrType>
ContainerPtr Container::Clone() const {
  return New(
      mojo::Clone(tabstrip_tree),
      mojo::Clone(tab_restore)
  );
}

template <typename T, Container::EnableIfSame<T>*>
bool Container::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tabstrip_tree, other_struct.tabstrip_tree))
    return false;
  if (!mojo::Equals(this->tab_restore, other_struct.tab_restore))
    return false;
  return true;
}

template <typename T, Container::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tabstrip_tree < rhs.tabstrip_tree)
    return true;
  if (rhs.tabstrip_tree < lhs.tabstrip_tree)
    return false;
  if (lhs.tab_restore < rhs.tab_restore)
    return true;
  if (rhs.tab_restore < lhs.tab_restore)
    return false;
  return false;
}
template <typename StructPtrType>
TabStripTreePtr TabStripTree::Clone() const {
  return New(
      mojo::Clone(windows)
  );
}

template <typename T, TabStripTree::EnableIfSame<T>*>
bool TabStripTree::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->windows, other_struct.windows))
    return false;
  return true;
}

template <typename T, TabStripTree::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.windows < rhs.windows)
    return true;
  if (rhs.windows < lhs.windows)
    return false;
  return false;
}
template <typename StructPtrType>
WindowNodePtr WindowNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(tabstrip_model),
      mojo::Clone(selection_model)
  );
}

template <typename T, WindowNode::EnableIfSame<T>*>
bool WindowNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->tabstrip_model, other_struct.tabstrip_model))
    return false;
  if (!mojo::Equals(this->selection_model, other_struct.selection_model))
    return false;
  return true;
}

template <typename T, WindowNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.tabstrip_model < rhs.tabstrip_model)
    return true;
  if (rhs.tabstrip_model < lhs.tabstrip_model)
    return false;
  if (lhs.selection_model < rhs.selection_model)
    return true;
  if (rhs.selection_model < lhs.selection_model)
    return false;
  return false;
}
template <typename StructPtrType>
NodeIdPtr NodeId::Clone() const {
  return New(
      mojo::Clone(node_id),
      mojo::Clone(type)
  );
}

template <typename T, NodeId::EnableIfSame<T>*>
bool NodeId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_id, other_struct.node_id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, NodeId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_id < rhs.node_id)
    return true;
  if (rhs.node_id < lhs.node_id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
TabStripModelPtr TabStripModel::Clone() const {
  return New(
      mojo::Clone(root)
  );
}

template <typename T, TabStripModel::EnableIfSame<T>*>
bool TabStripModel::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->root, other_struct.root))
    return false;
  return true;
}

template <typename T, TabStripModel::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.root < rhs.root)
    return true;
  if (rhs.root < lhs.root)
    return false;
  return false;
}
template <typename StructPtrType>
NodePtr Node::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(children)
  );
}

template <typename T, Node::EnableIfSame<T>*>
bool Node::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, Node::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}
template <typename StructPtrType>
TabPtr Tab::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(active),
      mojo::Clone(visible),
      mojo::Clone(selected),
      mojo::Clone(pinned),
      mojo::Clone(split),
      mojo::Clone(alert_states)
  );
}

template <typename T, Tab::EnableIfSame<T>*>
bool Tab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  if (!mojo::Equals(this->visible, other_struct.visible))
    return false;
  if (!mojo::Equals(this->selected, other_struct.selected))
    return false;
  if (!mojo::Equals(this->pinned, other_struct.pinned))
    return false;
  if (!mojo::Equals(this->split, other_struct.split))
    return false;
  if (!mojo::Equals(this->alert_states, other_struct.alert_states))
    return false;
  return true;
}

template <typename T, Tab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  if (lhs.visible < rhs.visible)
    return true;
  if (rhs.visible < lhs.visible)
    return false;
  if (lhs.selected < rhs.selected)
    return true;
  if (rhs.selected < lhs.selected)
    return false;
  if (lhs.pinned < rhs.pinned)
    return true;
  if (rhs.pinned < lhs.pinned)
    return false;
  if (lhs.split < rhs.split)
    return true;
  if (rhs.split < lhs.split)
    return false;
  if (lhs.alert_states < rhs.alert_states)
    return true;
  if (rhs.alert_states < lhs.alert_states)
    return false;
  return false;
}
template <typename StructPtrType>
TabStripCollectionPtr TabStripCollection::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, TabStripCollection::EnableIfSame<T>*>
bool TabStripCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, TabStripCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
PinnedCollectionPtr PinnedCollection::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, PinnedCollection::EnableIfSame<T>*>
bool PinnedCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, PinnedCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
UnpinnedCollectionPtr UnpinnedCollection::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, UnpinnedCollection::EnableIfSame<T>*>
bool UnpinnedCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, UnpinnedCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
GroupCollectionPtr GroupCollection::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(visualData)
  );
}

template <typename T, GroupCollection::EnableIfSame<T>*>
bool GroupCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->visualData, other_struct.visualData))
    return false;
  return true;
}

template <typename T, GroupCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.visualData < rhs.visualData)
    return true;
  if (rhs.visualData < lhs.visualData)
    return false;
  return false;
}
template <typename StructPtrType>
TabGroupVisualDataPtr TabGroupVisualData::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(color),
      mojo::Clone(is_collapsed)
  );
}

template <typename T, TabGroupVisualData::EnableIfSame<T>*>
bool TabGroupVisualData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->is_collapsed, other_struct.is_collapsed))
    return false;
  return true;
}

template <typename T, TabGroupVisualData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.is_collapsed < rhs.is_collapsed)
    return true;
  if (rhs.is_collapsed < lhs.is_collapsed)
    return false;
  return false;
}
template <typename StructPtrType>
SplitCollectionPtr SplitCollection::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(visualData)
  );
}

template <typename T, SplitCollection::EnableIfSame<T>*>
bool SplitCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->visualData, other_struct.visualData))
    return false;
  return true;
}

template <typename T, SplitCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.visualData < rhs.visualData)
    return true;
  if (rhs.visualData < lhs.visualData)
    return false;
  return false;
}
template <typename StructPtrType>
SplitTabVisualDataPtr SplitTabVisualData::Clone() const {
  return New(
      mojo::Clone(layout),
      mojo::Clone(split_ratio)
  );
}

template <typename T, SplitTabVisualData::EnableIfSame<T>*>
bool SplitTabVisualData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->split_ratio, other_struct.split_ratio))
    return false;
  return true;
}

template <typename T, SplitTabVisualData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.split_ratio < rhs.split_ratio)
    return true;
  if (rhs.split_ratio < lhs.split_ratio)
    return false;
  return false;
}
template <typename StructPtrType>
SelectionModelPtr SelectionModel::Clone() const {
  return New(
      mojo::Clone(active_index),
      mojo::Clone(anchor_index),
      mojo::Clone(selected_indices)
  );
}

template <typename T, SelectionModel::EnableIfSame<T>*>
bool SelectionModel::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->active_index, other_struct.active_index))
    return false;
  if (!mojo::Equals(this->anchor_index, other_struct.anchor_index))
    return false;
  if (!mojo::Equals(this->selected_indices, other_struct.selected_indices))
    return false;
  return true;
}

template <typename T, SelectionModel::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.active_index < rhs.active_index)
    return true;
  if (rhs.active_index < lhs.active_index)
    return false;
  if (lhs.anchor_index < rhs.anchor_index)
    return true;
  if (rhs.anchor_index < lhs.anchor_index)
    return false;
  if (lhs.selected_indices < rhs.selected_indices)
    return true;
  if (rhs.selected_indices < lhs.selected_indices)
    return false;
  return false;
}
template <typename StructPtrType>
TabRestoreDataPtr TabRestoreData::Clone() const {
  return New(
      mojo::Clone(entries)
  );
}

template <typename T, TabRestoreData::EnableIfSame<T>*>
bool TabRestoreData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->entries, other_struct.entries))
    return false;
  return true;
}

template <typename T, TabRestoreData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.entries < rhs.entries)
    return true;
  if (rhs.entries < lhs.entries)
    return false;
  return false;
}
template <typename StructPtrType>
TabRestoreEntryBasePtr TabRestoreEntryBase::Clone() const {
  return New(
      mojo::Clone(original_id),
      mojo::Clone(timestamp)
  );
}

template <typename T, TabRestoreEntryBase::EnableIfSame<T>*>
bool TabRestoreEntryBase::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->original_id, other_struct.original_id))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  return true;
}

template <typename T, TabRestoreEntryBase::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.original_id < rhs.original_id)
    return true;
  if (rhs.original_id < lhs.original_id)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
TabRestoreTabPtr TabRestoreTab::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(restore_entry),
      mojo::Clone(browser_id),
      mojo::Clone(tabstrip_index),
      mojo::Clone(pinned),
      mojo::Clone(group_id),
      mojo::Clone(group_visual_data),
      mojo::Clone(title),
      mojo::Clone(url)
  );
}

template <typename T, TabRestoreTab::EnableIfSame<T>*>
bool TabRestoreTab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->restore_entry, other_struct.restore_entry))
    return false;
  if (!mojo::Equals(this->browser_id, other_struct.browser_id))
    return false;
  if (!mojo::Equals(this->tabstrip_index, other_struct.tabstrip_index))
    return false;
  if (!mojo::Equals(this->pinned, other_struct.pinned))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->group_visual_data, other_struct.group_visual_data))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, TabRestoreTab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.restore_entry < rhs.restore_entry)
    return true;
  if (rhs.restore_entry < lhs.restore_entry)
    return false;
  if (lhs.browser_id < rhs.browser_id)
    return true;
  if (rhs.browser_id < lhs.browser_id)
    return false;
  if (lhs.tabstrip_index < rhs.tabstrip_index)
    return true;
  if (rhs.tabstrip_index < lhs.tabstrip_index)
    return false;
  if (lhs.pinned < rhs.pinned)
    return true;
  if (rhs.pinned < lhs.pinned)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.group_visual_data < rhs.group_visual_data)
    return true;
  if (rhs.group_visual_data < lhs.group_visual_data)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
TabRestoreGroupPtr TabRestoreGroup::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(restore_entry),
      mojo::Clone(browser_id),
      mojo::Clone(group_id),
      mojo::Clone(visual_data),
      mojo::Clone(tabs)
  );
}

template <typename T, TabRestoreGroup::EnableIfSame<T>*>
bool TabRestoreGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->restore_entry, other_struct.restore_entry))
    return false;
  if (!mojo::Equals(this->browser_id, other_struct.browser_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->visual_data, other_struct.visual_data))
    return false;
  if (!mojo::Equals(this->tabs, other_struct.tabs))
    return false;
  return true;
}

template <typename T, TabRestoreGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.restore_entry < rhs.restore_entry)
    return true;
  if (rhs.restore_entry < lhs.restore_entry)
    return false;
  if (lhs.browser_id < rhs.browser_id)
    return true;
  if (rhs.browser_id < lhs.browser_id)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.visual_data < rhs.visual_data)
    return true;
  if (rhs.visual_data < lhs.visual_data)
    return false;
  if (lhs.tabs < rhs.tabs)
    return true;
  if (rhs.tabs < lhs.tabs)
    return false;
  return false;
}
template <typename StructPtrType>
TabRestoreWindowPtr TabRestoreWindow::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(restore_entry),
      mojo::Clone(selected_tab_index),
      mojo::Clone(tabs)
  );
}

template <typename T, TabRestoreWindow::EnableIfSame<T>*>
bool TabRestoreWindow::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->restore_entry, other_struct.restore_entry))
    return false;
  if (!mojo::Equals(this->selected_tab_index, other_struct.selected_tab_index))
    return false;
  if (!mojo::Equals(this->tabs, other_struct.tabs))
    return false;
  return true;
}

template <typename T, TabRestoreWindow::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.restore_entry < rhs.restore_entry)
    return true;
  if (rhs.restore_entry < lhs.restore_entry)
    return false;
  if (lhs.selected_tab_index < rhs.selected_tab_index)
    return true;
  if (rhs.selected_tab_index < lhs.selected_tab_index)
    return false;
  if (lhs.tabs < rhs.tabs)
    return true;
  if (rhs.tabs < lhs.tabs)
    return false;
  return false;
}


}  // tab_strip_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::tab_strip_internals::mojom::Container::DataView,
                                         ::tab_strip_internals::mojom::ContainerPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::ContainerPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::ContainerPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::Container::tabstrip_tree)& tabstrip_tree(
      const ::tab_strip_internals::mojom::ContainerPtr& input) {
    return input->tabstrip_tree;
  }

  static const decltype(::tab_strip_internals::mojom::Container::tab_restore)& tab_restore(
      const ::tab_strip_internals::mojom::ContainerPtr& input) {
    return input->tab_restore;
  }

  static bool Read(::tab_strip_internals::mojom::Container::DataView input, ::tab_strip_internals::mojom::ContainerPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabStripTree::DataView,
                                         ::tab_strip_internals::mojom::TabStripTreePtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabStripTreePtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabStripTreePtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabStripTree::windows)& windows(
      const ::tab_strip_internals::mojom::TabStripTreePtr& input) {
    return input->windows;
  }

  static bool Read(::tab_strip_internals::mojom::TabStripTree::DataView input, ::tab_strip_internals::mojom::TabStripTreePtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::WindowNode::DataView,
                                         ::tab_strip_internals::mojom::WindowNodePtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::WindowNodePtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::WindowNodePtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::WindowNode::id)& id(
      const ::tab_strip_internals::mojom::WindowNodePtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::WindowNode::tabstrip_model)& tabstrip_model(
      const ::tab_strip_internals::mojom::WindowNodePtr& input) {
    return input->tabstrip_model;
  }

  static const decltype(::tab_strip_internals::mojom::WindowNode::selection_model)& selection_model(
      const ::tab_strip_internals::mojom::WindowNodePtr& input) {
    return input->selection_model;
  }

  static bool Read(::tab_strip_internals::mojom::WindowNode::DataView input, ::tab_strip_internals::mojom::WindowNodePtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::NodeId::DataView,
                                         ::tab_strip_internals::mojom::NodeIdPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::NodeIdPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::NodeIdPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::NodeId::node_id)& node_id(
      const ::tab_strip_internals::mojom::NodeIdPtr& input) {
    return input->node_id;
  }

  static decltype(::tab_strip_internals::mojom::NodeId::type) type(
      const ::tab_strip_internals::mojom::NodeIdPtr& input) {
    return input->type;
  }

  static bool Read(::tab_strip_internals::mojom::NodeId::DataView input, ::tab_strip_internals::mojom::NodeIdPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabStripModel::DataView,
                                         ::tab_strip_internals::mojom::TabStripModelPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabStripModelPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabStripModelPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabStripModel::root)& root(
      const ::tab_strip_internals::mojom::TabStripModelPtr& input) {
    return input->root;
  }

  static bool Read(::tab_strip_internals::mojom::TabStripModel::DataView input, ::tab_strip_internals::mojom::TabStripModelPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::Node::DataView,
                                         ::tab_strip_internals::mojom::NodePtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::NodePtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::NodePtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::Node::data)& data(
      const ::tab_strip_internals::mojom::NodePtr& input) {
    return input->data;
  }

  static const decltype(::tab_strip_internals::mojom::Node::children)& children(
      const ::tab_strip_internals::mojom::NodePtr& input) {
    return input->children;
  }

  static bool Read(::tab_strip_internals::mojom::Node::DataView input, ::tab_strip_internals::mojom::NodePtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::Tab::DataView,
                                         ::tab_strip_internals::mojom::TabPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::Tab::id)& id(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::Tab::title)& title(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->title;
  }

  static const decltype(::tab_strip_internals::mojom::Tab::url)& url(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->url;
  }

  static decltype(::tab_strip_internals::mojom::Tab::active) active(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->active;
  }

  static decltype(::tab_strip_internals::mojom::Tab::visible) visible(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->visible;
  }

  static decltype(::tab_strip_internals::mojom::Tab::selected) selected(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->selected;
  }

  static decltype(::tab_strip_internals::mojom::Tab::pinned) pinned(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->pinned;
  }

  static decltype(::tab_strip_internals::mojom::Tab::split) split(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->split;
  }

  static const decltype(::tab_strip_internals::mojom::Tab::alert_states)& alert_states(
      const ::tab_strip_internals::mojom::TabPtr& input) {
    return input->alert_states;
  }

  static bool Read(::tab_strip_internals::mojom::Tab::DataView input, ::tab_strip_internals::mojom::TabPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabStripCollection::DataView,
                                         ::tab_strip_internals::mojom::TabStripCollectionPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabStripCollectionPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabStripCollectionPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabStripCollection::id)& id(
      const ::tab_strip_internals::mojom::TabStripCollectionPtr& input) {
    return input->id;
  }

  static bool Read(::tab_strip_internals::mojom::TabStripCollection::DataView input, ::tab_strip_internals::mojom::TabStripCollectionPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::PinnedCollection::DataView,
                                         ::tab_strip_internals::mojom::PinnedCollectionPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::PinnedCollectionPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::PinnedCollectionPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::PinnedCollection::id)& id(
      const ::tab_strip_internals::mojom::PinnedCollectionPtr& input) {
    return input->id;
  }

  static bool Read(::tab_strip_internals::mojom::PinnedCollection::DataView input, ::tab_strip_internals::mojom::PinnedCollectionPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::UnpinnedCollection::DataView,
                                         ::tab_strip_internals::mojom::UnpinnedCollectionPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::UnpinnedCollectionPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::UnpinnedCollectionPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::UnpinnedCollection::id)& id(
      const ::tab_strip_internals::mojom::UnpinnedCollectionPtr& input) {
    return input->id;
  }

  static bool Read(::tab_strip_internals::mojom::UnpinnedCollection::DataView input, ::tab_strip_internals::mojom::UnpinnedCollectionPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::GroupCollection::DataView,
                                         ::tab_strip_internals::mojom::GroupCollectionPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::GroupCollectionPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::GroupCollectionPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::GroupCollection::id)& id(
      const ::tab_strip_internals::mojom::GroupCollectionPtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::GroupCollection::visualData)& visualData(
      const ::tab_strip_internals::mojom::GroupCollectionPtr& input) {
    return input->visualData;
  }

  static bool Read(::tab_strip_internals::mojom::GroupCollection::DataView input, ::tab_strip_internals::mojom::GroupCollectionPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabGroupVisualData::DataView,
                                         ::tab_strip_internals::mojom::TabGroupVisualDataPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabGroupVisualDataPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabGroupVisualDataPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabGroupVisualData::title)& title(
      const ::tab_strip_internals::mojom::TabGroupVisualDataPtr& input) {
    return input->title;
  }

  static decltype(::tab_strip_internals::mojom::TabGroupVisualData::color) color(
      const ::tab_strip_internals::mojom::TabGroupVisualDataPtr& input) {
    return input->color;
  }

  static decltype(::tab_strip_internals::mojom::TabGroupVisualData::is_collapsed) is_collapsed(
      const ::tab_strip_internals::mojom::TabGroupVisualDataPtr& input) {
    return input->is_collapsed;
  }

  static bool Read(::tab_strip_internals::mojom::TabGroupVisualData::DataView input, ::tab_strip_internals::mojom::TabGroupVisualDataPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::SplitCollection::DataView,
                                         ::tab_strip_internals::mojom::SplitCollectionPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::SplitCollectionPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::SplitCollectionPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::SplitCollection::id)& id(
      const ::tab_strip_internals::mojom::SplitCollectionPtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::SplitCollection::visualData)& visualData(
      const ::tab_strip_internals::mojom::SplitCollectionPtr& input) {
    return input->visualData;
  }

  static bool Read(::tab_strip_internals::mojom::SplitCollection::DataView input, ::tab_strip_internals::mojom::SplitCollectionPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::SplitTabVisualData::DataView,
                                         ::tab_strip_internals::mojom::SplitTabVisualDataPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::SplitTabVisualDataPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::SplitTabVisualDataPtr* output) { output->reset(); }

  static decltype(::tab_strip_internals::mojom::SplitTabVisualData::layout) layout(
      const ::tab_strip_internals::mojom::SplitTabVisualDataPtr& input) {
    return input->layout;
  }

  static decltype(::tab_strip_internals::mojom::SplitTabVisualData::split_ratio) split_ratio(
      const ::tab_strip_internals::mojom::SplitTabVisualDataPtr& input) {
    return input->split_ratio;
  }

  static bool Read(::tab_strip_internals::mojom::SplitTabVisualData::DataView input, ::tab_strip_internals::mojom::SplitTabVisualDataPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::SelectionModel::DataView,
                                         ::tab_strip_internals::mojom::SelectionModelPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::SelectionModelPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::SelectionModelPtr* output) { output->reset(); }

  static decltype(::tab_strip_internals::mojom::SelectionModel::active_index) active_index(
      const ::tab_strip_internals::mojom::SelectionModelPtr& input) {
    return input->active_index;
  }

  static decltype(::tab_strip_internals::mojom::SelectionModel::anchor_index) anchor_index(
      const ::tab_strip_internals::mojom::SelectionModelPtr& input) {
    return input->anchor_index;
  }

  static const decltype(::tab_strip_internals::mojom::SelectionModel::selected_indices)& selected_indices(
      const ::tab_strip_internals::mojom::SelectionModelPtr& input) {
    return input->selected_indices;
  }

  static bool Read(::tab_strip_internals::mojom::SelectionModel::DataView input, ::tab_strip_internals::mojom::SelectionModelPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabRestoreData::DataView,
                                         ::tab_strip_internals::mojom::TabRestoreDataPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabRestoreDataPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabRestoreDataPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabRestoreData::entries)& entries(
      const ::tab_strip_internals::mojom::TabRestoreDataPtr& input) {
    return input->entries;
  }

  static bool Read(::tab_strip_internals::mojom::TabRestoreData::DataView input, ::tab_strip_internals::mojom::TabRestoreDataPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabRestoreEntryBase::DataView,
                                         ::tab_strip_internals::mojom::TabRestoreEntryBasePtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabRestoreEntryBasePtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabRestoreEntryBasePtr* output) { output->reset(); }

  static decltype(::tab_strip_internals::mojom::TabRestoreEntryBase::original_id) original_id(
      const ::tab_strip_internals::mojom::TabRestoreEntryBasePtr& input) {
    return input->original_id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreEntryBase::timestamp)& timestamp(
      const ::tab_strip_internals::mojom::TabRestoreEntryBasePtr& input) {
    return input->timestamp;
  }

  static bool Read(::tab_strip_internals::mojom::TabRestoreEntryBase::DataView input, ::tab_strip_internals::mojom::TabRestoreEntryBasePtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabRestoreTab::DataView,
                                         ::tab_strip_internals::mojom::TabRestoreTabPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabRestoreTabPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabRestoreTab::id)& id(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreTab::restore_entry)& restore_entry(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->restore_entry;
  }

  static decltype(::tab_strip_internals::mojom::TabRestoreTab::browser_id) browser_id(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->browser_id;
  }

  static decltype(::tab_strip_internals::mojom::TabRestoreTab::tabstrip_index) tabstrip_index(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->tabstrip_index;
  }

  static decltype(::tab_strip_internals::mojom::TabRestoreTab::pinned) pinned(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->pinned;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreTab::group_id)& group_id(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->group_id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreTab::group_visual_data)& group_visual_data(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->group_visual_data;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreTab::title)& title(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->title;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreTab::url)& url(
      const ::tab_strip_internals::mojom::TabRestoreTabPtr& input) {
    return input->url;
  }

  static bool Read(::tab_strip_internals::mojom::TabRestoreTab::DataView input, ::tab_strip_internals::mojom::TabRestoreTabPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabRestoreGroup::DataView,
                                         ::tab_strip_internals::mojom::TabRestoreGroupPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabRestoreGroupPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabRestoreGroup::id)& id(
      const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreGroup::restore_entry)& restore_entry(
      const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) {
    return input->restore_entry;
  }

  static decltype(::tab_strip_internals::mojom::TabRestoreGroup::browser_id) browser_id(
      const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) {
    return input->browser_id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreGroup::group_id)& group_id(
      const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) {
    return input->group_id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreGroup::visual_data)& visual_data(
      const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) {
    return input->visual_data;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreGroup::tabs)& tabs(
      const ::tab_strip_internals::mojom::TabRestoreGroupPtr& input) {
    return input->tabs;
  }

  static bool Read(::tab_strip_internals::mojom::TabRestoreGroup::DataView input, ::tab_strip_internals::mojom::TabRestoreGroupPtr* output);
};


template <>
struct  StructTraits<::tab_strip_internals::mojom::TabRestoreWindow::DataView,
                                         ::tab_strip_internals::mojom::TabRestoreWindowPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabRestoreWindowPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabRestoreWindowPtr* output) { output->reset(); }

  static const decltype(::tab_strip_internals::mojom::TabRestoreWindow::id)& id(
      const ::tab_strip_internals::mojom::TabRestoreWindowPtr& input) {
    return input->id;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreWindow::restore_entry)& restore_entry(
      const ::tab_strip_internals::mojom::TabRestoreWindowPtr& input) {
    return input->restore_entry;
  }

  static decltype(::tab_strip_internals::mojom::TabRestoreWindow::selected_tab_index) selected_tab_index(
      const ::tab_strip_internals::mojom::TabRestoreWindowPtr& input) {
    return input->selected_tab_index;
  }

  static const decltype(::tab_strip_internals::mojom::TabRestoreWindow::tabs)& tabs(
      const ::tab_strip_internals::mojom::TabRestoreWindowPtr& input) {
    return input->tabs;
  }

  static bool Read(::tab_strip_internals::mojom::TabRestoreWindow::DataView input, ::tab_strip_internals::mojom::TabRestoreWindowPtr* output);
};


template <>
struct  UnionTraits<::tab_strip_internals::mojom::Data::DataView,
                                        ::tab_strip_internals::mojom::DataPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::DataPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::DataPtr* output) { output->reset(); }

  static ::tab_strip_internals::mojom::Data::Tag GetTag(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->which();
  }

  static const ::tab_strip_internals::mojom::TabPtr& tab(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->get_tab();
  }

  static const ::tab_strip_internals::mojom::TabStripCollectionPtr& tab_strip_collection(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->get_tab_strip_collection();
  }

  static const ::tab_strip_internals::mojom::PinnedCollectionPtr& pinned_tab_collection(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->get_pinned_tab_collection();
  }

  static const ::tab_strip_internals::mojom::UnpinnedCollectionPtr& unpinned_tab_collection(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->get_unpinned_tab_collection();
  }

  static const ::tab_strip_internals::mojom::GroupCollectionPtr& tab_group_collection(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->get_tab_group_collection();
  }

  static const ::tab_strip_internals::mojom::SplitCollectionPtr& split_tab_collection(const ::tab_strip_internals::mojom::DataPtr& input) {
    return input->get_split_tab_collection();
  }

  static bool Read(::tab_strip_internals::mojom::Data::DataView input, ::tab_strip_internals::mojom::DataPtr* output);
};


template <>
struct  UnionTraits<::tab_strip_internals::mojom::TabRestoreEntry::DataView,
                                        ::tab_strip_internals::mojom::TabRestoreEntryPtr> {
  static bool IsNull(const ::tab_strip_internals::mojom::TabRestoreEntryPtr& input) { return !input; }
  static void SetToNull(::tab_strip_internals::mojom::TabRestoreEntryPtr* output) { output->reset(); }

  static ::tab_strip_internals::mojom::TabRestoreEntry::Tag GetTag(const ::tab_strip_internals::mojom::TabRestoreEntryPtr& input) {
    return input->which();
  }

  static const ::tab_strip_internals::mojom::TabRestoreTabPtr& tab(const ::tab_strip_internals::mojom::TabRestoreEntryPtr& input) {
    return input->get_tab();
  }

  static const ::tab_strip_internals::mojom::TabRestoreWindowPtr& window(const ::tab_strip_internals::mojom::TabRestoreEntryPtr& input) {
    return input->get_window();
  }

  static const ::tab_strip_internals::mojom::TabRestoreGroupPtr& group(const ::tab_strip_internals::mojom::TabRestoreEntryPtr& input) {
    return input->get_group();
  }

  static bool Read(::tab_strip_internals::mojom::TabRestoreEntry::DataView input, ::tab_strip_internals::mojom::TabRestoreEntryPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_H_