// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared-internal.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::tab_strip_internals::mojom::NodeId_Type>
    : public mojo::internal::EnumHashImpl<::tab_strip_internals::mojom::NodeId_Type> {};

template <>
struct hash<::tab_strip_internals::mojom::SplitTabVisualData_Layout>
    : public mojo::internal::EnumHashImpl<::tab_strip_internals::mojom::SplitTabVisualData_Layout> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::NodeId_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_strip_internals::mojom::NodeId_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_strip_internals::mojom::NodeId_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SplitTabVisualData_Layout, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tab_strip_internals::mojom::SplitTabVisualData_Layout, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::ContainerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::ContainerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::Container_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tabstrip_tree(input)) in_tabstrip_tree = Traits::tabstrip_tree(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabstrip_tree)::BaseType> tabstrip_tree_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabStripTreeDataView>(
      in_tabstrip_tree,
      tabstrip_tree_fragment);

    fragment->tabstrip_tree.Set(
        tabstrip_tree_fragment.is_null() ? nullptr : tabstrip_tree_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabstrip_tree.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabstrip_tree in Container struct");

    decltype(Traits::tab_restore(input)) in_tab_restore = Traits::tab_restore(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_restore)::BaseType> tab_restore_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreDataDataView>(
      in_tab_restore,
      tab_restore_fragment);

    fragment->tab_restore.Set(
        tab_restore_fragment.is_null() ? nullptr : tab_restore_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_restore.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_restore in Container struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Container_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::ContainerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabStripTreeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabStripTreeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabStripTree_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::windows(input)) in_windows = Traits::windows(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->windows)::BaseType>
        windows_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::WindowNodeDataView>>(
      in_windows,
      windows_fragment,
      &windows_validate_params);

    fragment->windows.Set(
        windows_fragment.is_null() ? nullptr : windows_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->windows.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null windows in TabStripTree struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabStripTree_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabStripTreeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::WindowNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::WindowNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::WindowNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in WindowNode struct");

    decltype(Traits::tabstrip_model(input)) in_tabstrip_model = Traits::tabstrip_model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabstrip_model)::BaseType> tabstrip_model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabStripModelDataView>(
      in_tabstrip_model,
      tabstrip_model_fragment);

    fragment->tabstrip_model.Set(
        tabstrip_model_fragment.is_null() ? nullptr : tabstrip_model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabstrip_model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabstrip_model in WindowNode struct");

    decltype(Traits::selection_model(input)) in_selection_model = Traits::selection_model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection_model)::BaseType> selection_model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::SelectionModelDataView>(
      in_selection_model,
      selection_model_fragment);

    fragment->selection_model.Set(
        selection_model_fragment.is_null() ? nullptr : selection_model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selection_model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selection_model in WindowNode struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::WindowNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::WindowNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::NodeIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::NodeIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::NodeId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::node_id(input)) in_node_id = Traits::node_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->node_id)::BaseType> node_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_node_id,
      node_id_fragment);

    fragment->node_id.Set(
        node_id_fragment.is_null() ? nullptr : node_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->node_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null node_id in NodeId struct");

    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeId_Type>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::NodeId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::NodeIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabStripModelDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabStripModelDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabStripModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::root(input)) in_root = Traits::root(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root)::BaseType> root_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeDataView>(
      in_root,
      root_fragment);

    fragment->root.Set(
        root_fragment.is_null() ? nullptr : root_fragment.data());
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabStripModel_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabStripModelDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::NodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::NodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::Node_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::DataDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Node struct");

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::NodeDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in Node struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Node_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::NodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in Tab struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Tab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Tab struct");

    fragment->active = Traits::active(input);

    fragment->visible = Traits::visible(input);

    fragment->selected = Traits::selected(input);

    fragment->pinned = Traits::pinned(input);

    fragment->split = Traits::split(input);

    decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alert_states)::BaseType>
        alert_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
      in_alert_states,
      alert_states_fragment,
      &alert_states_validate_params);

    fragment->alert_states.Set(
        alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alert_states.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_states in Tab struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Tab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabStripCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabStripCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabStripCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabStripCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabStripCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabStripCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::PinnedCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::PinnedCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::PinnedCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PinnedCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::PinnedCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::PinnedCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::UnpinnedCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::UnpinnedCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::UnpinnedCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in UnpinnedCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::UnpinnedCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::UnpinnedCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::GroupCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::GroupCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::GroupCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GroupCollection struct");

    decltype(Traits::visualData(input)) in_visualData = Traits::visualData(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visualData)::BaseType> visualData_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
      in_visualData,
      visualData_fragment);

    fragment->visualData.Set(
        visualData_fragment.is_null() ? nullptr : visualData_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visualData.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visualData in GroupCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::GroupCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::GroupCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabGroupVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabGroupVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabGroupVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabGroupVisualData struct");

    
    mojo::internal::Serialize<::tab_groups::mojom::Color>(
      Traits::color(input),
      &fragment->color);

    fragment->is_collapsed = Traits::is_collapsed(input);
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabGroupVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabGroupVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SplitCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::SplitCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::SplitCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in SplitCollection struct");

    decltype(Traits::visualData(input)) in_visualData = Traits::visualData(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visualData)::BaseType> visualData_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::SplitTabVisualDataDataView>(
      in_visualData,
      visualData_fragment);

    fragment->visualData.Set(
        visualData_fragment.is_null() ? nullptr : visualData_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visualData.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visualData in SplitCollection struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::SplitCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::SplitCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SplitTabVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::SplitTabVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::SplitTabVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(
      Traits::layout(input),
      &fragment->layout);

    fragment->split_ratio = Traits::split_ratio(input);
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::SplitTabVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::SplitTabVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::SelectionModelDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::SelectionModelDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::SelectionModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->active_index = Traits::active_index(input);

    fragment->anchor_index = Traits::anchor_index(input);

    decltype(Traits::selected_indices(input)) in_selected_indices = Traits::selected_indices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_indices)::BaseType>
        selected_indices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& selected_indices_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_selected_indices,
      selected_indices_fragment,
      &selected_indices_validate_params);

    fragment->selected_indices.Set(
        selected_indices_fragment.is_null() ? nullptr : selected_indices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selected_indices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selected_indices in SelectionModel struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::SelectionModel_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::SelectionModelDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabRestoreDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabRestoreDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabRestoreData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::entries(input)) in_entries = Traits::entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->entries)::BaseType>
        entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::TabRestoreEntryDataView>>(
      in_entries,
      entries_fragment,
      &entries_validate_params);

    fragment->entries.Set(
        entries_fragment.is_null() ? nullptr : entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in TabRestoreData struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabRestoreData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabRestoreDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabRestoreEntryBase_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->original_id = Traits::original_id(input);

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabRestoreEntryBase_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabRestoreEntryBaseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabRestoreTabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabRestoreTabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabRestoreTab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabRestoreTab struct");

    decltype(Traits::restore_entry(input)) in_restore_entry = Traits::restore_entry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->restore_entry)::BaseType> restore_entry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView>(
      in_restore_entry,
      restore_entry_fragment);

    fragment->restore_entry.Set(
        restore_entry_fragment.is_null() ? nullptr : restore_entry_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->restore_entry.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null restore_entry in TabRestoreTab struct");

    fragment->browser_id = Traits::browser_id(input);

    fragment->tabstrip_index = Traits::tabstrip_index(input);

    fragment->pinned = Traits::pinned(input);

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    decltype(Traits::group_visual_data(input)) in_group_visual_data = Traits::group_visual_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_visual_data)::BaseType> group_visual_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
      in_group_visual_data,
      group_visual_data_fragment);

    fragment->group_visual_data.Set(
        group_visual_data_fragment.is_null() ? nullptr : group_visual_data_fragment.data());

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabRestoreTab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in TabRestoreTab struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabRestoreTab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabRestoreTabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabRestoreGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabRestoreGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabRestoreGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabRestoreGroup struct");

    decltype(Traits::restore_entry(input)) in_restore_entry = Traits::restore_entry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->restore_entry)::BaseType> restore_entry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView>(
      in_restore_entry,
      restore_entry_fragment);

    fragment->restore_entry.Set(
        restore_entry_fragment.is_null() ? nullptr : restore_entry_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->restore_entry.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null restore_entry in TabRestoreGroup struct");

    fragment->browser_id = Traits::browser_id(input);

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in TabRestoreGroup struct");

    decltype(Traits::visual_data(input)) in_visual_data = Traits::visual_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visual_data)::BaseType> visual_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
      in_visual_data,
      visual_data_fragment);

    fragment->visual_data.Set(
        visual_data_fragment.is_null() ? nullptr : visual_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visual_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visual_data in TabRestoreGroup struct");

    decltype(Traits::tabs(input)) in_tabs = Traits::tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabs)::BaseType>
        tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::TabRestoreTabDataView>>(
      in_tabs,
      tabs_fragment,
      &tabs_validate_params);

    fragment->tabs.Set(
        tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabs in TabRestoreGroup struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabRestoreGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabRestoreGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabRestoreWindowDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tab_strip_internals::mojom::TabRestoreWindowDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tab_strip_internals::mojom::internal::TabRestoreWindow_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabRestoreWindow struct");

    decltype(Traits::restore_entry(input)) in_restore_entry = Traits::restore_entry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->restore_entry)::BaseType> restore_entry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView>(
      in_restore_entry,
      restore_entry_fragment);

    fragment->restore_entry.Set(
        restore_entry_fragment.is_null() ? nullptr : restore_entry_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->restore_entry.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null restore_entry in TabRestoreWindow struct");

    fragment->selected_tab_index = Traits::selected_tab_index(input);

    decltype(Traits::tabs(input)) in_tabs = Traits::tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tabs)::BaseType>
        tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip_internals::mojom::TabRestoreTabDataView>>(
      in_tabs,
      tabs_fragment,
      &tabs_validate_params);

    fragment->tabs.Set(
        tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tabs in TabRestoreWindow struct");
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabRestoreWindow_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabRestoreWindowDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::DataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tab_strip_internals::mojom::DataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tab_strip_internals::mojom::internal::Data_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tab_strip_internals::mojom::DataDataView::Tag::kTab: {
    decltype(Traits::tab(input))
    in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabDataView>(
  in_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab in Data union");
    fragment->data.f_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kTabStripCollection: {
    decltype(Traits::tab_strip_collection(input))
    in_tab_strip_collection = Traits::tab_strip_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_strip_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabStripCollectionDataView>(
  in_tab_strip_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_strip_collection in Data union");
    fragment->data.f_tab_strip_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kPinnedTabCollection: {
    decltype(Traits::pinned_tab_collection(input))
    in_pinned_tab_collection = Traits::pinned_tab_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pinned_tab_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::PinnedCollectionDataView>(
  in_pinned_tab_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pinned_tab_collection in Data union");
    fragment->data.f_pinned_tab_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kUnpinnedTabCollection: {
    decltype(Traits::unpinned_tab_collection(input))
    in_unpinned_tab_collection = Traits::unpinned_tab_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unpinned_tab_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::UnpinnedCollectionDataView>(
  in_unpinned_tab_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unpinned_tab_collection in Data union");
    fragment->data.f_unpinned_tab_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kTabGroupCollection: {
    decltype(Traits::tab_group_collection(input))
    in_tab_group_collection = Traits::tab_group_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_group_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::GroupCollectionDataView>(
  in_tab_group_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_group_collection in Data union");
    fragment->data.f_tab_group_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::DataDataView::Tag::kSplitTabCollection: {
    decltype(Traits::split_tab_collection(input))
    in_split_tab_collection = Traits::split_tab_collection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_split_tab_collection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::SplitCollectionDataView>(
  in_split_tab_collection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null split_tab_collection in Data union");
    fragment->data.f_split_tab_collection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::Data_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::DataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tab_strip_internals::mojom::TabRestoreEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tab_strip_internals::mojom::TabRestoreEntryDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tab_strip_internals::mojom::internal::TabRestoreEntry_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tab_strip_internals::mojom::TabRestoreEntryDataView::Tag::kTab: {
    decltype(Traits::tab(input))
    in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreTabDataView>(
  in_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab in TabRestoreEntry union");
    fragment->data.f_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::TabRestoreEntryDataView::Tag::kWindow: {
    decltype(Traits::window(input))
    in_window = Traits::window(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_window)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreWindowDataView>(
  in_window,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null window in TabRestoreEntry union");
    fragment->data.f_window.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tab_strip_internals::mojom::TabRestoreEntryDataView::Tag::kGroup: {
    decltype(Traits::group(input))
    in_group = Traits::group(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_group)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tab_strip_internals::mojom::TabRestoreGroupDataView>(
  in_group,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null group in TabRestoreEntry union");
    fragment->data.f_group.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tab_strip_internals::mojom::internal::TabRestoreEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tab_strip_internals::mojom::TabRestoreEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tab_strip_internals::mojom {

inline void ContainerDataView::GetTabstripTreeDataView(
    TabStripTreeDataView* output) {
  auto pointer = data_->tabstrip_tree.Get();
  *output = TabStripTreeDataView(pointer, message_);
}
inline void ContainerDataView::GetTabRestoreDataView(
    TabRestoreDataDataView* output) {
  auto pointer = data_->tab_restore.Get();
  *output = TabRestoreDataDataView(pointer, message_);
}


inline void TabStripTreeDataView::GetWindowsDataView(
    mojo::ArrayDataView<WindowNodeDataView>* output) {
  auto pointer = data_->windows.Get();
  *output = mojo::ArrayDataView<WindowNodeDataView>(pointer, message_);
}


inline void WindowNodeDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void WindowNodeDataView::GetTabstripModelDataView(
    TabStripModelDataView* output) {
  auto pointer = data_->tabstrip_model.Get();
  *output = TabStripModelDataView(pointer, message_);
}
inline void WindowNodeDataView::GetSelectionModelDataView(
    SelectionModelDataView* output) {
  auto pointer = data_->selection_model.Get();
  *output = SelectionModelDataView(pointer, message_);
}


inline void NodeIdDataView::GetNodeIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->node_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TabStripModelDataView::GetRootDataView(
    NodeDataView* output) {
  auto pointer = data_->root.Get();
  *output = NodeDataView(pointer, message_);
}


inline void NodeDataView::GetDataDataView(
    DataDataView* output) {
  auto pointer = &data_->data;
  *output = DataDataView(pointer, message_);
}
inline void NodeDataView::GetChildrenDataView(
    mojo::ArrayDataView<NodeDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<NodeDataView>(pointer, message_);
}


inline void TabDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void TabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataView::GetAlertStatesDataView(
    mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output) {
  auto pointer = data_->alert_states.Get();
  *output = mojo::ArrayDataView<::tabs::mojom::TabAlertState>(pointer, message_);
}


inline void TabStripCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}


inline void PinnedCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}


inline void UnpinnedCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}


inline void GroupCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void GroupCollectionDataView::GetVisualDataDataView(
    TabGroupVisualDataDataView* output) {
  auto pointer = data_->visualData.Get();
  *output = TabGroupVisualDataDataView(pointer, message_);
}


inline void TabGroupVisualDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SplitCollectionDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void SplitCollectionDataView::GetVisualDataDataView(
    SplitTabVisualDataDataView* output) {
  auto pointer = data_->visualData.Get();
  *output = SplitTabVisualDataDataView(pointer, message_);
}




inline void SelectionModelDataView::GetSelectedIndicesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->selected_indices.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}


inline void TabRestoreDataDataView::GetEntriesDataView(
    mojo::ArrayDataView<TabRestoreEntryDataView>* output) {
  auto pointer = data_->entries.Get();
  *output = mojo::ArrayDataView<TabRestoreEntryDataView>(pointer, message_);
}


inline void TabRestoreEntryBaseDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void TabRestoreTabDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void TabRestoreTabDataView::GetRestoreEntryDataView(
    TabRestoreEntryBaseDataView* output) {
  auto pointer = data_->restore_entry.Get();
  *output = TabRestoreEntryBaseDataView(pointer, message_);
}
inline void TabRestoreTabDataView::GetGroupIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void TabRestoreTabDataView::GetGroupVisualDataDataView(
    TabGroupVisualDataDataView* output) {
  auto pointer = data_->group_visual_data.Get();
  *output = TabGroupVisualDataDataView(pointer, message_);
}
inline void TabRestoreTabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabRestoreTabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void TabRestoreGroupDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void TabRestoreGroupDataView::GetRestoreEntryDataView(
    TabRestoreEntryBaseDataView* output) {
  auto pointer = data_->restore_entry.Get();
  *output = TabRestoreEntryBaseDataView(pointer, message_);
}
inline void TabRestoreGroupDataView::GetGroupIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void TabRestoreGroupDataView::GetVisualDataDataView(
    TabGroupVisualDataDataView* output) {
  auto pointer = data_->visual_data.Get();
  *output = TabGroupVisualDataDataView(pointer, message_);
}
inline void TabRestoreGroupDataView::GetTabsDataView(
    mojo::ArrayDataView<TabRestoreTabDataView>* output) {
  auto pointer = data_->tabs.Get();
  *output = mojo::ArrayDataView<TabRestoreTabDataView>(pointer, message_);
}


inline void TabRestoreWindowDataView::GetIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = NodeIdDataView(pointer, message_);
}
inline void TabRestoreWindowDataView::GetRestoreEntryDataView(
    TabRestoreEntryBaseDataView* output) {
  auto pointer = data_->restore_entry.Get();
  *output = TabRestoreEntryBaseDataView(pointer, message_);
}
inline void TabRestoreWindowDataView::GetTabsDataView(
    mojo::ArrayDataView<TabRestoreTabDataView>* output) {
  auto pointer = data_->tabs.Get();
  *output = mojo::ArrayDataView<TabRestoreTabDataView>(pointer, message_);
}


inline void DataDataView::GetTabDataView(
    TabDataView* output) const {
  CHECK(is_tab());
  *output = TabDataView(data_->data.f_tab.Get(), message_);
}
inline void DataDataView::GetTabStripCollectionDataView(
    TabStripCollectionDataView* output) const {
  CHECK(is_tab_strip_collection());
  *output = TabStripCollectionDataView(data_->data.f_tab_strip_collection.Get(), message_);
}
inline void DataDataView::GetPinnedTabCollectionDataView(
    PinnedCollectionDataView* output) const {
  CHECK(is_pinned_tab_collection());
  *output = PinnedCollectionDataView(data_->data.f_pinned_tab_collection.Get(), message_);
}
inline void DataDataView::GetUnpinnedTabCollectionDataView(
    UnpinnedCollectionDataView* output) const {
  CHECK(is_unpinned_tab_collection());
  *output = UnpinnedCollectionDataView(data_->data.f_unpinned_tab_collection.Get(), message_);
}
inline void DataDataView::GetTabGroupCollectionDataView(
    GroupCollectionDataView* output) const {
  CHECK(is_tab_group_collection());
  *output = GroupCollectionDataView(data_->data.f_tab_group_collection.Get(), message_);
}
inline void DataDataView::GetSplitTabCollectionDataView(
    SplitCollectionDataView* output) const {
  CHECK(is_split_tab_collection());
  *output = SplitCollectionDataView(data_->data.f_split_tab_collection.Get(), message_);
}

inline void TabRestoreEntryDataView::GetTabDataView(
    TabRestoreTabDataView* output) const {
  CHECK(is_tab());
  *output = TabRestoreTabDataView(data_->data.f_tab.Get(), message_);
}
inline void TabRestoreEntryDataView::GetWindowDataView(
    TabRestoreWindowDataView* output) const {
  CHECK(is_window());
  *output = TabRestoreWindowDataView(data_->data.f_window.Get(), message_);
}
inline void TabRestoreEntryDataView::GetGroupDataView(
    TabRestoreGroupDataView* output) const {
  CHECK(is_group());
  *output = TabRestoreGroupDataView(data_->data.f_group.Get(), message_);
}


}  // tab_strip_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_strip_internals::mojom::NodeId_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_strip_internals::mojom::NodeId_Type value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::tab_strip_internals::mojom::SplitTabVisualData_Layout> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tab_strip_internals::mojom::SplitTabVisualData_Layout value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_SHARED_H_