// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-params-data.h"
namespace tab_strip_internals {
namespace mojom {

NOINLINE static const char* NodeId_TypeToStringHelper(NodeId_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NodeId_Type::kTab:
      return "kTab";
    case NodeId_Type::kCollection:
      return "kCollection";
    case NodeId_Type::kWindow:
      return "kWindow";
    case NodeId_Type::kTabRestoreTab:
      return "kTabRestoreTab";
    case NodeId_Type::kTabRestoreGroup:
      return "kTabRestoreGroup";
    case NodeId_Type::kTabRestoreWindow:
      return "kTabRestoreWindow";
    default:
      return nullptr;
  }
}

std::string NodeId_TypeToString(NodeId_Type value) {
  const char *str = NodeId_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NodeId_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NodeId_Type value) {
  return os << NodeId_TypeToString(value);
}

NOINLINE static const char* SplitTabVisualData_LayoutToStringHelper(SplitTabVisualData_Layout value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SplitTabVisualData_Layout::kVertical:
      return "kVertical";
    case SplitTabVisualData_Layout::kHorizontal:
      return "kHorizontal";
    default:
      return nullptr;
  }
}

std::string SplitTabVisualData_LayoutToString(SplitTabVisualData_Layout value) {
  const char *str = SplitTabVisualData_LayoutToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SplitTabVisualData_Layout value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SplitTabVisualData_Layout value) {
  return os << SplitTabVisualData_LayoutToString(value);
}

namespace internal {
// static
bool Data_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Data_Data* object = static_cast<const Data_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Data_Tag::kTab: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kTabStripCollection: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab_strip_collection, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab_strip_collection, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kPinnedTabCollection: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pinned_tab_collection, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pinned_tab_collection, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kUnpinnedTabCollection: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_unpinned_tab_collection, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_unpinned_tab_collection, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kTabGroupCollection: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab_group_collection, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab_group_collection, validation_context))
        return false;
      return true;
    }
    case Data_Tag::kSplitTabCollection: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_split_tab_collection, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_split_tab_collection, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Data");
      return false;
    }
  }
}
// static
bool TabRestoreEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabRestoreEntry_Data* object = static_cast<const TabRestoreEntry_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabRestoreEntry_Tag::kTab: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab, validation_context))
        return false;
      return true;
    }
    case TabRestoreEntry_Tag::kWindow: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_window, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_window, validation_context))
        return false;
      return true;
    }
    case TabRestoreEntry_Tag::kGroup: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_group, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_group, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabRestoreEntry");
      return false;
    }
  }
}


// static
bool Container_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Container_Data* object =
      static_cast<const Container_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabstrip_tree, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tabstrip_tree, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_restore, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_restore, validation_context))
    return false;

  return true;
}

Container_Data::Container_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripTree_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripTree_Data* object =
      static_cast<const TabStripTree_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->windows, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->windows, validation_context,
                                         &windows_validate_params)) {
    return false;
  }

  return true;
}

TabStripTree_Data::TabStripTree_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WindowNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WindowNode_Data* object =
      static_cast<const WindowNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabstrip_model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tabstrip_model, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection_model, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection_model, validation_context))
    return false;

  return true;
}

WindowNode_Data::WindowNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NodeId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NodeId_Data* object =
      static_cast<const NodeId_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_id, validation_context,
                                         &node_id_validate_params)) {
    return false;
  }


  if (!::tab_strip_internals::mojom::internal::NodeId_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NodeId_Data::NodeId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripModel_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripModel_Data* object =
      static_cast<const TabStripModel_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->root, validation_context))
    return false;

  return true;
}

TabStripModel_Data::TabStripModel_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Node_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Node_Data* object =
      static_cast<const Node_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  return true;
}

Node_Data::Node_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tab_Data* object =
      static_cast<const Tab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_states, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->alert_states, validation_context,
                                         &alert_states_validate_params)) {
    return false;
  }

  return true;
}

Tab_Data::Tab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripCollection_Data* object =
      static_cast<const TabStripCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

TabStripCollection_Data::TabStripCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinnedCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinnedCollection_Data* object =
      static_cast<const PinnedCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

PinnedCollection_Data::PinnedCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnpinnedCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnpinnedCollection_Data* object =
      static_cast<const UnpinnedCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

UnpinnedCollection_Data::UnpinnedCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GroupCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GroupCollection_Data* object =
      static_cast<const GroupCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visualData, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visualData, validation_context))
    return false;

  return true;
}

GroupCollection_Data::GroupCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabGroupVisualData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabGroupVisualData_Data* object =
      static_cast<const TabGroupVisualData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }


  if (!::tab_groups::mojom::internal::Color_Data
        ::Validate(object->color, validation_context))
    return false;

  return true;
}

TabGroupVisualData_Data::TabGroupVisualData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SplitCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SplitCollection_Data* object =
      static_cast<const SplitCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visualData, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visualData, validation_context))
    return false;

  return true;
}

SplitCollection_Data::SplitCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SplitTabVisualData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SplitTabVisualData_Data* object =
      static_cast<const SplitTabVisualData_Data*>(data);


  if (!::tab_strip_internals::mojom::internal::SplitTabVisualData_Layout_Data
        ::Validate(object->layout, validation_context))
    return false;

  return true;
}

SplitTabVisualData_Data::SplitTabVisualData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectionModel_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectionModel_Data* object =
      static_cast<const SelectionModel_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selected_indices, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selected_indices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selected_indices, validation_context,
                                         &selected_indices_validate_params)) {
    return false;
  }

  return true;
}

SelectionModel_Data::SelectionModel_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabRestoreData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabRestoreData_Data* object =
      static_cast<const TabRestoreData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

TabRestoreData_Data::TabRestoreData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabRestoreEntryBase_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabRestoreEntryBase_Data* object =
      static_cast<const TabRestoreEntryBase_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  return true;
}

TabRestoreEntryBase_Data::TabRestoreEntryBase_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabRestoreTab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabRestoreTab_Data* object =
      static_cast<const TabRestoreTab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->restore_entry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->restore_entry, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->group_visual_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

TabRestoreTab_Data::TabRestoreTab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabRestoreGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabRestoreGroup_Data* object =
      static_cast<const TabRestoreGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->restore_entry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->restore_entry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_data, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  return true;
}

TabRestoreGroup_Data::TabRestoreGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabRestoreWindow_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabRestoreWindow_Data* object =
      static_cast<const TabRestoreWindow_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->restore_entry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->restore_entry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  return true;
}

TabRestoreWindow_Data::TabRestoreWindow_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabStripData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabStripData_Params_Data* object =
      static_cast<const PageHandler_GetTabStripData_Params_Data*>(data);

  return true;
}

PageHandler_GetTabStripData_Params_Data::PageHandler_GetTabStripData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabStripData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabStripData_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabStripData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

PageHandler_GetTabStripData_ResponseParams_Data::PageHandler_GetTabStripData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnTabStripUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnTabStripUpdated_Params_Data* object =
      static_cast<const Page_OnTabStripUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

Page_OnTabStripUpdated_Params_Data::Page_OnTabStripUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tab_strip_internals

namespace perfetto {

// static
void TraceFormatTraits<::tab_strip_internals::mojom::NodeId_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_strip_internals::mojom::NodeId_Type value) {
  return std::move(context).WriteString(::tab_strip_internals::mojom::NodeId_TypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_strip_internals::mojom::SplitTabVisualData_Layout>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_strip_internals::mojom::SplitTabVisualData_Layout value) {
  return std::move(context).WriteString(::tab_strip_internals::mojom::SplitTabVisualData_LayoutToString(value));
}

} // namespace perfetto