// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared-internal.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace tab_strip_internals::mojom {
class ContainerDataView;

class TabStripTreeDataView;

class WindowNodeDataView;

class NodeIdDataView;

class TabStripModelDataView;

class NodeDataView;

class TabDataView;

class TabStripCollectionDataView;

class PinnedCollectionDataView;

class UnpinnedCollectionDataView;

class GroupCollectionDataView;

class TabGroupVisualDataDataView;

class SplitCollectionDataView;

class SplitTabVisualDataDataView;

class SelectionModelDataView;

class TabRestoreDataDataView;

class TabRestoreEntryBaseDataView;

class TabRestoreTabDataView;

class TabRestoreGroupDataView;

class TabRestoreWindowDataView;

class DataDataView;
class TabRestoreEntryDataView;


}  // tab_strip_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::ContainerDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Container_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabStripTreeDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabStripTree_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::WindowNodeDataView> {
  using Data = ::tab_strip_internals::mojom::internal::WindowNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::NodeIdDataView> {
  using Data = ::tab_strip_internals::mojom::internal::NodeId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabStripModelDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabStripModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::NodeDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Node_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabStripCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabStripCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::PinnedCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::PinnedCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::UnpinnedCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::UnpinnedCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::GroupCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::GroupCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabGroupVisualDataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabGroupVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::SplitCollectionDataView> {
  using Data = ::tab_strip_internals::mojom::internal::SplitCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::SplitTabVisualDataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::SplitTabVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::SelectionModelDataView> {
  using Data = ::tab_strip_internals::mojom::internal::SelectionModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabRestoreDataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabRestoreData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabRestoreEntryBase_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabRestoreTabDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabRestoreTab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabRestoreGroupDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabRestoreGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabRestoreWindowDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabRestoreWindow_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::DataDataView> {
  using Data = ::tab_strip_internals::mojom::internal::Data_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tab_strip_internals::mojom::TabRestoreEntryDataView> {
  using Data = ::tab_strip_internals::mojom::internal::TabRestoreEntry_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace tab_strip_internals::mojom {


enum class NodeId_Type : int32_t {
  
  kTab = 0,
  
  kCollection = 1,
  
  kWindow = 2,
  
  kTabRestoreTab = 3,
  
  kTabRestoreGroup = 4,
  
  kTabRestoreWindow = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, NodeId_Type value);
inline bool IsKnownEnumValue(NodeId_Type value) {
  return internal::NodeId_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SplitTabVisualData_Layout : int32_t {
  
  kVertical = 0,
  
  kHorizontal = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SplitTabVisualData_Layout value);
inline bool IsKnownEnumValue(SplitTabVisualData_Layout value) {
  return internal::SplitTabVisualData_Layout_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ContainerDataView {
 public:
  ContainerDataView() = default;

  ContainerDataView(
      internal::Container_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabstripTreeDataView(
      TabStripTreeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabstripTree(UserType* output) {
    
    auto* pointer = data_->tabstrip_tree.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabStripTreeDataView>(
        pointer, output, message_);
  }
  inline void GetTabRestoreDataView(
      TabRestoreDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabRestore(UserType* output) {
    
    auto* pointer = data_->tab_restore.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::Container_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripTreeDataView {
 public:
  TabStripTreeDataView() = default;

  TabStripTreeDataView(
      internal::TabStripTree_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowsDataView(
      mojo::ArrayDataView<WindowNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindows(UserType* output) {
    
    auto* pointer = data_->windows.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::WindowNodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TabStripTree_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WindowNodeDataView {
 public:
  WindowNodeDataView() = default;

  WindowNodeDataView(
      internal::WindowNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetTabstripModelDataView(
      TabStripModelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabstripModel(UserType* output) {
    
    auto* pointer = data_->tabstrip_model.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabStripModelDataView>(
        pointer, output, message_);
  }
  inline void GetSelectionModelDataView(
      SelectionModelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionModel(UserType* output) {
    
    auto* pointer = data_->selection_model.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SelectionModelDataView>(
        pointer, output, message_);
  }
 private:
  internal::WindowNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NodeIdDataView {
 public:
  NodeIdDataView() = default;

  NodeIdDataView(
      internal::NodeId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNodeIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodeId(UserType* output) {
    
    auto* pointer = data_->node_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeId_Type>(
        data_value, output);
  }
  NodeId_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_strip_internals::mojom::NodeId_Type>(data_->type));
  }
 private:
  internal::NodeId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripModelDataView {
 public:
  TabStripModelDataView() = default;

  TabStripModelDataView(
      internal::TabStripModel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootDataView(
      NodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tab_strip_internals::mojom::NodeDataView, UserType>(),
    "Attempting to read the optional `root` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRoot` instead "
    "of `ReadRoot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->root.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabStripModel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NodeDataView {
 public:
  NodeDataView() = default;

  NodeDataView(
      internal::Node_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      DataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::DataDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<NodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::NodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Node_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool active() const {
    return data_->active;
  }
  bool visible() const {
    return data_->visible;
  }
  bool selected() const {
    return data_->selected;
  }
  bool pinned() const {
    return data_->pinned;
  }
  bool split() const {
    return data_->split;
  }
  inline void GetAlertStatesDataView(
      mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlertStates(UserType* output) {
    
    auto* pointer = data_->alert_states.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
        pointer, output, message_);
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripCollectionDataView {
 public:
  TabStripCollectionDataView() = default;

  TabStripCollectionDataView(
      internal::TabStripCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabStripCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PinnedCollectionDataView {
 public:
  PinnedCollectionDataView() = default;

  PinnedCollectionDataView(
      internal::PinnedCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::PinnedCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UnpinnedCollectionDataView {
 public:
  UnpinnedCollectionDataView() = default;

  UnpinnedCollectionDataView(
      internal::UnpinnedCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnpinnedCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GroupCollectionDataView {
 public:
  GroupCollectionDataView() = default;

  GroupCollectionDataView(
      internal::GroupCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetVisualDataDataView(
      TabGroupVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualData(UserType* output) {
    
    auto* pointer = data_->visualData.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::GroupCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabGroupVisualDataDataView {
 public:
  TabGroupVisualDataDataView() = default;

  TabGroupVisualDataDataView(
      internal::TabGroupVisualData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    auto data_value = data_->color;
    return mojo::internal::Deserialize<::tab_groups::mojom::Color>(
        data_value, output);
  }
  ::tab_groups::mojom::Color color() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_groups::mojom::Color>(data_->color));
  }
  bool is_collapsed() const {
    return data_->is_collapsed;
  }
 private:
  internal::TabGroupVisualData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitCollectionDataView {
 public:
  SplitCollectionDataView() = default;

  SplitCollectionDataView(
      internal::SplitCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetVisualDataDataView(
      SplitTabVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualData(UserType* output) {
    
    auto* pointer = data_->visualData.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SplitTabVisualDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::SplitCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitTabVisualDataDataView {
 public:
  SplitTabVisualDataDataView() = default;

  SplitTabVisualDataDataView(
      internal::SplitTabVisualData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(
        data_value, output);
  }
  SplitTabVisualData_Layout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_strip_internals::mojom::SplitTabVisualData_Layout>(data_->layout));
  }
  double split_ratio() const {
    return data_->split_ratio;
  }
 private:
  internal::SplitTabVisualData_Data* data_ = nullptr;
};


class SelectionModelDataView {
 public:
  SelectionModelDataView() = default;

  SelectionModelDataView(
      internal::SelectionModel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t active_index() const {
    return data_->active_index;
  }
  int32_t anchor_index() const {
    return data_->anchor_index;
  }
  inline void GetSelectedIndicesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedIndices(UserType* output) {
    
    auto* pointer = data_->selected_indices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::SelectionModel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabRestoreDataDataView {
 public:
  TabRestoreDataDataView() = default;

  TabRestoreDataDataView(
      internal::TabRestoreData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<TabRestoreEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::TabRestoreEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TabRestoreData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabRestoreEntryBaseDataView {
 public:
  TabRestoreEntryBaseDataView() = default;

  TabRestoreEntryBaseDataView(
      internal::TabRestoreEntryBase_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t original_id() const {
    return data_->original_id;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimestamp` instead "
    "of `ReadTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabRestoreEntryBase_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabRestoreTabDataView {
 public:
  TabRestoreTabDataView() = default;

  TabRestoreTabDataView(
      internal::TabRestoreTab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetRestoreEntryDataView(
      TabRestoreEntryBaseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRestoreEntry(UserType* output) {
    
    auto* pointer = data_->restore_entry.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView>(
        pointer, output, message_);
  }
  int32_t browser_id() const {
    return data_->browser_id;
  }
  int32_t tabstrip_index() const {
    return data_->tabstrip_index;
  }
  bool pinned() const {
    return data_->pinned;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `group_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupId` instead "
    "of `ReadGroupId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetGroupVisualDataDataView(
      TabGroupVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupVisualData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tab_strip_internals::mojom::TabGroupVisualDataDataView, UserType>(),
    "Attempting to read the optional `group_visual_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupVisualData` instead "
    "of `ReadGroupVisualData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_visual_data.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabRestoreTab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabRestoreGroupDataView {
 public:
  TabRestoreGroupDataView() = default;

  TabRestoreGroupDataView(
      internal::TabRestoreGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetRestoreEntryDataView(
      TabRestoreEntryBaseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRestoreEntry(UserType* output) {
    
    auto* pointer = data_->restore_entry.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView>(
        pointer, output, message_);
  }
  int32_t browser_id() const {
    return data_->browser_id;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetVisualDataDataView(
      TabGroupVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualData(UserType* output) {
    
    auto* pointer = data_->visual_data.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabGroupVisualDataDataView>(
        pointer, output, message_);
  }
  inline void GetTabsDataView(
      mojo::ArrayDataView<TabRestoreTabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::TabRestoreTabDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TabRestoreGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabRestoreWindowDataView {
 public:
  TabRestoreWindowDataView() = default;

  TabRestoreWindowDataView(
      internal::TabRestoreWindow_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetRestoreEntryDataView(
      TabRestoreEntryBaseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRestoreEntry(UserType* output) {
    
    auto* pointer = data_->restore_entry.Get();
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreEntryBaseDataView>(
        pointer, output, message_);
  }
  int32_t selected_tab_index() const {
    return data_->selected_tab_index;
  }
  inline void GetTabsDataView(
      mojo::ArrayDataView<TabRestoreTabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_strip_internals::mojom::TabRestoreTabDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TabRestoreWindow_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataDataView {
 public:
  using Tag = internal::Data_Data::Data_Tag;

  DataDataView() = default;

  DataDataView(
      internal::Data_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_tab() const { return data_->tag == Tag::kTab; }
  inline void GetTabDataView(
      TabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) const {
    
    CHECK(is_tab());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabDataView>(
        data_->data.f_tab.Get(), output, message_);
  }
  bool is_tab_strip_collection() const { return data_->tag == Tag::kTabStripCollection; }
  inline void GetTabStripCollectionDataView(
      TabStripCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabStripCollection(UserType* output) const {
    
    CHECK(is_tab_strip_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabStripCollectionDataView>(
        data_->data.f_tab_strip_collection.Get(), output, message_);
  }
  bool is_pinned_tab_collection() const { return data_->tag == Tag::kPinnedTabCollection; }
  inline void GetPinnedTabCollectionDataView(
      PinnedCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPinnedTabCollection(UserType* output) const {
    
    CHECK(is_pinned_tab_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::PinnedCollectionDataView>(
        data_->data.f_pinned_tab_collection.Get(), output, message_);
  }
  bool is_unpinned_tab_collection() const { return data_->tag == Tag::kUnpinnedTabCollection; }
  inline void GetUnpinnedTabCollectionDataView(
      UnpinnedCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUnpinnedTabCollection(UserType* output) const {
    
    CHECK(is_unpinned_tab_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::UnpinnedCollectionDataView>(
        data_->data.f_unpinned_tab_collection.Get(), output, message_);
  }
  bool is_tab_group_collection() const { return data_->tag == Tag::kTabGroupCollection; }
  inline void GetTabGroupCollectionDataView(
      GroupCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabGroupCollection(UserType* output) const {
    
    CHECK(is_tab_group_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::GroupCollectionDataView>(
        data_->data.f_tab_group_collection.Get(), output, message_);
  }
  bool is_split_tab_collection() const { return data_->tag == Tag::kSplitTabCollection; }
  inline void GetSplitTabCollectionDataView(
      SplitCollectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSplitTabCollection(UserType* output) const {
    
    CHECK(is_split_tab_collection());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::SplitCollectionDataView>(
        data_->data.f_split_tab_collection.Get(), output, message_);
  }

 private:
  internal::Data_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabRestoreEntryDataView {
 public:
  using Tag = internal::TabRestoreEntry_Data::TabRestoreEntry_Tag;

  TabRestoreEntryDataView() = default;

  TabRestoreEntryDataView(
      internal::TabRestoreEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_tab() const { return data_->tag == Tag::kTab; }
  inline void GetTabDataView(
      TabRestoreTabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) const {
    
    CHECK(is_tab());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreTabDataView>(
        data_->data.f_tab.Get(), output, message_);
  }
  bool is_window() const { return data_->tag == Tag::kWindow; }
  inline void GetWindowDataView(
      TabRestoreWindowDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadWindow(UserType* output) const {
    
    CHECK(is_window());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreWindowDataView>(
        data_->data.f_window.Get(), output, message_);
  }
  bool is_group() const { return data_->tag == Tag::kGroup; }
  inline void GetGroupDataView(
      TabRestoreGroupDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGroup(UserType* output) const {
    
    CHECK(is_group());
    return mojo::internal::Deserialize<::tab_strip_internals::mojom::TabRestoreGroupDataView>(
        data_->data.f_group.Get(), output, message_);
  }

 private:
  internal::TabRestoreEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // tab_strip_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_INTERNALS_TAB_STRIP_INTERNALS_MOJOM_DATA_VIEW_H_