// chrome/browser/ui/webui/tab_strip/tab_strip.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tabs/tabs.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace tab_strip::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_strip.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_strip.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetGroupVisualDataMinVersion = 0,
    kGetTabsMinVersion = 0,
    kCloseTabMinVersion = 0,
    kGroupTabMinVersion = 0,
    kMoveGroupMinVersion = 0,
    kMoveTabMinVersion = 0,
    kSetThumbnailTrackedMinVersion = 0,
    kUngroupTabMinVersion = 0,
    kGetLayoutMinVersion = 0,
    kShowEditDialogForGroupMinVersion = 0,
    kShowTabContextMenuMinVersion = 0,
    kShowBackgroundContextMenuMinVersion = 0,
    kCloseContainerMinVersion = 0,
    kReportTabActivationDurationMinVersion = 0,
    kReportTabDataReceivedDurationMinVersion = 0,
    kReportTabCreationDurationMinVersion = 0,
    kActivateTabMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetGroupVisualData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GroupTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetThumbnailTracked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UngroupTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLayout_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowEditDialogForGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowTabContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowBackgroundContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseContainer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportTabActivationDuration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportTabDataReceivedDuration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportTabCreationDuration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivateTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetGroupVisualDataCallback = base::OnceCallback<void(base::flat_map<std::string, TabGroupVisualDataPtr>)>;
  using GetGroupVisualDataMojoCallback = base::OnceCallback<void(base::flat_map<std::string, TabGroupVisualDataPtr>)>;

  virtual void GetGroupVisualData(GetGroupVisualDataCallback callback) = 0;

  using GetTabsCallback = base::OnceCallback<void(std::vector<TabPtr>)>;
  using GetTabsMojoCallback = base::OnceCallback<void(std::vector<TabPtr>)>;

  virtual void GetTabs(GetTabsCallback callback) = 0;

  virtual void CloseTab(int32_t tab_id, bool tab_was_swiped) = 0;

  virtual void GroupTab(int32_t tab_id, const std::string& group_id) = 0;

  virtual void MoveGroup(const std::string& group_id, int32_t to_index) = 0;

  virtual void MoveTab(int32_t tab_id, int32_t to_index) = 0;

  virtual void SetThumbnailTracked(int32_t tab_id, bool thumbnail_tracked) = 0;

  virtual void UngroupTab(int32_t tab_id) = 0;

  using GetLayoutCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;
  using GetLayoutMojoCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;

  virtual void GetLayout(GetLayoutCallback callback) = 0;

  virtual void ShowEditDialogForGroup(const std::string& group_id, int32_t location_x, int32_t location_y, int32_t width, int32_t height) = 0;

  virtual void ShowTabContextMenu(int32_t tab_id, int32_t location_x, int32_t location_y) = 0;

  virtual void ShowBackgroundContextMenu(int32_t location_x, int32_t location_y) = 0;

  virtual void CloseContainer() = 0;

  virtual void ReportTabActivationDuration(uint32_t duration_ms) = 0;

  virtual void ReportTabDataReceivedDuration(uint32_t tab_count, uint32_t duration_ms) = 0;

  virtual void ReportTabCreationDuration(uint32_t tab_count, uint32_t duration_ms) = 0;

  virtual void ActivateTab(int32_t tab_id) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_strip.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kLayoutChangedMinVersion = 0,
    kReceivedKeyboardFocusMinVersion = 0,
    kContextMenuClosedMinVersion = 0,
    kLongPressMinVersion = 0,
    kTabGroupVisualsChangedMinVersion = 0,
    kTabGroupMovedMinVersion = 0,
    kTabGroupClosedMinVersion = 0,
    kTabGroupStateChangedMinVersion = 0,
    kTabCloseCancelledMinVersion = 0,
    kTabCreatedMinVersion = 0,
    kTabRemovedMinVersion = 0,
    kTabMovedMinVersion = 0,
    kTabReplacedMinVersion = 0,
    kTabActiveChangedMinVersion = 0,
    kTabUpdatedMinVersion = 0,
    kTabThumbnailUpdatedMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kThemeChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LayoutChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceivedKeyboardFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContextMenuClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LongPress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabGroupVisualsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabGroupMoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabGroupClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabGroupStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabCloseCancelled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabMoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabReplaced_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabActiveChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabThumbnailUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ThemeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void LayoutChanged(const base::flat_map<std::string, std::string>& layout) = 0;

  virtual void ReceivedKeyboardFocus() = 0;

  virtual void ContextMenuClosed() = 0;

  virtual void LongPress() = 0;

  virtual void TabGroupVisualsChanged(const std::string& group_id, TabGroupVisualDataPtr tab_group) = 0;

  virtual void TabGroupMoved(const std::string& group_id, int32_t index) = 0;

  virtual void TabGroupClosed(const std::string& group_id) = 0;

  virtual void TabGroupStateChanged(int32_t tab_id, int32_t index, const std::optional<std::string>& group_id) = 0;

  virtual void TabCloseCancelled(int32_t tab_id) = 0;

  virtual void TabCreated(TabPtr tab) = 0;

  virtual void TabRemoved(int32_t tab_id) = 0;

  virtual void TabMoved(int32_t tab_id, int32_t to_index, bool in_pinned) = 0;

  virtual void TabReplaced(int32_t tab_id, int32_t new_tab_id) = 0;

  virtual void TabActiveChanged(int32_t tab_id) = 0;

  virtual void TabUpdated(TabPtr tab) = 0;

  virtual void TabThumbnailUpdated(int32_t tab_id, const std::string& data_uri) = 0;

  virtual void ShowContextMenu() = 0;

  virtual void ThemeChanged() = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetGroupVisualData(GetGroupVisualDataCallback callback) final;
  
  void GetTabs(GetTabsCallback callback) final;
  
  void CloseTab(int32_t tab_id, bool tab_was_swiped) final;
  
  void GroupTab(int32_t tab_id, const std::string& group_id) final;
  
  void MoveGroup(const std::string& group_id, int32_t to_index) final;
  
  void MoveTab(int32_t tab_id, int32_t to_index) final;
  
  void SetThumbnailTracked(int32_t tab_id, bool thumbnail_tracked) final;
  
  void UngroupTab(int32_t tab_id) final;
  
  void GetLayout(GetLayoutCallback callback) final;
  
  void ShowEditDialogForGroup(const std::string& group_id, int32_t location_x, int32_t location_y, int32_t width, int32_t height) final;
  
  void ShowTabContextMenu(int32_t tab_id, int32_t location_x, int32_t location_y) final;
  
  void ShowBackgroundContextMenu(int32_t location_x, int32_t location_y) final;
  
  void CloseContainer() final;
  
  void ReportTabActivationDuration(uint32_t duration_ms) final;
  
  void ReportTabDataReceivedDuration(uint32_t tab_count, uint32_t duration_ms) final;
  
  void ReportTabCreationDuration(uint32_t tab_count, uint32_t duration_ms) final;
  
  void ActivateTab(int32_t tab_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LayoutChanged(const base::flat_map<std::string, std::string>& layout) final;
  
  void ReceivedKeyboardFocus() final;
  
  void ContextMenuClosed() final;
  
  void LongPress() final;
  
  void TabGroupVisualsChanged(const std::string& group_id, TabGroupVisualDataPtr tab_group) final;
  
  void TabGroupMoved(const std::string& group_id, int32_t index) final;
  
  void TabGroupClosed(const std::string& group_id) final;
  
  void TabGroupStateChanged(int32_t tab_id, int32_t index, const std::optional<std::string>& group_id) final;
  
  void TabCloseCancelled(int32_t tab_id) final;
  
  void TabCreated(TabPtr tab) final;
  
  void TabRemoved(int32_t tab_id) final;
  
  void TabMoved(int32_t tab_id, int32_t to_index, bool in_pinned) final;
  
  void TabReplaced(int32_t tab_id, int32_t new_tab_id) final;
  
  void TabActiveChanged(int32_t tab_id) final;
  
  void TabUpdated(TabPtr tab) final;
  
  void TabThumbnailUpdated(int32_t tab_id, const std::string& data_uri) final;
  
  void ShowContextMenu() final;
  
  void ThemeChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  TabGroupVisualData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabGroupVisualData, T>::value>;
  using DataView = TabGroupVisualDataDataView;
  using Data_ = internal::TabGroupVisualData_Data;

  template <typename... Args>
  static TabGroupVisualDataPtr New(Args&&... args) {
    return TabGroupVisualDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabGroupVisualDataPtr From(const U& u) {
    return mojo::TypeConverter<TabGroupVisualDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabGroupVisualData>::Convert(*this);
  }


  TabGroupVisualData();

  TabGroupVisualData(
      const std::string& color,
      const std::string& text_color,
      const std::string& title);


  ~TabGroupVisualData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabGroupVisualDataPtr>
  TabGroupVisualDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroupVisualData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroupVisualData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabGroupVisualData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabGroupVisualData_UnserializedMessageContext<
            UserType, TabGroupVisualData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabGroupVisualData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabGroupVisualData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabGroupVisualData_UnserializedMessageContext<
            UserType, TabGroupVisualData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabGroupVisualData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string color;
  
  std::string text_color;
  
  std::string title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  Tab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tab, T>::value>;
  using DataView = TabDataView;
  using Data_ = internal::Tab_Data;

  template <typename... Args>
  static TabPtr New(Args&&... args) {
    return TabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabPtr From(const U& u) {
    return mojo::TypeConverter<TabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tab>::Convert(*this);
  }


  Tab();

  Tab(
      bool active,
      std::vector<::tabs::TabAlert> alert_states,
      bool blocked,
      bool crashed,
      const std::optional<::GURL>& favicon_url,
      const std::optional<::GURL>& active_favicon_url,
      const std::optional<std::string>& group_id,
      int32_t id,
      int32_t index,
      bool is_default_favicon,
      ::TabNetworkState network_state,
      bool pinned,
      bool should_hide_throbber,
      bool show_icon,
      const std::string& title,
      const ::GURL& url);


  ~Tab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabPtr>
  TabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool active;
  
  std::vector<::tabs::TabAlert> alert_states;
  
  bool blocked;
  
  bool crashed;
  
  std::optional<::GURL> favicon_url;
  
  std::optional<::GURL> active_favicon_url;
  
  std::optional<std::string> group_id;
  
  int32_t id;
  
  int32_t index;
  
  bool is_default_favicon;
  
  ::TabNetworkState network_state;
  
  bool pinned;
  
  bool should_hide_throbber;
  
  bool show_icon;
  
  std::string title;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
TabPtr Tab::Clone() const {
  return New(
      mojo::Clone(active),
      mojo::Clone(alert_states),
      mojo::Clone(blocked),
      mojo::Clone(crashed),
      mojo::Clone(favicon_url),
      mojo::Clone(active_favicon_url),
      mojo::Clone(group_id),
      mojo::Clone(id),
      mojo::Clone(index),
      mojo::Clone(is_default_favicon),
      mojo::Clone(network_state),
      mojo::Clone(pinned),
      mojo::Clone(should_hide_throbber),
      mojo::Clone(show_icon),
      mojo::Clone(title),
      mojo::Clone(url)
  );
}

template <typename T, Tab::EnableIfSame<T>*>
bool Tab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  if (!mojo::Equals(this->alert_states, other_struct.alert_states))
    return false;
  if (!mojo::Equals(this->blocked, other_struct.blocked))
    return false;
  if (!mojo::Equals(this->crashed, other_struct.crashed))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->active_favicon_url, other_struct.active_favicon_url))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  if (!mojo::Equals(this->is_default_favicon, other_struct.is_default_favicon))
    return false;
  if (!mojo::Equals(this->network_state, other_struct.network_state))
    return false;
  if (!mojo::Equals(this->pinned, other_struct.pinned))
    return false;
  if (!mojo::Equals(this->should_hide_throbber, other_struct.should_hide_throbber))
    return false;
  if (!mojo::Equals(this->show_icon, other_struct.show_icon))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, Tab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  if (lhs.alert_states < rhs.alert_states)
    return true;
  if (rhs.alert_states < lhs.alert_states)
    return false;
  if (lhs.blocked < rhs.blocked)
    return true;
  if (rhs.blocked < lhs.blocked)
    return false;
  if (lhs.crashed < rhs.crashed)
    return true;
  if (rhs.crashed < lhs.crashed)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.active_favicon_url < rhs.active_favicon_url)
    return true;
  if (rhs.active_favicon_url < lhs.active_favicon_url)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  if (lhs.is_default_favicon < rhs.is_default_favicon)
    return true;
  if (rhs.is_default_favicon < lhs.is_default_favicon)
    return false;
  if (lhs.network_state < rhs.network_state)
    return true;
  if (rhs.network_state < lhs.network_state)
    return false;
  if (lhs.pinned < rhs.pinned)
    return true;
  if (rhs.pinned < lhs.pinned)
    return false;
  if (lhs.should_hide_throbber < rhs.should_hide_throbber)
    return true;
  if (rhs.should_hide_throbber < lhs.should_hide_throbber)
    return false;
  if (lhs.show_icon < rhs.show_icon)
    return true;
  if (rhs.show_icon < lhs.show_icon)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
TabGroupVisualDataPtr TabGroupVisualData::Clone() const {
  return New(
      mojo::Clone(color),
      mojo::Clone(text_color),
      mojo::Clone(title)
  );
}

template <typename T, TabGroupVisualData::EnableIfSame<T>*>
bool TabGroupVisualData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->text_color, other_struct.text_color))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, TabGroupVisualData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.text_color < rhs.text_color)
    return true;
  if (rhs.text_color < lhs.text_color)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}


}  // tab_strip::mojom

namespace mojo {


template <>
struct  StructTraits<::tab_strip::mojom::Tab::DataView,
                                         ::tab_strip::mojom::TabPtr> {
  static bool IsNull(const ::tab_strip::mojom::TabPtr& input) { return !input; }
  static void SetToNull(::tab_strip::mojom::TabPtr* output) { output->reset(); }

  static decltype(::tab_strip::mojom::Tab::active) active(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->active;
  }

  static const decltype(::tab_strip::mojom::Tab::alert_states)& alert_states(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->alert_states;
  }

  static decltype(::tab_strip::mojom::Tab::blocked) blocked(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->blocked;
  }

  static decltype(::tab_strip::mojom::Tab::crashed) crashed(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->crashed;
  }

  static const decltype(::tab_strip::mojom::Tab::favicon_url)& favicon_url(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->favicon_url;
  }

  static const decltype(::tab_strip::mojom::Tab::active_favicon_url)& active_favicon_url(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->active_favicon_url;
  }

  static const decltype(::tab_strip::mojom::Tab::group_id)& group_id(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->group_id;
  }

  static decltype(::tab_strip::mojom::Tab::id) id(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->id;
  }

  static decltype(::tab_strip::mojom::Tab::index) index(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->index;
  }

  static decltype(::tab_strip::mojom::Tab::is_default_favicon) is_default_favicon(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->is_default_favicon;
  }

  static decltype(::tab_strip::mojom::Tab::network_state) network_state(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->network_state;
  }

  static decltype(::tab_strip::mojom::Tab::pinned) pinned(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->pinned;
  }

  static decltype(::tab_strip::mojom::Tab::should_hide_throbber) should_hide_throbber(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->should_hide_throbber;
  }

  static decltype(::tab_strip::mojom::Tab::show_icon) show_icon(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->show_icon;
  }

  static const decltype(::tab_strip::mojom::Tab::title)& title(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->title;
  }

  static const decltype(::tab_strip::mojom::Tab::url)& url(
      const ::tab_strip::mojom::TabPtr& input) {
    return input->url;
  }

  static bool Read(::tab_strip::mojom::Tab::DataView input, ::tab_strip::mojom::TabPtr* output);
};


template <>
struct  StructTraits<::tab_strip::mojom::TabGroupVisualData::DataView,
                                         ::tab_strip::mojom::TabGroupVisualDataPtr> {
  static bool IsNull(const ::tab_strip::mojom::TabGroupVisualDataPtr& input) { return !input; }
  static void SetToNull(::tab_strip::mojom::TabGroupVisualDataPtr* output) { output->reset(); }

  static const decltype(::tab_strip::mojom::TabGroupVisualData::color)& color(
      const ::tab_strip::mojom::TabGroupVisualDataPtr& input) {
    return input->color;
  }

  static const decltype(::tab_strip::mojom::TabGroupVisualData::text_color)& text_color(
      const ::tab_strip::mojom::TabGroupVisualDataPtr& input) {
    return input->text_color;
  }

  static const decltype(::tab_strip::mojom::TabGroupVisualData::title)& title(
      const ::tab_strip::mojom::TabGroupVisualDataPtr& input) {
    return input->title;
  }

  static bool Read(::tab_strip::mojom::TabGroupVisualData::DataView input, ::tab_strip::mojom::TabGroupVisualDataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_H_