// chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-params-data.h"
namespace tab_strip {
namespace mojom {

namespace internal {


// static
bool Tab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tab_Data* object =
      static_cast<const Tab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_states, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->alert_states, validation_context,
                                         &alert_states_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->active_favicon_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }


  if (!::tabs::mojom::internal::TabNetworkState_Data
        ::Validate(object->network_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Tab_Data::Tab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabGroupVisualData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabGroupVisualData_Data* object =
      static_cast<const TabGroupVisualData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& color_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->color, validation_context,
                                         &color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_color, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_color_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_color, validation_context,
                                         &text_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

TabGroupVisualData_Data::TabGroupVisualData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetGroupVisualData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetGroupVisualData_Params_Data* object =
      static_cast<const PageHandler_GetGroupVisualData_Params_Data*>(data);

  return true;
}

PageHandler_GetGroupVisualData_Params_Data::PageHandler_GetGroupVisualData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetGroupVisualData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetGroupVisualData_ResponseParams_Data* object =
      static_cast<const PageHandler_GetGroupVisualData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetGroupVisualData_ResponseParams_Data::PageHandler_GetGroupVisualData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabs_Params_Data* object =
      static_cast<const PageHandler_GetTabs_Params_Data*>(data);

  return true;
}

PageHandler_GetTabs_Params_Data::PageHandler_GetTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabs_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetTabs_ResponseParams_Data::PageHandler_GetTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseTab_Params_Data* object =
      static_cast<const PageHandler_CloseTab_Params_Data*>(data);

  return true;
}

PageHandler_CloseTab_Params_Data::PageHandler_CloseTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GroupTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GroupTab_Params_Data* object =
      static_cast<const PageHandler_GroupTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GroupTab_Params_Data::PageHandler_GroupTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MoveGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MoveGroup_Params_Data* object =
      static_cast<const PageHandler_MoveGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_MoveGroup_Params_Data::PageHandler_MoveGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MoveTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MoveTab_Params_Data* object =
      static_cast<const PageHandler_MoveTab_Params_Data*>(data);

  return true;
}

PageHandler_MoveTab_Params_Data::PageHandler_MoveTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetThumbnailTracked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetThumbnailTracked_Params_Data* object =
      static_cast<const PageHandler_SetThumbnailTracked_Params_Data*>(data);

  return true;
}

PageHandler_SetThumbnailTracked_Params_Data::PageHandler_SetThumbnailTracked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UngroupTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UngroupTab_Params_Data* object =
      static_cast<const PageHandler_UngroupTab_Params_Data*>(data);

  return true;
}

PageHandler_UngroupTab_Params_Data::PageHandler_UngroupTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetLayout_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetLayout_Params_Data* object =
      static_cast<const PageHandler_GetLayout_Params_Data*>(data);

  return true;
}

PageHandler_GetLayout_Params_Data::PageHandler_GetLayout_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetLayout_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetLayout_ResponseParams_Data* object =
      static_cast<const PageHandler_GetLayout_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layout, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& layout_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->layout, validation_context,
                                         &layout_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetLayout_ResponseParams_Data::PageHandler_GetLayout_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowEditDialogForGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowEditDialogForGroup_Params_Data* object =
      static_cast<const PageHandler_ShowEditDialogForGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ShowEditDialogForGroup_Params_Data::PageHandler_ShowEditDialogForGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowTabContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowTabContextMenu_Params_Data* object =
      static_cast<const PageHandler_ShowTabContextMenu_Params_Data*>(data);

  return true;
}

PageHandler_ShowTabContextMenu_Params_Data::PageHandler_ShowTabContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowBackgroundContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowBackgroundContextMenu_Params_Data* object =
      static_cast<const PageHandler_ShowBackgroundContextMenu_Params_Data*>(data);

  return true;
}

PageHandler_ShowBackgroundContextMenu_Params_Data::PageHandler_ShowBackgroundContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseContainer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseContainer_Params_Data* object =
      static_cast<const PageHandler_CloseContainer_Params_Data*>(data);

  return true;
}

PageHandler_CloseContainer_Params_Data::PageHandler_CloseContainer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReportTabActivationDuration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReportTabActivationDuration_Params_Data* object =
      static_cast<const PageHandler_ReportTabActivationDuration_Params_Data*>(data);

  return true;
}

PageHandler_ReportTabActivationDuration_Params_Data::PageHandler_ReportTabActivationDuration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReportTabDataReceivedDuration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReportTabDataReceivedDuration_Params_Data* object =
      static_cast<const PageHandler_ReportTabDataReceivedDuration_Params_Data*>(data);

  return true;
}

PageHandler_ReportTabDataReceivedDuration_Params_Data::PageHandler_ReportTabDataReceivedDuration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReportTabCreationDuration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReportTabCreationDuration_Params_Data* object =
      static_cast<const PageHandler_ReportTabCreationDuration_Params_Data*>(data);

  return true;
}

PageHandler_ReportTabCreationDuration_Params_Data::PageHandler_ReportTabCreationDuration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ActivateTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ActivateTab_Params_Data* object =
      static_cast<const PageHandler_ActivateTab_Params_Data*>(data);

  return true;
}

PageHandler_ActivateTab_Params_Data::PageHandler_ActivateTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_LayoutChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_LayoutChanged_Params_Data* object =
      static_cast<const Page_LayoutChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layout, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& layout_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->layout, validation_context,
                                         &layout_validate_params)) {
    return false;
  }

  return true;
}

Page_LayoutChanged_Params_Data::Page_LayoutChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ReceivedKeyboardFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ReceivedKeyboardFocus_Params_Data* object =
      static_cast<const Page_ReceivedKeyboardFocus_Params_Data*>(data);

  return true;
}

Page_ReceivedKeyboardFocus_Params_Data::Page_ReceivedKeyboardFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ContextMenuClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ContextMenuClosed_Params_Data* object =
      static_cast<const Page_ContextMenuClosed_Params_Data*>(data);

  return true;
}

Page_ContextMenuClosed_Params_Data::Page_ContextMenuClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_LongPress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_LongPress_Params_Data* object =
      static_cast<const Page_LongPress_Params_Data*>(data);

  return true;
}

Page_LongPress_Params_Data::Page_LongPress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabGroupVisualsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabGroupVisualsChanged_Params_Data* object =
      static_cast<const Page_TabGroupVisualsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_group, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_group, validation_context))
    return false;

  return true;
}

Page_TabGroupVisualsChanged_Params_Data::Page_TabGroupVisualsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabGroupMoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabGroupMoved_Params_Data* object =
      static_cast<const Page_TabGroupMoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

Page_TabGroupMoved_Params_Data::Page_TabGroupMoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabGroupClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabGroupClosed_Params_Data* object =
      static_cast<const Page_TabGroupClosed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

Page_TabGroupClosed_Params_Data::Page_TabGroupClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabGroupStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabGroupStateChanged_Params_Data* object =
      static_cast<const Page_TabGroupStateChanged_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

Page_TabGroupStateChanged_Params_Data::Page_TabGroupStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabCloseCancelled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabCloseCancelled_Params_Data* object =
      static_cast<const Page_TabCloseCancelled_Params_Data*>(data);

  return true;
}

Page_TabCloseCancelled_Params_Data::Page_TabCloseCancelled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabCreated_Params_Data* object =
      static_cast<const Page_TabCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  return true;
}

Page_TabCreated_Params_Data::Page_TabCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabRemoved_Params_Data* object =
      static_cast<const Page_TabRemoved_Params_Data*>(data);

  return true;
}

Page_TabRemoved_Params_Data::Page_TabRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabMoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabMoved_Params_Data* object =
      static_cast<const Page_TabMoved_Params_Data*>(data);

  return true;
}

Page_TabMoved_Params_Data::Page_TabMoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabReplaced_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabReplaced_Params_Data* object =
      static_cast<const Page_TabReplaced_Params_Data*>(data);

  return true;
}

Page_TabReplaced_Params_Data::Page_TabReplaced_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabActiveChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabActiveChanged_Params_Data* object =
      static_cast<const Page_TabActiveChanged_Params_Data*>(data);

  return true;
}

Page_TabActiveChanged_Params_Data::Page_TabActiveChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabUpdated_Params_Data* object =
      static_cast<const Page_TabUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  return true;
}

Page_TabUpdated_Params_Data::Page_TabUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabThumbnailUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabThumbnailUpdated_Params_Data* object =
      static_cast<const Page_TabThumbnailUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_uri, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_uri_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data_uri, validation_context,
                                         &data_uri_validate_params)) {
    return false;
  }

  return true;
}

Page_TabThumbnailUpdated_Params_Data::Page_TabThumbnailUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ShowContextMenu_Params_Data* object =
      static_cast<const Page_ShowContextMenu_Params_Data*>(data);

  return true;
}

Page_ShowContextMenu_Params_Data::Page_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ThemeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ThemeChanged_Params_Data* object =
      static_cast<const Page_ThemeChanged_Params_Data*>(data);

  return true;
}

Page_ThemeChanged_Params_Data::Page_ThemeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tab_strip