// chrome/browser/ui/webui/tab_search/tab_search.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include "url/mojom/url.mojom.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace tab_search::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_search.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_search.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloseTabMinVersion = 0,
    kCloseWebUiTabMinVersion = 0,
    kDeclutterTabsMinVersion = 0,
    kAcceptTabOrganizationMinVersion = 0,
    kRejectTabOrganizationMinVersion = 0,
    kRenameTabOrganizationMinVersion = 0,
    kExcludeFromStaleTabsMinVersion = 0,
    kExcludeFromDuplicateTabsMinVersion = 0,
    kGetProfileDataMinVersion = 0,
    kGetUnusedTabsMinVersion = 0,
    kGetTabSearchSectionMinVersion = 0,
    kGetTabOrganizationFeatureMinVersion = 0,
    kGetTabOrganizationSessionMinVersion = 0,
    kGetTabOrganizationModelStrategyMinVersion = 0,
    kGetIsSplitMinVersion = 0,
    kSwitchToTabMinVersion = 0,
    kOpenRecentlyClosedEntryMinVersion = 0,
    kRequestTabOrganizationMinVersion = 0,
    kRemoveTabFromOrganizationMinVersion = 0,
    kRejectSessionMinVersion = 0,
    kReplaceActiveSplitTabMinVersion = 0,
    kRestartSessionMinVersion = 0,
    kSaveRecentlyClosedExpandedPrefMinVersion = 0,
    kSetOrganizationFeatureMinVersion = 0,
    kStartTabGroupTutorialMinVersion = 0,
    kTriggerFeedbackMinVersion = 0,
    kTriggerSignInMinVersion = 0,
    kOpenHelpPageMinVersion = 0,
    kSetTabOrganizationModelStrategyMinVersion = 0,
    kSetTabOrganizationUserInstructionMinVersion = 0,
    kSetUserFeedbackMinVersion = 0,
    kNotifyOrganizationUIReadyToShowMinVersion = 0,
    kNotifySearchUIReadyToShowMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CloseTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseWebUiTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeclutterTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcceptTabOrganization_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RejectTabOrganization_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenameTabOrganization_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExcludeFromStaleTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExcludeFromDuplicateTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProfileData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUnusedTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabSearchSection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabOrganizationFeature_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabOrganizationSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabOrganizationModelStrategy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsSplit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwitchToTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenRecentlyClosedEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestTabOrganization_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveTabFromOrganization_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RejectSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReplaceActiveSplitTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RestartSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveRecentlyClosedExpandedPref_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOrganizationFeature_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartTabGroupTutorial_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerSignIn_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenHelpPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTabOrganizationModelStrategy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTabOrganizationUserInstruction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOrganizationUIReadyToShow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifySearchUIReadyToShow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void CloseTab(int32_t tab_id) = 0;

  virtual void CloseWebUiTab() = 0;

  virtual void DeclutterTabs(const std::vector<int32_t>& tab_ids, const std::vector<::GURL>& urls) = 0;

  virtual void AcceptTabOrganization(int32_t session_id, int32_t organization_id, std::vector<TabPtr> tabs) = 0;

  virtual void RejectTabOrganization(int32_t session_id, int32_t organization_id) = 0;

  virtual void RenameTabOrganization(int32_t session_id, int32_t organization_id, const ::std::u16string& name) = 0;

  virtual void ExcludeFromStaleTabs(int32_t tab_id) = 0;

  virtual void ExcludeFromDuplicateTabs(const ::GURL& url) = 0;

  using GetProfileDataCallback = base::OnceCallback<void(ProfileDataPtr)>;
  using GetProfileDataMojoCallback = base::OnceCallback<void(ProfileDataPtr)>;

  virtual void GetProfileData(GetProfileDataCallback callback) = 0;

  using GetUnusedTabsCallback = base::OnceCallback<void(UnusedTabInfoPtr)>;
  using GetUnusedTabsMojoCallback = base::OnceCallback<void(UnusedTabInfoPtr)>;

  virtual void GetUnusedTabs(GetUnusedTabsCallback callback) = 0;

  using GetTabSearchSectionCallback = base::OnceCallback<void(TabSearchSection)>;
  using GetTabSearchSectionMojoCallback = base::OnceCallback<void(TabSearchSection)>;

  virtual void GetTabSearchSection(GetTabSearchSectionCallback callback) = 0;

  using GetTabOrganizationFeatureCallback = base::OnceCallback<void(TabOrganizationFeature)>;
  using GetTabOrganizationFeatureMojoCallback = base::OnceCallback<void(TabOrganizationFeature)>;

  virtual void GetTabOrganizationFeature(GetTabOrganizationFeatureCallback callback) = 0;

  using GetTabOrganizationSessionCallback = base::OnceCallback<void(TabOrganizationSessionPtr)>;
  using GetTabOrganizationSessionMojoCallback = base::OnceCallback<void(TabOrganizationSessionPtr)>;

  virtual void GetTabOrganizationSession(GetTabOrganizationSessionCallback callback) = 0;

  using GetTabOrganizationModelStrategyCallback = base::OnceCallback<void(TabOrganizationModelStrategy)>;
  using GetTabOrganizationModelStrategyMojoCallback = base::OnceCallback<void(TabOrganizationModelStrategy)>;

  virtual void GetTabOrganizationModelStrategy(GetTabOrganizationModelStrategyCallback callback) = 0;

  using GetIsSplitCallback = base::OnceCallback<void(bool)>;
  using GetIsSplitMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetIsSplit(GetIsSplitCallback callback) = 0;

  virtual void SwitchToTab(SwitchToTabInfoPtr switch_to_tab_info) = 0;

  virtual void OpenRecentlyClosedEntry(int32_t session_id) = 0;

  virtual void RequestTabOrganization() = 0;

  virtual void RemoveTabFromOrganization(int32_t session_id, int32_t organization_id, TabPtr tab) = 0;

  virtual void RejectSession(int32_t session_id) = 0;

  virtual void ReplaceActiveSplitTab(int32_t replacement_tab_id) = 0;

  virtual void RestartSession() = 0;

  virtual void SaveRecentlyClosedExpandedPref(bool expanded) = 0;

  virtual void SetOrganizationFeature(TabOrganizationFeature feature) = 0;

  virtual void StartTabGroupTutorial() = 0;

  virtual void TriggerFeedback(int32_t session_id) = 0;

  virtual void TriggerSignIn() = 0;

  virtual void OpenHelpPage() = 0;

  virtual void SetTabOrganizationModelStrategy(TabOrganizationModelStrategy strategy) = 0;

  virtual void SetTabOrganizationUserInstruction(const std::string& user_instruction) = 0;

  virtual void SetUserFeedback(int32_t session_id, UserFeedback feedback) = 0;

  virtual void NotifyOrganizationUIReadyToShow() = 0;

  virtual void NotifySearchUIReadyToShow() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tab_search.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kTabOrganizationSessionUpdatedMinVersion = 0,
    kTabOrganizationModelStrategyUpdatedMinVersion = 0,
    kHostWindowChangedMinVersion = 0,
    kTabsChangedMinVersion = 0,
    kTabUpdatedMinVersion = 0,
    kTabsRemovedMinVersion = 0,
    kTabSearchSectionChangedMinVersion = 0,
    kTabOrganizationFeatureChangedMinVersion = 0,
    kShowFREChangedMinVersion = 0,
    kTabOrganizationEnabledChangedMinVersion = 0,
    kUnusedTabsChangedMinVersion = 0,
    kTabUnsplitMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TabOrganizationSessionUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabOrganizationModelStrategyUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HostWindowChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabsRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabSearchSectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabOrganizationFeatureChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowFREChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabOrganizationEnabledChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnusedTabsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabUnsplit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void TabOrganizationSessionUpdated(TabOrganizationSessionPtr session) = 0;

  virtual void TabOrganizationModelStrategyUpdated(TabOrganizationModelStrategy strategy) = 0;

  virtual void HostWindowChanged() = 0;

  virtual void TabsChanged(ProfileDataPtr profile_tabs) = 0;

  virtual void TabUpdated(TabUpdateInfoPtr tabUpdateInfo) = 0;

  virtual void TabsRemoved(TabsRemovedInfoPtr tabsRemovedInfo) = 0;

  virtual void TabSearchSectionChanged(TabSearchSection section) = 0;

  virtual void TabOrganizationFeatureChanged(TabOrganizationFeature feature) = 0;

  virtual void ShowFREChanged(bool show) = 0;

  virtual void TabOrganizationEnabledChanged(bool enabled) = 0;

  virtual void UnusedTabsChanged(UnusedTabInfoPtr tabs) = 0;

  virtual void TabUnsplit() = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CloseTab(int32_t tab_id) final;
  
  void CloseWebUiTab() final;
  
  void DeclutterTabs(const std::vector<int32_t>& tab_ids, const std::vector<::GURL>& urls) final;
  
  void AcceptTabOrganization(int32_t session_id, int32_t organization_id, std::vector<TabPtr> tabs) final;
  
  void RejectTabOrganization(int32_t session_id, int32_t organization_id) final;
  
  void RenameTabOrganization(int32_t session_id, int32_t organization_id, const ::std::u16string& name) final;
  
  void ExcludeFromStaleTabs(int32_t tab_id) final;
  
  void ExcludeFromDuplicateTabs(const ::GURL& url) final;
  
  void GetProfileData(GetProfileDataCallback callback) final;
  
  void GetUnusedTabs(GetUnusedTabsCallback callback) final;
  
  void GetTabSearchSection(GetTabSearchSectionCallback callback) final;
  
  void GetTabOrganizationFeature(GetTabOrganizationFeatureCallback callback) final;
  
  void GetTabOrganizationSession(GetTabOrganizationSessionCallback callback) final;
  
  void GetTabOrganizationModelStrategy(GetTabOrganizationModelStrategyCallback callback) final;
  
  void GetIsSplit(GetIsSplitCallback callback) final;
  
  void SwitchToTab(SwitchToTabInfoPtr switch_to_tab_info) final;
  
  void OpenRecentlyClosedEntry(int32_t session_id) final;
  
  void RequestTabOrganization() final;
  
  void RemoveTabFromOrganization(int32_t session_id, int32_t organization_id, TabPtr tab) final;
  
  void RejectSession(int32_t session_id) final;
  
  void ReplaceActiveSplitTab(int32_t replacement_tab_id) final;
  
  void RestartSession() final;
  
  void SaveRecentlyClosedExpandedPref(bool expanded) final;
  
  void SetOrganizationFeature(TabOrganizationFeature feature) final;
  
  void StartTabGroupTutorial() final;
  
  void TriggerFeedback(int32_t session_id) final;
  
  void TriggerSignIn() final;
  
  void OpenHelpPage() final;
  
  void SetTabOrganizationModelStrategy(TabOrganizationModelStrategy strategy) final;
  
  void SetTabOrganizationUserInstruction(const std::string& user_instruction) final;
  
  void SetUserFeedback(int32_t session_id, UserFeedback feedback) final;
  
  void NotifyOrganizationUIReadyToShow() final;
  
  void NotifySearchUIReadyToShow() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TabOrganizationSessionUpdated(TabOrganizationSessionPtr session) final;
  
  void TabOrganizationModelStrategyUpdated(TabOrganizationModelStrategy strategy) final;
  
  void HostWindowChanged() final;
  
  void TabsChanged(ProfileDataPtr profile_tabs) final;
  
  void TabUpdated(TabUpdateInfoPtr tabUpdateInfo) final;
  
  void TabsRemoved(TabsRemovedInfoPtr tabsRemovedInfo) final;
  
  void TabSearchSectionChanged(TabSearchSection section) final;
  
  void TabOrganizationFeatureChanged(TabOrganizationFeature feature) final;
  
  void ShowFREChanged(bool show) final;
  
  void TabOrganizationEnabledChanged(bool enabled) final;
  
  void UnusedTabsChanged(UnusedTabInfoPtr tabs) final;
  
  void TabUnsplit() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class  SwitchToTabInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SwitchToTabInfo, T>::value>;
  using DataView = SwitchToTabInfoDataView;
  using Data_ = internal::SwitchToTabInfo_Data;

  template <typename... Args>
  static SwitchToTabInfoPtr New(Args&&... args) {
    return SwitchToTabInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SwitchToTabInfoPtr From(const U& u) {
    return mojo::TypeConverter<SwitchToTabInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SwitchToTabInfo>::Convert(*this);
  }


  SwitchToTabInfo();

  explicit SwitchToTabInfo(
      int32_t tab_id);


  ~SwitchToTabInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SwitchToTabInfoPtr>
  SwitchToTabInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SwitchToTabInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SwitchToTabInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SwitchToTabInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SwitchToTabInfo_UnserializedMessageContext<
            UserType, SwitchToTabInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SwitchToTabInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SwitchToTabInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SwitchToTabInfo_UnserializedMessageContext<
            UserType, SwitchToTabInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SwitchToTabInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SwitchToTabInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  ProfileData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProfileData, T>::value>;
  using DataView = ProfileDataDataView;
  using Data_ = internal::ProfileData_Data;

  template <typename... Args>
  static ProfileDataPtr New(Args&&... args) {
    return ProfileDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProfileDataPtr From(const U& u) {
    return mojo::TypeConverter<ProfileDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProfileData>::Convert(*this);
  }


  ProfileData();

  ProfileData(
      std::vector<WindowPtr> windows,
      std::vector<TabGroupPtr> tab_groups,
      std::vector<RecentlyClosedTabPtr> recently_closed_tabs,
      std::vector<RecentlyClosedTabGroupPtr> recently_closed_tab_groups,
      bool recently_closed_section_expanded);

ProfileData(const ProfileData&) = delete;
ProfileData& operator=(const ProfileData&) = delete;

  ~ProfileData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProfileDataPtr>
  ProfileDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProfileData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProfileData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProfileData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProfileData_UnserializedMessageContext<
            UserType, ProfileData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProfileData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProfileData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProfileData_UnserializedMessageContext<
            UserType, ProfileData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProfileData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WindowPtr> windows;
  
  std::vector<TabGroupPtr> tab_groups;
  
  std::vector<RecentlyClosedTabPtr> recently_closed_tabs;
  
  std::vector<RecentlyClosedTabGroupPtr> recently_closed_tab_groups;
  
  bool recently_closed_section_expanded;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProfileData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Window {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Window, T>::value>;
  using DataView = WindowDataView;
  using Data_ = internal::Window_Data;

  template <typename... Args>
  static WindowPtr New(Args&&... args) {
    return WindowPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WindowPtr From(const U& u) {
    return mojo::TypeConverter<WindowPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Window>::Convert(*this);
  }


  Window();

  Window(
      bool active,
      bool is_host_window,
      uint32_t height,
      std::vector<TabPtr> tabs);

Window(const Window&) = delete;
Window& operator=(const Window&) = delete;

  ~Window();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WindowPtr>
  WindowPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Window::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Window::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Window::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Window::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Window::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Window::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Window_UnserializedMessageContext<
            UserType, Window::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Window::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Window::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Window_UnserializedMessageContext<
            UserType, Window::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Window::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool active;
  
  bool is_host_window;
  
  uint32_t height;
  
  std::vector<TabPtr> tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Tab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tab, T>::value>;
  using DataView = TabDataView;
  using Data_ = internal::Tab_Data;

  template <typename... Args>
  static TabPtr New(Args&&... args) {
    return TabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabPtr From(const U& u) {
    return mojo::TypeConverter<TabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tab>::Convert(*this);
  }


  Tab();

  Tab(
      bool active,
      bool visible,
      std::vector<::tabs::TabAlert> alert_states,
      int32_t index,
      int32_t tab_id,
      const std::optional<::base::Token>& group_id,
      bool pinned,
      bool split,
      const std::string& title,
      const ::GURL& url,
      const std::optional<::GURL>& favicon_url,
      bool is_default_favicon,
      bool show_icon,
      ::base::TimeTicks last_active_time_ticks,
      const std::string& last_active_elapsed_text);


  ~Tab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabPtr>
  TabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool active;
  
  bool visible;
  
  std::vector<::tabs::TabAlert> alert_states;
  
  int32_t index;
  
  int32_t tab_id;
  
  std::optional<::base::Token> group_id;
  
  bool pinned;
  
  bool split;
  
  std::string title;
  
  ::GURL url;
  
  std::optional<::GURL> favicon_url;
  
  bool is_default_favicon;
  
  bool show_icon;
  
  ::base::TimeTicks last_active_time_ticks;
  
  std::string last_active_elapsed_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RecentlyClosedTab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RecentlyClosedTab, T>::value>;
  using DataView = RecentlyClosedTabDataView;
  using Data_ = internal::RecentlyClosedTab_Data;

  template <typename... Args>
  static RecentlyClosedTabPtr New(Args&&... args) {
    return RecentlyClosedTabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RecentlyClosedTabPtr From(const U& u) {
    return mojo::TypeConverter<RecentlyClosedTabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RecentlyClosedTab>::Convert(*this);
  }


  RecentlyClosedTab();

  RecentlyClosedTab(
      int32_t tab_id,
      const std::optional<::base::Token>& group_id,
      const std::string& title,
      const ::GURL& url,
      ::base::Time last_active_time,
      const std::string& last_active_elapsed_text);


  ~RecentlyClosedTab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RecentlyClosedTabPtr>
  RecentlyClosedTabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RecentlyClosedTab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RecentlyClosedTab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RecentlyClosedTab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RecentlyClosedTab_UnserializedMessageContext<
            UserType, RecentlyClosedTab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RecentlyClosedTab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RecentlyClosedTab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RecentlyClosedTab_UnserializedMessageContext<
            UserType, RecentlyClosedTab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RecentlyClosedTab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  std::optional<::base::Token> group_id;
  
  std::string title;
  
  ::GURL url;
  
  ::base::Time last_active_time;
  
  std::string last_active_elapsed_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RecentlyClosedTab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabGroup, T>::value>;
  using DataView = TabGroupDataView;
  using Data_ = internal::TabGroup_Data;

  template <typename... Args>
  static TabGroupPtr New(Args&&... args) {
    return TabGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabGroupPtr From(const U& u) {
    return mojo::TypeConverter<TabGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabGroup>::Convert(*this);
  }


  TabGroup();

  TabGroup(
      const ::base::Token& id,
      ::tab_groups::TabGroupColorId color,
      const std::string& title);


  ~TabGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabGroupPtr>
  TabGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabGroup_UnserializedMessageContext<
            UserType, TabGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabGroup_UnserializedMessageContext<
            UserType, TabGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token id;
  
  ::tab_groups::TabGroupColorId color;
  
  std::string title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RecentlyClosedTabGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RecentlyClosedTabGroup, T>::value>;
  using DataView = RecentlyClosedTabGroupDataView;
  using Data_ = internal::RecentlyClosedTabGroup_Data;

  template <typename... Args>
  static RecentlyClosedTabGroupPtr New(Args&&... args) {
    return RecentlyClosedTabGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RecentlyClosedTabGroupPtr From(const U& u) {
    return mojo::TypeConverter<RecentlyClosedTabGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RecentlyClosedTabGroup>::Convert(*this);
  }


  RecentlyClosedTabGroup();

  RecentlyClosedTabGroup(
      int32_t session_id,
      const ::base::Token& id,
      ::tab_groups::TabGroupColorId color,
      const std::string& title,
      uint32_t tab_count,
      ::base::Time last_active_time,
      const std::string& last_active_elapsed_text);


  ~RecentlyClosedTabGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RecentlyClosedTabGroupPtr>
  RecentlyClosedTabGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RecentlyClosedTabGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RecentlyClosedTabGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RecentlyClosedTabGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RecentlyClosedTabGroup_UnserializedMessageContext<
            UserType, RecentlyClosedTabGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RecentlyClosedTabGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RecentlyClosedTabGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RecentlyClosedTabGroup_UnserializedMessageContext<
            UserType, RecentlyClosedTabGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RecentlyClosedTabGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t session_id;
  
  ::base::Token id;
  
  ::tab_groups::TabGroupColorId color;
  
  std::string title;
  
  uint32_t tab_count;
  
  ::base::Time last_active_time;
  
  std::string last_active_elapsed_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  TabOrganization {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabOrganization, T>::value>;
  using DataView = TabOrganizationDataView;
  using Data_ = internal::TabOrganization_Data;

  template <typename... Args>
  static TabOrganizationPtr New(Args&&... args) {
    return TabOrganizationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabOrganizationPtr From(const U& u) {
    return mojo::TypeConverter<TabOrganizationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabOrganization>::Convert(*this);
  }


  TabOrganization();

  TabOrganization(
      int32_t organization_id,
      std::vector<TabPtr> tabs,
      int32_t first_new_tab_index,
      const ::std::u16string& name);

TabOrganization(const TabOrganization&) = delete;
TabOrganization& operator=(const TabOrganization&) = delete;

  ~TabOrganization();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabOrganizationPtr>
  TabOrganizationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabOrganization::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabOrganization::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabOrganization::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabOrganization_UnserializedMessageContext<
            UserType, TabOrganization::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabOrganization::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabOrganization::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabOrganization_UnserializedMessageContext<
            UserType, TabOrganization::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabOrganization::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t organization_id;
  
  std::vector<TabPtr> tabs;
  
  int32_t first_new_tab_index;
  
  ::std::u16string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabOrganization::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabOrganizationSession {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabOrganizationSession, T>::value>;
  using DataView = TabOrganizationSessionDataView;
  using Data_ = internal::TabOrganizationSession_Data;

  template <typename... Args>
  static TabOrganizationSessionPtr New(Args&&... args) {
    return TabOrganizationSessionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabOrganizationSessionPtr From(const U& u) {
    return mojo::TypeConverter<TabOrganizationSessionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabOrganizationSession>::Convert(*this);
  }


  TabOrganizationSession();

  TabOrganizationSession(
      int32_t session_id,
      TabOrganizationState state,
      std::vector<TabOrganizationPtr> organizations,
      TabOrganizationError error,
      int32_t active_tab_id);

TabOrganizationSession(const TabOrganizationSession&) = delete;
TabOrganizationSession& operator=(const TabOrganizationSession&) = delete;

  ~TabOrganizationSession();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabOrganizationSessionPtr>
  TabOrganizationSessionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabOrganizationSession::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabOrganizationSession::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabOrganizationSession::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabOrganizationSession_UnserializedMessageContext<
            UserType, TabOrganizationSession::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabOrganizationSession::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabOrganizationSession::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabOrganizationSession_UnserializedMessageContext<
            UserType, TabOrganizationSession::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabOrganizationSession::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t session_id;
  
  TabOrganizationState state;
  
  std::vector<TabOrganizationPtr> organizations;
  
  TabOrganizationError error;
  
  int32_t active_tab_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabOrganizationSession::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabUpdateInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabUpdateInfo, T>::value>;
  using DataView = TabUpdateInfoDataView;
  using Data_ = internal::TabUpdateInfo_Data;

  template <typename... Args>
  static TabUpdateInfoPtr New(Args&&... args) {
    return TabUpdateInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabUpdateInfoPtr From(const U& u) {
    return mojo::TypeConverter<TabUpdateInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabUpdateInfo>::Convert(*this);
  }


  TabUpdateInfo();

  TabUpdateInfo(
      bool in_active_window,
      bool in_host_window,
      TabPtr tab);

TabUpdateInfo(const TabUpdateInfo&) = delete;
TabUpdateInfo& operator=(const TabUpdateInfo&) = delete;

  ~TabUpdateInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabUpdateInfoPtr>
  TabUpdateInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabUpdateInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabUpdateInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabUpdateInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabUpdateInfo_UnserializedMessageContext<
            UserType, TabUpdateInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabUpdateInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabUpdateInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabUpdateInfo_UnserializedMessageContext<
            UserType, TabUpdateInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabUpdateInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool in_active_window;
  
  bool in_host_window;
  
  TabPtr tab;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabUpdateInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabsRemovedInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabsRemovedInfo, T>::value>;
  using DataView = TabsRemovedInfoDataView;
  using Data_ = internal::TabsRemovedInfo_Data;

  template <typename... Args>
  static TabsRemovedInfoPtr New(Args&&... args) {
    return TabsRemovedInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabsRemovedInfoPtr From(const U& u) {
    return mojo::TypeConverter<TabsRemovedInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabsRemovedInfo>::Convert(*this);
  }


  TabsRemovedInfo();

  TabsRemovedInfo(
      std::vector<int32_t> tab_ids,
      std::vector<RecentlyClosedTabPtr> recently_closed_tabs);

TabsRemovedInfo(const TabsRemovedInfo&) = delete;
TabsRemovedInfo& operator=(const TabsRemovedInfo&) = delete;

  ~TabsRemovedInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabsRemovedInfoPtr>
  TabsRemovedInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabsRemovedInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabsRemovedInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabsRemovedInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabsRemovedInfo_UnserializedMessageContext<
            UserType, TabsRemovedInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabsRemovedInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabsRemovedInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabsRemovedInfo_UnserializedMessageContext<
            UserType, TabsRemovedInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabsRemovedInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<int32_t> tab_ids;
  
  std::vector<RecentlyClosedTabPtr> recently_closed_tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabsRemovedInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UnusedTabInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnusedTabInfo, T>::value>;
  using DataView = UnusedTabInfoDataView;
  using Data_ = internal::UnusedTabInfo_Data;

  template <typename... Args>
  static UnusedTabInfoPtr New(Args&&... args) {
    return UnusedTabInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnusedTabInfoPtr From(const U& u) {
    return mojo::TypeConverter<UnusedTabInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnusedTabInfo>::Convert(*this);
  }


  UnusedTabInfo();

  UnusedTabInfo(
      std::vector<TabPtr> stale_tabs,
      base::flat_map<std::string, std::vector<TabPtr>> duplicate_tabs);

UnusedTabInfo(const UnusedTabInfo&) = delete;
UnusedTabInfo& operator=(const UnusedTabInfo&) = delete;

  ~UnusedTabInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnusedTabInfoPtr>
  UnusedTabInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnusedTabInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnusedTabInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnusedTabInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnusedTabInfo_UnserializedMessageContext<
            UserType, UnusedTabInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnusedTabInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnusedTabInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnusedTabInfo_UnserializedMessageContext<
            UserType, UnusedTabInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnusedTabInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<TabPtr> stale_tabs;
  
  base::flat_map<std::string, std::vector<TabPtr>> duplicate_tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnusedTabInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProfileDataPtr ProfileData::Clone() const {
  return New(
      mojo::Clone(windows),
      mojo::Clone(tab_groups),
      mojo::Clone(recently_closed_tabs),
      mojo::Clone(recently_closed_tab_groups),
      mojo::Clone(recently_closed_section_expanded)
  );
}

template <typename T, ProfileData::EnableIfSame<T>*>
bool ProfileData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->windows, other_struct.windows))
    return false;
  if (!mojo::Equals(this->tab_groups, other_struct.tab_groups))
    return false;
  if (!mojo::Equals(this->recently_closed_tabs, other_struct.recently_closed_tabs))
    return false;
  if (!mojo::Equals(this->recently_closed_tab_groups, other_struct.recently_closed_tab_groups))
    return false;
  if (!mojo::Equals(this->recently_closed_section_expanded, other_struct.recently_closed_section_expanded))
    return false;
  return true;
}

template <typename T, ProfileData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.windows < rhs.windows)
    return true;
  if (rhs.windows < lhs.windows)
    return false;
  if (lhs.tab_groups < rhs.tab_groups)
    return true;
  if (rhs.tab_groups < lhs.tab_groups)
    return false;
  if (lhs.recently_closed_tabs < rhs.recently_closed_tabs)
    return true;
  if (rhs.recently_closed_tabs < lhs.recently_closed_tabs)
    return false;
  if (lhs.recently_closed_tab_groups < rhs.recently_closed_tab_groups)
    return true;
  if (rhs.recently_closed_tab_groups < lhs.recently_closed_tab_groups)
    return false;
  if (lhs.recently_closed_section_expanded < rhs.recently_closed_section_expanded)
    return true;
  if (rhs.recently_closed_section_expanded < lhs.recently_closed_section_expanded)
    return false;
  return false;
}
template <typename StructPtrType>
WindowPtr Window::Clone() const {
  return New(
      mojo::Clone(active),
      mojo::Clone(is_host_window),
      mojo::Clone(height),
      mojo::Clone(tabs)
  );
}

template <typename T, Window::EnableIfSame<T>*>
bool Window::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  if (!mojo::Equals(this->is_host_window, other_struct.is_host_window))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->tabs, other_struct.tabs))
    return false;
  return true;
}

template <typename T, Window::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  if (lhs.is_host_window < rhs.is_host_window)
    return true;
  if (rhs.is_host_window < lhs.is_host_window)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.tabs < rhs.tabs)
    return true;
  if (rhs.tabs < lhs.tabs)
    return false;
  return false;
}
template <typename StructPtrType>
TabPtr Tab::Clone() const {
  return New(
      mojo::Clone(active),
      mojo::Clone(visible),
      mojo::Clone(alert_states),
      mojo::Clone(index),
      mojo::Clone(tab_id),
      mojo::Clone(group_id),
      mojo::Clone(pinned),
      mojo::Clone(split),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(favicon_url),
      mojo::Clone(is_default_favicon),
      mojo::Clone(show_icon),
      mojo::Clone(last_active_time_ticks),
      mojo::Clone(last_active_elapsed_text)
  );
}

template <typename T, Tab::EnableIfSame<T>*>
bool Tab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  if (!mojo::Equals(this->visible, other_struct.visible))
    return false;
  if (!mojo::Equals(this->alert_states, other_struct.alert_states))
    return false;
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->pinned, other_struct.pinned))
    return false;
  if (!mojo::Equals(this->split, other_struct.split))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->is_default_favicon, other_struct.is_default_favicon))
    return false;
  if (!mojo::Equals(this->show_icon, other_struct.show_icon))
    return false;
  if (!mojo::Equals(this->last_active_time_ticks, other_struct.last_active_time_ticks))
    return false;
  if (!mojo::Equals(this->last_active_elapsed_text, other_struct.last_active_elapsed_text))
    return false;
  return true;
}

template <typename T, Tab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  if (lhs.visible < rhs.visible)
    return true;
  if (rhs.visible < lhs.visible)
    return false;
  if (lhs.alert_states < rhs.alert_states)
    return true;
  if (rhs.alert_states < lhs.alert_states)
    return false;
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.pinned < rhs.pinned)
    return true;
  if (rhs.pinned < lhs.pinned)
    return false;
  if (lhs.split < rhs.split)
    return true;
  if (rhs.split < lhs.split)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.is_default_favicon < rhs.is_default_favicon)
    return true;
  if (rhs.is_default_favicon < lhs.is_default_favicon)
    return false;
  if (lhs.show_icon < rhs.show_icon)
    return true;
  if (rhs.show_icon < lhs.show_icon)
    return false;
  if (lhs.last_active_time_ticks < rhs.last_active_time_ticks)
    return true;
  if (rhs.last_active_time_ticks < lhs.last_active_time_ticks)
    return false;
  if (lhs.last_active_elapsed_text < rhs.last_active_elapsed_text)
    return true;
  if (rhs.last_active_elapsed_text < lhs.last_active_elapsed_text)
    return false;
  return false;
}
template <typename StructPtrType>
RecentlyClosedTabPtr RecentlyClosedTab::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(group_id),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(last_active_time),
      mojo::Clone(last_active_elapsed_text)
  );
}

template <typename T, RecentlyClosedTab::EnableIfSame<T>*>
bool RecentlyClosedTab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->last_active_time, other_struct.last_active_time))
    return false;
  if (!mojo::Equals(this->last_active_elapsed_text, other_struct.last_active_elapsed_text))
    return false;
  return true;
}

template <typename T, RecentlyClosedTab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.last_active_time < rhs.last_active_time)
    return true;
  if (rhs.last_active_time < lhs.last_active_time)
    return false;
  if (lhs.last_active_elapsed_text < rhs.last_active_elapsed_text)
    return true;
  if (rhs.last_active_elapsed_text < lhs.last_active_elapsed_text)
    return false;
  return false;
}
template <typename StructPtrType>
TabGroupPtr TabGroup::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(color),
      mojo::Clone(title)
  );
}

template <typename T, TabGroup::EnableIfSame<T>*>
bool TabGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, TabGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}
template <typename StructPtrType>
RecentlyClosedTabGroupPtr RecentlyClosedTabGroup::Clone() const {
  return New(
      mojo::Clone(session_id),
      mojo::Clone(id),
      mojo::Clone(color),
      mojo::Clone(title),
      mojo::Clone(tab_count),
      mojo::Clone(last_active_time),
      mojo::Clone(last_active_elapsed_text)
  );
}

template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>*>
bool RecentlyClosedTabGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->tab_count, other_struct.tab_count))
    return false;
  if (!mojo::Equals(this->last_active_time, other_struct.last_active_time))
    return false;
  if (!mojo::Equals(this->last_active_elapsed_text, other_struct.last_active_elapsed_text))
    return false;
  return true;
}

template <typename T, RecentlyClosedTabGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_id < rhs.session_id)
    return true;
  if (rhs.session_id < lhs.session_id)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.tab_count < rhs.tab_count)
    return true;
  if (rhs.tab_count < lhs.tab_count)
    return false;
  if (lhs.last_active_time < rhs.last_active_time)
    return true;
  if (rhs.last_active_time < lhs.last_active_time)
    return false;
  if (lhs.last_active_elapsed_text < rhs.last_active_elapsed_text)
    return true;
  if (rhs.last_active_elapsed_text < lhs.last_active_elapsed_text)
    return false;
  return false;
}
template <typename StructPtrType>
SwitchToTabInfoPtr SwitchToTabInfo::Clone() const {
  return New(
      mojo::Clone(tab_id)
  );
}

template <typename T, SwitchToTabInfo::EnableIfSame<T>*>
bool SwitchToTabInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  return true;
}

template <typename T, SwitchToTabInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  return false;
}
template <typename StructPtrType>
TabOrganizationPtr TabOrganization::Clone() const {
  return New(
      mojo::Clone(organization_id),
      mojo::Clone(tabs),
      mojo::Clone(first_new_tab_index),
      mojo::Clone(name)
  );
}

template <typename T, TabOrganization::EnableIfSame<T>*>
bool TabOrganization::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->organization_id, other_struct.organization_id))
    return false;
  if (!mojo::Equals(this->tabs, other_struct.tabs))
    return false;
  if (!mojo::Equals(this->first_new_tab_index, other_struct.first_new_tab_index))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, TabOrganization::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.organization_id < rhs.organization_id)
    return true;
  if (rhs.organization_id < lhs.organization_id)
    return false;
  if (lhs.tabs < rhs.tabs)
    return true;
  if (rhs.tabs < lhs.tabs)
    return false;
  if (lhs.first_new_tab_index < rhs.first_new_tab_index)
    return true;
  if (rhs.first_new_tab_index < lhs.first_new_tab_index)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}
template <typename StructPtrType>
TabOrganizationSessionPtr TabOrganizationSession::Clone() const {
  return New(
      mojo::Clone(session_id),
      mojo::Clone(state),
      mojo::Clone(organizations),
      mojo::Clone(error),
      mojo::Clone(active_tab_id)
  );
}

template <typename T, TabOrganizationSession::EnableIfSame<T>*>
bool TabOrganizationSession::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->organizations, other_struct.organizations))
    return false;
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->active_tab_id, other_struct.active_tab_id))
    return false;
  return true;
}

template <typename T, TabOrganizationSession::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_id < rhs.session_id)
    return true;
  if (rhs.session_id < lhs.session_id)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.organizations < rhs.organizations)
    return true;
  if (rhs.organizations < lhs.organizations)
    return false;
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.active_tab_id < rhs.active_tab_id)
    return true;
  if (rhs.active_tab_id < lhs.active_tab_id)
    return false;
  return false;
}
template <typename StructPtrType>
TabUpdateInfoPtr TabUpdateInfo::Clone() const {
  return New(
      mojo::Clone(in_active_window),
      mojo::Clone(in_host_window),
      mojo::Clone(tab)
  );
}

template <typename T, TabUpdateInfo::EnableIfSame<T>*>
bool TabUpdateInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->in_active_window, other_struct.in_active_window))
    return false;
  if (!mojo::Equals(this->in_host_window, other_struct.in_host_window))
    return false;
  if (!mojo::Equals(this->tab, other_struct.tab))
    return false;
  return true;
}

template <typename T, TabUpdateInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.in_active_window < rhs.in_active_window)
    return true;
  if (rhs.in_active_window < lhs.in_active_window)
    return false;
  if (lhs.in_host_window < rhs.in_host_window)
    return true;
  if (rhs.in_host_window < lhs.in_host_window)
    return false;
  if (lhs.tab < rhs.tab)
    return true;
  if (rhs.tab < lhs.tab)
    return false;
  return false;
}
template <typename StructPtrType>
TabsRemovedInfoPtr TabsRemovedInfo::Clone() const {
  return New(
      mojo::Clone(tab_ids),
      mojo::Clone(recently_closed_tabs)
  );
}

template <typename T, TabsRemovedInfo::EnableIfSame<T>*>
bool TabsRemovedInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_ids, other_struct.tab_ids))
    return false;
  if (!mojo::Equals(this->recently_closed_tabs, other_struct.recently_closed_tabs))
    return false;
  return true;
}

template <typename T, TabsRemovedInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_ids < rhs.tab_ids)
    return true;
  if (rhs.tab_ids < lhs.tab_ids)
    return false;
  if (lhs.recently_closed_tabs < rhs.recently_closed_tabs)
    return true;
  if (rhs.recently_closed_tabs < lhs.recently_closed_tabs)
    return false;
  return false;
}
template <typename StructPtrType>
UnusedTabInfoPtr UnusedTabInfo::Clone() const {
  return New(
      mojo::Clone(stale_tabs),
      mojo::Clone(duplicate_tabs)
  );
}

template <typename T, UnusedTabInfo::EnableIfSame<T>*>
bool UnusedTabInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stale_tabs, other_struct.stale_tabs))
    return false;
  if (!mojo::Equals(this->duplicate_tabs, other_struct.duplicate_tabs))
    return false;
  return true;
}

template <typename T, UnusedTabInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stale_tabs < rhs.stale_tabs)
    return true;
  if (rhs.stale_tabs < lhs.stale_tabs)
    return false;
  if (lhs.duplicate_tabs < rhs.duplicate_tabs)
    return true;
  if (rhs.duplicate_tabs < lhs.duplicate_tabs)
    return false;
  return false;
}


}  // tab_search::mojom

namespace mojo {


template <>
struct  StructTraits<::tab_search::mojom::ProfileData::DataView,
                                         ::tab_search::mojom::ProfileDataPtr> {
  static bool IsNull(const ::tab_search::mojom::ProfileDataPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::ProfileDataPtr* output) { output->reset(); }

  static const decltype(::tab_search::mojom::ProfileData::windows)& windows(
      const ::tab_search::mojom::ProfileDataPtr& input) {
    return input->windows;
  }

  static const decltype(::tab_search::mojom::ProfileData::tab_groups)& tab_groups(
      const ::tab_search::mojom::ProfileDataPtr& input) {
    return input->tab_groups;
  }

  static const decltype(::tab_search::mojom::ProfileData::recently_closed_tabs)& recently_closed_tabs(
      const ::tab_search::mojom::ProfileDataPtr& input) {
    return input->recently_closed_tabs;
  }

  static const decltype(::tab_search::mojom::ProfileData::recently_closed_tab_groups)& recently_closed_tab_groups(
      const ::tab_search::mojom::ProfileDataPtr& input) {
    return input->recently_closed_tab_groups;
  }

  static decltype(::tab_search::mojom::ProfileData::recently_closed_section_expanded) recently_closed_section_expanded(
      const ::tab_search::mojom::ProfileDataPtr& input) {
    return input->recently_closed_section_expanded;
  }

  static bool Read(::tab_search::mojom::ProfileData::DataView input, ::tab_search::mojom::ProfileDataPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::Window::DataView,
                                         ::tab_search::mojom::WindowPtr> {
  static bool IsNull(const ::tab_search::mojom::WindowPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::WindowPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::Window::active) active(
      const ::tab_search::mojom::WindowPtr& input) {
    return input->active;
  }

  static decltype(::tab_search::mojom::Window::is_host_window) is_host_window(
      const ::tab_search::mojom::WindowPtr& input) {
    return input->is_host_window;
  }

  static decltype(::tab_search::mojom::Window::height) height(
      const ::tab_search::mojom::WindowPtr& input) {
    return input->height;
  }

  static const decltype(::tab_search::mojom::Window::tabs)& tabs(
      const ::tab_search::mojom::WindowPtr& input) {
    return input->tabs;
  }

  static bool Read(::tab_search::mojom::Window::DataView input, ::tab_search::mojom::WindowPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::Tab::DataView,
                                         ::tab_search::mojom::TabPtr> {
  static bool IsNull(const ::tab_search::mojom::TabPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::TabPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::Tab::active) active(
      const ::tab_search::mojom::TabPtr& input) {
    return input->active;
  }

  static decltype(::tab_search::mojom::Tab::visible) visible(
      const ::tab_search::mojom::TabPtr& input) {
    return input->visible;
  }

  static const decltype(::tab_search::mojom::Tab::alert_states)& alert_states(
      const ::tab_search::mojom::TabPtr& input) {
    return input->alert_states;
  }

  static decltype(::tab_search::mojom::Tab::index) index(
      const ::tab_search::mojom::TabPtr& input) {
    return input->index;
  }

  static decltype(::tab_search::mojom::Tab::tab_id) tab_id(
      const ::tab_search::mojom::TabPtr& input) {
    return input->tab_id;
  }

  static const decltype(::tab_search::mojom::Tab::group_id)& group_id(
      const ::tab_search::mojom::TabPtr& input) {
    return input->group_id;
  }

  static decltype(::tab_search::mojom::Tab::pinned) pinned(
      const ::tab_search::mojom::TabPtr& input) {
    return input->pinned;
  }

  static decltype(::tab_search::mojom::Tab::split) split(
      const ::tab_search::mojom::TabPtr& input) {
    return input->split;
  }

  static const decltype(::tab_search::mojom::Tab::title)& title(
      const ::tab_search::mojom::TabPtr& input) {
    return input->title;
  }

  static const decltype(::tab_search::mojom::Tab::url)& url(
      const ::tab_search::mojom::TabPtr& input) {
    return input->url;
  }

  static const decltype(::tab_search::mojom::Tab::favicon_url)& favicon_url(
      const ::tab_search::mojom::TabPtr& input) {
    return input->favicon_url;
  }

  static decltype(::tab_search::mojom::Tab::is_default_favicon) is_default_favicon(
      const ::tab_search::mojom::TabPtr& input) {
    return input->is_default_favicon;
  }

  static decltype(::tab_search::mojom::Tab::show_icon) show_icon(
      const ::tab_search::mojom::TabPtr& input) {
    return input->show_icon;
  }

  static const decltype(::tab_search::mojom::Tab::last_active_time_ticks)& last_active_time_ticks(
      const ::tab_search::mojom::TabPtr& input) {
    return input->last_active_time_ticks;
  }

  static const decltype(::tab_search::mojom::Tab::last_active_elapsed_text)& last_active_elapsed_text(
      const ::tab_search::mojom::TabPtr& input) {
    return input->last_active_elapsed_text;
  }

  static bool Read(::tab_search::mojom::Tab::DataView input, ::tab_search::mojom::TabPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::RecentlyClosedTab::DataView,
                                         ::tab_search::mojom::RecentlyClosedTabPtr> {
  static bool IsNull(const ::tab_search::mojom::RecentlyClosedTabPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::RecentlyClosedTabPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::RecentlyClosedTab::tab_id) tab_id(
      const ::tab_search::mojom::RecentlyClosedTabPtr& input) {
    return input->tab_id;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTab::group_id)& group_id(
      const ::tab_search::mojom::RecentlyClosedTabPtr& input) {
    return input->group_id;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTab::title)& title(
      const ::tab_search::mojom::RecentlyClosedTabPtr& input) {
    return input->title;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTab::url)& url(
      const ::tab_search::mojom::RecentlyClosedTabPtr& input) {
    return input->url;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTab::last_active_time)& last_active_time(
      const ::tab_search::mojom::RecentlyClosedTabPtr& input) {
    return input->last_active_time;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTab::last_active_elapsed_text)& last_active_elapsed_text(
      const ::tab_search::mojom::RecentlyClosedTabPtr& input) {
    return input->last_active_elapsed_text;
  }

  static bool Read(::tab_search::mojom::RecentlyClosedTab::DataView input, ::tab_search::mojom::RecentlyClosedTabPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::TabGroup::DataView,
                                         ::tab_search::mojom::TabGroupPtr> {
  static bool IsNull(const ::tab_search::mojom::TabGroupPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::TabGroupPtr* output) { output->reset(); }

  static const decltype(::tab_search::mojom::TabGroup::id)& id(
      const ::tab_search::mojom::TabGroupPtr& input) {
    return input->id;
  }

  static decltype(::tab_search::mojom::TabGroup::color) color(
      const ::tab_search::mojom::TabGroupPtr& input) {
    return input->color;
  }

  static const decltype(::tab_search::mojom::TabGroup::title)& title(
      const ::tab_search::mojom::TabGroupPtr& input) {
    return input->title;
  }

  static bool Read(::tab_search::mojom::TabGroup::DataView input, ::tab_search::mojom::TabGroupPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::RecentlyClosedTabGroup::DataView,
                                         ::tab_search::mojom::RecentlyClosedTabGroupPtr> {
  static bool IsNull(const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::RecentlyClosedTabGroupPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::RecentlyClosedTabGroup::session_id) session_id(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->session_id;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTabGroup::id)& id(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->id;
  }

  static decltype(::tab_search::mojom::RecentlyClosedTabGroup::color) color(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->color;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTabGroup::title)& title(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->title;
  }

  static decltype(::tab_search::mojom::RecentlyClosedTabGroup::tab_count) tab_count(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->tab_count;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTabGroup::last_active_time)& last_active_time(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->last_active_time;
  }

  static const decltype(::tab_search::mojom::RecentlyClosedTabGroup::last_active_elapsed_text)& last_active_elapsed_text(
      const ::tab_search::mojom::RecentlyClosedTabGroupPtr& input) {
    return input->last_active_elapsed_text;
  }

  static bool Read(::tab_search::mojom::RecentlyClosedTabGroup::DataView input, ::tab_search::mojom::RecentlyClosedTabGroupPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::SwitchToTabInfo::DataView,
                                         ::tab_search::mojom::SwitchToTabInfoPtr> {
  static bool IsNull(const ::tab_search::mojom::SwitchToTabInfoPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::SwitchToTabInfoPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::SwitchToTabInfo::tab_id) tab_id(
      const ::tab_search::mojom::SwitchToTabInfoPtr& input) {
    return input->tab_id;
  }

  static bool Read(::tab_search::mojom::SwitchToTabInfo::DataView input, ::tab_search::mojom::SwitchToTabInfoPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::TabOrganization::DataView,
                                         ::tab_search::mojom::TabOrganizationPtr> {
  static bool IsNull(const ::tab_search::mojom::TabOrganizationPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::TabOrganizationPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::TabOrganization::organization_id) organization_id(
      const ::tab_search::mojom::TabOrganizationPtr& input) {
    return input->organization_id;
  }

  static const decltype(::tab_search::mojom::TabOrganization::tabs)& tabs(
      const ::tab_search::mojom::TabOrganizationPtr& input) {
    return input->tabs;
  }

  static decltype(::tab_search::mojom::TabOrganization::first_new_tab_index) first_new_tab_index(
      const ::tab_search::mojom::TabOrganizationPtr& input) {
    return input->first_new_tab_index;
  }

  static const decltype(::tab_search::mojom::TabOrganization::name)& name(
      const ::tab_search::mojom::TabOrganizationPtr& input) {
    return input->name;
  }

  static bool Read(::tab_search::mojom::TabOrganization::DataView input, ::tab_search::mojom::TabOrganizationPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::TabOrganizationSession::DataView,
                                         ::tab_search::mojom::TabOrganizationSessionPtr> {
  static bool IsNull(const ::tab_search::mojom::TabOrganizationSessionPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::TabOrganizationSessionPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::TabOrganizationSession::session_id) session_id(
      const ::tab_search::mojom::TabOrganizationSessionPtr& input) {
    return input->session_id;
  }

  static decltype(::tab_search::mojom::TabOrganizationSession::state) state(
      const ::tab_search::mojom::TabOrganizationSessionPtr& input) {
    return input->state;
  }

  static const decltype(::tab_search::mojom::TabOrganizationSession::organizations)& organizations(
      const ::tab_search::mojom::TabOrganizationSessionPtr& input) {
    return input->organizations;
  }

  static decltype(::tab_search::mojom::TabOrganizationSession::error) error(
      const ::tab_search::mojom::TabOrganizationSessionPtr& input) {
    return input->error;
  }

  static decltype(::tab_search::mojom::TabOrganizationSession::active_tab_id) active_tab_id(
      const ::tab_search::mojom::TabOrganizationSessionPtr& input) {
    return input->active_tab_id;
  }

  static bool Read(::tab_search::mojom::TabOrganizationSession::DataView input, ::tab_search::mojom::TabOrganizationSessionPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::TabUpdateInfo::DataView,
                                         ::tab_search::mojom::TabUpdateInfoPtr> {
  static bool IsNull(const ::tab_search::mojom::TabUpdateInfoPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::TabUpdateInfoPtr* output) { output->reset(); }

  static decltype(::tab_search::mojom::TabUpdateInfo::in_active_window) in_active_window(
      const ::tab_search::mojom::TabUpdateInfoPtr& input) {
    return input->in_active_window;
  }

  static decltype(::tab_search::mojom::TabUpdateInfo::in_host_window) in_host_window(
      const ::tab_search::mojom::TabUpdateInfoPtr& input) {
    return input->in_host_window;
  }

  static const decltype(::tab_search::mojom::TabUpdateInfo::tab)& tab(
      const ::tab_search::mojom::TabUpdateInfoPtr& input) {
    return input->tab;
  }

  static bool Read(::tab_search::mojom::TabUpdateInfo::DataView input, ::tab_search::mojom::TabUpdateInfoPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::TabsRemovedInfo::DataView,
                                         ::tab_search::mojom::TabsRemovedInfoPtr> {
  static bool IsNull(const ::tab_search::mojom::TabsRemovedInfoPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::TabsRemovedInfoPtr* output) { output->reset(); }

  static const decltype(::tab_search::mojom::TabsRemovedInfo::tab_ids)& tab_ids(
      const ::tab_search::mojom::TabsRemovedInfoPtr& input) {
    return input->tab_ids;
  }

  static const decltype(::tab_search::mojom::TabsRemovedInfo::recently_closed_tabs)& recently_closed_tabs(
      const ::tab_search::mojom::TabsRemovedInfoPtr& input) {
    return input->recently_closed_tabs;
  }

  static bool Read(::tab_search::mojom::TabsRemovedInfo::DataView input, ::tab_search::mojom::TabsRemovedInfoPtr* output);
};


template <>
struct  StructTraits<::tab_search::mojom::UnusedTabInfo::DataView,
                                         ::tab_search::mojom::UnusedTabInfoPtr> {
  static bool IsNull(const ::tab_search::mojom::UnusedTabInfoPtr& input) { return !input; }
  static void SetToNull(::tab_search::mojom::UnusedTabInfoPtr* output) { output->reset(); }

  static const decltype(::tab_search::mojom::UnusedTabInfo::stale_tabs)& stale_tabs(
      const ::tab_search::mojom::UnusedTabInfoPtr& input) {
    return input->stale_tabs;
  }

  static const decltype(::tab_search::mojom::UnusedTabInfo::duplicate_tabs)& duplicate_tabs(
      const ::tab_search::mojom::UnusedTabInfoPtr& input) {
    return input->duplicate_tabs;
  }

  static bool Read(::tab_search::mojom::UnusedTabInfo::DataView input, ::tab_search::mojom::UnusedTabInfoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_H_