// chrome/browser/ui/webui/tab_search/tab_search.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-params-data.h"
namespace tab_search {
namespace mojom {

NOINLINE static const char* DeclutterCTREventToStringHelper(DeclutterCTREvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeclutterCTREvent::kDeclutterShown:
      return "kDeclutterShown";
    case DeclutterCTREvent::kCloseTabsClicked:
      return "kCloseTabsClicked";
    default:
      return nullptr;
  }
}

std::string DeclutterCTREventToString(DeclutterCTREvent value) {
  const char *str = DeclutterCTREventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeclutterCTREvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeclutterCTREvent value) {
  return os << DeclutterCTREventToString(value);
}

NOINLINE static const char* SelectorCTREventToStringHelper(SelectorCTREvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SelectorCTREvent::kSelectorShown:
      return "kSelectorShown";
    case SelectorCTREvent::kAutoTabGroupsClicked:
      return "kAutoTabGroupsClicked";
    case SelectorCTREvent::kDeclutterClicked:
      return "kDeclutterClicked";
    default:
      return nullptr;
  }
}

std::string SelectorCTREventToString(SelectorCTREvent value) {
  const char *str = SelectorCTREventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SelectorCTREvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SelectorCTREvent value) {
  return os << SelectorCTREventToString(value);
}

NOINLINE static const char* TabDeclutterEntryPointToStringHelper(TabDeclutterEntryPoint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabDeclutterEntryPoint::kNudge:
      return "kNudge";
    case TabDeclutterEntryPoint::kAppMenu:
      return "kAppMenu";
    case TabDeclutterEntryPoint::kSelector:
      return "kSelector";
    default:
      return nullptr;
  }
}

std::string TabDeclutterEntryPointToString(TabDeclutterEntryPoint value) {
  const char *str = TabDeclutterEntryPointToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabDeclutterEntryPoint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabDeclutterEntryPoint value) {
  return os << TabDeclutterEntryPointToString(value);
}

NOINLINE static const char* TabOrganizationStateToStringHelper(TabOrganizationState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabOrganizationState::kInitializing:
      return "kInitializing";
    case TabOrganizationState::kNotStarted:
      return "kNotStarted";
    case TabOrganizationState::kInProgress:
      return "kInProgress";
    case TabOrganizationState::kSuccess:
      return "kSuccess";
    case TabOrganizationState::kFailure:
      return "kFailure";
    default:
      return nullptr;
  }
}

std::string TabOrganizationStateToString(TabOrganizationState value) {
  const char *str = TabOrganizationStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabOrganizationState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabOrganizationState value) {
  return os << TabOrganizationStateToString(value);
}

NOINLINE static const char* TabOrganizationFeatureToStringHelper(TabOrganizationFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabOrganizationFeature::kNone:
      return "kNone";
    case TabOrganizationFeature::kSelector:
      return "kSelector";
    case TabOrganizationFeature::kAutoTabGroups:
      return "kAutoTabGroups";
    case TabOrganizationFeature::kDeclutter:
      return "kDeclutter";
    default:
      return nullptr;
  }
}

std::string TabOrganizationFeatureToString(TabOrganizationFeature value) {
  const char *str = TabOrganizationFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabOrganizationFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabOrganizationFeature value) {
  return os << TabOrganizationFeatureToString(value);
}

NOINLINE static const char* TabOrganizationErrorToStringHelper(TabOrganizationError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabOrganizationError::kNone:
      return "kNone";
    case TabOrganizationError::kGrouping:
      return "kGrouping";
    case TabOrganizationError::kGeneric:
      return "kGeneric";
    default:
      return nullptr;
  }
}

std::string TabOrganizationErrorToString(TabOrganizationError value) {
  const char *str = TabOrganizationErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabOrganizationError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabOrganizationError value) {
  return os << TabOrganizationErrorToString(value);
}

NOINLINE static const char* TabOrganizationModelStrategyToStringHelper(TabOrganizationModelStrategy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabOrganizationModelStrategy::kTopic:
      return "kTopic";
    case TabOrganizationModelStrategy::kTask:
      return "kTask";
    case TabOrganizationModelStrategy::kDomain:
      return "kDomain";
    default:
      return nullptr;
  }
}

std::string TabOrganizationModelStrategyToString(TabOrganizationModelStrategy value) {
  const char *str = TabOrganizationModelStrategyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabOrganizationModelStrategy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabOrganizationModelStrategy value) {
  return os << TabOrganizationModelStrategyToString(value);
}

NOINLINE static const char* TabSearchSectionToStringHelper(TabSearchSection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabSearchSection::kNone:
      return "kNone";
    case TabSearchSection::kSearch:
      return "kSearch";
    case TabSearchSection::kOrganize:
      return "kOrganize";
    default:
      return nullptr;
  }
}

std::string TabSearchSectionToString(TabSearchSection value) {
  const char *str = TabSearchSectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabSearchSection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabSearchSection value) {
  return os << TabSearchSectionToString(value);
}

NOINLINE static const char* UserFeedbackToStringHelper(UserFeedback value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserFeedback::kUserFeedBackUnspecified:
      return "kUserFeedBackUnspecified";
    case UserFeedback::kUserFeedBackPositive:
      return "kUserFeedBackPositive";
    case UserFeedback::kUserFeedBackNegative:
      return "kUserFeedBackNegative";
    default:
      return nullptr;
  }
}

std::string UserFeedbackToString(UserFeedback value) {
  const char *str = UserFeedbackToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserFeedback value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserFeedback value) {
  return os << UserFeedbackToString(value);
}

namespace internal {


// static
bool ProfileData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileData_Data* object =
      static_cast<const ProfileData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->windows, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->windows, validation_context,
                                         &windows_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_groups, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_groups, validation_context,
                                         &tab_groups_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recently_closed_tabs, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& recently_closed_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->recently_closed_tabs, validation_context,
                                         &recently_closed_tabs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recently_closed_tab_groups, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& recently_closed_tab_groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->recently_closed_tab_groups, validation_context,
                                         &recently_closed_tab_groups_validate_params)) {
    return false;
  }

  return true;
}

ProfileData_Data::ProfileData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Window_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Window_Data* object =
      static_cast<const Window_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  return true;
}

Window_Data::Window_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tab_Data* object =
      static_cast<const Tab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_states, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->alert_states, validation_context,
                                         &alert_states_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_time_ticks, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_active_time_ticks, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_elapsed_text, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_active_elapsed_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_active_elapsed_text, validation_context,
                                         &last_active_elapsed_text_validate_params)) {
    return false;
  }

  return true;
}

Tab_Data::Tab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RecentlyClosedTab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RecentlyClosedTab_Data* object =
      static_cast<const RecentlyClosedTab_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->group_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_active_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_elapsed_text, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_active_elapsed_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_active_elapsed_text, validation_context,
                                         &last_active_elapsed_text_validate_params)) {
    return false;
  }

  return true;
}

RecentlyClosedTab_Data::RecentlyClosedTab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabGroup_Data* object =
      static_cast<const TabGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;


  if (!::tab_groups::mojom::internal::Color_Data
        ::Validate(object->color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

TabGroup_Data::TabGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RecentlyClosedTabGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RecentlyClosedTabGroup_Data* object =
      static_cast<const RecentlyClosedTabGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;


  if (!::tab_groups::mojom::internal::Color_Data
        ::Validate(object->color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_active_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_elapsed_text, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_active_elapsed_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_active_elapsed_text, validation_context,
                                         &last_active_elapsed_text_validate_params)) {
    return false;
  }

  return true;
}

RecentlyClosedTabGroup_Data::RecentlyClosedTabGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SwitchToTabInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SwitchToTabInfo_Data* object =
      static_cast<const SwitchToTabInfo_Data*>(data);

  return true;
}

SwitchToTabInfo_Data::SwitchToTabInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabOrganization_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabOrganization_Data* object =
      static_cast<const TabOrganization_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  return true;
}

TabOrganization_Data::TabOrganization_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabOrganizationSession_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabOrganizationSession_Data* object =
      static_cast<const TabOrganizationSession_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->organizations, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& organizations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->organizations, validation_context,
                                         &organizations_validate_params)) {
    return false;
  }


  if (!::tab_search::mojom::internal::TabOrganizationError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

TabOrganizationSession_Data::TabOrganizationSession_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabUpdateInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabUpdateInfo_Data* object =
      static_cast<const TabUpdateInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  return true;
}

TabUpdateInfo_Data::TabUpdateInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabsRemovedInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabsRemovedInfo_Data* object =
      static_cast<const TabsRemovedInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_ids, validation_context,
                                         &tab_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recently_closed_tabs, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& recently_closed_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->recently_closed_tabs, validation_context,
                                         &recently_closed_tabs_validate_params)) {
    return false;
  }

  return true;
}

TabsRemovedInfo_Data::TabsRemovedInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnusedTabInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnusedTabInfo_Data* object =
      static_cast<const UnusedTabInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stale_tabs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stale_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stale_tabs, validation_context,
                                         &stale_tabs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duplicate_tabs, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& duplicate_tabs_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->duplicate_tabs, validation_context,
                                         &duplicate_tabs_validate_params)) {
    return false;
  }

  return true;
}

UnusedTabInfo_Data::UnusedTabInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseTab_Params_Data* object =
      static_cast<const PageHandler_CloseTab_Params_Data*>(data);

  return true;
}

PageHandler_CloseTab_Params_Data::PageHandler_CloseTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseWebUiTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseWebUiTab_Params_Data* object =
      static_cast<const PageHandler_CloseWebUiTab_Params_Data*>(data);

  return true;
}

PageHandler_CloseWebUiTab_Params_Data::PageHandler_CloseWebUiTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeclutterTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeclutterTabs_Params_Data* object =
      static_cast<const PageHandler_DeclutterTabs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_ids, validation_context,
                                         &tab_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_DeclutterTabs_Params_Data::PageHandler_DeclutterTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AcceptTabOrganization_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AcceptTabOrganization_Params_Data* object =
      static_cast<const PageHandler_AcceptTabOrganization_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_AcceptTabOrganization_Params_Data::PageHandler_AcceptTabOrganization_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RejectTabOrganization_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RejectTabOrganization_Params_Data* object =
      static_cast<const PageHandler_RejectTabOrganization_Params_Data*>(data);

  return true;
}

PageHandler_RejectTabOrganization_Params_Data::PageHandler_RejectTabOrganization_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RenameTabOrganization_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RenameTabOrganization_Params_Data* object =
      static_cast<const PageHandler_RenameTabOrganization_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  return true;
}

PageHandler_RenameTabOrganization_Params_Data::PageHandler_RenameTabOrganization_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ExcludeFromStaleTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ExcludeFromStaleTabs_Params_Data* object =
      static_cast<const PageHandler_ExcludeFromStaleTabs_Params_Data*>(data);

  return true;
}

PageHandler_ExcludeFromStaleTabs_Params_Data::PageHandler_ExcludeFromStaleTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ExcludeFromDuplicateTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ExcludeFromDuplicateTabs_Params_Data* object =
      static_cast<const PageHandler_ExcludeFromDuplicateTabs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_ExcludeFromDuplicateTabs_Params_Data::PageHandler_ExcludeFromDuplicateTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetProfileData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetProfileData_Params_Data* object =
      static_cast<const PageHandler_GetProfileData_Params_Data*>(data);

  return true;
}

PageHandler_GetProfileData_Params_Data::PageHandler_GetProfileData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetProfileData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetProfileData_ResponseParams_Data* object =
      static_cast<const PageHandler_GetProfileData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile_data, validation_context))
    return false;

  return true;
}

PageHandler_GetProfileData_ResponseParams_Data::PageHandler_GetProfileData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetUnusedTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetUnusedTabs_Params_Data* object =
      static_cast<const PageHandler_GetUnusedTabs_Params_Data*>(data);

  return true;
}

PageHandler_GetUnusedTabs_Params_Data::PageHandler_GetUnusedTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetUnusedTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetUnusedTabs_ResponseParams_Data* object =
      static_cast<const PageHandler_GetUnusedTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tabs, validation_context))
    return false;

  return true;
}

PageHandler_GetUnusedTabs_ResponseParams_Data::PageHandler_GetUnusedTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabSearchSection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabSearchSection_Params_Data* object =
      static_cast<const PageHandler_GetTabSearchSection_Params_Data*>(data);

  return true;
}

PageHandler_GetTabSearchSection_Params_Data::PageHandler_GetTabSearchSection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabSearchSection_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabSearchSection_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabSearchSection_ResponseParams_Data*>(data);


  if (!::tab_search::mojom::internal::TabSearchSection_Data
        ::Validate(object->section, validation_context))
    return false;

  return true;
}

PageHandler_GetTabSearchSection_ResponseParams_Data::PageHandler_GetTabSearchSection_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabOrganizationFeature_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabOrganizationFeature_Params_Data* object =
      static_cast<const PageHandler_GetTabOrganizationFeature_Params_Data*>(data);

  return true;
}

PageHandler_GetTabOrganizationFeature_Params_Data::PageHandler_GetTabOrganizationFeature_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabOrganizationFeature_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabOrganizationFeature_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabOrganizationFeature_ResponseParams_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

PageHandler_GetTabOrganizationFeature_ResponseParams_Data::PageHandler_GetTabOrganizationFeature_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabOrganizationSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabOrganizationSession_Params_Data* object =
      static_cast<const PageHandler_GetTabOrganizationSession_Params_Data*>(data);

  return true;
}

PageHandler_GetTabOrganizationSession_Params_Data::PageHandler_GetTabOrganizationSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabOrganizationSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabOrganizationSession_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabOrganizationSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  return true;
}

PageHandler_GetTabOrganizationSession_ResponseParams_Data::PageHandler_GetTabOrganizationSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabOrganizationModelStrategy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabOrganizationModelStrategy_Params_Data* object =
      static_cast<const PageHandler_GetTabOrganizationModelStrategy_Params_Data*>(data);

  return true;
}

PageHandler_GetTabOrganizationModelStrategy_Params_Data::PageHandler_GetTabOrganizationModelStrategy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationModelStrategy_Data
        ::Validate(object->strategy, validation_context))
    return false;

  return true;
}

PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data::PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetIsSplit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetIsSplit_Params_Data* object =
      static_cast<const PageHandler_GetIsSplit_Params_Data*>(data);

  return true;
}

PageHandler_GetIsSplit_Params_Data::PageHandler_GetIsSplit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetIsSplit_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetIsSplit_ResponseParams_Data* object =
      static_cast<const PageHandler_GetIsSplit_ResponseParams_Data*>(data);

  return true;
}

PageHandler_GetIsSplit_ResponseParams_Data::PageHandler_GetIsSplit_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SwitchToTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SwitchToTab_Params_Data* object =
      static_cast<const PageHandler_SwitchToTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->switch_to_tab_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->switch_to_tab_info, validation_context))
    return false;

  return true;
}

PageHandler_SwitchToTab_Params_Data::PageHandler_SwitchToTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenRecentlyClosedEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenRecentlyClosedEntry_Params_Data* object =
      static_cast<const PageHandler_OpenRecentlyClosedEntry_Params_Data*>(data);

  return true;
}

PageHandler_OpenRecentlyClosedEntry_Params_Data::PageHandler_OpenRecentlyClosedEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RequestTabOrganization_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RequestTabOrganization_Params_Data* object =
      static_cast<const PageHandler_RequestTabOrganization_Params_Data*>(data);

  return true;
}

PageHandler_RequestTabOrganization_Params_Data::PageHandler_RequestTabOrganization_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RemoveTabFromOrganization_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RemoveTabFromOrganization_Params_Data* object =
      static_cast<const PageHandler_RemoveTabFromOrganization_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  return true;
}

PageHandler_RemoveTabFromOrganization_Params_Data::PageHandler_RemoveTabFromOrganization_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RejectSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RejectSession_Params_Data* object =
      static_cast<const PageHandler_RejectSession_Params_Data*>(data);

  return true;
}

PageHandler_RejectSession_Params_Data::PageHandler_RejectSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReplaceActiveSplitTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReplaceActiveSplitTab_Params_Data* object =
      static_cast<const PageHandler_ReplaceActiveSplitTab_Params_Data*>(data);

  return true;
}

PageHandler_ReplaceActiveSplitTab_Params_Data::PageHandler_ReplaceActiveSplitTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RestartSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RestartSession_Params_Data* object =
      static_cast<const PageHandler_RestartSession_Params_Data*>(data);

  return true;
}

PageHandler_RestartSession_Params_Data::PageHandler_RestartSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SaveRecentlyClosedExpandedPref_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SaveRecentlyClosedExpandedPref_Params_Data* object =
      static_cast<const PageHandler_SaveRecentlyClosedExpandedPref_Params_Data*>(data);

  return true;
}

PageHandler_SaveRecentlyClosedExpandedPref_Params_Data::PageHandler_SaveRecentlyClosedExpandedPref_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetOrganizationFeature_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetOrganizationFeature_Params_Data* object =
      static_cast<const PageHandler_SetOrganizationFeature_Params_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

PageHandler_SetOrganizationFeature_Params_Data::PageHandler_SetOrganizationFeature_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StartTabGroupTutorial_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StartTabGroupTutorial_Params_Data* object =
      static_cast<const PageHandler_StartTabGroupTutorial_Params_Data*>(data);

  return true;
}

PageHandler_StartTabGroupTutorial_Params_Data::PageHandler_StartTabGroupTutorial_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_TriggerFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_TriggerFeedback_Params_Data* object =
      static_cast<const PageHandler_TriggerFeedback_Params_Data*>(data);

  return true;
}

PageHandler_TriggerFeedback_Params_Data::PageHandler_TriggerFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_TriggerSignIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_TriggerSignIn_Params_Data* object =
      static_cast<const PageHandler_TriggerSignIn_Params_Data*>(data);

  return true;
}

PageHandler_TriggerSignIn_Params_Data::PageHandler_TriggerSignIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenHelpPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenHelpPage_Params_Data* object =
      static_cast<const PageHandler_OpenHelpPage_Params_Data*>(data);

  return true;
}

PageHandler_OpenHelpPage_Params_Data::PageHandler_OpenHelpPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetTabOrganizationModelStrategy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetTabOrganizationModelStrategy_Params_Data* object =
      static_cast<const PageHandler_SetTabOrganizationModelStrategy_Params_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationModelStrategy_Data
        ::Validate(object->strategy, validation_context))
    return false;

  return true;
}

PageHandler_SetTabOrganizationModelStrategy_Params_Data::PageHandler_SetTabOrganizationModelStrategy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetTabOrganizationUserInstruction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetTabOrganizationUserInstruction_Params_Data* object =
      static_cast<const PageHandler_SetTabOrganizationUserInstruction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_instruction, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_instruction_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_instruction, validation_context,
                                         &user_instruction_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetTabOrganizationUserInstruction_Params_Data::PageHandler_SetTabOrganizationUserInstruction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetUserFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetUserFeedback_Params_Data* object =
      static_cast<const PageHandler_SetUserFeedback_Params_Data*>(data);


  if (!::tab_search::mojom::internal::UserFeedback_Data
        ::Validate(object->feedback, validation_context))
    return false;

  return true;
}

PageHandler_SetUserFeedback_Params_Data::PageHandler_SetUserFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_NotifyOrganizationUIReadyToShow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_NotifyOrganizationUIReadyToShow_Params_Data* object =
      static_cast<const PageHandler_NotifyOrganizationUIReadyToShow_Params_Data*>(data);

  return true;
}

PageHandler_NotifyOrganizationUIReadyToShow_Params_Data::PageHandler_NotifyOrganizationUIReadyToShow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_NotifySearchUIReadyToShow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_NotifySearchUIReadyToShow_Params_Data* object =
      static_cast<const PageHandler_NotifySearchUIReadyToShow_Params_Data*>(data);

  return true;
}

PageHandler_NotifySearchUIReadyToShow_Params_Data::PageHandler_NotifySearchUIReadyToShow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabOrganizationSessionUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabOrganizationSessionUpdated_Params_Data* object =
      static_cast<const Page_TabOrganizationSessionUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  return true;
}

Page_TabOrganizationSessionUpdated_Params_Data::Page_TabOrganizationSessionUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabOrganizationModelStrategyUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabOrganizationModelStrategyUpdated_Params_Data* object =
      static_cast<const Page_TabOrganizationModelStrategyUpdated_Params_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationModelStrategy_Data
        ::Validate(object->strategy, validation_context))
    return false;

  return true;
}

Page_TabOrganizationModelStrategyUpdated_Params_Data::Page_TabOrganizationModelStrategyUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_HostWindowChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_HostWindowChanged_Params_Data* object =
      static_cast<const Page_HostWindowChanged_Params_Data*>(data);

  return true;
}

Page_HostWindowChanged_Params_Data::Page_HostWindowChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabsChanged_Params_Data* object =
      static_cast<const Page_TabsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_tabs, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile_tabs, validation_context))
    return false;

  return true;
}

Page_TabsChanged_Params_Data::Page_TabsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabUpdated_Params_Data* object =
      static_cast<const Page_TabUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabUpdateInfo, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tabUpdateInfo, validation_context))
    return false;

  return true;
}

Page_TabUpdated_Params_Data::Page_TabUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabsRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabsRemoved_Params_Data* object =
      static_cast<const Page_TabsRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabsRemovedInfo, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tabsRemovedInfo, validation_context))
    return false;

  return true;
}

Page_TabsRemoved_Params_Data::Page_TabsRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabSearchSectionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabSearchSectionChanged_Params_Data* object =
      static_cast<const Page_TabSearchSectionChanged_Params_Data*>(data);


  if (!::tab_search::mojom::internal::TabSearchSection_Data
        ::Validate(object->section, validation_context))
    return false;

  return true;
}

Page_TabSearchSectionChanged_Params_Data::Page_TabSearchSectionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabOrganizationFeatureChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabOrganizationFeatureChanged_Params_Data* object =
      static_cast<const Page_TabOrganizationFeatureChanged_Params_Data*>(data);


  if (!::tab_search::mojom::internal::TabOrganizationFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

Page_TabOrganizationFeatureChanged_Params_Data::Page_TabOrganizationFeatureChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ShowFREChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ShowFREChanged_Params_Data* object =
      static_cast<const Page_ShowFREChanged_Params_Data*>(data);

  return true;
}

Page_ShowFREChanged_Params_Data::Page_ShowFREChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabOrganizationEnabledChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabOrganizationEnabledChanged_Params_Data* object =
      static_cast<const Page_TabOrganizationEnabledChanged_Params_Data*>(data);

  return true;
}

Page_TabOrganizationEnabledChanged_Params_Data::Page_TabOrganizationEnabledChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_UnusedTabsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_UnusedTabsChanged_Params_Data* object =
      static_cast<const Page_UnusedTabsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tabs, validation_context))
    return false;

  return true;
}

Page_UnusedTabsChanged_Params_Data::Page_UnusedTabsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_TabUnsplit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_TabUnsplit_Params_Data* object =
      static_cast<const Page_TabUnsplit_Params_Data*>(data);

  return true;
}

Page_TabUnsplit_Params_Data::Page_TabUnsplit_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tab_search

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::DeclutterCTREvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::DeclutterCTREvent value) {
  return std::move(context).WriteString(::tab_search::mojom::DeclutterCTREventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::SelectorCTREvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::SelectorCTREvent value) {
  return std::move(context).WriteString(::tab_search::mojom::SelectorCTREventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::TabDeclutterEntryPoint>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::TabDeclutterEntryPoint value) {
  return std::move(context).WriteString(::tab_search::mojom::TabDeclutterEntryPointToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::TabOrganizationState>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationState value) {
  return std::move(context).WriteString(::tab_search::mojom::TabOrganizationStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::TabOrganizationFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationFeature value) {
  return std::move(context).WriteString(::tab_search::mojom::TabOrganizationFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::TabOrganizationError>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationError value) {
  return std::move(context).WriteString(::tab_search::mojom::TabOrganizationErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::TabOrganizationModelStrategy>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::TabOrganizationModelStrategy value) {
  return std::move(context).WriteString(::tab_search::mojom::TabOrganizationModelStrategyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::TabSearchSection>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::TabSearchSection value) {
  return std::move(context).WriteString(::tab_search::mojom::TabSearchSectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tab_search::mojom::UserFeedback>::WriteIntoTrace(
   perfetto::TracedValue context, ::tab_search::mojom::UserFeedback value) {
  return std::move(context).WriteString(::tab_search::mojom::UserFeedbackToString(value));
}

} // namespace perfetto