// chrome/browser/ui/webui/tab_search/tab_search.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"


namespace tab_search::mojom {
class ProfileDataDataView;

class WindowDataView;

class TabDataView;

class RecentlyClosedTabDataView;

class TabGroupDataView;

class RecentlyClosedTabGroupDataView;

class SwitchToTabInfoDataView;

class TabOrganizationDataView;

class TabOrganizationSessionDataView;

class TabUpdateInfoDataView;

class TabsRemovedInfoDataView;

class UnusedTabInfoDataView;



}  // tab_search::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tab_search::mojom::ProfileDataDataView> {
  using Data = ::tab_search::mojom::internal::ProfileData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::WindowDataView> {
  using Data = ::tab_search::mojom::internal::Window_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::TabDataView> {
  using Data = ::tab_search::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::RecentlyClosedTabDataView> {
  using Data = ::tab_search::mojom::internal::RecentlyClosedTab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::TabGroupDataView> {
  using Data = ::tab_search::mojom::internal::TabGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::RecentlyClosedTabGroupDataView> {
  using Data = ::tab_search::mojom::internal::RecentlyClosedTabGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::SwitchToTabInfoDataView> {
  using Data = ::tab_search::mojom::internal::SwitchToTabInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::TabOrganizationDataView> {
  using Data = ::tab_search::mojom::internal::TabOrganization_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::TabOrganizationSessionDataView> {
  using Data = ::tab_search::mojom::internal::TabOrganizationSession_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::TabUpdateInfoDataView> {
  using Data = ::tab_search::mojom::internal::TabUpdateInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::TabsRemovedInfoDataView> {
  using Data = ::tab_search::mojom::internal::TabsRemovedInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_search::mojom::UnusedTabInfoDataView> {
  using Data = ::tab_search::mojom::internal::UnusedTabInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tab_search::mojom {


enum class DeclutterCTREvent : int32_t {
  
  kDeclutterShown = 0,
  
  kCloseTabsClicked = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, DeclutterCTREvent value);
inline bool IsKnownEnumValue(DeclutterCTREvent value) {
  return internal::DeclutterCTREvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SelectorCTREvent : int32_t {
  
  kSelectorShown = 0,
  
  kAutoTabGroupsClicked = 1,
  
  kDeclutterClicked = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SelectorCTREvent value);
inline bool IsKnownEnumValue(SelectorCTREvent value) {
  return internal::SelectorCTREvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabDeclutterEntryPoint : int32_t {
  
  kNudge = 0,
  
  kAppMenu = 1,
  
  kSelector = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TabDeclutterEntryPoint value);
inline bool IsKnownEnumValue(TabDeclutterEntryPoint value) {
  return internal::TabDeclutterEntryPoint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabOrganizationState : int32_t {
  
  kInitializing = 0,
  
  kNotStarted = 1,
  
  kInProgress = 2,
  
  kSuccess = 3,
  
  kFailure = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, TabOrganizationState value);
inline bool IsKnownEnumValue(TabOrganizationState value) {
  return internal::TabOrganizationState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabOrganizationFeature : int32_t {
  
  kNone = 0,
  
  kSelector = 1,
  
  kAutoTabGroups = 2,
  
  kDeclutter = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, TabOrganizationFeature value);
inline bool IsKnownEnumValue(TabOrganizationFeature value) {
  return internal::TabOrganizationFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline TabOrganizationFeature ToKnownEnumValue(TabOrganizationFeature value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return TabOrganizationFeature::kDefaultValue;
}


enum class TabOrganizationError : int32_t {
  
  kNone = 0,
  
  kGrouping = 1,
  
  kGeneric = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TabOrganizationError value);
inline bool IsKnownEnumValue(TabOrganizationError value) {
  return internal::TabOrganizationError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabOrganizationModelStrategy : int32_t {
  
  kTopic = 0,
  
  kTask = 1,
  
  kDomain = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TabOrganizationModelStrategy value);
inline bool IsKnownEnumValue(TabOrganizationModelStrategy value) {
  return internal::TabOrganizationModelStrategy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabSearchSection : int32_t {
  
  kNone = 0,
  
  kSearch = 1,
  
  kOrganize = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, TabSearchSection value);
inline bool IsKnownEnumValue(TabSearchSection value) {
  return internal::TabSearchSection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline TabSearchSection ToKnownEnumValue(TabSearchSection value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return TabSearchSection::kDefaultValue;
}


enum class UserFeedback : int32_t {
  
  kUserFeedBackUnspecified = 0,
  
  kUserFeedBackPositive = 1,
  
  kUserFeedBackNegative = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UserFeedback value);
inline bool IsKnownEnumValue(UserFeedback value) {
  return internal::UserFeedback_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ProfileDataDataView {
 public:
  ProfileDataDataView() = default;

  ProfileDataDataView(
      internal::ProfileData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowsDataView(
      mojo::ArrayDataView<WindowDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindows(UserType* output) {
    
    auto* pointer = data_->windows.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::WindowDataView>>(
        pointer, output, message_);
  }
  inline void GetTabGroupsDataView(
      mojo::ArrayDataView<TabGroupDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabGroups(UserType* output) {
    
    auto* pointer = data_->tab_groups.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::TabGroupDataView>>(
        pointer, output, message_);
  }
  inline void GetRecentlyClosedTabsDataView(
      mojo::ArrayDataView<RecentlyClosedTabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecentlyClosedTabs(UserType* output) {
    
    auto* pointer = data_->recently_closed_tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::RecentlyClosedTabDataView>>(
        pointer, output, message_);
  }
  inline void GetRecentlyClosedTabGroupsDataView(
      mojo::ArrayDataView<RecentlyClosedTabGroupDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecentlyClosedTabGroups(UserType* output) {
    
    auto* pointer = data_->recently_closed_tab_groups.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::RecentlyClosedTabGroupDataView>>(
        pointer, output, message_);
  }
  bool recently_closed_section_expanded() const {
    return data_->recently_closed_section_expanded;
  }
 private:
  internal::ProfileData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WindowDataView {
 public:
  WindowDataView() = default;

  WindowDataView(
      internal::Window_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool active() const {
    return data_->active;
  }
  bool is_host_window() const {
    return data_->is_host_window;
  }
  uint32_t height() const {
    return data_->height;
  }
  inline void GetTabsDataView(
      mojo::ArrayDataView<TabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Window_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool active() const {
    return data_->active;
  }
  bool visible() const {
    return data_->visible;
  }
  inline void GetAlertStatesDataView(
      mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlertStates(UserType* output) {
    
    auto* pointer = data_->alert_states.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
        pointer, output, message_);
  }
  int32_t index() const {
    return data_->index;
  }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `group_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupId` instead "
    "of `ReadGroupId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  bool pinned() const {
    return data_->pinned;
  }
  bool split() const {
    return data_->split;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `favicon_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFaviconUrl` instead "
    "of `ReadFaviconUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_default_favicon() const {
    return data_->is_default_favicon;
  }
  bool show_icon() const {
    return data_->show_icon;
  }
  inline void GetLastActiveTimeTicksDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveTimeTicks(UserType* output) {
    
    auto* pointer = data_->last_active_time_ticks.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLastActiveElapsedTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveElapsedText(UserType* output) {
    
    auto* pointer = data_->last_active_elapsed_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RecentlyClosedTabDataView {
 public:
  RecentlyClosedTabDataView() = default;

  RecentlyClosedTabDataView(
      internal::RecentlyClosedTab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `group_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupId` instead "
    "of `ReadGroupId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLastActiveTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveTime(UserType* output) {
    
    auto* pointer = data_->last_active_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastActiveElapsedTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveElapsedText(UserType* output) {
    
    auto* pointer = data_->last_active_elapsed_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RecentlyClosedTab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabGroupDataView {
 public:
  TabGroupDataView() = default;

  TabGroupDataView(
      internal::TabGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    auto data_value = data_->color;
    return mojo::internal::Deserialize<::tab_groups::mojom::Color>(
        data_value, output);
  }
  ::tab_groups::mojom::Color color() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_groups::mojom::Color>(data_->color));
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RecentlyClosedTabGroupDataView {
 public:
  RecentlyClosedTabGroupDataView() = default;

  RecentlyClosedTabGroupDataView(
      internal::RecentlyClosedTabGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t session_id() const {
    return data_->session_id;
  }
  inline void GetIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    auto data_value = data_->color;
    return mojo::internal::Deserialize<::tab_groups::mojom::Color>(
        data_value, output);
  }
  ::tab_groups::mojom::Color color() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_groups::mojom::Color>(data_->color));
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t tab_count() const {
    return data_->tab_count;
  }
  inline void GetLastActiveTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveTime(UserType* output) {
    
    auto* pointer = data_->last_active_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastActiveElapsedTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveElapsedText(UserType* output) {
    
    auto* pointer = data_->last_active_elapsed_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RecentlyClosedTabGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SwitchToTabInfoDataView {
 public:
  SwitchToTabInfoDataView() = default;

  SwitchToTabInfoDataView(
      internal::SwitchToTabInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
 private:
  internal::SwitchToTabInfo_Data* data_ = nullptr;
};


class TabOrganizationDataView {
 public:
  TabOrganizationDataView() = default;

  TabOrganizationDataView(
      internal::TabOrganization_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t organization_id() const {
    return data_->organization_id;
  }
  inline void GetTabsDataView(
      mojo::ArrayDataView<TabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
        pointer, output, message_);
  }
  int32_t first_new_tab_index() const {
    return data_->first_new_tab_index;
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::TabOrganization_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabOrganizationSessionDataView {
 public:
  TabOrganizationSessionDataView() = default;

  TabOrganizationSessionDataView(
      internal::TabOrganizationSession_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t session_id() const {
    return data_->session_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::tab_search::mojom::TabOrganizationState>(
        data_value, output);
  }
  TabOrganizationState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_search::mojom::TabOrganizationState>(data_->state));
  }
  inline void GetOrganizationsDataView(
      mojo::ArrayDataView<TabOrganizationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrganizations(UserType* output) {
    
    auto* pointer = data_->organizations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::TabOrganizationDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::tab_search::mojom::TabOrganizationError>(
        data_value, output);
  }
  TabOrganizationError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_search::mojom::TabOrganizationError>(data_->error));
  }
  int32_t active_tab_id() const {
    return data_->active_tab_id;
  }
 private:
  internal::TabOrganizationSession_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabUpdateInfoDataView {
 public:
  TabUpdateInfoDataView() = default;

  TabUpdateInfoDataView(
      internal::TabUpdateInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool in_active_window() const {
    return data_->in_active_window;
  }
  bool in_host_window() const {
    return data_->in_host_window;
  }
  inline void GetTabDataView(
      TabDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) {
    
    auto* pointer = data_->tab.Get();
    return mojo::internal::Deserialize<::tab_search::mojom::TabDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabUpdateInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabsRemovedInfoDataView {
 public:
  TabsRemovedInfoDataView() = default;

  TabsRemovedInfoDataView(
      internal::TabsRemovedInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabIdsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabIds(UserType* output) {
    
    auto* pointer = data_->tab_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetRecentlyClosedTabsDataView(
      mojo::ArrayDataView<RecentlyClosedTabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecentlyClosedTabs(UserType* output) {
    
    auto* pointer = data_->recently_closed_tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::RecentlyClosedTabDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TabsRemovedInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UnusedTabInfoDataView {
 public:
  UnusedTabInfoDataView() = default;

  UnusedTabInfoDataView(
      internal::UnusedTabInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStaleTabsDataView(
      mojo::ArrayDataView<TabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStaleTabs(UserType* output) {
    
    auto* pointer = data_->stale_tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
        pointer, output, message_);
  }
  inline void GetDuplicateTabsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<TabDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuplicateTabs(UserType* output) {
    
    auto* pointer = data_->duplicate_tabs.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<::tab_search::mojom::TabDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::UnusedTabInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tab_search::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_SEARCH_TAB_SEARCH_MOJOM_DATA_VIEW_H_