// chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec,
  UnguessableToken as mojoBase_mojom_UnguessableToken
} from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const RequestStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum RequestStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kHardcoded = 0,
  kCreated = 1,
  kSent = 2,
  kSucceeded = 3,
  kFailed = 4,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'suggest_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  setPage(page: PageRemote): void;
  hardcodeResponse(response: string, delay: mojoBase_mojom_TimeDelta): Promise<{
        request: Request, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setPage(
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  hardcodeResponse(
      response: string,
      delay: mojoBase_mojom_TimeDelta): Promise<{
        request: Request, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_HardcodeResponse_ParamsSpec.$,
        PageHandler_HardcodeResponse_ResponseParamsSpec.$,
        [
          response,
          delay
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        impl.setPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_HardcodeResponse_ParamsSpec.$,
        PageHandler_HardcodeResponse_ResponseParamsSpec.$,
        impl.hardcodeResponse.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "suggest_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hardcodeResponse: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        this.setPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hardcodeResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_HardcodeResponse_ParamsSpec.$,
        PageHandler_HardcodeResponse_ResponseParamsSpec.$,
        this.hardcodeResponse.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'suggest_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onRequestCreated(request: Request): void;
  onRequestStarted(request: Request): void;
  onRequestCompleted(request: Request): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onRequestCreated(
      request: Request): void {
    this.proxy.sendMessage(
        0,
        Page_OnRequestCreated_ParamsSpec.$,
        null,
        [
          request
        ],
        false);
  }

  onRequestStarted(
      request: Request): void {
    this.proxy.sendMessage(
        1,
        Page_OnRequestStarted_ParamsSpec.$,
        null,
        [
          request
        ],
        false);
  }

  onRequestCompleted(
      request: Request): void {
    this.proxy.sendMessage(
        2,
        Page_OnRequestCompleted_ParamsSpec.$,
        null,
        [
          request
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnRequestCreated_ParamsSpec.$,
        null,
        impl.onRequestCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_OnRequestStarted_ParamsSpec.$,
        null,
        impl.onRequestStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OnRequestCompleted_ParamsSpec.$,
        null,
        impl.onRequestCompleted.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "suggest_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onRequestCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onRequestStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onRequestCompleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onRequestCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnRequestCreated_ParamsSpec.$,
        null,
        this.onRequestCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onRequestStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_OnRequestStarted_ParamsSpec.$,
        null,
        this.onRequestStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onRequestCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OnRequestCompleted_ParamsSpec.$,
        null,
        this.onRequestCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const RequestSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HardcodeResponse_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HardcodeResponse_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnRequestCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnRequestStarted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnRequestCompleted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface RequestMojoType {
  id: mojoBase_mojom_UnguessableToken;
  url: url_mojom_Url;
  data: {[key: string]: string};
  status: RequestStatus;
  startTime: mojoBase_mojom_Time;
  endTime: mojoBase_mojom_Time;
  response: string;
}


export type Request = RequestMojoType;
mojo.internal.Struct<RequestMojoType>(
    RequestSpec.$,
    'Request',
    [
      mojo.internal.StructField<RequestMojoType, mojoBase_mojom_UnguessableToken>(
        'id', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RequestMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RequestMojoType, {[key: string]: string}>(
        'data', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RequestMojoType, RequestStatus>(
        'status', 24,
        0,
        RequestStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RequestMojoType, mojoBase_mojom_Time>(
        'startTime', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RequestMojoType, mojoBase_mojom_Time>(
        'endTime', 40,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RequestMojoType, string>(
        'response', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface PageHandler_SetPage_ParamsMojoType {
  page: PageRemote;
}


export type PageHandler_SetPage_Params = PageHandler_SetPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPage_ParamsMojoType>(
    PageHandler_SetPage_ParamsSpec.$,
    'PageHandler_SetPage_Params',
    [
      mojo.internal.StructField<PageHandler_SetPage_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_HardcodeResponse_ParamsMojoType {
  response: string;
  delay: mojoBase_mojom_TimeDelta;
}


export type PageHandler_HardcodeResponse_Params = PageHandler_HardcodeResponse_ParamsMojoType;
mojo.internal.Struct<PageHandler_HardcodeResponse_ParamsMojoType>(
    PageHandler_HardcodeResponse_ParamsSpec.$,
    'PageHandler_HardcodeResponse_Params',
    [
      mojo.internal.StructField<PageHandler_HardcodeResponse_ParamsMojoType, string>(
        'response', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_HardcodeResponse_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'delay', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_HardcodeResponse_ResponseParamsMojoType {
  request: Request;
}


export type PageHandler_HardcodeResponse_ResponseParams = PageHandler_HardcodeResponse_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_HardcodeResponse_ResponseParamsMojoType>(
    PageHandler_HardcodeResponse_ResponseParamsSpec.$,
    'PageHandler_HardcodeResponse_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_HardcodeResponse_ResponseParamsMojoType, Request>(
        'request', 0,
        0,
        RequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnRequestCreated_ParamsMojoType {
  request: Request;
}


export type Page_OnRequestCreated_Params = Page_OnRequestCreated_ParamsMojoType;
mojo.internal.Struct<Page_OnRequestCreated_ParamsMojoType>(
    Page_OnRequestCreated_ParamsSpec.$,
    'Page_OnRequestCreated_Params',
    [
      mojo.internal.StructField<Page_OnRequestCreated_ParamsMojoType, Request>(
        'request', 0,
        0,
        RequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnRequestStarted_ParamsMojoType {
  request: Request;
}


export type Page_OnRequestStarted_Params = Page_OnRequestStarted_ParamsMojoType;
mojo.internal.Struct<Page_OnRequestStarted_ParamsMojoType>(
    Page_OnRequestStarted_ParamsSpec.$,
    'Page_OnRequestStarted_Params',
    [
      mojo.internal.StructField<Page_OnRequestStarted_ParamsMojoType, Request>(
        'request', 0,
        0,
        RequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnRequestCompleted_ParamsMojoType {
  request: Request;
}


export type Page_OnRequestCompleted_Params = Page_OnRequestCompleted_ParamsMojoType;
mojo.internal.Struct<Page_OnRequestCompleted_ParamsMojoType>(
    Page_OnRequestCompleted_ParamsSpec.$,
    'Page_OnRequestCompleted_Params',
    [
      mojo.internal.StructField<Page_OnRequestCompleted_ParamsMojoType, Request>(
        'request', 0,
        0,
        RequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



