// chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_SIGNOUT_CONFIRMATION_SIGNOUT_CONFIRMATION_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_SIGNOUT_CONFIRMATION_SIGNOUT_CONFIRMATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace signout_confirmation::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "signout_confirmation.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateSignoutConfirmationHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateSignoutConfirmationHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreateSignoutConfirmationHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "signout_confirmation.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateViewHeightMinVersion = 0,
    kAcceptMinVersion = 0,
    kCancelMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateViewHeight_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void UpdateViewHeight(uint32_t height) = 0;

  virtual void Accept(bool uninstall_account_extensions) = 0;

  virtual void Cancel(bool uninstall_account_extensions) = 0;

  virtual void Close() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "signout_confirmation.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendSignoutConfirmationDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendSignoutConfirmationData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SendSignoutConfirmationData(SignoutConfirmationDataPtr data) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateSignoutConfirmationHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateViewHeight(uint32_t height) final;
  
  void Accept(bool uninstall_account_extensions) final;
  
  void Cancel(bool uninstall_account_extensions) final;
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendSignoutConfirmationData(SignoutConfirmationDataPtr data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ExtensionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionInfo, T>::value>;
  using DataView = ExtensionInfoDataView;
  using Data_ = internal::ExtensionInfo_Data;

  template <typename... Args>
  static ExtensionInfoPtr New(Args&&... args) {
    return ExtensionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionInfoPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionInfo>::Convert(*this);
  }


  ExtensionInfo();

  ExtensionInfo(
      const std::string& name,
      const std::string& icon_url);


  ~ExtensionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionInfoPtr>
  ExtensionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionInfo_UnserializedMessageContext<
            UserType, ExtensionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionInfo_UnserializedMessageContext<
            UserType, ExtensionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string icon_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  SignoutConfirmationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignoutConfirmationData, T>::value>;
  using DataView = SignoutConfirmationDataDataView;
  using Data_ = internal::SignoutConfirmationData_Data;

  template <typename... Args>
  static SignoutConfirmationDataPtr New(Args&&... args) {
    return SignoutConfirmationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignoutConfirmationDataPtr From(const U& u) {
    return mojo::TypeConverter<SignoutConfirmationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignoutConfirmationData>::Convert(*this);
  }


  SignoutConfirmationData();

  SignoutConfirmationData(
      const std::string& dialog_title,
      const std::string& dialog_subtitle,
      const std::string& accept_button_label,
      const std::string& cancel_button_label,
      std::vector<ExtensionInfoPtr> account_extensions,
      bool has_unsynced_data);

SignoutConfirmationData(const SignoutConfirmationData&) = delete;
SignoutConfirmationData& operator=(const SignoutConfirmationData&) = delete;

  ~SignoutConfirmationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignoutConfirmationDataPtr>
  SignoutConfirmationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignoutConfirmationData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignoutConfirmationData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignoutConfirmationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignoutConfirmationData_UnserializedMessageContext<
            UserType, SignoutConfirmationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignoutConfirmationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignoutConfirmationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignoutConfirmationData_UnserializedMessageContext<
            UserType, SignoutConfirmationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignoutConfirmationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string dialog_title;
  
  std::string dialog_subtitle;
  
  std::string accept_button_label;
  
  std::string cancel_button_label;
  
  std::vector<ExtensionInfoPtr> account_extensions;
  
  bool has_unsynced_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignoutConfirmationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExtensionInfoPtr ExtensionInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(icon_url)
  );
}

template <typename T, ExtensionInfo::EnableIfSame<T>*>
bool ExtensionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  return true;
}

template <typename T, ExtensionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  return false;
}
template <typename StructPtrType>
SignoutConfirmationDataPtr SignoutConfirmationData::Clone() const {
  return New(
      mojo::Clone(dialog_title),
      mojo::Clone(dialog_subtitle),
      mojo::Clone(accept_button_label),
      mojo::Clone(cancel_button_label),
      mojo::Clone(account_extensions),
      mojo::Clone(has_unsynced_data)
  );
}

template <typename T, SignoutConfirmationData::EnableIfSame<T>*>
bool SignoutConfirmationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dialog_title, other_struct.dialog_title))
    return false;
  if (!mojo::Equals(this->dialog_subtitle, other_struct.dialog_subtitle))
    return false;
  if (!mojo::Equals(this->accept_button_label, other_struct.accept_button_label))
    return false;
  if (!mojo::Equals(this->cancel_button_label, other_struct.cancel_button_label))
    return false;
  if (!mojo::Equals(this->account_extensions, other_struct.account_extensions))
    return false;
  if (!mojo::Equals(this->has_unsynced_data, other_struct.has_unsynced_data))
    return false;
  return true;
}

template <typename T, SignoutConfirmationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dialog_title < rhs.dialog_title)
    return true;
  if (rhs.dialog_title < lhs.dialog_title)
    return false;
  if (lhs.dialog_subtitle < rhs.dialog_subtitle)
    return true;
  if (rhs.dialog_subtitle < lhs.dialog_subtitle)
    return false;
  if (lhs.accept_button_label < rhs.accept_button_label)
    return true;
  if (rhs.accept_button_label < lhs.accept_button_label)
    return false;
  if (lhs.cancel_button_label < rhs.cancel_button_label)
    return true;
  if (rhs.cancel_button_label < lhs.cancel_button_label)
    return false;
  if (lhs.account_extensions < rhs.account_extensions)
    return true;
  if (rhs.account_extensions < lhs.account_extensions)
    return false;
  if (lhs.has_unsynced_data < rhs.has_unsynced_data)
    return true;
  if (rhs.has_unsynced_data < lhs.has_unsynced_data)
    return false;
  return false;
}


}  // signout_confirmation::mojom

namespace mojo {


template <>
struct  StructTraits<::signout_confirmation::mojom::ExtensionInfo::DataView,
                                         ::signout_confirmation::mojom::ExtensionInfoPtr> {
  static bool IsNull(const ::signout_confirmation::mojom::ExtensionInfoPtr& input) { return !input; }
  static void SetToNull(::signout_confirmation::mojom::ExtensionInfoPtr* output) { output->reset(); }

  static const decltype(::signout_confirmation::mojom::ExtensionInfo::name)& name(
      const ::signout_confirmation::mojom::ExtensionInfoPtr& input) {
    return input->name;
  }

  static const decltype(::signout_confirmation::mojom::ExtensionInfo::icon_url)& icon_url(
      const ::signout_confirmation::mojom::ExtensionInfoPtr& input) {
    return input->icon_url;
  }

  static bool Read(::signout_confirmation::mojom::ExtensionInfo::DataView input, ::signout_confirmation::mojom::ExtensionInfoPtr* output);
};


template <>
struct  StructTraits<::signout_confirmation::mojom::SignoutConfirmationData::DataView,
                                         ::signout_confirmation::mojom::SignoutConfirmationDataPtr> {
  static bool IsNull(const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) { return !input; }
  static void SetToNull(::signout_confirmation::mojom::SignoutConfirmationDataPtr* output) { output->reset(); }

  static const decltype(::signout_confirmation::mojom::SignoutConfirmationData::dialog_title)& dialog_title(
      const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) {
    return input->dialog_title;
  }

  static const decltype(::signout_confirmation::mojom::SignoutConfirmationData::dialog_subtitle)& dialog_subtitle(
      const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) {
    return input->dialog_subtitle;
  }

  static const decltype(::signout_confirmation::mojom::SignoutConfirmationData::accept_button_label)& accept_button_label(
      const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) {
    return input->accept_button_label;
  }

  static const decltype(::signout_confirmation::mojom::SignoutConfirmationData::cancel_button_label)& cancel_button_label(
      const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) {
    return input->cancel_button_label;
  }

  static const decltype(::signout_confirmation::mojom::SignoutConfirmationData::account_extensions)& account_extensions(
      const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) {
    return input->account_extensions;
  }

  static decltype(::signout_confirmation::mojom::SignoutConfirmationData::has_unsynced_data) has_unsynced_data(
      const ::signout_confirmation::mojom::SignoutConfirmationDataPtr& input) {
    return input->has_unsynced_data;
  }

  static bool Read(::signout_confirmation::mojom::SignoutConfirmationData::DataView input, ::signout_confirmation::mojom::SignoutConfirmationDataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_SIGNOUT_CONFIRMATION_SIGNOUT_CONFIRMATION_MOJOM_H_