// chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-params-data.h"
#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-import-headers.h"
#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-test-utils.h"


namespace history_sync_optin::mojom {
AccountInfo::AccountInfo()
    : account_image_src() {}

AccountInfo::AccountInfo(
    const ::GURL& account_image_src_in)
    : account_image_src(std::move(account_image_src_in)) {}

AccountInfo::~AccountInfo() = default;

void AccountInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "account_image_src"), this->account_image_src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AccountInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreateHistorySyncOptinHandler: {
      return &PageHandlerFactory::CreateHistorySyncOptinHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreateHistorySyncOptinHandler:
            return "Receive history_sync_optin::mojom::PageHandlerFactory::CreateHistorySyncOptinHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreateHistorySyncOptinHandler:
            return "Receive reply history_sync_optin::mojom::PageHandlerFactory::CreateHistorySyncOptinHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreateHistorySyncOptinHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec3852e0;  // IPCStableHash for history_sync_optin::mojom::PageHandlerFactory::CreateHistorySyncOptinHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreateHistorySyncOptinHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_sync_optin::mojom::PageHandlerFactory::CreateHistorySyncOptinHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreateHistorySyncOptinHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::history_sync_optin::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreateHistorySyncOptinHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::history_sync_optin::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreateHistorySyncOptinHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreateHistorySyncOptinHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreateHistorySyncOptinHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHistorySyncOptinHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreateHistorySyncOptinHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_sync_optin::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kAccept: {
      return &PageHandler::Accept_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReject: {
      return &PageHandler::Reject_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRequestAccountInfo: {
      return &PageHandler::RequestAccountInfo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateDialogHeight: {
      return &PageHandler::UpdateDialogHeight_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kAccept:
            return "Receive history_sync_optin::mojom::PageHandler::Accept";
      case messages::PageHandler::kReject:
            return "Receive history_sync_optin::mojom::PageHandler::Reject";
      case messages::PageHandler::kRequestAccountInfo:
            return "Receive history_sync_optin::mojom::PageHandler::RequestAccountInfo";
      case messages::PageHandler::kUpdateDialogHeight:
            return "Receive history_sync_optin::mojom::PageHandler::UpdateDialogHeight";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kAccept:
            return "Receive reply history_sync_optin::mojom::PageHandler::Accept";
      case messages::PageHandler::kReject:
            return "Receive reply history_sync_optin::mojom::PageHandler::Reject";
      case messages::PageHandler::kRequestAccountInfo:
            return "Receive reply history_sync_optin::mojom::PageHandler::RequestAccountInfo";
      case messages::PageHandler::kUpdateDialogHeight:
            return "Receive reply history_sync_optin::mojom::PageHandler::UpdateDialogHeight";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdca7bb80;  // IPCStableHash for history_sync_optin::mojom::PageHandler::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Reject_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7f25d87;  // IPCStableHash for history_sync_optin::mojom::PageHandler::Reject
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RequestAccountInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb35c276b;  // IPCStableHash for history_sync_optin::mojom::PageHandler::RequestAccountInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateDialogHeight_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28a17287;  // IPCStableHash for history_sync_optin::mojom::PageHandler::UpdateDialogHeight
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::Accept(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_sync_optin::mojom::PageHandler::Accept");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::PageHandler_Accept_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Accept");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Reject(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_sync_optin::mojom::PageHandler::Reject");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReject), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::PageHandler_Reject_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Reject");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RequestAccountInfo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_sync_optin::mojom::PageHandler::RequestAccountInfo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRequestAccountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::PageHandler_RequestAccountInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RequestAccountInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UpdateDialogHeight(
    uint32_t in_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_sync_optin::mojom::PageHandler::UpdateDialogHeight", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("height"), in_height,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateDialogHeight), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::PageHandler_UpdateDialogHeight_Params_Data> params(
          message);
  params.Allocate();

  params->height = in_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateDialogHeight");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kAccept: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Accept_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Accept_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_Accept_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        );
      return true;
    }
    case messages::PageHandler::kReject: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Reject_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Reject_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_Reject_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reject(        );
      return true;
    }
    case messages::PageHandler::kRequestAccountInfo: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RequestAccountInfo_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RequestAccountInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_RequestAccountInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAccountInfo(        );
      return true;
    }
    case messages::PageHandler::kUpdateDialogHeight: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateDialogHeight_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateDialogHeight_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      uint32_t p_height{};
      PageHandler_UpdateDialogHeight_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_height = input_data_view.height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDialogHeight(        
        std::move(p_height));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kAccept: {
      break;
    }
    case messages::PageHandler::kReject: {
      break;
    }
    case messages::PageHandler::kRequestAccountInfo: {
      break;
    }
    case messages::PageHandler::kUpdateDialogHeight: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_Accept_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Reject_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RequestAccountInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UpdateDialogHeight_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_sync_optin::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSendAccountInfo: {
      return &Page::SendAccountInfo_Sym::IPCStableHash;
    }
    case messages::Page::kSendScreenMode: {
      return &Page::SendScreenMode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSendAccountInfo:
            return "Receive history_sync_optin::mojom::Page::SendAccountInfo";
      case messages::Page::kSendScreenMode:
            return "Receive history_sync_optin::mojom::Page::SendScreenMode";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSendAccountInfo:
            return "Receive reply history_sync_optin::mojom::Page::SendAccountInfo";
      case messages::Page::kSendScreenMode:
            return "Receive reply history_sync_optin::mojom::Page::SendScreenMode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SendAccountInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8df7b874;  // IPCStableHash for history_sync_optin::mojom::Page::SendAccountInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SendScreenMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2576e575;  // IPCStableHash for history_sync_optin::mojom::Page::SendScreenMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SendAccountInfo(
    AccountInfoPtr in_account_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_sync_optin::mojom::Page::SendAccountInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("account_info"), in_account_info,
                        "<value of type AccountInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSendAccountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::Page_SendAccountInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->account_info)::BaseType> account_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::history_sync_optin::mojom::AccountInfoDataView>(
    in_account_info,
    account_info_fragment);

  params->account_info.Set(
      account_info_fragment.is_null() ? nullptr : account_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->account_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null account_info in Page.SendAccountInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SendAccountInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SendScreenMode(
    ScreenMode in_screen_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_sync_optin::mojom::Page::SendScreenMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_mode"), in_screen_mode,
                        "<value of type ScreenMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSendScreenMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_sync_optin::mojom::internal::Page_SendScreenMode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::history_sync_optin::mojom::ScreenMode>(
    in_screen_mode,
    &params->screen_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SendScreenMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSendAccountInfo: {
      DCHECK(message->is_serialized());
      internal::Page_SendAccountInfo_Params_Data* params =
          reinterpret_cast<internal::Page_SendAccountInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      AccountInfoPtr p_account_info{};
      Page_SendAccountInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccountInfo(&p_account_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendAccountInfo(        
        std::move(p_account_info));
      return true;
    }
    case messages::Page::kSendScreenMode: {
      DCHECK(message->is_serialized());
      internal::Page_SendScreenMode_Params_Data* params =
          reinterpret_cast<internal::Page_SendScreenMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ScreenMode p_screen_mode{};
      Page_SendScreenMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScreenMode(&p_screen_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendScreenMode(        
        std::move(p_screen_mode));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSendAccountInfo: {
      break;
    }
    case messages::Page::kSendScreenMode: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SendAccountInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SendScreenMode_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_sync_optin::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // history_sync_optin::mojom


namespace mojo {


// static
bool StructTraits<::history_sync_optin::mojom::AccountInfo::DataView, ::history_sync_optin::mojom::AccountInfoPtr>::Read(
    ::history_sync_optin::mojom::AccountInfo::DataView input,
    ::history_sync_optin::mojom::AccountInfoPtr* output) {
  bool success = true;
  ::history_sync_optin::mojom::AccountInfoPtr result(::history_sync_optin::mojom::AccountInfo::New());
  
      if (success && !input.ReadAccountImageSrc(&result->account_image_src))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace history_sync_optin::mojom {


void PageHandlerFactoryInterceptorForTesting::CreateHistorySyncOptinHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreateHistorySyncOptinHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::Accept() {
  GetForwardingInterface()->Accept();
}
void PageHandlerInterceptorForTesting::Reject() {
  GetForwardingInterface()->Reject();
}
void PageHandlerInterceptorForTesting::RequestAccountInfo() {
  GetForwardingInterface()->RequestAccountInfo();
}
void PageHandlerInterceptorForTesting::UpdateDialogHeight(uint32_t height) {
  GetForwardingInterface()->UpdateDialogHeight(
    std::move(height)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::SendAccountInfo(AccountInfoPtr account_info) {
  GetForwardingInterface()->SendAccountInfo(
    std::move(account_info)
    );
}
void PageInterceptorForTesting::SendScreenMode(ScreenMode screen_mode) {
  GetForwardingInterface()->SendScreenMode(
    std::move(screen_mode)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // history_sync_optin::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif