// chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_HISTORY_SYNC_OPTIN_HISTORY_SYNC_OPTIN_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_HISTORY_SYNC_OPTIN_HISTORY_SYNC_OPTIN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-data-view.h"




namespace std {

template <>
struct hash<::history_sync_optin::mojom::LaunchContext>
    : public mojo::internal::EnumHashImpl<::history_sync_optin::mojom::LaunchContext> {};

template <>
struct hash<::history_sync_optin::mojom::ScreenMode>
    : public mojo::internal::EnumHashImpl<::history_sync_optin::mojom::ScreenMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_sync_optin::mojom::LaunchContext, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_sync_optin::mojom::LaunchContext, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_sync_optin::mojom::LaunchContext>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_sync_optin::mojom::ScreenMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_sync_optin::mojom::ScreenMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_sync_optin::mojom::ScreenMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_sync_optin::mojom::AccountInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_sync_optin::mojom::AccountInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_sync_optin::mojom::internal::AccountInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::account_image_src(input)) in_account_image_src = Traits::account_image_src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->account_image_src)::BaseType> account_image_src_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_account_image_src,
      account_image_src_fragment);

    fragment->account_image_src.Set(
        account_image_src_fragment.is_null() ? nullptr : account_image_src_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->account_image_src.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null account_image_src in AccountInfo struct");
  }

  static bool Deserialize(::history_sync_optin::mojom::internal::AccountInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_sync_optin::mojom::AccountInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace history_sync_optin::mojom {

inline void AccountInfoDataView::GetAccountImageSrcDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->account_image_src.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // history_sync_optin::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_sync_optin::mojom::LaunchContext> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_sync_optin::mojom::LaunchContext value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_sync_optin::mojom::ScreenMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_sync_optin::mojom::ScreenMode value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_HISTORY_SYNC_OPTIN_HISTORY_SYNC_OPTIN_MOJOM_SHARED_H_