// chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-params-data.h"
namespace history_sync_optin {
namespace mojom {

NOINLINE static const char* LaunchContextToStringHelper(LaunchContext value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LaunchContext::kWindow:
      return "kWindow";
    case LaunchContext::kModal:
      return "kModal";
    default:
      return nullptr;
  }
}

std::string LaunchContextToString(LaunchContext value) {
  const char *str = LaunchContextToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LaunchContext value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LaunchContext value) {
  return os << LaunchContextToString(value);
}

NOINLINE static const char* ScreenModeToStringHelper(ScreenMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScreenMode::kPending:
      return "kPending";
    case ScreenMode::kRestricted:
      return "kRestricted";
    case ScreenMode::kUnrestricted:
      return "kUnrestricted";
    case ScreenMode::kDeadlined:
      return "kDeadlined";
    default:
      return nullptr;
  }
}

std::string ScreenModeToString(ScreenMode value) {
  const char *str = ScreenModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScreenMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScreenMode value) {
  return os << ScreenModeToString(value);
}

namespace internal {


// static
bool AccountInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AccountInfo_Data* object =
      static_cast<const AccountInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->account_image_src, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->account_image_src, validation_context))
    return false;

  return true;
}

AccountInfo_Data::AccountInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data::PageHandlerFactory_CreateHistorySyncOptinHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Accept_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Accept_Params_Data* object =
      static_cast<const PageHandler_Accept_Params_Data*>(data);

  return true;
}

PageHandler_Accept_Params_Data::PageHandler_Accept_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Reject_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Reject_Params_Data* object =
      static_cast<const PageHandler_Reject_Params_Data*>(data);

  return true;
}

PageHandler_Reject_Params_Data::PageHandler_Reject_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RequestAccountInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RequestAccountInfo_Params_Data* object =
      static_cast<const PageHandler_RequestAccountInfo_Params_Data*>(data);

  return true;
}

PageHandler_RequestAccountInfo_Params_Data::PageHandler_RequestAccountInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateDialogHeight_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateDialogHeight_Params_Data* object =
      static_cast<const PageHandler_UpdateDialogHeight_Params_Data*>(data);

  return true;
}

PageHandler_UpdateDialogHeight_Params_Data::PageHandler_UpdateDialogHeight_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SendAccountInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SendAccountInfo_Params_Data* object =
      static_cast<const Page_SendAccountInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->account_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->account_info, validation_context))
    return false;

  return true;
}

Page_SendAccountInfo_Params_Data::Page_SendAccountInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SendScreenMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SendScreenMode_Params_Data* object =
      static_cast<const Page_SendScreenMode_Params_Data*>(data);


  if (!::history_sync_optin::mojom::internal::ScreenMode_Data
        ::Validate(object->screen_mode, validation_context))
    return false;

  return true;
}

Page_SendScreenMode_Params_Data::Page_SendScreenMode_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace history_sync_optin

namespace perfetto {

// static
void TraceFormatTraits<::history_sync_optin::mojom::LaunchContext>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_sync_optin::mojom::LaunchContext value) {
  return std::move(context).WriteString(::history_sync_optin::mojom::LaunchContextToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::history_sync_optin::mojom::ScreenMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_sync_optin::mojom::ScreenMode value) {
  return std::move(context).WriteString(::history_sync_optin::mojom::ScreenModeToString(value));
}

} // namespace perfetto