// chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_BATCH_UPLOAD_BATCH_UPLOAD_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_BATCH_UPLOAD_BATCH_UPLOAD_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-shared-internal.h"


namespace batch_upload::mojom {
class DataItemDataView;

class DataContainerDataView;

class BatchUploadAccountInfoDataView;

class BatchUploadDataDataView;



}  // batch_upload::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::batch_upload::mojom::DataItemDataView> {
  using Data = ::batch_upload::mojom::internal::DataItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::batch_upload::mojom::DataContainerDataView> {
  using Data = ::batch_upload::mojom::internal::DataContainer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::batch_upload::mojom::BatchUploadAccountInfoDataView> {
  using Data = ::batch_upload::mojom::internal::BatchUploadAccountInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::batch_upload::mojom::BatchUploadDataDataView> {
  using Data = ::batch_upload::mojom::internal::BatchUploadData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace batch_upload::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class DataItemDataView {
 public:
  DataItemDataView() = default;

  DataItemDataView(
      internal::DataItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetIconUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSubtitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubtitle(UserType* output) {
    
    auto* pointer = data_->subtitle.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataContainerDataView {
 public:
  DataContainerDataView() = default;

  DataContainerDataView(
      internal::DataContainer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSectionTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSectionTitle(UserType* output) {
    
    auto* pointer = data_->section_title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataItemsDataView(
      mojo::ArrayDataView<DataItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataItems(UserType* output) {
    
    auto* pointer = data_->data_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::batch_upload::mojom::DataItemDataView>>(
        pointer, output, message_);
  }
  bool is_theme() const {
    return data_->is_theme;
  }
 private:
  internal::DataContainer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BatchUploadAccountInfoDataView {
 public:
  BatchUploadAccountInfoDataView() = default;

  BatchUploadAccountInfoDataView(
      internal::BatchUploadAccountInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataPictureUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPictureUrl(UserType* output) {
    
    auto* pointer = data_->data_picture_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BatchUploadAccountInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BatchUploadDataDataView {
 public:
  BatchUploadDataDataView() = default;

  BatchUploadDataDataView(
      internal::BatchUploadData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccountInfoDataView(
      BatchUploadAccountInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccountInfo(UserType* output) {
    
    auto* pointer = data_->account_info.Get();
    return mojo::internal::Deserialize<::batch_upload::mojom::BatchUploadAccountInfoDataView>(
        pointer, output, message_);
  }
  inline void GetDialogSubtitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDialogSubtitle(UserType* output) {
    
    auto* pointer = data_->dialog_subtitle.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataContainersDataView(
      mojo::ArrayDataView<DataContainerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataContainers(UserType* output) {
    
    auto* pointer = data_->data_containers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::batch_upload::mojom::DataContainerDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BatchUploadData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // batch_upload::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_BATCH_UPLOAD_BATCH_UPLOAD_MOJOM_DATA_VIEW_H_