// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-params-data.h"
#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-import-headers.h"
#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-test-utils.h"


namespace reading_list::mojom {
ReadLaterEntriesByStatus::ReadLaterEntriesByStatus()
    : unread_entries(),
      read_entries() {}

ReadLaterEntriesByStatus::ReadLaterEntriesByStatus(
    std::vector<ReadLaterEntryPtr> unread_entries_in,
    std::vector<ReadLaterEntryPtr> read_entries_in)
    : unread_entries(std::move(unread_entries_in)),
      read_entries(std::move(read_entries_in)) {}

ReadLaterEntriesByStatus::~ReadLaterEntriesByStatus() = default;

void ReadLaterEntriesByStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unread_entries"), this->unread_entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ReadLaterEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_entries"), this->read_entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ReadLaterEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadLaterEntriesByStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadLaterEntry::ReadLaterEntry()
    : title(),
      url(),
      display_url(),
      update_time(),
      read(),
      display_time_since_update() {}

ReadLaterEntry::ReadLaterEntry(
    const std::string& title_in,
    const ::GURL& url_in,
    const std::string& display_url_in,
    int64_t update_time_in,
    bool read_in,
    const std::string& display_time_since_update_in)
    : title(std::move(title_in)),
      url(std::move(url_in)),
      display_url(std::move(display_url_in)),
      update_time(std::move(update_time_in)),
      read(std::move(read_in)),
      display_time_since_update(std::move(display_time_since_update_in)) {}

ReadLaterEntry::~ReadLaterEntry() = default;

void ReadLaterEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_url"), this->display_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_time"), this->update_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read"), this->read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_time_since_update"), this->display_time_since_update,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadLaterEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Window::Window()
    : active(),
      height() {}

Window::Window(
    bool active_in,
    uint32_t height_in)
    : active(std::move(active_in)),
      height(std::move(height_in)) {}

Window::~Window() = default;
size_t Window::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->active);
  seed = mojo::internal::Hash(seed, this->height);
  return seed;
}

void Window::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Window::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reading_list::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply reading_list::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7d3546a;  // IPCStableHash for reading_list::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::reading_list::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::reading_list::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::reading_list::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetReadLaterEntries: {
      return &PageHandler::GetReadLaterEntries_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenURL: {
      return &PageHandler::OpenURL_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateReadStatus: {
      return &PageHandler::UpdateReadStatus_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMarkCurrentTabAsRead: {
      return &PageHandler::MarkCurrentTabAsRead_Sym::IPCStableHash;
    }
    case messages::PageHandler::kAddCurrentTab: {
      return &PageHandler::AddCurrentTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveEntry: {
      return &PageHandler::RemoveEntry_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowContextMenuForURL: {
      return &PageHandler::ShowContextMenuForURL_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateCurrentPageActionButtonState: {
      return &PageHandler::UpdateCurrentPageActionButtonState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowUI: {
      return &PageHandler::ShowUI_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloseUI: {
      return &PageHandler::CloseUI_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetWindowData: {
      return &PageHandler::GetWindowData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetReadLaterEntries:
            return "Receive reading_list::mojom::PageHandler::GetReadLaterEntries";
      case messages::PageHandler::kOpenURL:
            return "Receive reading_list::mojom::PageHandler::OpenURL";
      case messages::PageHandler::kUpdateReadStatus:
            return "Receive reading_list::mojom::PageHandler::UpdateReadStatus";
      case messages::PageHandler::kMarkCurrentTabAsRead:
            return "Receive reading_list::mojom::PageHandler::MarkCurrentTabAsRead";
      case messages::PageHandler::kAddCurrentTab:
            return "Receive reading_list::mojom::PageHandler::AddCurrentTab";
      case messages::PageHandler::kRemoveEntry:
            return "Receive reading_list::mojom::PageHandler::RemoveEntry";
      case messages::PageHandler::kShowContextMenuForURL:
            return "Receive reading_list::mojom::PageHandler::ShowContextMenuForURL";
      case messages::PageHandler::kUpdateCurrentPageActionButtonState:
            return "Receive reading_list::mojom::PageHandler::UpdateCurrentPageActionButtonState";
      case messages::PageHandler::kShowUI:
            return "Receive reading_list::mojom::PageHandler::ShowUI";
      case messages::PageHandler::kCloseUI:
            return "Receive reading_list::mojom::PageHandler::CloseUI";
      case messages::PageHandler::kGetWindowData:
            return "Receive reading_list::mojom::PageHandler::GetWindowData";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetReadLaterEntries:
            return "Receive reply reading_list::mojom::PageHandler::GetReadLaterEntries";
      case messages::PageHandler::kOpenURL:
            return "Receive reply reading_list::mojom::PageHandler::OpenURL";
      case messages::PageHandler::kUpdateReadStatus:
            return "Receive reply reading_list::mojom::PageHandler::UpdateReadStatus";
      case messages::PageHandler::kMarkCurrentTabAsRead:
            return "Receive reply reading_list::mojom::PageHandler::MarkCurrentTabAsRead";
      case messages::PageHandler::kAddCurrentTab:
            return "Receive reply reading_list::mojom::PageHandler::AddCurrentTab";
      case messages::PageHandler::kRemoveEntry:
            return "Receive reply reading_list::mojom::PageHandler::RemoveEntry";
      case messages::PageHandler::kShowContextMenuForURL:
            return "Receive reply reading_list::mojom::PageHandler::ShowContextMenuForURL";
      case messages::PageHandler::kUpdateCurrentPageActionButtonState:
            return "Receive reply reading_list::mojom::PageHandler::UpdateCurrentPageActionButtonState";
      case messages::PageHandler::kShowUI:
            return "Receive reply reading_list::mojom::PageHandler::ShowUI";
      case messages::PageHandler::kCloseUI:
            return "Receive reply reading_list::mojom::PageHandler::CloseUI";
      case messages::PageHandler::kGetWindowData:
            return "Receive reply reading_list::mojom::PageHandler::GetWindowData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetReadLaterEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a18c867;  // IPCStableHash for reading_list::mojom::PageHandler::GetReadLaterEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24e2d885;  // IPCStableHash for reading_list::mojom::PageHandler::OpenURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateReadStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x46e2f0e3;  // IPCStableHash for reading_list::mojom::PageHandler::UpdateReadStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MarkCurrentTabAsRead_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf34a3fc4;  // IPCStableHash for reading_list::mojom::PageHandler::MarkCurrentTabAsRead
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::AddCurrentTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67f0f36c;  // IPCStableHash for reading_list::mojom::PageHandler::AddCurrentTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43845669;  // IPCStableHash for reading_list::mojom::PageHandler::RemoveEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowContextMenuForURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12a2dcda;  // IPCStableHash for reading_list::mojom::PageHandler::ShowContextMenuForURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateCurrentPageActionButtonState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b8fcab2;  // IPCStableHash for reading_list::mojom::PageHandler::UpdateCurrentPageActionButtonState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87c1775c;  // IPCStableHash for reading_list::mojom::PageHandler::ShowUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloseUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd82c6640;  // IPCStableHash for reading_list::mojom::PageHandler::CloseUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetWindowData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c2f7314;  // IPCStableHash for reading_list::mojom::PageHandler::GetWindowData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetReadLaterEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetReadLaterEntries_ForwardToCallback(
      PageHandler::GetReadLaterEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetReadLaterEntries_ForwardToCallback(const PageHandler_GetReadLaterEntries_ForwardToCallback&) = delete;
  PageHandler_GetReadLaterEntries_ForwardToCallback& operator=(const PageHandler_GetReadLaterEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetReadLaterEntriesCallback callback_;
};

class PageHandler_GetWindowData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetWindowData_ForwardToCallback(
      PageHandler::GetWindowDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetWindowData_ForwardToCallback(const PageHandler_GetWindowData_ForwardToCallback&) = delete;
  PageHandler_GetWindowData_ForwardToCallback& operator=(const PageHandler_GetWindowData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetWindowDataCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetReadLaterEntries(
    GetReadLaterEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::GetReadLaterEntries");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetReadLaterEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_GetReadLaterEntries_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetReadLaterEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetReadLaterEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenURL(
    const ::GURL& in_url, bool in_mark_as_read, ::ui::mojom::ClickModifiersPtr in_click_modifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::PageHandler::OpenURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mark_as_read"), in_mark_as_read,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_modifiers"), in_click_modifiers,
                        "<value of type ::ui::mojom::ClickModifiersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_OpenURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.OpenURL request");

  params->mark_as_read = in_mark_as_read;
  mojo::internal::MessageFragment<
      typename decltype(params->click_modifiers)::BaseType> click_modifiers_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::ClickModifiersDataView>(
    in_click_modifiers,
    click_modifiers_fragment);

  params->click_modifiers.Set(
      click_modifiers_fragment.is_null() ? nullptr : click_modifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->click_modifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null click_modifiers in PageHandler.OpenURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UpdateReadStatus(
    const ::GURL& in_url, bool in_read) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::PageHandler::UpdateReadStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read"), in_read,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateReadStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_UpdateReadStatus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.UpdateReadStatus request");

  params->read = in_read;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateReadStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MarkCurrentTabAsRead(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::MarkCurrentTabAsRead");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMarkCurrentTabAsRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_MarkCurrentTabAsRead_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MarkCurrentTabAsRead");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::AddCurrentTab(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::AddCurrentTab");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAddCurrentTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_AddCurrentTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AddCurrentTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RemoveEntry(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::PageHandler::RemoveEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_RemoveEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.RemoveEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowContextMenuForURL(
    const ::GURL& in_url, int32_t in_x, int32_t in_y) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::PageHandler::ShowContextMenuForURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("x"), in_x,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("y"), in_y,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowContextMenuForURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_ShowContextMenuForURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.ShowContextMenuForURL request");

  params->x = in_x;

  params->y = in_y;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowContextMenuForURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UpdateCurrentPageActionButtonState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::UpdateCurrentPageActionButtonState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateCurrentPageActionButtonState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_UpdateCurrentPageActionButtonState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateCurrentPageActionButtonState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::ShowUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_ShowUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::CloseUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::CloseUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_CloseUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetWindowData(
    GetWindowDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reading_list::mojom::PageHandler::GetWindowData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetWindowData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_GetWindowData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetWindowData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetWindowData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_GetReadLaterEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetReadLaterEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetReadLaterEntries_ProxyToResponder> proxy(
        new PageHandler_GetReadLaterEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetReadLaterEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetReadLaterEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetReadLaterEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetReadLaterEntriesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ReadLaterEntriesByStatusPtr in_entries);
};

bool PageHandler_GetReadLaterEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetReadLaterEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetReadLaterEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  ReadLaterEntriesByStatusPtr p_entries{};
  PageHandler_GetReadLaterEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entries));
  }
  return true;
}

void PageHandler_GetReadLaterEntries_ProxyToResponder::Run(
    ReadLaterEntriesByStatusPtr in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply reading_list::mojom::PageHandler::GetReadLaterEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type ReadLaterEntriesByStatusPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetReadLaterEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_GetReadLaterEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType> entries_fragment(
          params.message());
  
  mojo::internal::Serialize<::reading_list::mojom::ReadLaterEntriesByStatusDataView>(
    in_entries,
    entries_fragment);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetReadLaterEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetWindowData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetWindowDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetWindowData_ProxyToResponder> proxy(
        new PageHandler_GetWindowData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetWindowData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetWindowData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetWindowData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetWindowDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WindowPtr> in_windows);
};

bool PageHandler_GetWindowData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetWindowData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetWindowData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.10
  bool success = true;
  std::vector<WindowPtr> p_windows{};
  PageHandler_GetWindowData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadWindows(&p_windows))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_windows));
  }
  return true;
}

void PageHandler_GetWindowData_ProxyToResponder::Run(
    std::vector<WindowPtr> in_windows) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply reading_list::mojom::PageHandler::GetWindowData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("windows"), in_windows,
                        "<value of type std::vector<WindowPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetWindowData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::PageHandler_GetWindowData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->windows)::BaseType>
      windows_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& windows_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::reading_list::mojom::WindowDataView>>(
    in_windows,
    windows_fragment,
    &windows_validate_params);

  params->windows.Set(
      windows_fragment.is_null() ? nullptr : windows_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->windows.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null windows in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetWindowData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetReadLaterEntries: {
      break;
    }
    case messages::PageHandler::kOpenURL: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenURL_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::GURL p_url{};
      bool p_mark_as_read{};
      ::ui::mojom::ClickModifiersPtr p_click_modifiers{};
      PageHandler_OpenURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_mark_as_read = input_data_view.mark_as_read();
      if (success && !input_data_view.ReadClickModifiers(&p_click_modifiers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(        
        std::move(p_url), 
        std::move(p_mark_as_read), 
        std::move(p_click_modifiers));
      return true;
    }
    case messages::PageHandler::kUpdateReadStatus: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateReadStatus_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateReadStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      ::GURL p_url{};
      bool p_read{};
      PageHandler_UpdateReadStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_read = input_data_view.read();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateReadStatus(        
        std::move(p_url), 
        std::move(p_read));
      return true;
    }
    case messages::PageHandler::kMarkCurrentTabAsRead: {
      DCHECK(message->is_serialized());
      internal::PageHandler_MarkCurrentTabAsRead_Params_Data* params =
          reinterpret_cast<internal::PageHandler_MarkCurrentTabAsRead_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_MarkCurrentTabAsRead_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MarkCurrentTabAsRead(        );
      return true;
    }
    case messages::PageHandler::kAddCurrentTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_AddCurrentTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_AddCurrentTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_AddCurrentTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCurrentTab(        );
      return true;
    }
    case messages::PageHandler::kRemoveEntry: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RemoveEntry_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RemoveEntry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      ::GURL p_url{};
      PageHandler_RemoveEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveEntry(        
        std::move(p_url));
      return true;
    }
    case messages::PageHandler::kShowContextMenuForURL: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowContextMenuForURL_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowContextMenuForURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      ::GURL p_url{};
      int32_t p_x{};
      int32_t p_y{};
      PageHandler_ShowContextMenuForURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_x = input_data_view.x();
      if (success)
        p_y = input_data_view.y();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenuForURL(        
        std::move(p_url), 
        std::move(p_x), 
        std::move(p_y));
      return true;
    }
    case messages::PageHandler::kUpdateCurrentPageActionButtonState: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateCurrentPageActionButtonState_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateCurrentPageActionButtonState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_UpdateCurrentPageActionButtonState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCurrentPageActionButtonState(        );
      return true;
    }
    case messages::PageHandler::kShowUI: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowUI_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_ShowUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowUI(        );
      return true;
    }
    case messages::PageHandler::kCloseUI: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseUI_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      PageHandler_CloseUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseUI(        );
      return true;
    }
    case messages::PageHandler::kGetWindowData: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetReadLaterEntries: {
      internal::PageHandler_GetReadLaterEntries_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetReadLaterEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetReadLaterEntries_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetReadLaterEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetReadLaterEntries(std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenURL: {
      break;
    }
    case messages::PageHandler::kUpdateReadStatus: {
      break;
    }
    case messages::PageHandler::kMarkCurrentTabAsRead: {
      break;
    }
    case messages::PageHandler::kAddCurrentTab: {
      break;
    }
    case messages::PageHandler::kRemoveEntry: {
      break;
    }
    case messages::PageHandler::kShowContextMenuForURL: {
      break;
    }
    case messages::PageHandler::kUpdateCurrentPageActionButtonState: {
      break;
    }
    case messages::PageHandler::kShowUI: {
      break;
    }
    case messages::PageHandler::kCloseUI: {
      break;
    }
    case messages::PageHandler::kGetWindowData: {
      internal::PageHandler_GetWindowData_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetWindowData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_GetWindowData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          PageHandler_GetWindowData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWindowData(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetReadLaterEntries_Params_Data::Validate,
     &internal::PageHandler_GetReadLaterEntries_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UpdateReadStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MarkCurrentTabAsRead_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_AddCurrentTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RemoveEntry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowContextMenuForURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UpdateCurrentPageActionButtonState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_CloseUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetWindowData_Params_Data::Validate,
     &internal::PageHandler_GetWindowData_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::reading_list::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::reading_list::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kItemsChanged: {
      return &Page::ItemsChanged_Sym::IPCStableHash;
    }
    case messages::Page::kCurrentPageActionButtonStateChanged: {
      return &Page::CurrentPageActionButtonStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kItemsChanged:
            return "Receive reading_list::mojom::Page::ItemsChanged";
      case messages::Page::kCurrentPageActionButtonStateChanged:
            return "Receive reading_list::mojom::Page::CurrentPageActionButtonStateChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kItemsChanged:
            return "Receive reply reading_list::mojom::Page::ItemsChanged";
      case messages::Page::kCurrentPageActionButtonStateChanged:
            return "Receive reply reading_list::mojom::Page::CurrentPageActionButtonStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::ItemsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b2efba4;  // IPCStableHash for reading_list::mojom::Page::ItemsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::CurrentPageActionButtonStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42a7be12;  // IPCStableHash for reading_list::mojom::Page::CurrentPageActionButtonStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::ItemsChanged(
    ReadLaterEntriesByStatusPtr in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::Page::ItemsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type ReadLaterEntriesByStatusPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kItemsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::Page_ItemsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType> entries_fragment(
          params.message());
  
  mojo::internal::Serialize<::reading_list::mojom::ReadLaterEntriesByStatusDataView>(
    in_entries,
    entries_fragment);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in Page.ItemsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ItemsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::CurrentPageActionButtonStateChanged(
    CurrentPageActionButtonState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reading_list::mojom::Page::CurrentPageActionButtonStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type CurrentPageActionButtonState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kCurrentPageActionButtonStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::reading_list::mojom::internal::Page_CurrentPageActionButtonStateChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::reading_list::mojom::CurrentPageActionButtonState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("CurrentPageActionButtonStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kItemsChanged: {
      DCHECK(message->is_serialized());
      internal::Page_ItemsChanged_Params_Data* params =
          reinterpret_cast<internal::Page_ItemsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ReadLaterEntriesByStatusPtr p_entries{};
      Page_ItemsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ItemsChanged(        
        std::move(p_entries));
      return true;
    }
    case messages::Page::kCurrentPageActionButtonStateChanged: {
      DCHECK(message->is_serialized());
      internal::Page_CurrentPageActionButtonStateChanged_Params_Data* params =
          reinterpret_cast<internal::Page_CurrentPageActionButtonStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      CurrentPageActionButtonState p_state{};
      Page_CurrentPageActionButtonStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CurrentPageActionButtonStateChanged(        
        std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kItemsChanged: {
      break;
    }
    case messages::Page::kCurrentPageActionButtonStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_ItemsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_CurrentPageActionButtonStateChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::reading_list::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // reading_list::mojom


namespace mojo {


// static
bool StructTraits<::reading_list::mojom::ReadLaterEntriesByStatus::DataView, ::reading_list::mojom::ReadLaterEntriesByStatusPtr>::Read(
    ::reading_list::mojom::ReadLaterEntriesByStatus::DataView input,
    ::reading_list::mojom::ReadLaterEntriesByStatusPtr* output) {
  bool success = true;
  ::reading_list::mojom::ReadLaterEntriesByStatusPtr result(::reading_list::mojom::ReadLaterEntriesByStatus::New());
  
      if (success && !input.ReadUnreadEntries(&result->unread_entries))
        success = false;
      if (success && !input.ReadReadEntries(&result->read_entries))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::reading_list::mojom::ReadLaterEntry::DataView, ::reading_list::mojom::ReadLaterEntryPtr>::Read(
    ::reading_list::mojom::ReadLaterEntry::DataView input,
    ::reading_list::mojom::ReadLaterEntryPtr* output) {
  bool success = true;
  ::reading_list::mojom::ReadLaterEntryPtr result(::reading_list::mojom::ReadLaterEntry::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadDisplayUrl(&result->display_url))
        success = false;
      if (success)
        result->update_time = input.update_time();
      if (success)
        result->read = input.read();
      if (success && !input.ReadDisplayTimeSinceUpdate(&result->display_time_since_update))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::reading_list::mojom::Window::DataView, ::reading_list::mojom::WindowPtr>::Read(
    ::reading_list::mojom::Window::DataView input,
    ::reading_list::mojom::WindowPtr* output) {
  bool success = true;
  ::reading_list::mojom::WindowPtr result(::reading_list::mojom::Window::New());
  
      if (success)
        result->active = input.active();
      if (success)
        result->height = input.height();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace reading_list::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetReadLaterEntries(GetReadLaterEntriesCallback callback) {
  GetForwardingInterface()->GetReadLaterEntries(std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenURL(const ::GURL& url, bool mark_as_read, ::ui::mojom::ClickModifiersPtr click_modifiers) {
  GetForwardingInterface()->OpenURL(
    std::move(url)
    , 
    std::move(mark_as_read)
    , 
    std::move(click_modifiers)
    );
}
void PageHandlerInterceptorForTesting::UpdateReadStatus(const ::GURL& url, bool read) {
  GetForwardingInterface()->UpdateReadStatus(
    std::move(url)
    , 
    std::move(read)
    );
}
void PageHandlerInterceptorForTesting::MarkCurrentTabAsRead() {
  GetForwardingInterface()->MarkCurrentTabAsRead();
}
void PageHandlerInterceptorForTesting::AddCurrentTab() {
  GetForwardingInterface()->AddCurrentTab();
}
void PageHandlerInterceptorForTesting::RemoveEntry(const ::GURL& url) {
  GetForwardingInterface()->RemoveEntry(
    std::move(url)
    );
}
void PageHandlerInterceptorForTesting::ShowContextMenuForURL(const ::GURL& url, int32_t x, int32_t y) {
  GetForwardingInterface()->ShowContextMenuForURL(
    std::move(url)
    , 
    std::move(x)
    , 
    std::move(y)
    );
}
void PageHandlerInterceptorForTesting::UpdateCurrentPageActionButtonState() {
  GetForwardingInterface()->UpdateCurrentPageActionButtonState();
}
void PageHandlerInterceptorForTesting::ShowUI() {
  GetForwardingInterface()->ShowUI();
}
void PageHandlerInterceptorForTesting::CloseUI() {
  GetForwardingInterface()->CloseUI();
}
void PageHandlerInterceptorForTesting::GetWindowData(GetWindowDataCallback callback) {
  GetForwardingInterface()->GetWindowData(std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetReadLaterEntries(
    ReadLaterEntriesByStatusPtr* out_entries) {
  base::RunLoop loop;
  proxy_->GetReadLaterEntries(
      base::BindOnce(
          [](base::RunLoop* loop,
             ReadLaterEntriesByStatusPtr* out_entries
,
             ReadLaterEntriesByStatusPtr entries) {*out_entries = std::move(entries);
            loop->Quit();
          },
          &loop,
          out_entries));
  loop.Run();
}

ReadLaterEntriesByStatusPtr PageHandlerAsyncWaiter::GetReadLaterEntries(
    ) {
  ReadLaterEntriesByStatusPtr async_wait_result;
  GetReadLaterEntries(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetWindowData(
    std::vector<WindowPtr>* out_windows) {
  base::RunLoop loop;
  proxy_->GetWindowData(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WindowPtr>* out_windows
,
             std::vector<WindowPtr> windows) {*out_windows = std::move(windows);
            loop->Quit();
          },
          &loop,
          out_windows));
  loop.Run();
}

std::vector<WindowPtr> PageHandlerAsyncWaiter::GetWindowData(
    ) {
  std::vector<WindowPtr> async_wait_result;
  GetWindowData(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::ItemsChanged(ReadLaterEntriesByStatusPtr entries) {
  GetForwardingInterface()->ItemsChanged(
    std::move(entries)
    );
}
void PageInterceptorForTesting::CurrentPageActionButtonStateChanged(CurrentPageActionButtonState state) {
  GetForwardingInterface()->CurrentPageActionButtonStateChanged(
    std::move(state)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // reading_list::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif