// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom.h"


namespace reading_list::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetReadLaterEntries(GetReadLaterEntriesCallback callback) override;
  void OpenURL(const ::GURL& url, bool mark_as_read, ::ui::mojom::ClickModifiersPtr click_modifiers) override;
  void UpdateReadStatus(const ::GURL& url, bool read) override;
  void MarkCurrentTabAsRead() override;
  void AddCurrentTab() override;
  void RemoveEntry(const ::GURL& url) override;
  void ShowContextMenuForURL(const ::GURL& url, int32_t x, int32_t y) override;
  void UpdateCurrentPageActionButtonState() override;
  void ShowUI() override;
  void CloseUI() override;
  void GetWindowData(GetWindowDataCallback callback) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetReadLaterEntries(
      ReadLaterEntriesByStatusPtr* out_entries);
  ReadLaterEntriesByStatusPtr GetReadLaterEntries();
  void GetWindowData(
      std::vector<WindowPtr>* out_windows);
  std::vector<WindowPtr> GetWindowData();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void ItemsChanged(ReadLaterEntriesByStatusPtr entries) override;
  void CurrentPageActionButtonStateChanged(CurrentPageActionButtonState state) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // reading_list::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_TEST_UTILS_H_