// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_PARAMS_DATA_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace reading_list::mojom {
namespace internal {
class  PageHandlerFactory_CreatePageHandler_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandlerFactory_CreatePageHandler_Params_Data>;

  PageHandlerFactory_CreatePageHandler_Params_Data();
  ~PageHandlerFactory_CreatePageHandler_Params_Data() = delete;
};
static_assert(sizeof(PageHandlerFactory_CreatePageHandler_Params_Data) == 24,
              "Bad sizeof(PageHandlerFactory_CreatePageHandler_Params_Data)");
class  PageHandler_GetReadLaterEntries_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetReadLaterEntries_Params_Data>;

  PageHandler_GetReadLaterEntries_Params_Data();
  ~PageHandler_GetReadLaterEntries_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetReadLaterEntries_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetReadLaterEntries_Params_Data)");
class  PageHandler_GetReadLaterEntries_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ReadLaterEntriesByStatus_Data> entries;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetReadLaterEntries_ResponseParams_Data>;

  PageHandler_GetReadLaterEntries_ResponseParams_Data();
  ~PageHandler_GetReadLaterEntries_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetReadLaterEntries_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetReadLaterEntries_ResponseParams_Data)");
class  PageHandler_OpenURL_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint8_t mark_as_read : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::ui::mojom::internal::ClickModifiers_Data> click_modifiers;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OpenURL_Params_Data>;

  PageHandler_OpenURL_Params_Data();
  ~PageHandler_OpenURL_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OpenURL_Params_Data) == 32,
              "Bad sizeof(PageHandler_OpenURL_Params_Data)");
class  PageHandler_UpdateReadStatus_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint8_t read : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_UpdateReadStatus_Params_Data>;

  PageHandler_UpdateReadStatus_Params_Data();
  ~PageHandler_UpdateReadStatus_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_UpdateReadStatus_Params_Data) == 24,
              "Bad sizeof(PageHandler_UpdateReadStatus_Params_Data)");
class  PageHandler_MarkCurrentTabAsRead_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_MarkCurrentTabAsRead_Params_Data>;

  PageHandler_MarkCurrentTabAsRead_Params_Data();
  ~PageHandler_MarkCurrentTabAsRead_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_MarkCurrentTabAsRead_Params_Data) == 8,
              "Bad sizeof(PageHandler_MarkCurrentTabAsRead_Params_Data)");
class  PageHandler_AddCurrentTab_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddCurrentTab_Params_Data>;

  PageHandler_AddCurrentTab_Params_Data();
  ~PageHandler_AddCurrentTab_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_AddCurrentTab_Params_Data) == 8,
              "Bad sizeof(PageHandler_AddCurrentTab_Params_Data)");
class  PageHandler_RemoveEntry_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_RemoveEntry_Params_Data>;

  PageHandler_RemoveEntry_Params_Data();
  ~PageHandler_RemoveEntry_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_RemoveEntry_Params_Data) == 16,
              "Bad sizeof(PageHandler_RemoveEntry_Params_Data)");
class  PageHandler_ShowContextMenuForURL_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int32_t x;
  int32_t y;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ShowContextMenuForURL_Params_Data>;

  PageHandler_ShowContextMenuForURL_Params_Data();
  ~PageHandler_ShowContextMenuForURL_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ShowContextMenuForURL_Params_Data) == 24,
              "Bad sizeof(PageHandler_ShowContextMenuForURL_Params_Data)");
class  PageHandler_UpdateCurrentPageActionButtonState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_UpdateCurrentPageActionButtonState_Params_Data>;

  PageHandler_UpdateCurrentPageActionButtonState_Params_Data();
  ~PageHandler_UpdateCurrentPageActionButtonState_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_UpdateCurrentPageActionButtonState_Params_Data) == 8,
              "Bad sizeof(PageHandler_UpdateCurrentPageActionButtonState_Params_Data)");
class  PageHandler_ShowUI_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ShowUI_Params_Data>;

  PageHandler_ShowUI_Params_Data();
  ~PageHandler_ShowUI_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ShowUI_Params_Data) == 8,
              "Bad sizeof(PageHandler_ShowUI_Params_Data)");
class  PageHandler_CloseUI_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_CloseUI_Params_Data>;

  PageHandler_CloseUI_Params_Data();
  ~PageHandler_CloseUI_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_CloseUI_Params_Data) == 8,
              "Bad sizeof(PageHandler_CloseUI_Params_Data)");
class  PageHandler_GetWindowData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetWindowData_Params_Data>;

  PageHandler_GetWindowData_Params_Data();
  ~PageHandler_GetWindowData_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetWindowData_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetWindowData_Params_Data)");
class  PageHandler_GetWindowData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Window_Data>>> windows;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetWindowData_ResponseParams_Data>;

  PageHandler_GetWindowData_ResponseParams_Data();
  ~PageHandler_GetWindowData_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetWindowData_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetWindowData_ResponseParams_Data)");
class  Page_ItemsChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ReadLaterEntriesByStatus_Data> entries;

 private:
  friend class mojo::internal::MessageFragment<Page_ItemsChanged_Params_Data>;

  Page_ItemsChanged_Params_Data();
  ~Page_ItemsChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_ItemsChanged_Params_Data) == 16,
              "Bad sizeof(Page_ItemsChanged_Params_Data)");
class  Page_CurrentPageActionButtonStateChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t state;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Page_CurrentPageActionButtonStateChanged_Params_Data>;

  Page_CurrentPageActionButtonStateChanged_Params_Data();
  ~Page_CurrentPageActionButtonStateChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_CurrentPageActionButtonStateChanged_Params_Data) == 16,
              "Bad sizeof(Page_CurrentPageActionButtonStateChanged_Params_Data)");

}  // namespace internal


class PageHandlerFactory_CreatePageHandler_ParamsDataView {
 public:
  PageHandlerFactory_CreatePageHandler_ParamsDataView() = default;

  PageHandlerFactory_CreatePageHandler_ParamsDataView(
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::reading_list::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::reading_list::mojom::PageHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandlerFactory_CreatePageHandler_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetReadLaterEntries_ParamsDataView {
 public:
  PageHandler_GetReadLaterEntries_ParamsDataView() = default;

  PageHandler_GetReadLaterEntries_ParamsDataView(
      internal::PageHandler_GetReadLaterEntries_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetReadLaterEntries_Params_Data* data_ = nullptr;
};


class PageHandler_GetReadLaterEntries_ResponseParamsDataView {
 public:
  PageHandler_GetReadLaterEntries_ResponseParamsDataView() = default;

  PageHandler_GetReadLaterEntries_ResponseParamsDataView(
      internal::PageHandler_GetReadLaterEntries_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntriesDataView(
      ReadLaterEntriesByStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<::reading_list::mojom::ReadLaterEntriesByStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetReadLaterEntries_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_OpenURL_ParamsDataView {
 public:
  PageHandler_OpenURL_ParamsDataView() = default;

  PageHandler_OpenURL_ParamsDataView(
      internal::PageHandler_OpenURL_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool mark_as_read() const {
    return data_->mark_as_read;
  }
  inline void GetClickModifiersDataView(
      ::ui::mojom::ClickModifiersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClickModifiers(UserType* output) {
    
    auto* pointer = data_->click_modifiers.Get();
    return mojo::internal::Deserialize<::ui::mojom::ClickModifiersDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_OpenURL_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_UpdateReadStatus_ParamsDataView {
 public:
  PageHandler_UpdateReadStatus_ParamsDataView() = default;

  PageHandler_UpdateReadStatus_ParamsDataView(
      internal::PageHandler_UpdateReadStatus_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool read() const {
    return data_->read;
  }
 private:
  internal::PageHandler_UpdateReadStatus_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_MarkCurrentTabAsRead_ParamsDataView {
 public:
  PageHandler_MarkCurrentTabAsRead_ParamsDataView() = default;

  PageHandler_MarkCurrentTabAsRead_ParamsDataView(
      internal::PageHandler_MarkCurrentTabAsRead_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_MarkCurrentTabAsRead_Params_Data* data_ = nullptr;
};


class PageHandler_AddCurrentTab_ParamsDataView {
 public:
  PageHandler_AddCurrentTab_ParamsDataView() = default;

  PageHandler_AddCurrentTab_ParamsDataView(
      internal::PageHandler_AddCurrentTab_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_AddCurrentTab_Params_Data* data_ = nullptr;
};


class PageHandler_RemoveEntry_ParamsDataView {
 public:
  PageHandler_RemoveEntry_ParamsDataView() = default;

  PageHandler_RemoveEntry_ParamsDataView(
      internal::PageHandler_RemoveEntry_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_RemoveEntry_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ShowContextMenuForURL_ParamsDataView {
 public:
  PageHandler_ShowContextMenuForURL_ParamsDataView() = default;

  PageHandler_ShowContextMenuForURL_ParamsDataView(
      internal::PageHandler_ShowContextMenuForURL_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t x() const {
    return data_->x;
  }
  int32_t y() const {
    return data_->y;
  }
 private:
  internal::PageHandler_ShowContextMenuForURL_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_UpdateCurrentPageActionButtonState_ParamsDataView {
 public:
  PageHandler_UpdateCurrentPageActionButtonState_ParamsDataView() = default;

  PageHandler_UpdateCurrentPageActionButtonState_ParamsDataView(
      internal::PageHandler_UpdateCurrentPageActionButtonState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_UpdateCurrentPageActionButtonState_Params_Data* data_ = nullptr;
};


class PageHandler_ShowUI_ParamsDataView {
 public:
  PageHandler_ShowUI_ParamsDataView() = default;

  PageHandler_ShowUI_ParamsDataView(
      internal::PageHandler_ShowUI_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ShowUI_Params_Data* data_ = nullptr;
};


class PageHandler_CloseUI_ParamsDataView {
 public:
  PageHandler_CloseUI_ParamsDataView() = default;

  PageHandler_CloseUI_ParamsDataView(
      internal::PageHandler_CloseUI_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_CloseUI_Params_Data* data_ = nullptr;
};


class PageHandler_GetWindowData_ParamsDataView {
 public:
  PageHandler_GetWindowData_ParamsDataView() = default;

  PageHandler_GetWindowData_ParamsDataView(
      internal::PageHandler_GetWindowData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetWindowData_Params_Data* data_ = nullptr;
};


class PageHandler_GetWindowData_ResponseParamsDataView {
 public:
  PageHandler_GetWindowData_ResponseParamsDataView() = default;

  PageHandler_GetWindowData_ResponseParamsDataView(
      internal::PageHandler_GetWindowData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowsDataView(
      mojo::ArrayDataView<WindowDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindows(UserType* output) {
    
    auto* pointer = data_->windows.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::reading_list::mojom::WindowDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetWindowData_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_ItemsChanged_ParamsDataView {
 public:
  Page_ItemsChanged_ParamsDataView() = default;

  Page_ItemsChanged_ParamsDataView(
      internal::Page_ItemsChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntriesDataView(
      ReadLaterEntriesByStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<::reading_list::mojom::ReadLaterEntriesByStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::Page_ItemsChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_CurrentPageActionButtonStateChanged_ParamsDataView {
 public:
  Page_CurrentPageActionButtonStateChanged_ParamsDataView() = default;

  Page_CurrentPageActionButtonStateChanged_ParamsDataView(
      internal::Page_CurrentPageActionButtonStateChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::reading_list::mojom::CurrentPageActionButtonState>(
        data_value, output);
  }
  CurrentPageActionButtonState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::reading_list::mojom::CurrentPageActionButtonState>(data_->state));
  }
 private:
  internal::Page_CurrentPageActionButtonStateChanged_Params_Data* data_ = nullptr;
};





inline void PageHandler_GetReadLaterEntries_ResponseParamsDataView::GetEntriesDataView(
    ReadLaterEntriesByStatusDataView* output) {
  auto pointer = data_->entries.Get();
  *output = ReadLaterEntriesByStatusDataView(pointer, message_);
}


inline void PageHandler_OpenURL_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PageHandler_OpenURL_ParamsDataView::GetClickModifiersDataView(
    ::ui::mojom::ClickModifiersDataView* output) {
  auto pointer = data_->click_modifiers.Get();
  *output = ::ui::mojom::ClickModifiersDataView(pointer, message_);
}


inline void PageHandler_UpdateReadStatus_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}






inline void PageHandler_RemoveEntry_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PageHandler_ShowContextMenuForURL_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}










inline void PageHandler_GetWindowData_ResponseParamsDataView::GetWindowsDataView(
    mojo::ArrayDataView<WindowDataView>* output) {
  auto pointer = data_->windows.Get();
  *output = mojo::ArrayDataView<WindowDataView>(pointer, message_);
}


inline void Page_ItemsChanged_ParamsDataView::GetEntriesDataView(
    ReadLaterEntriesByStatusDataView* output) {
  auto pointer = data_->entries.Get();
  *output = ReadLaterEntriesByStatusDataView(pointer, message_);
}





}  // reading_list::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_PARAMS_DATA_H_