// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared-internal.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace reading_list::mojom {
class ReadLaterEntriesByStatusDataView;

class ReadLaterEntryDataView;

class WindowDataView;



}  // reading_list::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::reading_list::mojom::ReadLaterEntriesByStatusDataView> {
  using Data = ::reading_list::mojom::internal::ReadLaterEntriesByStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::reading_list::mojom::ReadLaterEntryDataView> {
  using Data = ::reading_list::mojom::internal::ReadLaterEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::reading_list::mojom::WindowDataView> {
  using Data = ::reading_list::mojom::internal::Window_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace reading_list::mojom {


enum class CurrentPageActionButtonState : int32_t {
  
  kAdd = 0,
  
  kDisabled = 1,
  
  kMarkAsRead = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CurrentPageActionButtonState value);
inline bool IsKnownEnumValue(CurrentPageActionButtonState value) {
  return internal::CurrentPageActionButtonState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ReadLaterEntriesByStatusDataView {
 public:
  ReadLaterEntriesByStatusDataView() = default;

  ReadLaterEntriesByStatusDataView(
      internal::ReadLaterEntriesByStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUnreadEntriesDataView(
      mojo::ArrayDataView<ReadLaterEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnreadEntries(UserType* output) {
    
    auto* pointer = data_->unread_entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::reading_list::mojom::ReadLaterEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetReadEntriesDataView(
      mojo::ArrayDataView<ReadLaterEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadEntries(UserType* output) {
    
    auto* pointer = data_->read_entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::reading_list::mojom::ReadLaterEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ReadLaterEntriesByStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadLaterEntryDataView {
 public:
  ReadLaterEntryDataView() = default;

  ReadLaterEntryDataView(
      internal::ReadLaterEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayUrl(UserType* output) {
    
    auto* pointer = data_->display_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t update_time() const {
    return data_->update_time;
  }
  bool read() const {
    return data_->read;
  }
  inline void GetDisplayTimeSinceUpdateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayTimeSinceUpdate(UserType* output) {
    
    auto* pointer = data_->display_time_since_update.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReadLaterEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WindowDataView {
 public:
  WindowDataView() = default;

  WindowDataView(
      internal::Window_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool active() const {
    return data_->active;
  }
  uint32_t height() const {
    return data_->height;
  }
 private:
  internal::Window_Data* data_ = nullptr;
};


}  // reading_list::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_DATA_VIEW_H_