// chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_WALLPAPER_SEARCH_WALLPAPER_SEARCH_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_WALLPAPER_SEARCH_WALLPAPER_SEARCH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/token.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace side_panel::customize_chrome::mojom {

class WallpaperSearchHandlerFactoryProxy;

template <typename ImplRefTraits>
class WallpaperSearchHandlerFactoryStub;

class WallpaperSearchHandlerFactoryRequestValidator;


class WallpaperSearchHandlerFactory
    : public WallpaperSearchHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.customize_chrome.mojom.WallpaperSearchHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WallpaperSearchHandlerFactoryInterfaceBase;
  using Proxy_ = WallpaperSearchHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = WallpaperSearchHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = WallpaperSearchHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateWallpaperSearchHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWallpaperSearchHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WallpaperSearchHandlerFactory() = default;

  virtual void CreateWallpaperSearchHandler(::mojo::PendingRemote<WallpaperSearchClient> client, ::mojo::PendingReceiver<WallpaperSearchHandler> handler) = 0;
};

class WallpaperSearchHandlerProxy;

template <typename ImplRefTraits>
class WallpaperSearchHandlerStub;

class WallpaperSearchHandlerRequestValidator;
class WallpaperSearchHandlerResponseValidator;


class WallpaperSearchHandler
    : public WallpaperSearchHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.customize_chrome.mojom.WallpaperSearchHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WallpaperSearchHandlerInterfaceBase;
  using Proxy_ = WallpaperSearchHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WallpaperSearchHandlerStub<ImplRefTraits>;

  using RequestValidator_ = WallpaperSearchHandlerRequestValidator;
  using ResponseValidator_ = WallpaperSearchHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDescriptorsMinVersion = 0,
    kGetInspirationsMinVersion = 0,
    kGetWallpaperSearchResultsMinVersion = 0,
    kSetResultRenderTimeMinVersion = 0,
    kSetBackgroundToHistoryImageMinVersion = 0,
    kSetBackgroundToInspirationImageMinVersion = 0,
    kSetBackgroundToWallpaperSearchResultMinVersion = 0,
    kUpdateHistoryMinVersion = 0,
    kSetUserFeedbackMinVersion = 0,
    kOpenHelpArticleMinVersion = 0,
    kLaunchHatsSurveyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDescriptors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInspirations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWallpaperSearchResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetResultRenderTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundToHistoryImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundToInspirationImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundToWallpaperSearchResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenHelpArticle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LaunchHatsSurvey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WallpaperSearchHandler() = default;

  using GetDescriptorsCallback = base::OnceCallback<void(DescriptorsPtr)>;
  using GetDescriptorsMojoCallback = base::OnceCallback<void(DescriptorsPtr)>;

  virtual void GetDescriptors(GetDescriptorsCallback callback) = 0;

  using GetInspirationsCallback = base::OnceCallback<void(std::optional<std::vector<InspirationGroupPtr>>)>;
  using GetInspirationsMojoCallback = base::OnceCallback<void(std::optional<std::vector<InspirationGroupPtr>>)>;

  virtual void GetInspirations(GetInspirationsCallback callback) = 0;

  using GetWallpaperSearchResultsCallback = base::OnceCallback<void(WallpaperSearchStatus, std::vector<WallpaperSearchResultPtr>)>;
  using GetWallpaperSearchResultsMojoCallback = base::OnceCallback<void(WallpaperSearchStatus, std::vector<WallpaperSearchResultPtr>)>;

  virtual void GetWallpaperSearchResults(ResultDescriptorsPtr result_descriptors, GetWallpaperSearchResultsCallback callback) = 0;

  virtual void SetResultRenderTime(const std::vector<::base::Token>& result_ids, double time) = 0;

  virtual void SetBackgroundToHistoryImage(const ::base::Token& result_id, ResultDescriptorsPtr descriptors) = 0;

  virtual void SetBackgroundToInspirationImage(const ::base::Token& id, const ::GURL& background_url) = 0;

  virtual void SetBackgroundToWallpaperSearchResult(const ::base::Token& result_id, double time, ResultDescriptorsPtr descriptors) = 0;

  virtual void UpdateHistory() = 0;

  virtual void SetUserFeedback(UserFeedback selected_option) = 0;

  virtual void OpenHelpArticle() = 0;

  virtual void LaunchHatsSurvey() = 0;
};

class WallpaperSearchClientProxy;

template <typename ImplRefTraits>
class WallpaperSearchClientStub;

class WallpaperSearchClientRequestValidator;


class WallpaperSearchClient
    : public WallpaperSearchClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.customize_chrome.mojom.WallpaperSearchClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WallpaperSearchClientInterfaceBase;
  using Proxy_ = WallpaperSearchClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WallpaperSearchClientStub<ImplRefTraits>;

  using RequestValidator_ = WallpaperSearchClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetHistoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WallpaperSearchClient() = default;

  virtual void SetHistory(std::vector<WallpaperSearchResultPtr> history) = 0;
};



class  WallpaperSearchHandlerFactoryProxy
    : public WallpaperSearchHandlerFactory {
 public:
  using InterfaceType = WallpaperSearchHandlerFactory;

  explicit WallpaperSearchHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWallpaperSearchHandler(::mojo::PendingRemote<WallpaperSearchClient> client, ::mojo::PendingReceiver<WallpaperSearchHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WallpaperSearchHandlerProxy
    : public WallpaperSearchHandler {
 public:
  using InterfaceType = WallpaperSearchHandler;

  explicit WallpaperSearchHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDescriptors(GetDescriptorsCallback callback) final;
  
  void GetInspirations(GetInspirationsCallback callback) final;
  
  void GetWallpaperSearchResults(ResultDescriptorsPtr result_descriptors, GetWallpaperSearchResultsCallback callback) final;
  
  void SetResultRenderTime(const std::vector<::base::Token>& result_ids, double time) final;
  
  void SetBackgroundToHistoryImage(const ::base::Token& result_id, ResultDescriptorsPtr descriptors) final;
  
  void SetBackgroundToInspirationImage(const ::base::Token& id, const ::GURL& background_url) final;
  
  void SetBackgroundToWallpaperSearchResult(const ::base::Token& result_id, double time, ResultDescriptorsPtr descriptors) final;
  
  void UpdateHistory() final;
  
  void SetUserFeedback(UserFeedback selected_option) final;
  
  void OpenHelpArticle() final;
  
  void LaunchHatsSurvey() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WallpaperSearchClientProxy
    : public WallpaperSearchClient {
 public:
  using InterfaceType = WallpaperSearchClient;

  explicit WallpaperSearchClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetHistory(std::vector<WallpaperSearchResultPtr> history) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WallpaperSearchHandlerFactoryStubDispatch {
 public:
  static bool Accept(WallpaperSearchHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WallpaperSearchHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WallpaperSearchHandlerFactory>>
class WallpaperSearchHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WallpaperSearchHandlerFactoryStub() = default;
  ~WallpaperSearchHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WallpaperSearchHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WallpaperSearchHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WallpaperSearchHandlerStubDispatch {
 public:
  static bool Accept(WallpaperSearchHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WallpaperSearchHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WallpaperSearchHandler>>
class WallpaperSearchHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WallpaperSearchHandlerStub() = default;
  ~WallpaperSearchHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WallpaperSearchHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WallpaperSearchHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WallpaperSearchClientStubDispatch {
 public:
  static bool Accept(WallpaperSearchClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WallpaperSearchClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WallpaperSearchClient>>
class WallpaperSearchClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WallpaperSearchClientStub() = default;
  ~WallpaperSearchClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WallpaperSearchClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WallpaperSearchClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WallpaperSearchHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WallpaperSearchHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WallpaperSearchClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WallpaperSearchHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  KeyLabel {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeyLabel, T>::value>;
  using DataView = KeyLabelDataView;
  using Data_ = internal::KeyLabel_Data;

  template <typename... Args>
  static KeyLabelPtr New(Args&&... args) {
    return KeyLabelPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeyLabelPtr From(const U& u) {
    return mojo::TypeConverter<KeyLabelPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeyLabel>::Convert(*this);
  }


  KeyLabel();

  KeyLabel(
      const std::string& key,
      const std::string& label);


  ~KeyLabel();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeyLabelPtr>
  KeyLabelPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyLabel::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyLabel::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeyLabel::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeyLabel_UnserializedMessageContext<
            UserType, KeyLabel::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<KeyLabel::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return KeyLabel::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeyLabel_UnserializedMessageContext<
            UserType, KeyLabel::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeyLabel::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeyLabel::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DescriptorB {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DescriptorB, T>::value>;
  using DataView = DescriptorBDataView;
  using Data_ = internal::DescriptorB_Data;

  template <typename... Args>
  static DescriptorBPtr New(Args&&... args) {
    return DescriptorBPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DescriptorBPtr From(const U& u) {
    return mojo::TypeConverter<DescriptorBPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DescriptorB>::Convert(*this);
  }


  DescriptorB();

  DescriptorB(
      const std::string& key,
      const std::string& label,
      const std::string& image_path);


  ~DescriptorB();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DescriptorBPtr>
  DescriptorBPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DescriptorB::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DescriptorB::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DescriptorB::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DescriptorB_UnserializedMessageContext<
            UserType, DescriptorB::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DescriptorB::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DescriptorB::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DescriptorB_UnserializedMessageContext<
            UserType, DescriptorB::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DescriptorB::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  std::string label;
  
  std::string image_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DescriptorB::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  DescriptorDValue {
 public:
  using DataView = DescriptorDValueDataView;
  using Data_ = internal::DescriptorDValue_Data;
  using Tag = Data_::DescriptorDValue_Tag;

  template <typename... Args>
  static DescriptorDValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |color|.
  static DescriptorDValuePtr NewColor(
      ::SkColor value);
  // Construct an instance holding |hue|.
  static DescriptorDValuePtr NewHue(
      float value);
  // Construct an instance holding |name|.
  static DescriptorDValuePtr NewName(
      DescriptorDName value);

  template <typename U>
  static DescriptorDValuePtr From(const U& u) {
    return mojo::TypeConverter<DescriptorDValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DescriptorDValue>::Convert(*this);
  }
  ~DescriptorDValue();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DescriptorDValue(const DescriptorDValue& other) = delete;
  DescriptorDValue& operator=(const DescriptorDValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DescriptorDValuePtr>
  DescriptorDValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DescriptorDValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DescriptorDValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_color() const { return tag_ == Tag::kColor; }
  const ::SkColor& get_color() const {
    CHECK(tag_ == Tag::kColor);
    return data_.color;
  }
  ::SkColor& get_color() {
    CHECK(tag_ == Tag::kColor);
    return data_.color;
  }
  void set_color(::SkColor color);

  bool is_hue() const { return tag_ == Tag::kHue; }
  float get_hue() const {
    CHECK(tag_ == Tag::kHue);
    return data_.hue;
  }
  void set_hue(float hue);

  bool is_name() const { return tag_ == Tag::kName; }
  DescriptorDName get_name() const {
    CHECK(tag_ == Tag::kName);
    return data_.name;
  }
  void set_name(DescriptorDName name);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DescriptorDValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DescriptorDValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kColor)>,
        ::SkColor value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHue)>,
        float value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kName)>,
        DescriptorDName value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::SkColor color;
    float hue;
    DescriptorDName name;
  };

  DescriptorDValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kColor)>,
      ::SkColor value);
  DescriptorDValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kHue)>,
      float value);
  DescriptorDValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kName)>,
      DescriptorDName value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  Group {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Group, T>::value>;
  using DataView = GroupDataView;
  using Data_ = internal::Group_Data;

  template <typename... Args>
  static GroupPtr New(Args&&... args) {
    return GroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GroupPtr From(const U& u) {
    return mojo::TypeConverter<GroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Group>::Convert(*this);
  }


  Group();

  Group(
      const std::string& category,
      std::vector<KeyLabelPtr> descriptor_as);

Group(const Group&) = delete;
Group& operator=(const Group&) = delete;

  ~Group();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GroupPtr>
  GroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Group::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Group::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Group::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Group::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Group::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Group::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Group_UnserializedMessageContext<
            UserType, Group::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Group::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Group::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Group_UnserializedMessageContext<
            UserType, Group::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Group::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string category;
  
  std::vector<KeyLabelPtr> descriptor_as;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Group::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Group::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Group::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Group::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Descriptors {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Descriptors, T>::value>;
  using DataView = DescriptorsDataView;
  using Data_ = internal::Descriptors_Data;

  template <typename... Args>
  static DescriptorsPtr New(Args&&... args) {
    return DescriptorsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DescriptorsPtr From(const U& u) {
    return mojo::TypeConverter<DescriptorsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Descriptors>::Convert(*this);
  }


  Descriptors();

  Descriptors(
      std::vector<GroupPtr> groups,
      std::vector<DescriptorBPtr> descriptor_b,
      std::vector<KeyLabelPtr> descriptor_c);

Descriptors(const Descriptors&) = delete;
Descriptors& operator=(const Descriptors&) = delete;

  ~Descriptors();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DescriptorsPtr>
  DescriptorsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Descriptors::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Descriptors::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Descriptors::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Descriptors_UnserializedMessageContext<
            UserType, Descriptors::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Descriptors::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Descriptors::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Descriptors_UnserializedMessageContext<
            UserType, Descriptors::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Descriptors::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<GroupPtr> groups;
  
  std::vector<DescriptorBPtr> descriptor_b;
  
  std::vector<KeyLabelPtr> descriptor_c;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Descriptors::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Inspiration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Inspiration, T>::value>;
  using DataView = InspirationDataView;
  using Data_ = internal::Inspiration_Data;

  template <typename... Args>
  static InspirationPtr New(Args&&... args) {
    return InspirationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspirationPtr From(const U& u) {
    return mojo::TypeConverter<InspirationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Inspiration>::Convert(*this);
  }


  Inspiration();

  Inspiration(
      const ::base::Token& id,
      const std::string& description,
      const ::GURL& background_url,
      const ::GURL& thumbnail_url);


  ~Inspiration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspirationPtr>
  InspirationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Inspiration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Inspiration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Inspiration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Inspiration_UnserializedMessageContext<
            UserType, Inspiration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Inspiration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Inspiration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Inspiration_UnserializedMessageContext<
            UserType, Inspiration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Inspiration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token id;
  
  std::string description;
  
  ::GURL background_url;
  
  ::GURL thumbnail_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Inspiration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InspirationDescriptors {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InspirationDescriptors, T>::value>;
  using DataView = InspirationDescriptorsDataView;
  using Data_ = internal::InspirationDescriptors_Data;

  template <typename... Args>
  static InspirationDescriptorsPtr New(Args&&... args) {
    return InspirationDescriptorsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspirationDescriptorsPtr From(const U& u) {
    return mojo::TypeConverter<InspirationDescriptorsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InspirationDescriptors>::Convert(*this);
  }


  InspirationDescriptors();

  InspirationDescriptors(
      KeyLabelPtr subject,
      KeyLabelPtr style,
      KeyLabelPtr mood,
      DescriptorDValuePtr color);

InspirationDescriptors(const InspirationDescriptors&) = delete;
InspirationDescriptors& operator=(const InspirationDescriptors&) = delete;

  ~InspirationDescriptors();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspirationDescriptorsPtr>
  InspirationDescriptorsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspirationDescriptors::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspirationDescriptors::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InspirationDescriptors::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InspirationDescriptors_UnserializedMessageContext<
            UserType, InspirationDescriptors::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InspirationDescriptors::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InspirationDescriptors::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InspirationDescriptors_UnserializedMessageContext<
            UserType, InspirationDescriptors::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InspirationDescriptors::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  KeyLabelPtr subject;
  
  KeyLabelPtr style;
  
  KeyLabelPtr mood;
  
  DescriptorDValuePtr color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InspirationDescriptors::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InspirationGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InspirationGroup, T>::value>;
  using DataView = InspirationGroupDataView;
  using Data_ = internal::InspirationGroup_Data;

  template <typename... Args>
  static InspirationGroupPtr New(Args&&... args) {
    return InspirationGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspirationGroupPtr From(const U& u) {
    return mojo::TypeConverter<InspirationGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InspirationGroup>::Convert(*this);
  }


  InspirationGroup();

  InspirationGroup(
      InspirationDescriptorsPtr descriptors,
      std::vector<InspirationPtr> inspirations);

InspirationGroup(const InspirationGroup&) = delete;
InspirationGroup& operator=(const InspirationGroup&) = delete;

  ~InspirationGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspirationGroupPtr>
  InspirationGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspirationGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspirationGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InspirationGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InspirationGroup_UnserializedMessageContext<
            UserType, InspirationGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InspirationGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InspirationGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InspirationGroup_UnserializedMessageContext<
            UserType, InspirationGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InspirationGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  InspirationDescriptorsPtr descriptors;
  
  std::vector<InspirationPtr> inspirations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InspirationGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WallpaperSearchResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WallpaperSearchResult, T>::value>;
  using DataView = WallpaperSearchResultDataView;
  using Data_ = internal::WallpaperSearchResult_Data;

  template <typename... Args>
  static WallpaperSearchResultPtr New(Args&&... args) {
    return WallpaperSearchResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WallpaperSearchResultPtr From(const U& u) {
    return mojo::TypeConverter<WallpaperSearchResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WallpaperSearchResult>::Convert(*this);
  }


  WallpaperSearchResult();

  WallpaperSearchResult(
      const ::base::Token& id,
      const std::string& image,
      ResultDescriptorsPtr descriptors);

WallpaperSearchResult(const WallpaperSearchResult&) = delete;
WallpaperSearchResult& operator=(const WallpaperSearchResult&) = delete;

  ~WallpaperSearchResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WallpaperSearchResultPtr>
  WallpaperSearchResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WallpaperSearchResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WallpaperSearchResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WallpaperSearchResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WallpaperSearchResult_UnserializedMessageContext<
            UserType, WallpaperSearchResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WallpaperSearchResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WallpaperSearchResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WallpaperSearchResult_UnserializedMessageContext<
            UserType, WallpaperSearchResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WallpaperSearchResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token id;
  
  std::string image;
  
  ResultDescriptorsPtr descriptors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WallpaperSearchResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ResultDescriptors {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResultDescriptors, T>::value>;
  using DataView = ResultDescriptorsDataView;
  using Data_ = internal::ResultDescriptors_Data;

  template <typename... Args>
  static ResultDescriptorsPtr New(Args&&... args) {
    return ResultDescriptorsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResultDescriptorsPtr From(const U& u) {
    return mojo::TypeConverter<ResultDescriptorsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResultDescriptors>::Convert(*this);
  }


  ResultDescriptors();

  ResultDescriptors(
      const std::optional<std::string>& subject,
      const std::optional<std::string>& style,
      const std::optional<std::string>& mood,
      DescriptorDValuePtr color);

ResultDescriptors(const ResultDescriptors&) = delete;
ResultDescriptors& operator=(const ResultDescriptors&) = delete;

  ~ResultDescriptors();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResultDescriptorsPtr>
  ResultDescriptorsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResultDescriptors::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResultDescriptors::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResultDescriptors::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResultDescriptors_UnserializedMessageContext<
            UserType, ResultDescriptors::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResultDescriptors::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResultDescriptors::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResultDescriptors_UnserializedMessageContext<
            UserType, ResultDescriptors::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResultDescriptors::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> subject;
  
  std::optional<std::string> style;
  
  std::optional<std::string> mood;
  
  DescriptorDValuePtr color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResultDescriptors::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DescriptorDValuePtr DescriptorDValue::Clone() const {
  switch (tag_) {
    case Tag::kColor:
      return NewColor(
          mojo::Clone(data_.color));
    case Tag::kHue:
      return NewHue(
          mojo::Clone(data_.hue));
    case Tag::kName:
      return NewName(
          mojo::Clone(data_.name));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DescriptorDValue>::value>::type*>
bool DescriptorDValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kColor:
      return mojo::Equals(data_.color, other.data_.color);
    case Tag::kHue:
      return mojo::Equals(data_.hue, other.data_.hue);
    case Tag::kName:
      return mojo::Equals(data_.name, other.data_.name);
  }

  return false;
}
template <typename StructPtrType>
KeyLabelPtr KeyLabel::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(label)
  );
}

template <typename T, KeyLabel::EnableIfSame<T>*>
bool KeyLabel::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, KeyLabel::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GroupPtr Group::Clone() const {
  return New(
      mojo::Clone(category),
      mojo::Clone(descriptor_as)
  );
}

template <typename T, Group::EnableIfSame<T>*>
bool Group::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->category, other_struct.category))
    return false;
  if (!mojo::Equals(this->descriptor_as, other_struct.descriptor_as))
    return false;
  return true;
}

template <typename T, Group::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.category < rhs.category)
    return true;
  if (rhs.category < lhs.category)
    return false;
  if (lhs.descriptor_as < rhs.descriptor_as)
    return true;
  if (rhs.descriptor_as < lhs.descriptor_as)
    return false;
  return false;
}
template <typename StructPtrType>
DescriptorBPtr DescriptorB::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(label),
      mojo::Clone(image_path)
  );
}

template <typename T, DescriptorB::EnableIfSame<T>*>
bool DescriptorB::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->image_path, other_struct.image_path))
    return false;
  return true;
}

template <typename T, DescriptorB::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.image_path < rhs.image_path)
    return true;
  if (rhs.image_path < lhs.image_path)
    return false;
  return false;
}
template <typename StructPtrType>
DescriptorsPtr Descriptors::Clone() const {
  return New(
      mojo::Clone(groups),
      mojo::Clone(descriptor_b),
      mojo::Clone(descriptor_c)
  );
}

template <typename T, Descriptors::EnableIfSame<T>*>
bool Descriptors::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->groups, other_struct.groups))
    return false;
  if (!mojo::Equals(this->descriptor_b, other_struct.descriptor_b))
    return false;
  if (!mojo::Equals(this->descriptor_c, other_struct.descriptor_c))
    return false;
  return true;
}

template <typename T, Descriptors::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.groups < rhs.groups)
    return true;
  if (rhs.groups < lhs.groups)
    return false;
  if (lhs.descriptor_b < rhs.descriptor_b)
    return true;
  if (rhs.descriptor_b < lhs.descriptor_b)
    return false;
  if (lhs.descriptor_c < rhs.descriptor_c)
    return true;
  if (rhs.descriptor_c < lhs.descriptor_c)
    return false;
  return false;
}
template <typename StructPtrType>
InspirationPtr Inspiration::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(description),
      mojo::Clone(background_url),
      mojo::Clone(thumbnail_url)
  );
}

template <typename T, Inspiration::EnableIfSame<T>*>
bool Inspiration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->background_url, other_struct.background_url))
    return false;
  if (!mojo::Equals(this->thumbnail_url, other_struct.thumbnail_url))
    return false;
  return true;
}

template <typename T, Inspiration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.background_url < rhs.background_url)
    return true;
  if (rhs.background_url < lhs.background_url)
    return false;
  if (lhs.thumbnail_url < rhs.thumbnail_url)
    return true;
  if (rhs.thumbnail_url < lhs.thumbnail_url)
    return false;
  return false;
}
template <typename StructPtrType>
InspirationDescriptorsPtr InspirationDescriptors::Clone() const {
  return New(
      mojo::Clone(subject),
      mojo::Clone(style),
      mojo::Clone(mood),
      mojo::Clone(color)
  );
}

template <typename T, InspirationDescriptors::EnableIfSame<T>*>
bool InspirationDescriptors::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subject, other_struct.subject))
    return false;
  if (!mojo::Equals(this->style, other_struct.style))
    return false;
  if (!mojo::Equals(this->mood, other_struct.mood))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  return true;
}

template <typename T, InspirationDescriptors::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subject < rhs.subject)
    return true;
  if (rhs.subject < lhs.subject)
    return false;
  if (lhs.style < rhs.style)
    return true;
  if (rhs.style < lhs.style)
    return false;
  if (lhs.mood < rhs.mood)
    return true;
  if (rhs.mood < lhs.mood)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  return false;
}
template <typename StructPtrType>
InspirationGroupPtr InspirationGroup::Clone() const {
  return New(
      mojo::Clone(descriptors),
      mojo::Clone(inspirations)
  );
}

template <typename T, InspirationGroup::EnableIfSame<T>*>
bool InspirationGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->descriptors, other_struct.descriptors))
    return false;
  if (!mojo::Equals(this->inspirations, other_struct.inspirations))
    return false;
  return true;
}

template <typename T, InspirationGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.descriptors < rhs.descriptors)
    return true;
  if (rhs.descriptors < lhs.descriptors)
    return false;
  if (lhs.inspirations < rhs.inspirations)
    return true;
  if (rhs.inspirations < lhs.inspirations)
    return false;
  return false;
}
template <typename StructPtrType>
WallpaperSearchResultPtr WallpaperSearchResult::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(image),
      mojo::Clone(descriptors)
  );
}

template <typename T, WallpaperSearchResult::EnableIfSame<T>*>
bool WallpaperSearchResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->image, other_struct.image))
    return false;
  if (!mojo::Equals(this->descriptors, other_struct.descriptors))
    return false;
  return true;
}

template <typename T, WallpaperSearchResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.image < rhs.image)
    return true;
  if (rhs.image < lhs.image)
    return false;
  if (lhs.descriptors < rhs.descriptors)
    return true;
  if (rhs.descriptors < lhs.descriptors)
    return false;
  return false;
}
template <typename StructPtrType>
ResultDescriptorsPtr ResultDescriptors::Clone() const {
  return New(
      mojo::Clone(subject),
      mojo::Clone(style),
      mojo::Clone(mood),
      mojo::Clone(color)
  );
}

template <typename T, ResultDescriptors::EnableIfSame<T>*>
bool ResultDescriptors::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subject, other_struct.subject))
    return false;
  if (!mojo::Equals(this->style, other_struct.style))
    return false;
  if (!mojo::Equals(this->mood, other_struct.mood))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  return true;
}

template <typename T, ResultDescriptors::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subject < rhs.subject)
    return true;
  if (rhs.subject < lhs.subject)
    return false;
  if (lhs.style < rhs.style)
    return true;
  if (rhs.style < lhs.style)
    return false;
  if (lhs.mood < rhs.mood)
    return true;
  if (rhs.mood < lhs.mood)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  return false;
}


}  // side_panel::customize_chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::KeyLabel::DataView,
                                         ::side_panel::customize_chrome::mojom::KeyLabelPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::KeyLabelPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::KeyLabelPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::KeyLabel::key)& key(
      const ::side_panel::customize_chrome::mojom::KeyLabelPtr& input) {
    return input->key;
  }

  static const decltype(::side_panel::customize_chrome::mojom::KeyLabel::label)& label(
      const ::side_panel::customize_chrome::mojom::KeyLabelPtr& input) {
    return input->label;
  }

  static bool Read(::side_panel::customize_chrome::mojom::KeyLabel::DataView input, ::side_panel::customize_chrome::mojom::KeyLabelPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::Group::DataView,
                                         ::side_panel::customize_chrome::mojom::GroupPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::GroupPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::GroupPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::Group::category)& category(
      const ::side_panel::customize_chrome::mojom::GroupPtr& input) {
    return input->category;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Group::descriptor_as)& descriptor_as(
      const ::side_panel::customize_chrome::mojom::GroupPtr& input) {
    return input->descriptor_as;
  }

  static bool Read(::side_panel::customize_chrome::mojom::Group::DataView input, ::side_panel::customize_chrome::mojom::GroupPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::DescriptorB::DataView,
                                         ::side_panel::customize_chrome::mojom::DescriptorBPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::DescriptorBPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::DescriptorBPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::DescriptorB::key)& key(
      const ::side_panel::customize_chrome::mojom::DescriptorBPtr& input) {
    return input->key;
  }

  static const decltype(::side_panel::customize_chrome::mojom::DescriptorB::label)& label(
      const ::side_panel::customize_chrome::mojom::DescriptorBPtr& input) {
    return input->label;
  }

  static const decltype(::side_panel::customize_chrome::mojom::DescriptorB::image_path)& image_path(
      const ::side_panel::customize_chrome::mojom::DescriptorBPtr& input) {
    return input->image_path;
  }

  static bool Read(::side_panel::customize_chrome::mojom::DescriptorB::DataView input, ::side_panel::customize_chrome::mojom::DescriptorBPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::Descriptors::DataView,
                                         ::side_panel::customize_chrome::mojom::DescriptorsPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::DescriptorsPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::DescriptorsPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::Descriptors::groups)& groups(
      const ::side_panel::customize_chrome::mojom::DescriptorsPtr& input) {
    return input->groups;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Descriptors::descriptor_b)& descriptor_b(
      const ::side_panel::customize_chrome::mojom::DescriptorsPtr& input) {
    return input->descriptor_b;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Descriptors::descriptor_c)& descriptor_c(
      const ::side_panel::customize_chrome::mojom::DescriptorsPtr& input) {
    return input->descriptor_c;
  }

  static bool Read(::side_panel::customize_chrome::mojom::Descriptors::DataView input, ::side_panel::customize_chrome::mojom::DescriptorsPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::Inspiration::DataView,
                                         ::side_panel::customize_chrome::mojom::InspirationPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::InspirationPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::InspirationPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::Inspiration::id)& id(
      const ::side_panel::customize_chrome::mojom::InspirationPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Inspiration::description)& description(
      const ::side_panel::customize_chrome::mojom::InspirationPtr& input) {
    return input->description;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Inspiration::background_url)& background_url(
      const ::side_panel::customize_chrome::mojom::InspirationPtr& input) {
    return input->background_url;
  }

  static const decltype(::side_panel::customize_chrome::mojom::Inspiration::thumbnail_url)& thumbnail_url(
      const ::side_panel::customize_chrome::mojom::InspirationPtr& input) {
    return input->thumbnail_url;
  }

  static bool Read(::side_panel::customize_chrome::mojom::Inspiration::DataView input, ::side_panel::customize_chrome::mojom::InspirationPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::InspirationDescriptors::DataView,
                                         ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::InspirationDescriptors::subject)& subject(
      const ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr& input) {
    return input->subject;
  }

  static const decltype(::side_panel::customize_chrome::mojom::InspirationDescriptors::style)& style(
      const ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr& input) {
    return input->style;
  }

  static const decltype(::side_panel::customize_chrome::mojom::InspirationDescriptors::mood)& mood(
      const ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr& input) {
    return input->mood;
  }

  static const decltype(::side_panel::customize_chrome::mojom::InspirationDescriptors::color)& color(
      const ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr& input) {
    return input->color;
  }

  static bool Read(::side_panel::customize_chrome::mojom::InspirationDescriptors::DataView input, ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::InspirationGroup::DataView,
                                         ::side_panel::customize_chrome::mojom::InspirationGroupPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::InspirationGroupPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::InspirationGroupPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::InspirationGroup::descriptors)& descriptors(
      const ::side_panel::customize_chrome::mojom::InspirationGroupPtr& input) {
    return input->descriptors;
  }

  static const decltype(::side_panel::customize_chrome::mojom::InspirationGroup::inspirations)& inspirations(
      const ::side_panel::customize_chrome::mojom::InspirationGroupPtr& input) {
    return input->inspirations;
  }

  static bool Read(::side_panel::customize_chrome::mojom::InspirationGroup::DataView input, ::side_panel::customize_chrome::mojom::InspirationGroupPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::WallpaperSearchResult::DataView,
                                         ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::WallpaperSearchResult::id)& id(
      const ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::customize_chrome::mojom::WallpaperSearchResult::image)& image(
      const ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr& input) {
    return input->image;
  }

  static const decltype(::side_panel::customize_chrome::mojom::WallpaperSearchResult::descriptors)& descriptors(
      const ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr& input) {
    return input->descriptors;
  }

  static bool Read(::side_panel::customize_chrome::mojom::WallpaperSearchResult::DataView input, ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr* output);
};


template <>
struct  StructTraits<::side_panel::customize_chrome::mojom::ResultDescriptors::DataView,
                                         ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::ResultDescriptorsPtr* output) { output->reset(); }

  static const decltype(::side_panel::customize_chrome::mojom::ResultDescriptors::subject)& subject(
      const ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr& input) {
    return input->subject;
  }

  static const decltype(::side_panel::customize_chrome::mojom::ResultDescriptors::style)& style(
      const ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr& input) {
    return input->style;
  }

  static const decltype(::side_panel::customize_chrome::mojom::ResultDescriptors::mood)& mood(
      const ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr& input) {
    return input->mood;
  }

  static const decltype(::side_panel::customize_chrome::mojom::ResultDescriptors::color)& color(
      const ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr& input) {
    return input->color;
  }

  static bool Read(::side_panel::customize_chrome::mojom::ResultDescriptors::DataView input, ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr* output);
};


template <>
struct  UnionTraits<::side_panel::customize_chrome::mojom::DescriptorDValue::DataView,
                                        ::side_panel::customize_chrome::mojom::DescriptorDValuePtr> {
  static bool IsNull(const ::side_panel::customize_chrome::mojom::DescriptorDValuePtr& input) { return !input; }
  static void SetToNull(::side_panel::customize_chrome::mojom::DescriptorDValuePtr* output) { output->reset(); }

  static ::side_panel::customize_chrome::mojom::DescriptorDValue::Tag GetTag(const ::side_panel::customize_chrome::mojom::DescriptorDValuePtr& input) {
    return input->which();
  }

  static const ::SkColor& color(const ::side_panel::customize_chrome::mojom::DescriptorDValuePtr& input) {
    return input->get_color();
  }

  static  float hue(const ::side_panel::customize_chrome::mojom::DescriptorDValuePtr& input) {
    return input->get_hue();
  }

  static  ::side_panel::customize_chrome::mojom::DescriptorDName name(const ::side_panel::customize_chrome::mojom::DescriptorDValuePtr& input) {
    return input->get_name();
  }

  static bool Read(::side_panel::customize_chrome::mojom::DescriptorDValue::DataView input, ::side_panel::customize_chrome::mojom::DescriptorDValuePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_WALLPAPER_SEARCH_WALLPAPER_SEARCH_MOJOM_H_