// chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_WALLPAPER_SEARCH_WALLPAPER_SEARCH_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_WALLPAPER_SEARCH_WALLPAPER_SEARCH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace side_panel::customize_chrome::mojom {
class KeyLabelDataView;

class GroupDataView;

class DescriptorBDataView;

class DescriptorsDataView;

class InspirationDataView;

class InspirationDescriptorsDataView;

class InspirationGroupDataView;

class WallpaperSearchResultDataView;

class ResultDescriptorsDataView;

class DescriptorDValueDataView;


}  // side_panel::customize_chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::KeyLabelDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::KeyLabel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::GroupDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::Group_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::DescriptorBDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::DescriptorB_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::DescriptorsDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::Descriptors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::InspirationDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::Inspiration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::InspirationDescriptorsDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::InspirationDescriptors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::InspirationGroupDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::InspirationGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::WallpaperSearchResultDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::WallpaperSearchResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::ResultDescriptorsDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::ResultDescriptors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::DescriptorDValueDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::DescriptorDValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace side_panel::customize_chrome::mojom {


enum class DescriptorDName : int32_t {
  
  kYellow = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, DescriptorDName value);
inline bool IsKnownEnumValue(DescriptorDName value) {
  return internal::DescriptorDName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WallpaperSearchStatus : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kRequestThrottled = 2,
  
  kOffline = 3,
  
  kSignedOut = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, WallpaperSearchStatus value);
inline bool IsKnownEnumValue(WallpaperSearchStatus value) {
  return internal::WallpaperSearchStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UserFeedback : int32_t {
  
  kUnspecified = 0,
  
  kThumbsUp = 1,
  
  kThumbsDown = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UserFeedback value);
inline bool IsKnownEnumValue(UserFeedback value) {
  return internal::UserFeedback_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WallpaperSearchHandlerFactoryInterfaceBase {};

using WallpaperSearchHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<WallpaperSearchHandlerFactoryInterfaceBase>;
using WallpaperSearchHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<WallpaperSearchHandlerFactoryInterfaceBase>;
using WallpaperSearchHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WallpaperSearchHandlerFactoryInterfaceBase>;
using WallpaperSearchHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WallpaperSearchHandlerFactoryInterfaceBase>;
class WallpaperSearchHandlerInterfaceBase {};

using WallpaperSearchHandlerPtrDataView =
    mojo::InterfacePtrDataView<WallpaperSearchHandlerInterfaceBase>;
using WallpaperSearchHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WallpaperSearchHandlerInterfaceBase>;
using WallpaperSearchHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WallpaperSearchHandlerInterfaceBase>;
using WallpaperSearchHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WallpaperSearchHandlerInterfaceBase>;
class WallpaperSearchClientInterfaceBase {};

using WallpaperSearchClientPtrDataView =
    mojo::InterfacePtrDataView<WallpaperSearchClientInterfaceBase>;
using WallpaperSearchClientRequestDataView =
    mojo::InterfaceRequestDataView<WallpaperSearchClientInterfaceBase>;
using WallpaperSearchClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WallpaperSearchClientInterfaceBase>;
using WallpaperSearchClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WallpaperSearchClientInterfaceBase>;


class KeyLabelDataView {
 public:
  KeyLabelDataView() = default;

  KeyLabelDataView(
      internal::KeyLabel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::KeyLabel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GroupDataView {
 public:
  GroupDataView() = default;

  GroupDataView(
      internal::Group_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCategoryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCategory(UserType* output) {
    
    auto* pointer = data_->category.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptorAsDataView(
      mojo::ArrayDataView<KeyLabelDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptorAs(UserType* output) {
    
    auto* pointer = data_->descriptor_as.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::KeyLabelDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Group_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DescriptorBDataView {
 public:
  DescriptorBDataView() = default;

  DescriptorBDataView(
      internal::DescriptorB_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImagePathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImagePath(UserType* output) {
    
    auto* pointer = data_->image_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DescriptorB_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DescriptorsDataView {
 public:
  DescriptorsDataView() = default;

  DescriptorsDataView(
      internal::Descriptors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupsDataView(
      mojo::ArrayDataView<GroupDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroups(UserType* output) {
    
    auto* pointer = data_->groups.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::GroupDataView>>(
        pointer, output, message_);
  }
  inline void GetDescriptorBDataView(
      mojo::ArrayDataView<DescriptorBDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptorB(UserType* output) {
    
    auto* pointer = data_->descriptor_b.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::DescriptorBDataView>>(
        pointer, output, message_);
  }
  inline void GetDescriptorCDataView(
      mojo::ArrayDataView<KeyLabelDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptorC(UserType* output) {
    
    auto* pointer = data_->descriptor_c.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::KeyLabelDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Descriptors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InspirationDataView {
 public:
  InspirationDataView() = default;

  InspirationDataView(
      internal::Inspiration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundUrl(UserType* output) {
    
    auto* pointer = data_->background_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetThumbnailUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThumbnailUrl(UserType* output) {
    
    auto* pointer = data_->thumbnail_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Inspiration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InspirationDescriptorsDataView {
 public:
  InspirationDescriptorsDataView() = default;

  InspirationDescriptorsDataView(
      internal::InspirationDescriptors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubjectDataView(
      KeyLabelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubject(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::customize_chrome::mojom::KeyLabelDataView, UserType>(),
    "Attempting to read the optional `subject` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubject` instead "
    "of `ReadSubject if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subject.Get();
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::KeyLabelDataView>(
        pointer, output, message_);
  }
  inline void GetStyleDataView(
      KeyLabelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStyle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::customize_chrome::mojom::KeyLabelDataView, UserType>(),
    "Attempting to read the optional `style` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStyle` instead "
    "of `ReadStyle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->style.Get();
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::KeyLabelDataView>(
        pointer, output, message_);
  }
  inline void GetMoodDataView(
      KeyLabelDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMood(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::customize_chrome::mojom::KeyLabelDataView, UserType>(),
    "Attempting to read the optional `mood` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMood` instead "
    "of `ReadMood if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mood.Get();
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::KeyLabelDataView>(
        pointer, output, message_);
  }
  inline void GetColorDataView(
      DescriptorDValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::customize_chrome::mojom::DescriptorDValueDataView, UserType>(),
    "Attempting to read the optional `color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColor` instead "
    "of `ReadColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->color.is_null() ? &data_->color : nullptr;
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::DescriptorDValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::InspirationDescriptors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InspirationGroupDataView {
 public:
  InspirationGroupDataView() = default;

  InspirationGroupDataView(
      internal::InspirationGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDescriptorsDataView(
      InspirationDescriptorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptors(UserType* output) {
    
    auto* pointer = data_->descriptors.Get();
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::InspirationDescriptorsDataView>(
        pointer, output, message_);
  }
  inline void GetInspirationsDataView(
      mojo::ArrayDataView<InspirationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInspirations(UserType* output) {
    
    auto* pointer = data_->inspirations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::InspirationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::InspirationGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WallpaperSearchResultDataView {
 public:
  WallpaperSearchResultDataView() = default;

  WallpaperSearchResultDataView(
      internal::WallpaperSearchResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetImageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptorsDataView(
      ResultDescriptorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::customize_chrome::mojom::ResultDescriptorsDataView, UserType>(),
    "Attempting to read the optional `descriptors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescriptors` instead "
    "of `ReadDescriptors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->descriptors.Get();
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::ResultDescriptorsDataView>(
        pointer, output, message_);
  }
 private:
  internal::WallpaperSearchResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResultDescriptorsDataView {
 public:
  ResultDescriptorsDataView() = default;

  ResultDescriptorsDataView(
      internal::ResultDescriptors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubjectDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubject(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `subject` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubject` instead "
    "of `ReadSubject if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subject.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStyleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStyle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `style` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStyle` instead "
    "of `ReadStyle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->style.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMoodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMood(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `mood` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMood` instead "
    "of `ReadMood if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mood.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetColorDataView(
      DescriptorDValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::customize_chrome::mojom::DescriptorDValueDataView, UserType>(),
    "Attempting to read the optional `color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColor` instead "
    "of `ReadColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->color.is_null() ? &data_->color : nullptr;
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::DescriptorDValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResultDescriptors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DescriptorDValueDataView {
 public:
  using Tag = internal::DescriptorDValue_Data::DescriptorDValue_Tag;

  DescriptorDValueDataView() = default;

  DescriptorDValueDataView(
      internal::DescriptorDValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_color() const { return data_->tag == Tag::kColor; }
  inline void GetColorDataView(
      ::skia::mojom::SkColorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    
    CHECK(is_color());
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        data_->data.f_color.Get(), output, message_);
  }
  bool is_hue() const { return data_->tag == Tag::kHue; }
  float hue() const {
    CHECK(is_hue());
    return data_->data.f_hue;
  }
  bool is_name() const { return data_->tag == Tag::kName; }
  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) const {
    CHECK(is_name());
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::DescriptorDName>(
        data_->data.f_name, output);
  }
  DescriptorDName name() const {
    CHECK(is_name());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::customize_chrome::mojom::DescriptorDName>(data_->data.f_name));
  }

 private:
  internal::DescriptorDValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // side_panel::customize_chrome::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_WALLPAPER_SEARCH_WALLPAPER_SEARCH_MOJOM_DATA_VIEW_H_