// chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-data-view.h"




namespace std {

template <>
struct hash<::side_panel::customize_chrome::mojom::ActionId>
    : public mojo::internal::EnumHashImpl<::side_panel::customize_chrome::mojom::ActionId> {};

template <>
struct hash<::side_panel::customize_chrome::mojom::CategoryId>
    : public mojo::internal::EnumHashImpl<::side_panel::customize_chrome::mojom::CategoryId> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::customize_chrome::mojom::ActionId, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::customize_chrome::mojom::ActionId, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::customize_chrome::mojom::ActionId>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::customize_chrome::mojom::CategoryId, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::customize_chrome::mojom::CategoryId, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::customize_chrome::mojom::CategoryId>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::customize_chrome::mojom::ActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::customize_chrome::mojom::ActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::customize_chrome::mojom::internal::Action_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::side_panel::customize_chrome::mojom::ActionId>(
      Traits::id(input),
      &fragment->id);

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in Action struct");

    fragment->pinned = Traits::pinned(input);

    fragment->has_enterprise_controlled_pinned_state = Traits::has_enterprise_controlled_pinned_state(input);

    
    mojo::internal::Serialize<::side_panel::customize_chrome::mojom::CategoryId>(
      Traits::category(input),
      &fragment->category);

    decltype(Traits::icon_url(input)) in_icon_url = Traits::icon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_url)::BaseType> icon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_icon_url,
      icon_url_fragment);

    fragment->icon_url.Set(
        icon_url_fragment.is_null() ? nullptr : icon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_url in Action struct");
  }

  static bool Deserialize(::side_panel::customize_chrome::mojom::internal::Action_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::customize_chrome::mojom::ActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::customize_chrome::mojom::CategoryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::customize_chrome::mojom::CategoryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::customize_chrome::mojom::internal::Category_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::side_panel::customize_chrome::mojom::CategoryId>(
      Traits::id(input),
      &fragment->id);

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in Category struct");
  }

  static bool Deserialize(::side_panel::customize_chrome::mojom::internal::Category_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::customize_chrome::mojom::CategoryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace side_panel::customize_chrome::mojom {

inline void ActionDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ActionDataView::GetIconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void CategoryDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // side_panel::customize_chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::customize_chrome::mojom::ActionId> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::ActionId value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::customize_chrome::mojom::CategoryId> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::CategoryId value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_SHARED_H_