// chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace side_panel::customize_chrome::mojom {
class ActionDataView;

class CategoryDataView;



}  // side_panel::customize_chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::ActionDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::Action_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::customize_chrome::mojom::CategoryDataView> {
  using Data = ::side_panel::customize_chrome::mojom::internal::Category_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace side_panel::customize_chrome::mojom {


enum class ActionId : int32_t {
  
  kShowBookmarks = 0,
  
  kShowHistoryCluster = 1,
  
  kShowReadAnything = 2,
  
  kShowReadingList = 3,
  
  kShowLensOverlay = 4,
  
  kShowSearchCompanion = 5,
  
  kHome = 6,
  
  kForward = 7,
  
  kNewIncognitoWindow = 8,
  
  kShowPasswordManager = 9,
  
  kShowPaymentMethods = 10,
  
  kShowAddresses = 11,
  
  kShowDownloads = 12,
  
  kClearBrowsingData = 13,
  
  kPrint = 14,
  
  kShowTranslate = 15,
  
  kSendTabToSelf = 16,
  
  kQrCodeGenerator = 17,
  
  kRouteMedia = 18,
  
  kTaskManager = 19,
  
  kDevTools = 20,
  
  kShowChromeLabs = 21,
  
  kCopyLink = 22,
  
  kTabSearch = 23,
  
  kSplitTab = 24,
  
  kContextualTasks = 25,
  kMinValue = 0,
  kMaxValue = 25,
};

 std::ostream& operator<<(std::ostream& os, ActionId value);
inline bool IsKnownEnumValue(ActionId value) {
  return internal::ActionId_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CategoryId : int32_t {
  
  kNavigation = 0,
  
  kYourChrome = 1,
  
  kTools = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CategoryId value);
inline bool IsKnownEnumValue(CategoryId value) {
  return internal::CategoryId_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CustomizeToolbarHandlerFactoryInterfaceBase {};

using CustomizeToolbarHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<CustomizeToolbarHandlerFactoryInterfaceBase>;
using CustomizeToolbarHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CustomizeToolbarHandlerFactoryInterfaceBase>;
using CustomizeToolbarHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomizeToolbarHandlerFactoryInterfaceBase>;
using CustomizeToolbarHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomizeToolbarHandlerFactoryInterfaceBase>;
class CustomizeToolbarHandlerInterfaceBase {};

using CustomizeToolbarHandlerPtrDataView =
    mojo::InterfacePtrDataView<CustomizeToolbarHandlerInterfaceBase>;
using CustomizeToolbarHandlerRequestDataView =
    mojo::InterfaceRequestDataView<CustomizeToolbarHandlerInterfaceBase>;
using CustomizeToolbarHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomizeToolbarHandlerInterfaceBase>;
using CustomizeToolbarHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomizeToolbarHandlerInterfaceBase>;
class CustomizeToolbarClientInterfaceBase {};

using CustomizeToolbarClientPtrDataView =
    mojo::InterfacePtrDataView<CustomizeToolbarClientInterfaceBase>;
using CustomizeToolbarClientRequestDataView =
    mojo::InterfaceRequestDataView<CustomizeToolbarClientInterfaceBase>;
using CustomizeToolbarClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomizeToolbarClientInterfaceBase>;
using CustomizeToolbarClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomizeToolbarClientInterfaceBase>;


class ActionDataView {
 public:
  ActionDataView() = default;

  ActionDataView(
      internal::Action_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) const {
    auto data_value = data_->id;
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::ActionId>(
        data_value, output);
  }
  ActionId id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::side_panel::customize_chrome::mojom::ActionId>(data_->id));
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool pinned() const {
    return data_->pinned;
  }
  bool has_enterprise_controlled_pinned_state() const {
    return data_->has_enterprise_controlled_pinned_state;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCategory(UserType* output) const {
    auto data_value = data_->category;
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::CategoryId>(
        data_value, output);
  }
  CategoryId category() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::side_panel::customize_chrome::mojom::CategoryId>(data_->category));
  }
  inline void GetIconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Action_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CategoryDataView {
 public:
  CategoryDataView() = default;

  CategoryDataView(
      internal::Category_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) const {
    auto data_value = data_->id;
    return mojo::internal::Deserialize<::side_panel::customize_chrome::mojom::CategoryId>(
        data_value, output);
  }
  CategoryId id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::side_panel::customize_chrome::mojom::CategoryId>(data_->id));
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Category_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // side_panel::customize_chrome::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_TOOLBAR_CUSTOMIZE_TOOLBAR_MOJOM_DATA_VIEW_H_