// chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-forward.h"  // IWYU pragma: export
#include "components/ntp_tiles/tile_type.mojom-forward.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome_mojom_traits.h"




namespace side_panel::mojom {

class CustomizeChromePageHandlerFactoryProxy;

template <typename ImplRefTraits>
class CustomizeChromePageHandlerFactoryStub;

class CustomizeChromePageHandlerFactoryRequestValidator;


class CustomizeChromePageHandlerFactory
    : public CustomizeChromePageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.mojom.CustomizeChromePageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeChromePageHandlerFactoryInterfaceBase;
  using Proxy_ = CustomizeChromePageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeChromePageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeChromePageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeChromePageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<CustomizeChromePage> page, ::mojo::PendingReceiver<CustomizeChromePageHandler> handler) = 0;
};

class CustomizeChromePageHandlerProxy;

template <typename ImplRefTraits>
class CustomizeChromePageHandlerStub;

class CustomizeChromePageHandlerRequestValidator;
class CustomizeChromePageHandlerResponseValidator;


class CustomizeChromePageHandler
    : public CustomizeChromePageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.mojom.CustomizeChromePageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeChromePageHandlerInterfaceBase;
  using Proxy_ = CustomizeChromePageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeChromePageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeChromePageHandlerRequestValidator;
  using ResponseValidator_ = CustomizeChromePageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetMostVisitedSettingsMinVersion = 0,
    kUpdateMostVisitedSettingsMinVersion = 0,
    kGetBackgroundCollectionsMinVersion = 0,
    kGetReplacementCollectionPreviewImageMinVersion = 0,
    kGetBackgroundImagesMinVersion = 0,
    kUpdateModulesSettingsMinVersion = 0,
    kUpdateThemeMinVersion = 0,
    kUpdateThemeEditableMinVersion = 0,
    kSetDefaultColorMinVersion = 0,
    kSetFollowDeviceThemeMinVersion = 0,
    kRemoveBackgroundImageMinVersion = 0,
    kChooseLocalCustomBackgroundMinVersion = 0,
    kSetBackgroundImageMinVersion = 0,
    kSetDailyRefreshCollectionIdMinVersion = 0,
    kOpenChromeWebStoreMinVersion = 0,
    kOpenChromeWebStoreHomePageMinVersion = 0,
    kOpenThirdPartyThemePageMinVersion = 0,
    kOpenChromeWebStoreCategoryPageMinVersion = 0,
    kOpenChromeWebStoreCollectionPageMinVersion = 0,
    kOpenNtpManagedByPageMinVersion = 0,
    kSetModulesVisibleMinVersion = 0,
    kSetModuleDisabledMinVersion = 0,
    kSetToolChipsVisibleMinVersion = 0,
    kUpdateToolChipsSettingsMinVersion = 0,
    kUpdateScrollToSectionMinVersion = 0,
    kUpdateAttachedTabStateMinVersion = 0,
    kUpdateNtpManagedByNameMinVersion = 0,
    kSetFooterVisibleMinVersion = 0,
    kUpdateFooterSettingsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetMostVisitedSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateMostVisitedSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBackgroundCollections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetReplacementCollectionPreviewImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBackgroundImages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateModulesSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateThemeEditable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDefaultColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFollowDeviceTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveBackgroundImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ChooseLocalCustomBackground_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDailyRefreshCollectionId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChromeWebStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChromeWebStoreHomePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenThirdPartyThemePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChromeWebStoreCategoryPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChromeWebStoreCollectionPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenNtpManagedByPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetModulesVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetModuleDisabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetToolChipsVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateToolChipsSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateScrollToSection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateAttachedTabState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateNtpManagedByName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFooterVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateFooterSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeChromePageHandler() = default;

  virtual void SetMostVisitedSettings(const std::vector<::ntp_tiles::mojom::TileType>& shortcuts_types, bool shortcuts_visible, bool personal_shortcuts_visible) = 0;

  virtual void UpdateMostVisitedSettings() = 0;

  using GetBackgroundCollectionsCallback = base::OnceCallback<void(std::vector<BackgroundCollectionPtr>)>;
  using GetBackgroundCollectionsMojoCallback = base::OnceCallback<void(std::vector<BackgroundCollectionPtr>)>;

  virtual void GetBackgroundCollections(GetBackgroundCollectionsCallback callback) = 0;

  using GetReplacementCollectionPreviewImageCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;
  using GetReplacementCollectionPreviewImageMojoCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;

  virtual void GetReplacementCollectionPreviewImage(const std::string& collection_id, GetReplacementCollectionPreviewImageCallback callback) = 0;

  using GetBackgroundImagesCallback = base::OnceCallback<void(std::vector<CollectionImagePtr>)>;
  using GetBackgroundImagesMojoCallback = base::OnceCallback<void(std::vector<CollectionImagePtr>)>;

  virtual void GetBackgroundImages(const std::string& collection_id, GetBackgroundImagesCallback callback) = 0;

  virtual void UpdateModulesSettings() = 0;

  virtual void UpdateTheme() = 0;

  virtual void UpdateThemeEditable(bool is_theme_editable) = 0;

  virtual void SetDefaultColor() = 0;

  virtual void SetFollowDeviceTheme(bool follow) = 0;

  virtual void RemoveBackgroundImage() = 0;

  using ChooseLocalCustomBackgroundCallback = base::OnceCallback<void(bool)>;
  using ChooseLocalCustomBackgroundMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ChooseLocalCustomBackground(ChooseLocalCustomBackgroundCallback callback) = 0;

  virtual void SetBackgroundImage(const std::string& attribution_1, const std::string& attribution_2, const ::GURL& attribution_url, const ::GURL& image_url, const ::GURL& thumbnail_url, const std::string& collection_id) = 0;

  virtual void SetDailyRefreshCollectionId(const std::string& collection_id) = 0;

  virtual void OpenChromeWebStore() = 0;

  virtual void OpenChromeWebStoreHomePage() = 0;

  virtual void OpenThirdPartyThemePage(const std::string& theme_id) = 0;

  virtual void OpenChromeWebStoreCategoryPage(ChromeWebStoreCategory category) = 0;

  virtual void OpenChromeWebStoreCollectionPage(ChromeWebStoreCollection collection) = 0;

  virtual void OpenNtpManagedByPage() = 0;

  virtual void SetModulesVisible(bool visible) = 0;

  virtual void SetModuleDisabled(const std::string& module_id, bool disabled) = 0;

  virtual void SetToolChipsVisible(bool visible) = 0;

  virtual void UpdateToolChipsSettings() = 0;

  virtual void UpdateScrollToSection() = 0;

  virtual void UpdateAttachedTabState() = 0;

  virtual void UpdateNtpManagedByName() = 0;

  virtual void SetFooterVisible(bool visible) = 0;

  virtual void UpdateFooterSettings() = 0;
};

class CustomizeChromePageProxy;

template <typename ImplRefTraits>
class CustomizeChromePageStub;

class CustomizeChromePageRequestValidator;


class CustomizeChromePage
    : public CustomizeChromePageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.mojom.CustomizeChromePage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeChromePageInterfaceBase;
  using Proxy_ = CustomizeChromePageProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeChromePageStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeChromePageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetModulesSettingsMinVersion = 0,
    kSetMostVisitedSettingsMinVersion = 0,
    kSetToolsSettingsMinVersion = 0,
    kSetFooterSettingsMinVersion = 0,
    kSetThemeMinVersion = 0,
    kSetThemeEditableMinVersion = 0,
    kScrollToSectionMinVersion = 0,
    kAttachedTabStateUpdatedMinVersion = 0,
    kNtpManagedByNameUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetModulesSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMostVisitedSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetToolsSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFooterSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetThemeEditable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrollToSection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AttachedTabStateUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NtpManagedByNameUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeChromePage() = default;

  virtual void SetModulesSettings(std::vector<ModuleSettingsPtr> modules_settings, bool managed, bool visible) = 0;

  virtual void SetMostVisitedSettings(const std::vector<::ntp_tiles::mojom::TileType>& shortcuts_types, bool visible, bool personal_shortcuts_visible, const std::vector<::ntp_tiles::mojom::TileType>& disabled_shortcuts) = 0;

  virtual void SetToolsSettings(bool visible) = 0;

  virtual void SetFooterSettings(bool visible, bool extension_policy_enabled, ManagementNoticeStatePtr management_notice_state) = 0;

  virtual void SetTheme(ThemePtr theme) = 0;

  virtual void SetThemeEditable(bool is_theme_editable) = 0;

  virtual void ScrollToSection(::CustomizeChromeSection section) = 0;

  virtual void AttachedTabStateUpdated(NewTabPageType ntp_type) = 0;

  virtual void NtpManagedByNameUpdated(const std::string& name, const std::string& description) = 0;
};



class  CustomizeChromePageHandlerFactoryProxy
    : public CustomizeChromePageHandlerFactory {
 public:
  using InterfaceType = CustomizeChromePageHandlerFactory;

  explicit CustomizeChromePageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<CustomizeChromePage> page, ::mojo::PendingReceiver<CustomizeChromePageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomizeChromePageHandlerProxy
    : public CustomizeChromePageHandler {
 public:
  using InterfaceType = CustomizeChromePageHandler;

  explicit CustomizeChromePageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetMostVisitedSettings(const std::vector<::ntp_tiles::mojom::TileType>& shortcuts_types, bool shortcuts_visible, bool personal_shortcuts_visible) final;
  
  void UpdateMostVisitedSettings() final;
  
  void GetBackgroundCollections(GetBackgroundCollectionsCallback callback) final;
  
  void GetReplacementCollectionPreviewImage(const std::string& collection_id, GetReplacementCollectionPreviewImageCallback callback) final;
  
  void GetBackgroundImages(const std::string& collection_id, GetBackgroundImagesCallback callback) final;
  
  void UpdateModulesSettings() final;
  
  void UpdateTheme() final;
  
  void UpdateThemeEditable(bool is_theme_editable) final;
  
  void SetDefaultColor() final;
  
  void SetFollowDeviceTheme(bool follow) final;
  
  void RemoveBackgroundImage() final;
  
  void ChooseLocalCustomBackground(ChooseLocalCustomBackgroundCallback callback) final;
  
  void SetBackgroundImage(const std::string& attribution_1, const std::string& attribution_2, const ::GURL& attribution_url, const ::GURL& image_url, const ::GURL& thumbnail_url, const std::string& collection_id) final;
  
  void SetDailyRefreshCollectionId(const std::string& collection_id) final;
  
  void OpenChromeWebStore() final;
  
  void OpenChromeWebStoreHomePage() final;
  
  void OpenThirdPartyThemePage(const std::string& theme_id) final;
  
  void OpenChromeWebStoreCategoryPage(ChromeWebStoreCategory category) final;
  
  void OpenChromeWebStoreCollectionPage(ChromeWebStoreCollection collection) final;
  
  void OpenNtpManagedByPage() final;
  
  void SetModulesVisible(bool visible) final;
  
  void SetModuleDisabled(const std::string& module_id, bool disabled) final;
  
  void SetToolChipsVisible(bool visible) final;
  
  void UpdateToolChipsSettings() final;
  
  void UpdateScrollToSection() final;
  
  void UpdateAttachedTabState() final;
  
  void UpdateNtpManagedByName() final;
  
  void SetFooterVisible(bool visible) final;
  
  void UpdateFooterSettings() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomizeChromePageProxy
    : public CustomizeChromePage {
 public:
  using InterfaceType = CustomizeChromePage;

  explicit CustomizeChromePageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetModulesSettings(std::vector<ModuleSettingsPtr> modules_settings, bool managed, bool visible) final;
  
  void SetMostVisitedSettings(const std::vector<::ntp_tiles::mojom::TileType>& shortcuts_types, bool visible, bool personal_shortcuts_visible, const std::vector<::ntp_tiles::mojom::TileType>& disabled_shortcuts) final;
  
  void SetToolsSettings(bool visible) final;
  
  void SetFooterSettings(bool visible, bool extension_policy_enabled, ManagementNoticeStatePtr management_notice_state) final;
  
  void SetTheme(ThemePtr theme) final;
  
  void SetThemeEditable(bool is_theme_editable) final;
  
  void ScrollToSection(::CustomizeChromeSection section) final;
  
  void AttachedTabStateUpdated(NewTabPageType ntp_type) final;
  
  void NtpManagedByNameUpdated(const std::string& name, const std::string& description) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CustomizeChromePageHandlerFactoryStubDispatch {
 public:
  static bool Accept(CustomizeChromePageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeChromePageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeChromePageHandlerFactory>>
class CustomizeChromePageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeChromePageHandlerFactoryStub() = default;
  ~CustomizeChromePageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeChromePageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeChromePageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeChromePageHandlerStubDispatch {
 public:
  static bool Accept(CustomizeChromePageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeChromePageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeChromePageHandler>>
class CustomizeChromePageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeChromePageHandlerStub() = default;
  ~CustomizeChromePageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeChromePageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeChromePageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeChromePageStubDispatch {
 public:
  static bool Accept(CustomizeChromePage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeChromePage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeChromePage>>
class CustomizeChromePageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeChromePageStub() = default;
  ~CustomizeChromePageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeChromePageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeChromePageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeChromePageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeChromePageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeChromePageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeChromePageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  ThirdPartyThemeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ThirdPartyThemeInfo, T>::value>;
  using DataView = ThirdPartyThemeInfoDataView;
  using Data_ = internal::ThirdPartyThemeInfo_Data;

  template <typename... Args>
  static ThirdPartyThemeInfoPtr New(Args&&... args) {
    return ThirdPartyThemeInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ThirdPartyThemeInfoPtr From(const U& u) {
    return mojo::TypeConverter<ThirdPartyThemeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ThirdPartyThemeInfo>::Convert(*this);
  }


  ThirdPartyThemeInfo();

  ThirdPartyThemeInfo(
      const std::string& id,
      const std::string& name);


  ~ThirdPartyThemeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ThirdPartyThemeInfoPtr>
  ThirdPartyThemeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ThirdPartyThemeInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ThirdPartyThemeInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ThirdPartyThemeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ThirdPartyThemeInfo_UnserializedMessageContext<
            UserType, ThirdPartyThemeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ThirdPartyThemeInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ThirdPartyThemeInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ThirdPartyThemeInfo_UnserializedMessageContext<
            UserType, ThirdPartyThemeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ThirdPartyThemeInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  ManagementNoticeState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManagementNoticeState, T>::value>;
  using DataView = ManagementNoticeStateDataView;
  using Data_ = internal::ManagementNoticeState_Data;

  template <typename... Args>
  static ManagementNoticeStatePtr New(Args&&... args) {
    return ManagementNoticeStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManagementNoticeStatePtr From(const U& u) {
    return mojo::TypeConverter<ManagementNoticeStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManagementNoticeState>::Convert(*this);
  }


  ManagementNoticeState();

  ManagementNoticeState(
      bool can_be_shown,
      bool enabled_by_policy);


  ~ManagementNoticeState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManagementNoticeStatePtr>
  ManagementNoticeStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManagementNoticeState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManagementNoticeState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManagementNoticeState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManagementNoticeState_UnserializedMessageContext<
            UserType, ManagementNoticeState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManagementNoticeState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManagementNoticeState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManagementNoticeState_UnserializedMessageContext<
            UserType, ManagementNoticeState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManagementNoticeState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool can_be_shown;
  
  bool enabled_by_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManagementNoticeState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  BackgroundImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundImage, T>::value>;
  using DataView = BackgroundImageDataView;
  using Data_ = internal::BackgroundImage_Data;

  template <typename... Args>
  static BackgroundImagePtr New(Args&&... args) {
    return BackgroundImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundImagePtr From(const U& u) {
    return mojo::TypeConverter<BackgroundImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundImage>::Convert(*this);
  }


  BackgroundImage();

  BackgroundImage(
      const ::GURL& url,
      const ::GURL& snapshot_url,
      bool is_uploaded_image,
      const std::optional<::base::Token>& local_background_id,
      const std::string& title,
      const std::string& collection_id,
      bool daily_refresh_enabled);


  ~BackgroundImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundImagePtr>
  BackgroundImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundImage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundImage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundImage_UnserializedMessageContext<
            UserType, BackgroundImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundImage_UnserializedMessageContext<
            UserType, BackgroundImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::GURL snapshot_url;
  
  bool is_uploaded_image;
  
  std::optional<::base::Token> local_background_id;
  
  std::string title;
  
  std::string collection_id;
  
  bool daily_refresh_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Theme {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Theme, T>::value>;
  using DataView = ThemeDataView;
  using Data_ = internal::Theme_Data;

  template <typename... Args>
  static ThemePtr New(Args&&... args) {
    return ThemePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ThemePtr From(const U& u) {
    return mojo::TypeConverter<ThemePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Theme>::Convert(*this);
  }


  Theme();

  Theme(
      BackgroundImagePtr background_image,
      ThirdPartyThemeInfoPtr third_party_theme_info,
      ::SkColor background_color,
      std::optional<::SkColor> foreground_color,
      bool background_managed_by_policy,
      bool follow_device_theme);

Theme(const Theme&) = delete;
Theme& operator=(const Theme&) = delete;

  ~Theme();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ThemePtr>
  ThemePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Theme::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Theme::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BackgroundImagePtr background_image;
  
  ThirdPartyThemeInfoPtr third_party_theme_info;
  
  ::SkColor background_color;
  
  std::optional<::SkColor> foreground_color;
  
  bool background_managed_by_policy;
  
  bool follow_device_theme;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BackgroundCollection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundCollection, T>::value>;
  using DataView = BackgroundCollectionDataView;
  using Data_ = internal::BackgroundCollection_Data;

  template <typename... Args>
  static BackgroundCollectionPtr New(Args&&... args) {
    return BackgroundCollectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundCollectionPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundCollectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundCollection>::Convert(*this);
  }


  BackgroundCollection();

  BackgroundCollection(
      const std::string& id,
      const std::string& label,
      const ::GURL& preview_image_url,
      bool image_verified);


  ~BackgroundCollection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundCollectionPtr>
  BackgroundCollectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundCollection::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundCollection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundCollection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundCollection_UnserializedMessageContext<
            UserType, BackgroundCollection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundCollection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundCollection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundCollection_UnserializedMessageContext<
            UserType, BackgroundCollection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundCollection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string label;
  
  ::GURL preview_image_url;
  
  bool image_verified;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundCollection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CollectionImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CollectionImage, T>::value>;
  using DataView = CollectionImageDataView;
  using Data_ = internal::CollectionImage_Data;

  template <typename... Args>
  static CollectionImagePtr New(Args&&... args) {
    return CollectionImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CollectionImagePtr From(const U& u) {
    return mojo::TypeConverter<CollectionImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CollectionImage>::Convert(*this);
  }


  CollectionImage();

  CollectionImage(
      const std::string& attribution_1,
      const std::string& attribution_2,
      const ::GURL& attribution_url,
      const ::GURL& image_url,
      const ::GURL& preview_image_url,
      const std::string& collection_id,
      bool image_verified);


  ~CollectionImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CollectionImagePtr>
  CollectionImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CollectionImage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CollectionImage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CollectionImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CollectionImage_UnserializedMessageContext<
            UserType, CollectionImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CollectionImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CollectionImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CollectionImage_UnserializedMessageContext<
            UserType, CollectionImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CollectionImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string attribution_1;
  
  std::string attribution_2;
  
  ::GURL attribution_url;
  
  ::GURL image_url;
  
  ::GURL preview_image_url;
  
  std::string collection_id;
  
  bool image_verified;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CollectionImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ModuleSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModuleSettings, T>::value>;
  using DataView = ModuleSettingsDataView;
  using Data_ = internal::ModuleSettings_Data;

  template <typename... Args>
  static ModuleSettingsPtr New(Args&&... args) {
    return ModuleSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModuleSettingsPtr From(const U& u) {
    return mojo::TypeConverter<ModuleSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModuleSettings>::Convert(*this);
  }


  ModuleSettings();

  ModuleSettings(
      const std::string& id,
      const std::string& name,
      const std::optional<std::string>& description,
      bool enabled,
      bool visible);


  ~ModuleSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModuleSettingsPtr>
  ModuleSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModuleSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModuleSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModuleSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModuleSettings_UnserializedMessageContext<
            UserType, ModuleSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModuleSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModuleSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModuleSettings_UnserializedMessageContext<
            UserType, ModuleSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModuleSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string name;
  
  std::optional<std::string> description;
  
  bool enabled;
  
  bool visible;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModuleSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
BackgroundImagePtr BackgroundImage::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(snapshot_url),
      mojo::Clone(is_uploaded_image),
      mojo::Clone(local_background_id),
      mojo::Clone(title),
      mojo::Clone(collection_id),
      mojo::Clone(daily_refresh_enabled)
  );
}

template <typename T, BackgroundImage::EnableIfSame<T>*>
bool BackgroundImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->snapshot_url, other_struct.snapshot_url))
    return false;
  if (!mojo::Equals(this->is_uploaded_image, other_struct.is_uploaded_image))
    return false;
  if (!mojo::Equals(this->local_background_id, other_struct.local_background_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->collection_id, other_struct.collection_id))
    return false;
  if (!mojo::Equals(this->daily_refresh_enabled, other_struct.daily_refresh_enabled))
    return false;
  return true;
}

template <typename T, BackgroundImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.snapshot_url < rhs.snapshot_url)
    return true;
  if (rhs.snapshot_url < lhs.snapshot_url)
    return false;
  if (lhs.is_uploaded_image < rhs.is_uploaded_image)
    return true;
  if (rhs.is_uploaded_image < lhs.is_uploaded_image)
    return false;
  if (lhs.local_background_id < rhs.local_background_id)
    return true;
  if (rhs.local_background_id < lhs.local_background_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.collection_id < rhs.collection_id)
    return true;
  if (rhs.collection_id < lhs.collection_id)
    return false;
  if (lhs.daily_refresh_enabled < rhs.daily_refresh_enabled)
    return true;
  if (rhs.daily_refresh_enabled < lhs.daily_refresh_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
ThirdPartyThemeInfoPtr ThirdPartyThemeInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name)
  );
}

template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>*>
bool ThirdPartyThemeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, ThirdPartyThemeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}
template <typename StructPtrType>
ThemePtr Theme::Clone() const {
  return New(
      mojo::Clone(background_image),
      mojo::Clone(third_party_theme_info),
      mojo::Clone(background_color),
      mojo::Clone(foreground_color),
      mojo::Clone(background_managed_by_policy),
      mojo::Clone(follow_device_theme)
  );
}

template <typename T, Theme::EnableIfSame<T>*>
bool Theme::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->background_image, other_struct.background_image))
    return false;
  if (!mojo::Equals(this->third_party_theme_info, other_struct.third_party_theme_info))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->foreground_color, other_struct.foreground_color))
    return false;
  if (!mojo::Equals(this->background_managed_by_policy, other_struct.background_managed_by_policy))
    return false;
  if (!mojo::Equals(this->follow_device_theme, other_struct.follow_device_theme))
    return false;
  return true;
}

template <typename T, Theme::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.background_image < rhs.background_image)
    return true;
  if (rhs.background_image < lhs.background_image)
    return false;
  if (lhs.third_party_theme_info < rhs.third_party_theme_info)
    return true;
  if (rhs.third_party_theme_info < lhs.third_party_theme_info)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.foreground_color < rhs.foreground_color)
    return true;
  if (rhs.foreground_color < lhs.foreground_color)
    return false;
  if (lhs.background_managed_by_policy < rhs.background_managed_by_policy)
    return true;
  if (rhs.background_managed_by_policy < lhs.background_managed_by_policy)
    return false;
  if (lhs.follow_device_theme < rhs.follow_device_theme)
    return true;
  if (rhs.follow_device_theme < lhs.follow_device_theme)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundCollectionPtr BackgroundCollection::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(label),
      mojo::Clone(preview_image_url),
      mojo::Clone(image_verified)
  );
}

template <typename T, BackgroundCollection::EnableIfSame<T>*>
bool BackgroundCollection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->preview_image_url, other_struct.preview_image_url))
    return false;
  if (!mojo::Equals(this->image_verified, other_struct.image_verified))
    return false;
  return true;
}

template <typename T, BackgroundCollection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.preview_image_url < rhs.preview_image_url)
    return true;
  if (rhs.preview_image_url < lhs.preview_image_url)
    return false;
  if (lhs.image_verified < rhs.image_verified)
    return true;
  if (rhs.image_verified < lhs.image_verified)
    return false;
  return false;
}
template <typename StructPtrType>
CollectionImagePtr CollectionImage::Clone() const {
  return New(
      mojo::Clone(attribution_1),
      mojo::Clone(attribution_2),
      mojo::Clone(attribution_url),
      mojo::Clone(image_url),
      mojo::Clone(preview_image_url),
      mojo::Clone(collection_id),
      mojo::Clone(image_verified)
  );
}

template <typename T, CollectionImage::EnableIfSame<T>*>
bool CollectionImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->attribution_1, other_struct.attribution_1))
    return false;
  if (!mojo::Equals(this->attribution_2, other_struct.attribution_2))
    return false;
  if (!mojo::Equals(this->attribution_url, other_struct.attribution_url))
    return false;
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->preview_image_url, other_struct.preview_image_url))
    return false;
  if (!mojo::Equals(this->collection_id, other_struct.collection_id))
    return false;
  if (!mojo::Equals(this->image_verified, other_struct.image_verified))
    return false;
  return true;
}

template <typename T, CollectionImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.attribution_1 < rhs.attribution_1)
    return true;
  if (rhs.attribution_1 < lhs.attribution_1)
    return false;
  if (lhs.attribution_2 < rhs.attribution_2)
    return true;
  if (rhs.attribution_2 < lhs.attribution_2)
    return false;
  if (lhs.attribution_url < rhs.attribution_url)
    return true;
  if (rhs.attribution_url < lhs.attribution_url)
    return false;
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.preview_image_url < rhs.preview_image_url)
    return true;
  if (rhs.preview_image_url < lhs.preview_image_url)
    return false;
  if (lhs.collection_id < rhs.collection_id)
    return true;
  if (rhs.collection_id < lhs.collection_id)
    return false;
  if (lhs.image_verified < rhs.image_verified)
    return true;
  if (rhs.image_verified < lhs.image_verified)
    return false;
  return false;
}
template <typename StructPtrType>
ModuleSettingsPtr ModuleSettings::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(description),
      mojo::Clone(enabled),
      mojo::Clone(visible)
  );
}

template <typename T, ModuleSettings::EnableIfSame<T>*>
bool ModuleSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->enabled, other_struct.enabled))
    return false;
  if (!mojo::Equals(this->visible, other_struct.visible))
    return false;
  return true;
}

template <typename T, ModuleSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.enabled < rhs.enabled)
    return true;
  if (rhs.enabled < lhs.enabled)
    return false;
  if (lhs.visible < rhs.visible)
    return true;
  if (rhs.visible < lhs.visible)
    return false;
  return false;
}
template <typename StructPtrType>
ManagementNoticeStatePtr ManagementNoticeState::Clone() const {
  return New(
      mojo::Clone(can_be_shown),
      mojo::Clone(enabled_by_policy)
  );
}

template <typename T, ManagementNoticeState::EnableIfSame<T>*>
bool ManagementNoticeState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_be_shown, other_struct.can_be_shown))
    return false;
  if (!mojo::Equals(this->enabled_by_policy, other_struct.enabled_by_policy))
    return false;
  return true;
}

template <typename T, ManagementNoticeState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.can_be_shown < rhs.can_be_shown)
    return true;
  if (rhs.can_be_shown < lhs.can_be_shown)
    return false;
  if (lhs.enabled_by_policy < rhs.enabled_by_policy)
    return true;
  if (rhs.enabled_by_policy < lhs.enabled_by_policy)
    return false;
  return false;
}


}  // side_panel::mojom

namespace mojo {


template <>
struct  StructTraits<::side_panel::mojom::BackgroundImage::DataView,
                                         ::side_panel::mojom::BackgroundImagePtr> {
  static bool IsNull(const ::side_panel::mojom::BackgroundImagePtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::BackgroundImagePtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::BackgroundImage::url)& url(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->url;
  }

  static const decltype(::side_panel::mojom::BackgroundImage::snapshot_url)& snapshot_url(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->snapshot_url;
  }

  static decltype(::side_panel::mojom::BackgroundImage::is_uploaded_image) is_uploaded_image(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->is_uploaded_image;
  }

  static const decltype(::side_panel::mojom::BackgroundImage::local_background_id)& local_background_id(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->local_background_id;
  }

  static const decltype(::side_panel::mojom::BackgroundImage::title)& title(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->title;
  }

  static const decltype(::side_panel::mojom::BackgroundImage::collection_id)& collection_id(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->collection_id;
  }

  static decltype(::side_panel::mojom::BackgroundImage::daily_refresh_enabled) daily_refresh_enabled(
      const ::side_panel::mojom::BackgroundImagePtr& input) {
    return input->daily_refresh_enabled;
  }

  static bool Read(::side_panel::mojom::BackgroundImage::DataView input, ::side_panel::mojom::BackgroundImagePtr* output);
};


template <>
struct  StructTraits<::side_panel::mojom::ThirdPartyThemeInfo::DataView,
                                         ::side_panel::mojom::ThirdPartyThemeInfoPtr> {
  static bool IsNull(const ::side_panel::mojom::ThirdPartyThemeInfoPtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::ThirdPartyThemeInfoPtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::ThirdPartyThemeInfo::id)& id(
      const ::side_panel::mojom::ThirdPartyThemeInfoPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::mojom::ThirdPartyThemeInfo::name)& name(
      const ::side_panel::mojom::ThirdPartyThemeInfoPtr& input) {
    return input->name;
  }

  static bool Read(::side_panel::mojom::ThirdPartyThemeInfo::DataView input, ::side_panel::mojom::ThirdPartyThemeInfoPtr* output);
};


template <>
struct  StructTraits<::side_panel::mojom::Theme::DataView,
                                         ::side_panel::mojom::ThemePtr> {
  static bool IsNull(const ::side_panel::mojom::ThemePtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::ThemePtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::Theme::background_image)& background_image(
      const ::side_panel::mojom::ThemePtr& input) {
    return input->background_image;
  }

  static const decltype(::side_panel::mojom::Theme::third_party_theme_info)& third_party_theme_info(
      const ::side_panel::mojom::ThemePtr& input) {
    return input->third_party_theme_info;
  }

  static const decltype(::side_panel::mojom::Theme::background_color)& background_color(
      const ::side_panel::mojom::ThemePtr& input) {
    return input->background_color;
  }

  static const decltype(::side_panel::mojom::Theme::foreground_color)& foreground_color(
      const ::side_panel::mojom::ThemePtr& input) {
    return input->foreground_color;
  }

  static decltype(::side_panel::mojom::Theme::background_managed_by_policy) background_managed_by_policy(
      const ::side_panel::mojom::ThemePtr& input) {
    return input->background_managed_by_policy;
  }

  static decltype(::side_panel::mojom::Theme::follow_device_theme) follow_device_theme(
      const ::side_panel::mojom::ThemePtr& input) {
    return input->follow_device_theme;
  }

  static bool Read(::side_panel::mojom::Theme::DataView input, ::side_panel::mojom::ThemePtr* output);
};


template <>
struct  StructTraits<::side_panel::mojom::BackgroundCollection::DataView,
                                         ::side_panel::mojom::BackgroundCollectionPtr> {
  static bool IsNull(const ::side_panel::mojom::BackgroundCollectionPtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::BackgroundCollectionPtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::BackgroundCollection::id)& id(
      const ::side_panel::mojom::BackgroundCollectionPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::mojom::BackgroundCollection::label)& label(
      const ::side_panel::mojom::BackgroundCollectionPtr& input) {
    return input->label;
  }

  static const decltype(::side_panel::mojom::BackgroundCollection::preview_image_url)& preview_image_url(
      const ::side_panel::mojom::BackgroundCollectionPtr& input) {
    return input->preview_image_url;
  }

  static decltype(::side_panel::mojom::BackgroundCollection::image_verified) image_verified(
      const ::side_panel::mojom::BackgroundCollectionPtr& input) {
    return input->image_verified;
  }

  static bool Read(::side_panel::mojom::BackgroundCollection::DataView input, ::side_panel::mojom::BackgroundCollectionPtr* output);
};


template <>
struct  StructTraits<::side_panel::mojom::CollectionImage::DataView,
                                         ::side_panel::mojom::CollectionImagePtr> {
  static bool IsNull(const ::side_panel::mojom::CollectionImagePtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::CollectionImagePtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::CollectionImage::attribution_1)& attribution_1(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->attribution_1;
  }

  static const decltype(::side_panel::mojom::CollectionImage::attribution_2)& attribution_2(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->attribution_2;
  }

  static const decltype(::side_panel::mojom::CollectionImage::attribution_url)& attribution_url(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->attribution_url;
  }

  static const decltype(::side_panel::mojom::CollectionImage::image_url)& image_url(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->image_url;
  }

  static const decltype(::side_panel::mojom::CollectionImage::preview_image_url)& preview_image_url(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->preview_image_url;
  }

  static const decltype(::side_panel::mojom::CollectionImage::collection_id)& collection_id(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->collection_id;
  }

  static decltype(::side_panel::mojom::CollectionImage::image_verified) image_verified(
      const ::side_panel::mojom::CollectionImagePtr& input) {
    return input->image_verified;
  }

  static bool Read(::side_panel::mojom::CollectionImage::DataView input, ::side_panel::mojom::CollectionImagePtr* output);
};


template <>
struct  StructTraits<::side_panel::mojom::ModuleSettings::DataView,
                                         ::side_panel::mojom::ModuleSettingsPtr> {
  static bool IsNull(const ::side_panel::mojom::ModuleSettingsPtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::ModuleSettingsPtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::ModuleSettings::id)& id(
      const ::side_panel::mojom::ModuleSettingsPtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::mojom::ModuleSettings::name)& name(
      const ::side_panel::mojom::ModuleSettingsPtr& input) {
    return input->name;
  }

  static const decltype(::side_panel::mojom::ModuleSettings::description)& description(
      const ::side_panel::mojom::ModuleSettingsPtr& input) {
    return input->description;
  }

  static decltype(::side_panel::mojom::ModuleSettings::enabled) enabled(
      const ::side_panel::mojom::ModuleSettingsPtr& input) {
    return input->enabled;
  }

  static decltype(::side_panel::mojom::ModuleSettings::visible) visible(
      const ::side_panel::mojom::ModuleSettingsPtr& input) {
    return input->visible;
  }

  static bool Read(::side_panel::mojom::ModuleSettings::DataView input, ::side_panel::mojom::ModuleSettingsPtr* output);
};


template <>
struct  StructTraits<::side_panel::mojom::ManagementNoticeState::DataView,
                                         ::side_panel::mojom::ManagementNoticeStatePtr> {
  static bool IsNull(const ::side_panel::mojom::ManagementNoticeStatePtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::ManagementNoticeStatePtr* output) { output->reset(); }

  static decltype(::side_panel::mojom::ManagementNoticeState::can_be_shown) can_be_shown(
      const ::side_panel::mojom::ManagementNoticeStatePtr& input) {
    return input->can_be_shown;
  }

  static decltype(::side_panel::mojom::ManagementNoticeState::enabled_by_policy) enabled_by_policy(
      const ::side_panel::mojom::ManagementNoticeStatePtr& input) {
    return input->enabled_by_policy;
  }

  static bool Read(::side_panel::mojom::ManagementNoticeState::DataView input, ::side_panel::mojom::ManagementNoticeStatePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_H_