// chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared-internal.h"
#include "components/ntp_tiles/tile_type.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-data-view.h"




namespace std {

template <>
struct hash<::side_panel::mojom::CustomizeChromeSection>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::CustomizeChromeSection> {};

template <>
struct hash<::side_panel::mojom::ChromeWebStoreCollection>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::ChromeWebStoreCollection> {};

template <>
struct hash<::side_panel::mojom::ChromeWebStoreCategory>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::ChromeWebStoreCategory> {};

template <>
struct hash<::side_panel::mojom::NewTabPageType>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::NewTabPageType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::CustomizeChromeSection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::CustomizeChromeSection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::CustomizeChromeSection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ChromeWebStoreCollection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::ChromeWebStoreCollection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::ChromeWebStoreCollection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ChromeWebStoreCategory, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::ChromeWebStoreCategory, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::ChromeWebStoreCategory>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::NewTabPageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::NewTabPageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::NewTabPageType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::BackgroundImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::BackgroundImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::BackgroundImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BackgroundImage struct");

    decltype(Traits::snapshot_url(input)) in_snapshot_url = Traits::snapshot_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->snapshot_url)::BaseType> snapshot_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_snapshot_url,
      snapshot_url_fragment);

    fragment->snapshot_url.Set(
        snapshot_url_fragment.is_null() ? nullptr : snapshot_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->snapshot_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null snapshot_url in BackgroundImage struct");

    fragment->is_uploaded_image = Traits::is_uploaded_image(input);

    decltype(Traits::local_background_id(input)) in_local_background_id = Traits::local_background_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_background_id)::BaseType> local_background_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_local_background_id,
      local_background_id_fragment);

    fragment->local_background_id.Set(
        local_background_id_fragment.is_null() ? nullptr : local_background_id_fragment.data());

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in BackgroundImage struct");

    decltype(Traits::collection_id(input)) in_collection_id = Traits::collection_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->collection_id)::BaseType> collection_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_collection_id,
      collection_id_fragment);

    fragment->collection_id.Set(
        collection_id_fragment.is_null() ? nullptr : collection_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->collection_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null collection_id in BackgroundImage struct");

    fragment->daily_refresh_enabled = Traits::daily_refresh_enabled(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::BackgroundImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::BackgroundImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ThirdPartyThemeInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::ThirdPartyThemeInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::ThirdPartyThemeInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ThirdPartyThemeInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ThirdPartyThemeInfo struct");
  }

  static bool Deserialize(::side_panel::mojom::internal::ThirdPartyThemeInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::ThirdPartyThemeInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ThemeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::ThemeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::Theme_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::background_image(input)) in_background_image = Traits::background_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image)::BaseType> background_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::side_panel::mojom::BackgroundImageDataView>(
      in_background_image,
      background_image_fragment);

    fragment->background_image.Set(
        background_image_fragment.is_null() ? nullptr : background_image_fragment.data());

    decltype(Traits::third_party_theme_info(input)) in_third_party_theme_info = Traits::third_party_theme_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->third_party_theme_info)::BaseType> third_party_theme_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::side_panel::mojom::ThirdPartyThemeInfoDataView>(
      in_third_party_theme_info,
      third_party_theme_info_fragment);

    fragment->third_party_theme_info.Set(
        third_party_theme_info_fragment.is_null() ? nullptr : third_party_theme_info_fragment.data());

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in Theme struct");

    decltype(Traits::foreground_color(input)) in_foreground_color = Traits::foreground_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->foreground_color)::BaseType> foreground_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_foreground_color,
      foreground_color_fragment);

    fragment->foreground_color.Set(
        foreground_color_fragment.is_null() ? nullptr : foreground_color_fragment.data());

    fragment->background_managed_by_policy = Traits::background_managed_by_policy(input);

    fragment->follow_device_theme = Traits::follow_device_theme(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::Theme_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::ThemeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::BackgroundCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::BackgroundCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::BackgroundCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in BackgroundCollection struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in BackgroundCollection struct");

    decltype(Traits::preview_image_url(input)) in_preview_image_url = Traits::preview_image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preview_image_url)::BaseType> preview_image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_preview_image_url,
      preview_image_url_fragment);

    fragment->preview_image_url.Set(
        preview_image_url_fragment.is_null() ? nullptr : preview_image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->preview_image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preview_image_url in BackgroundCollection struct");

    fragment->image_verified = Traits::image_verified(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::BackgroundCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::BackgroundCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::CollectionImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::CollectionImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::CollectionImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::attribution_1(input)) in_attribution_1 = Traits::attribution_1(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_1)::BaseType> attribution_1_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_attribution_1,
      attribution_1_fragment);

    fragment->attribution_1.Set(
        attribution_1_fragment.is_null() ? nullptr : attribution_1_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attribution_1.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attribution_1 in CollectionImage struct");

    decltype(Traits::attribution_2(input)) in_attribution_2 = Traits::attribution_2(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_2)::BaseType> attribution_2_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_attribution_2,
      attribution_2_fragment);

    fragment->attribution_2.Set(
        attribution_2_fragment.is_null() ? nullptr : attribution_2_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attribution_2.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attribution_2 in CollectionImage struct");

    decltype(Traits::attribution_url(input)) in_attribution_url = Traits::attribution_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_url)::BaseType> attribution_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_attribution_url,
      attribution_url_fragment);

    fragment->attribution_url.Set(
        attribution_url_fragment.is_null() ? nullptr : attribution_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attribution_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attribution_url in CollectionImage struct");

    decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_url)::BaseType> image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_url,
      image_url_fragment);

    fragment->image_url.Set(
        image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_url in CollectionImage struct");

    decltype(Traits::preview_image_url(input)) in_preview_image_url = Traits::preview_image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preview_image_url)::BaseType> preview_image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_preview_image_url,
      preview_image_url_fragment);

    fragment->preview_image_url.Set(
        preview_image_url_fragment.is_null() ? nullptr : preview_image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->preview_image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preview_image_url in CollectionImage struct");

    decltype(Traits::collection_id(input)) in_collection_id = Traits::collection_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->collection_id)::BaseType> collection_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_collection_id,
      collection_id_fragment);

    fragment->collection_id.Set(
        collection_id_fragment.is_null() ? nullptr : collection_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->collection_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null collection_id in CollectionImage struct");

    fragment->image_verified = Traits::image_verified(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::CollectionImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::CollectionImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ModuleSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::ModuleSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::ModuleSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ModuleSettings struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ModuleSettings struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    fragment->enabled = Traits::enabled(input);

    fragment->visible = Traits::visible(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::ModuleSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::ModuleSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ManagementNoticeStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::ManagementNoticeStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::ManagementNoticeState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->can_be_shown = Traits::can_be_shown(input);

    fragment->enabled_by_policy = Traits::enabled_by_policy(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::ManagementNoticeState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::ManagementNoticeStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace side_panel::mojom {

inline void BackgroundImageDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetSnapshotUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->snapshot_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetLocalBackgroundIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->local_background_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetCollectionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->collection_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ThirdPartyThemeInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ThirdPartyThemeInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ThemeDataView::GetBackgroundImageDataView(
    BackgroundImageDataView* output) {
  auto pointer = data_->background_image.Get();
  *output = BackgroundImageDataView(pointer, message_);
}
inline void ThemeDataView::GetThirdPartyThemeInfoDataView(
    ThirdPartyThemeInfoDataView* output) {
  auto pointer = data_->third_party_theme_info.Get();
  *output = ThirdPartyThemeInfoDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetForegroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->foreground_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}


inline void BackgroundCollectionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundCollectionDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundCollectionDataView::GetPreviewImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->preview_image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void CollectionImageDataView::GetAttribution1DataView(
    mojo::StringDataView* output) {
  auto pointer = data_->attribution_1.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CollectionImageDataView::GetAttribution2DataView(
    mojo::StringDataView* output) {
  auto pointer = data_->attribution_2.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CollectionImageDataView::GetAttributionUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->attribution_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CollectionImageDataView::GetImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CollectionImageDataView::GetPreviewImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->preview_image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CollectionImageDataView::GetCollectionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->collection_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ModuleSettingsDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ModuleSettingsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ModuleSettingsDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // side_panel::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::CustomizeChromeSection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::CustomizeChromeSection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::ChromeWebStoreCollection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::ChromeWebStoreCollection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::ChromeWebStoreCategory> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::ChromeWebStoreCategory value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::NewTabPageType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::NewTabPageType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_SHARED_H_