// chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared-internal.h"
#include "components/ntp_tiles/tile_type.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace side_panel::mojom {
class BackgroundImageDataView;

class ThirdPartyThemeInfoDataView;

class ThemeDataView;

class BackgroundCollectionDataView;

class CollectionImageDataView;

class ModuleSettingsDataView;

class ManagementNoticeStateDataView;



}  // side_panel::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::side_panel::mojom::BackgroundImageDataView> {
  using Data = ::side_panel::mojom::internal::BackgroundImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::mojom::ThirdPartyThemeInfoDataView> {
  using Data = ::side_panel::mojom::internal::ThirdPartyThemeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::mojom::ThemeDataView> {
  using Data = ::side_panel::mojom::internal::Theme_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::mojom::BackgroundCollectionDataView> {
  using Data = ::side_panel::mojom::internal::BackgroundCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::mojom::CollectionImageDataView> {
  using Data = ::side_panel::mojom::internal::CollectionImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::mojom::ModuleSettingsDataView> {
  using Data = ::side_panel::mojom::internal::ModuleSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::side_panel::mojom::ManagementNoticeStateDataView> {
  using Data = ::side_panel::mojom::internal::ManagementNoticeState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace side_panel::mojom {


enum class CustomizeChromeSection : int32_t {
  
  kUnspecified = 0,
  
  kAppearance = 1,
  
  kShortcuts = 2,
  
  kModules = 3,
  
  kWallpaperSearch = 4,
  
  kToolbar = 5,
  
  kFooter = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, CustomizeChromeSection value);
inline bool IsKnownEnumValue(CustomizeChromeSection value) {
  return internal::CustomizeChromeSection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ChromeWebStoreCollection : int32_t {
  
  kWritingEssentials = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, ChromeWebStoreCollection value);
inline bool IsKnownEnumValue(ChromeWebStoreCollection value) {
  return internal::ChromeWebStoreCollection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ChromeWebStoreCategory : int32_t {
  
  kWorkflowPlanning = 0,
  
  kShopping = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ChromeWebStoreCategory value);
inline bool IsKnownEnumValue(ChromeWebStoreCategory value) {
  return internal::ChromeWebStoreCategory_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NewTabPageType : int32_t {
  
  kFirstPartyWebUI = 0,
  
  kThirdPartyWebUI = 1,
  
  kThirdPartyRemote = 2,
  
  kExtension = 3,
  
  kIncognito = 4,
  
  kGuestMode = 5,
  
  kNone = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, NewTabPageType value);
inline bool IsKnownEnumValue(NewTabPageType value) {
  return internal::NewTabPageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CustomizeChromePageHandlerFactoryInterfaceBase {};

using CustomizeChromePageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<CustomizeChromePageHandlerFactoryInterfaceBase>;
using CustomizeChromePageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CustomizeChromePageHandlerFactoryInterfaceBase>;
using CustomizeChromePageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomizeChromePageHandlerFactoryInterfaceBase>;
using CustomizeChromePageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomizeChromePageHandlerFactoryInterfaceBase>;
class CustomizeChromePageHandlerInterfaceBase {};

using CustomizeChromePageHandlerPtrDataView =
    mojo::InterfacePtrDataView<CustomizeChromePageHandlerInterfaceBase>;
using CustomizeChromePageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<CustomizeChromePageHandlerInterfaceBase>;
using CustomizeChromePageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomizeChromePageHandlerInterfaceBase>;
using CustomizeChromePageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomizeChromePageHandlerInterfaceBase>;
class CustomizeChromePageInterfaceBase {};

using CustomizeChromePagePtrDataView =
    mojo::InterfacePtrDataView<CustomizeChromePageInterfaceBase>;
using CustomizeChromePageRequestDataView =
    mojo::InterfaceRequestDataView<CustomizeChromePageInterfaceBase>;
using CustomizeChromePageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomizeChromePageInterfaceBase>;
using CustomizeChromePageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomizeChromePageInterfaceBase>;


class BackgroundImageDataView {
 public:
  BackgroundImageDataView() = default;

  BackgroundImageDataView(
      internal::BackgroundImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSnapshotUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSnapshotUrl(UserType* output) {
    
    auto* pointer = data_->snapshot_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_uploaded_image() const {
    return data_->is_uploaded_image;
  }
  inline void GetLocalBackgroundIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalBackgroundId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TokenDataView, UserType>(),
    "Attempting to read the optional `local_background_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalBackgroundId` instead "
    "of `ReadLocalBackgroundId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_background_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCollectionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCollectionId(UserType* output) {
    
    auto* pointer = data_->collection_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool daily_refresh_enabled() const {
    return data_->daily_refresh_enabled;
  }
 private:
  internal::BackgroundImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ThirdPartyThemeInfoDataView {
 public:
  ThirdPartyThemeInfoDataView() = default;

  ThirdPartyThemeInfoDataView(
      internal::ThirdPartyThemeInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ThirdPartyThemeInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ThemeDataView {
 public:
  ThemeDataView() = default;

  ThemeDataView(
      internal::Theme_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBackgroundImageDataView(
      BackgroundImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::mojom::BackgroundImageDataView, UserType>(),
    "Attempting to read the optional `background_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImage` instead "
    "of `ReadBackgroundImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image.Get();
    return mojo::internal::Deserialize<::side_panel::mojom::BackgroundImageDataView>(
        pointer, output, message_);
  }
  inline void GetThirdPartyThemeInfoDataView(
      ThirdPartyThemeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThirdPartyThemeInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::side_panel::mojom::ThirdPartyThemeInfoDataView, UserType>(),
    "Attempting to read the optional `third_party_theme_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadThirdPartyThemeInfo` instead "
    "of `ReadThirdPartyThemeInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->third_party_theme_info.Get();
    return mojo::internal::Deserialize<::side_panel::mojom::ThirdPartyThemeInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetForegroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForegroundColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `foreground_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadForegroundColor` instead "
    "of `ReadForegroundColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->foreground_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  bool background_managed_by_policy() const {
    return data_->background_managed_by_policy;
  }
  bool follow_device_theme() const {
    return data_->follow_device_theme;
  }
 private:
  internal::Theme_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundCollectionDataView {
 public:
  BackgroundCollectionDataView() = default;

  BackgroundCollectionDataView(
      internal::BackgroundCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPreviewImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviewImageUrl(UserType* output) {
    
    auto* pointer = data_->preview_image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool image_verified() const {
    return data_->image_verified;
  }
 private:
  internal::BackgroundCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CollectionImageDataView {
 public:
  CollectionImageDataView() = default;

  CollectionImageDataView(
      internal::CollectionImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAttribution1DataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttribution1(UserType* output) {
    
    auto* pointer = data_->attribution_1.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAttribution2DataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttribution2(UserType* output) {
    
    auto* pointer = data_->attribution_2.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionUrl(UserType* output) {
    
    auto* pointer = data_->attribution_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPreviewImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviewImageUrl(UserType* output) {
    
    auto* pointer = data_->preview_image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCollectionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCollectionId(UserType* output) {
    
    auto* pointer = data_->collection_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool image_verified() const {
    return data_->image_verified;
  }
 private:
  internal::CollectionImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModuleSettingsDataView {
 public:
  ModuleSettingsDataView() = default;

  ModuleSettingsDataView(
      internal::ModuleSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool enabled() const {
    return data_->enabled;
  }
  bool visible() const {
    return data_->visible;
  }
 private:
  internal::ModuleSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManagementNoticeStateDataView {
 public:
  ManagementNoticeStateDataView() = default;

  ManagementNoticeStateDataView(
      internal::ManagementNoticeState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_be_shown() const {
    return data_->can_be_shown;
  }
  bool enabled_by_policy() const {
    return data_->enabled_by_policy;
  }
 private:
  internal::ManagementNoticeState_Data* data_ = nullptr;
};


}  // side_panel::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_CUSTOMIZE_CHROME_CUSTOMIZE_CHROME_MOJOM_DATA_VIEW_H_