// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ClickModifiersSpec as ui_mojom_ClickModifiersSpec,
  ClickModifiers as ui_mojom_ClickModifiers
} from '//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js';
import {
  PointSpec as gfx_mojom_PointSpec,
  Point as gfx_mojom_Point
} from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';





export const ActionSourceSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ActionSource {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kBookmark = 0,
  kPriceTracking = 1,
}

export const SortOrderSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SortOrder {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kNewest = 0,
  kOldest = 1,
  kLastOpened = 2,
  kAlphabetical = 3,
  kReverseAlphabetical = 4,
  kCount = 5,
}

export const ViewTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ViewType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kCompact = 0,
  kExpanded = 1,
  kCount = 2,
}



export type BookmarksPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BookmarksPageHandlerFactoryPendingReceiver>;

export class BookmarksPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<BookmarksPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<BookmarksPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|BookmarksPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.mojom.BookmarksPageHandlerFactory',
        scope);
  }
}

export interface BookmarksPageHandlerFactoryInterface {
  createBookmarksPageHandler(page: BookmarksPageRemote, handler: BookmarksPageHandlerPendingReceiver): void;
}

export class BookmarksPageHandlerFactoryRemote implements BookmarksPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BookmarksPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BookmarksPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BookmarksPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BookmarksPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createBookmarksPageHandler(
      page: BookmarksPageRemote,
      handler: BookmarksPageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BookmarksPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BookmarksPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BookmarksPageHandlerFactoryRemote, BookmarksPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BookmarksPageHandlerFactoryRemote, BookmarksPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BookmarksPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BookmarksPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,
        null,
        impl.createBookmarksPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BookmarksPageHandlerFactory {
  static get $interfaceName(): string {
    return "side_panel.mojom.BookmarksPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BookmarksPageHandlerFactoryRemote {
    let remote = new BookmarksPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the BookmarksPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BookmarksPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BookmarksPageHandlerFactoryRemote, BookmarksPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BookmarksPageHandlerFactoryRemote, BookmarksPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createBookmarksPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BookmarksPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createBookmarksPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,
        null,
        this.createBookmarksPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type BookmarksPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BookmarksPageHandlerPendingReceiver>;

export class BookmarksPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<BookmarksPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<BookmarksPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|BookmarksPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.mojom.BookmarksPageHandler',
        scope);
  }
}

export interface BookmarksPageHandlerInterface {
  bookmarkCurrentTabInFolder(folderId: string): void;
  createFolder(folderId: string, title: string): Promise<{
        newFolderId: string, }>;
  dropBookmarks(folderId: string): Promise<void>;
  executeEditCommand(nodeIds: bigint[], source: ActionSource): void;
  executeMoveCommand(nodeIds: bigint[], source: ActionSource): void;
  executeOpenInNewTabCommand(sidePanelIds: string[], source: ActionSource): void;
  executeOpenInNewWindowCommand(sidePanelIds: string[], source: ActionSource): void;
  executeOpenInIncognitoWindowCommand(sidePanelIds: string[], source: ActionSource): void;
  executeOpenInNewTabGroupCommand(sidePanelIds: string[], source: ActionSource): void;
  executeOpenInSplitViewCommand(nodeIds: bigint[], source: ActionSource): void;
  executeAddToBookmarksBarCommand(nodeId: bigint, source: ActionSource): void;
  executeRemoveFromBookmarksBarCommand(nodeId: bigint, source: ActionSource): void;
  executeDeleteCommand(nodeIds: bigint[], source: ActionSource): void;
  openBookmark(nodeId: bigint, parentFolderDepth: number, clickModifiers: ui_mojom_ClickModifiers, source: ActionSource): void;
  undo(): void;
  renameBookmark(nodeId: bigint, newTitle: string): void;
  moveBookmark(nodeId: bigint, folderId: string): void;
  removeBookmarks(nodeIds: bigint[]): Promise<void>;
  setSortOrder(sortOrder: SortOrder): void;
  setViewType(viewType: ViewType): void;
  showContextMenu(id: string, point: gfx_mojom_Point, source: ActionSource): void;
  showUI(): void;
  getAllBookmarks(): Promise<{
        nodes: BookmarksTreeNode[], }>;
}

export class BookmarksPageHandlerRemote implements BookmarksPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BookmarksPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BookmarksPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BookmarksPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BookmarksPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  bookmarkCurrentTabInFolder(
      folderId: string): void {
    this.proxy.sendMessage(
        0,
        BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,
        null,
        [
          folderId
        ],
        false);
  }

  createFolder(
      folderId: string,
      title: string): Promise<{
        newFolderId: string, }> {
    return this.proxy.sendMessage(
        1,
        BookmarksPageHandler_CreateFolder_ParamsSpec.$,
        BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,
        [
          folderId,
          title
        ],
        false);
  }

  dropBookmarks(
      folderId: string): Promise<void> {
    return this.proxy.sendMessage(
        2,
        BookmarksPageHandler_DropBookmarks_ParamsSpec.$,
        BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,
        [
          folderId
        ],
        false);
  }

  executeEditCommand(
      nodeIds: bigint[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        3,
        BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        [
          nodeIds,
          source
        ],
        false);
  }

  executeMoveCommand(
      nodeIds: bigint[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        4,
        BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,
        null,
        [
          nodeIds,
          source
        ],
        false);
  }

  executeOpenInNewTabCommand(
      sidePanelIds: string[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        5,
        BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,
        null,
        [
          sidePanelIds,
          source
        ],
        false);
  }

  executeOpenInNewWindowCommand(
      sidePanelIds: string[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        6,
        BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,
        null,
        [
          sidePanelIds,
          source
        ],
        false);
  }

  executeOpenInIncognitoWindowCommand(
      sidePanelIds: string[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        7,
        BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,
        null,
        [
          sidePanelIds,
          source
        ],
        false);
  }

  executeOpenInNewTabGroupCommand(
      sidePanelIds: string[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        8,
        BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,
        null,
        [
          sidePanelIds,
          source
        ],
        false);
  }

  executeOpenInSplitViewCommand(
      nodeIds: bigint[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        9,
        BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,
        null,
        [
          nodeIds,
          source
        ],
        false);
  }

  executeAddToBookmarksBarCommand(
      nodeId: bigint,
      source: ActionSource): void {
    this.proxy.sendMessage(
        10,
        BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,
        null,
        [
          nodeId,
          source
        ],
        false);
  }

  executeRemoveFromBookmarksBarCommand(
      nodeId: bigint,
      source: ActionSource): void {
    this.proxy.sendMessage(
        11,
        BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,
        null,
        [
          nodeId,
          source
        ],
        false);
  }

  executeDeleteCommand(
      nodeIds: bigint[],
      source: ActionSource): void {
    this.proxy.sendMessage(
        12,
        BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,
        null,
        [
          nodeIds,
          source
        ],
        false);
  }

  openBookmark(
      nodeId: bigint,
      parentFolderDepth: number,
      clickModifiers: ui_mojom_ClickModifiers,
      source: ActionSource): void {
    this.proxy.sendMessage(
        13,
        BookmarksPageHandler_OpenBookmark_ParamsSpec.$,
        null,
        [
          nodeId,
          parentFolderDepth,
          clickModifiers,
          source
        ],
        false);
  }

  undo(): void {
    this.proxy.sendMessage(
        14,
        BookmarksPageHandler_Undo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  renameBookmark(
      nodeId: bigint,
      newTitle: string): void {
    this.proxy.sendMessage(
        15,
        BookmarksPageHandler_RenameBookmark_ParamsSpec.$,
        null,
        [
          nodeId,
          newTitle
        ],
        false);
  }

  moveBookmark(
      nodeId: bigint,
      folderId: string): void {
    this.proxy.sendMessage(
        16,
        BookmarksPageHandler_MoveBookmark_ParamsSpec.$,
        null,
        [
          nodeId,
          folderId
        ],
        false);
  }

  removeBookmarks(
      nodeIds: bigint[]): Promise<void> {
    return this.proxy.sendMessage(
        17,
        BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,
        BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,
        [
          nodeIds
        ],
        false);
  }

  setSortOrder(
      sortOrder: SortOrder): void {
    this.proxy.sendMessage(
        18,
        BookmarksPageHandler_SetSortOrder_ParamsSpec.$,
        null,
        [
          sortOrder
        ],
        false);
  }

  setViewType(
      viewType: ViewType): void {
    this.proxy.sendMessage(
        19,
        BookmarksPageHandler_SetViewType_ParamsSpec.$,
        null,
        [
          viewType
        ],
        false);
  }

  showContextMenu(
      id: string,
      point: gfx_mojom_Point,
      source: ActionSource): void {
    this.proxy.sendMessage(
        20,
        BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,
        null,
        [
          id,
          point,
          source
        ],
        false);
  }

  showUI(): void {
    this.proxy.sendMessage(
        21,
        BookmarksPageHandler_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getAllBookmarks(): Promise<{
        nodes: BookmarksTreeNode[], }> {
    return this.proxy.sendMessage(
        22,
        BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,
        BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BookmarksPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BookmarksPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BookmarksPageHandlerRemote, BookmarksPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BookmarksPageHandlerRemote, BookmarksPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BookmarksPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BookmarksPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,
        null,
        impl.bookmarkCurrentTabInFolder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BookmarksPageHandler_CreateFolder_ParamsSpec.$,
        BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,
        impl.createFolder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BookmarksPageHandler_DropBookmarks_ParamsSpec.$,
        BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,
        impl.dropBookmarks.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        impl.executeEditCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,
        null,
        impl.executeMoveCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,
        null,
        impl.executeOpenInNewTabCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,
        null,
        impl.executeOpenInNewWindowCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,
        null,
        impl.executeOpenInIncognitoWindowCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,
        null,
        impl.executeOpenInNewTabGroupCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,
        null,
        impl.executeOpenInSplitViewCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,
        null,
        impl.executeAddToBookmarksBarCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,
        null,
        impl.executeRemoveFromBookmarksBarCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,
        null,
        impl.executeDeleteCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        BookmarksPageHandler_OpenBookmark_ParamsSpec.$,
        null,
        impl.openBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        BookmarksPageHandler_Undo_ParamsSpec.$,
        null,
        impl.undo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        BookmarksPageHandler_RenameBookmark_ParamsSpec.$,
        null,
        impl.renameBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        BookmarksPageHandler_MoveBookmark_ParamsSpec.$,
        null,
        impl.moveBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,
        BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,
        impl.removeBookmarks.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        BookmarksPageHandler_SetSortOrder_ParamsSpec.$,
        null,
        impl.setSortOrder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        BookmarksPageHandler_SetViewType_ParamsSpec.$,
        null,
        impl.setViewType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,
        null,
        impl.showContextMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        BookmarksPageHandler_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,
        BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,
        impl.getAllBookmarks.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BookmarksPageHandler {
  static get $interfaceName(): string {
    return "side_panel.mojom.BookmarksPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BookmarksPageHandlerRemote {
    let remote = new BookmarksPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the BookmarksPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BookmarksPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BookmarksPageHandlerRemote, BookmarksPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BookmarksPageHandlerRemote, BookmarksPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  bookmarkCurrentTabInFolder: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createFolder: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dropBookmarks: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeEditCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeMoveCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeOpenInNewTabCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeOpenInNewWindowCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeOpenInIncognitoWindowCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeOpenInNewTabGroupCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeOpenInSplitViewCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeAddToBookmarksBarCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeRemoveFromBookmarksBarCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeDeleteCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  undo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  renameBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  moveBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeBookmarks: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSortOrder: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setViewType: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showContextMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllBookmarks: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BookmarksPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.bookmarkCurrentTabInFolder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,
        null,
        this.bookmarkCurrentTabInFolder.createReceiverHandler(false /* expectsResponse */),
        false);
    this.createFolder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BookmarksPageHandler_CreateFolder_ParamsSpec.$,
        BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,
        this.createFolder.createReceiverHandler(true /* expectsResponse */),
        false);
    this.dropBookmarks =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BookmarksPageHandler_DropBookmarks_ParamsSpec.$,
        BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,
        this.dropBookmarks.createReceiverHandler(true /* expectsResponse */),
        false);
    this.executeEditCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        this.executeEditCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeMoveCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,
        null,
        this.executeMoveCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeOpenInNewTabCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,
        null,
        this.executeOpenInNewTabCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeOpenInNewWindowCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,
        null,
        this.executeOpenInNewWindowCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeOpenInIncognitoWindowCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,
        null,
        this.executeOpenInIncognitoWindowCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeOpenInNewTabGroupCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,
        null,
        this.executeOpenInNewTabGroupCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeOpenInSplitViewCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,
        null,
        this.executeOpenInSplitViewCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeAddToBookmarksBarCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,
        null,
        this.executeAddToBookmarksBarCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeRemoveFromBookmarksBarCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,
        null,
        this.executeRemoveFromBookmarksBarCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeDeleteCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,
        null,
        this.executeDeleteCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        BookmarksPageHandler_OpenBookmark_ParamsSpec.$,
        null,
        this.openBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.undo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        BookmarksPageHandler_Undo_ParamsSpec.$,
        null,
        this.undo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.renameBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        BookmarksPageHandler_RenameBookmark_ParamsSpec.$,
        null,
        this.renameBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.moveBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        BookmarksPageHandler_MoveBookmark_ParamsSpec.$,
        null,
        this.moveBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeBookmarks =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,
        BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,
        this.removeBookmarks.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setSortOrder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        BookmarksPageHandler_SetSortOrder_ParamsSpec.$,
        null,
        this.setSortOrder.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setViewType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        BookmarksPageHandler_SetViewType_ParamsSpec.$,
        null,
        this.setViewType.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showContextMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,
        null,
        this.showContextMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        BookmarksPageHandler_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getAllBookmarks =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,
        BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,
        this.getAllBookmarks.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type BookmarksPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BookmarksPagePendingReceiver>;

export class BookmarksPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<BookmarksPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<BookmarksPagePendingReceiver>;
  constructor(handle: MojoHandle|BookmarksPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.mojom.BookmarksPage',
        scope);
  }
}

export interface BookmarksPageInterface {
  onBookmarkNodeAdded(node: BookmarksTreeNode): void;
  onBookmarkNodesRemoved(nodeIds: string[]): void;
  onBookmarkParentFolderChildrenReordered(folderId: string, childrenOrderedIds: string[]): void;
  onBookmarkNodeMoved(oldParentIndex: string, oldNodeIndex: number, newParentIndex: string, newNodeIndex: number): void;
  onBookmarkNodeChanged(id: string, newTitle: string, newUrl: string): void;
}

export class BookmarksPageRemote implements BookmarksPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BookmarksPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BookmarksPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BookmarksPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BookmarksPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onBookmarkNodeAdded(
      node: BookmarksTreeNode): void {
    this.proxy.sendMessage(
        0,
        BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,
        null,
        [
          node
        ],
        false);
  }

  onBookmarkNodesRemoved(
      nodeIds: string[]): void {
    this.proxy.sendMessage(
        1,
        BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,
        null,
        [
          nodeIds
        ],
        false);
  }

  onBookmarkParentFolderChildrenReordered(
      folderId: string,
      childrenOrderedIds: string[]): void {
    this.proxy.sendMessage(
        2,
        BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,
        null,
        [
          folderId,
          childrenOrderedIds
        ],
        false);
  }

  onBookmarkNodeMoved(
      oldParentIndex: string,
      oldNodeIndex: number,
      newParentIndex: string,
      newNodeIndex: number): void {
    this.proxy.sendMessage(
        3,
        BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,
        null,
        [
          oldParentIndex,
          oldNodeIndex,
          newParentIndex,
          newNodeIndex
        ],
        false);
  }

  onBookmarkNodeChanged(
      id: string,
      newTitle: string,
      newUrl: string): void {
    this.proxy.sendMessage(
        4,
        BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,
        null,
        [
          id,
          newTitle,
          newUrl
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BookmarksPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BookmarksPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BookmarksPageRemote, BookmarksPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BookmarksPageRemote, BookmarksPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BookmarksPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BookmarksPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,
        null,
        impl.onBookmarkNodeAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,
        null,
        impl.onBookmarkNodesRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,
        null,
        impl.onBookmarkParentFolderChildrenReordered.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,
        null,
        impl.onBookmarkNodeMoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,
        null,
        impl.onBookmarkNodeChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BookmarksPage {
  static get $interfaceName(): string {
    return "side_panel.mojom.BookmarksPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BookmarksPageRemote {
    let remote = new BookmarksPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the BookmarksPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BookmarksPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BookmarksPageRemote, BookmarksPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BookmarksPageRemote, BookmarksPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onBookmarkNodeAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onBookmarkNodesRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onBookmarkParentFolderChildrenReordered: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onBookmarkNodeMoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onBookmarkNodeChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BookmarksPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onBookmarkNodeAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,
        null,
        this.onBookmarkNodeAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onBookmarkNodesRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,
        null,
        this.onBookmarkNodesRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onBookmarkParentFolderChildrenReordered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,
        null,
        this.onBookmarkParentFolderChildrenReordered.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onBookmarkNodeMoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,
        null,
        this.onBookmarkNodeMoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onBookmarkNodeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,
        null,
        this.onBookmarkNodeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const BookmarksTreeNodeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_CreateFolder_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_CreateFolder_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_DropBookmarks_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_DropBookmarks_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteEditCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_OpenBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_Undo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_RenameBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_MoveBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_RemoveBookmarks_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_SetSortOrder_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_SetViewType_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ShowContextMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_ShowUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_GetAllBookmarks_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPage_OnBookmarkNodeAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPage_OnBookmarkNodeMoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BookmarksPage_OnBookmarkNodeChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface BookmarksTreeNodeMojoType {
  id: string;
  parentId: string;
  index: number;
  dateAdded: (number | null);
  dateLastUsed: (number | null);
  unmodifiable: boolean;
  title: string;
  url: (string | null);
  children: (BookmarksTreeNode[] | null);
}


export type BookmarksTreeNode = BookmarksTreeNodeMojoType;
mojo.internal.Struct<BookmarksTreeNodeMojoType>(
    BookmarksTreeNodeSpec.$,
    'BookmarksTreeNode',
    [
      mojo.internal.StructField<BookmarksTreeNodeMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, string>(
        'parentId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, number>(
        'index', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, string>(
        'title', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, string>(
        'url', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, BookmarksTreeNode[]>(
        'children', 40,
        0,
        mojo.internal.Array(BookmarksTreeNodeSpec.$, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, boolean>(
        'date_added_$flag', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "date_added_$value",
          originalFieldName: "dateAdded",
        },
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, number>(
        'date_added_$value', 48,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "dateAdded",
        },
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, boolean>(
        'date_last_used_$flag', 20,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "date_last_used_$value",
          originalFieldName: "dateLastUsed",
        },
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, number>(
        'date_last_used_$value', 56,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "dateLastUsed",
        },
        undefined,
    ),
      mojo.internal.StructField<BookmarksTreeNodeMojoType, boolean>(
        'unmodifiable', 20,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 72],]);





export interface BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsMojoType {
  page: BookmarksPageRemote;
  handler: BookmarksPageHandlerPendingReceiver;
}


export type BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params = BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsMojoType>(
    BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,
    'BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params',
    [
      mojo.internal.StructField<BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsMojoType, BookmarksPageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(BookmarksPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsMojoType, BookmarksPageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(BookmarksPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsMojoType {
  folderId: string;
}


export type BookmarksPageHandler_BookmarkCurrentTabInFolder_Params = BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsMojoType>(
    BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,
    'BookmarksPageHandler_BookmarkCurrentTabInFolder_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsMojoType, string>(
        'folderId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPageHandler_CreateFolder_ParamsMojoType {
  folderId: string;
  title: string;
}


export type BookmarksPageHandler_CreateFolder_Params = BookmarksPageHandler_CreateFolder_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_CreateFolder_ParamsMojoType>(
    BookmarksPageHandler_CreateFolder_ParamsSpec.$,
    'BookmarksPageHandler_CreateFolder_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_CreateFolder_ParamsMojoType, string>(
        'folderId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_CreateFolder_ParamsMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_CreateFolder_ResponseParamsMojoType {
  newFolderId: string;
}


export type BookmarksPageHandler_CreateFolder_ResponseParams = BookmarksPageHandler_CreateFolder_ResponseParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_CreateFolder_ResponseParamsMojoType>(
    BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,
    'BookmarksPageHandler_CreateFolder_ResponseParams',
    [
      mojo.internal.StructField<BookmarksPageHandler_CreateFolder_ResponseParamsMojoType, string>(
        'newFolderId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPageHandler_DropBookmarks_ParamsMojoType {
  folderId: string;
}


export type BookmarksPageHandler_DropBookmarks_Params = BookmarksPageHandler_DropBookmarks_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_DropBookmarks_ParamsMojoType>(
    BookmarksPageHandler_DropBookmarks_ParamsSpec.$,
    'BookmarksPageHandler_DropBookmarks_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_DropBookmarks_ParamsMojoType, string>(
        'folderId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPageHandler_DropBookmarks_ResponseParamsMojoType {
}


export type BookmarksPageHandler_DropBookmarks_ResponseParams = BookmarksPageHandler_DropBookmarks_ResponseParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_DropBookmarks_ResponseParamsMojoType>(
    BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,
    'BookmarksPageHandler_DropBookmarks_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface BookmarksPageHandler_ExecuteEditCommand_ParamsMojoType {
  nodeIds: bigint[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteEditCommand_Params = BookmarksPageHandler_ExecuteEditCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteEditCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteEditCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteEditCommand_ParamsMojoType, bigint[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteEditCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteMoveCommand_ParamsMojoType {
  nodeIds: bigint[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteMoveCommand_Params = BookmarksPageHandler_ExecuteMoveCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteMoveCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteMoveCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteMoveCommand_ParamsMojoType, bigint[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteMoveCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsMojoType {
  sidePanelIds: string[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params = BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsMojoType, string[]>(
        'sidePanelIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsMojoType {
  sidePanelIds: string[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params = BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsMojoType, string[]>(
        'sidePanelIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsMojoType {
  sidePanelIds: string[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params = BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsMojoType, string[]>(
        'sidePanelIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsMojoType {
  sidePanelIds: string[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params = BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsMojoType, string[]>(
        'sidePanelIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsMojoType {
  nodeIds: bigint[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params = BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsMojoType, bigint[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsMojoType {
  nodeId: bigint;
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params = BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsMojoType {
  nodeId: bigint;
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params = BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_ExecuteDeleteCommand_ParamsMojoType {
  nodeIds: bigint[];
  source: ActionSource;
}


export type BookmarksPageHandler_ExecuteDeleteCommand_Params = BookmarksPageHandler_ExecuteDeleteCommand_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ExecuteDeleteCommand_ParamsMojoType>(
    BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,
    'BookmarksPageHandler_ExecuteDeleteCommand_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ExecuteDeleteCommand_ParamsMojoType, bigint[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ExecuteDeleteCommand_ParamsMojoType, ActionSource>(
        'source', 8,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_OpenBookmark_ParamsMojoType {
  nodeId: bigint;
  parentFolderDepth: number;
  source: ActionSource;
  clickModifiers: ui_mojom_ClickModifiers;
}


export type BookmarksPageHandler_OpenBookmark_Params = BookmarksPageHandler_OpenBookmark_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_OpenBookmark_ParamsMojoType>(
    BookmarksPageHandler_OpenBookmark_ParamsSpec.$,
    'BookmarksPageHandler_OpenBookmark_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_OpenBookmark_ParamsMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_OpenBookmark_ParamsMojoType, number>(
        'parentFolderDepth', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_OpenBookmark_ParamsMojoType, ui_mojom_ClickModifiers>(
        'clickModifiers', 16,
        0,
        ui_mojom_ClickModifiersSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_OpenBookmark_ParamsMojoType, ActionSource>(
        'source', 12,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface BookmarksPageHandler_Undo_ParamsMojoType {
}


export type BookmarksPageHandler_Undo_Params = BookmarksPageHandler_Undo_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_Undo_ParamsMojoType>(
    BookmarksPageHandler_Undo_ParamsSpec.$,
    'BookmarksPageHandler_Undo_Params',
    [
    ],
    [[0, 8],]);





export interface BookmarksPageHandler_RenameBookmark_ParamsMojoType {
  nodeId: bigint;
  newTitle: string;
}


export type BookmarksPageHandler_RenameBookmark_Params = BookmarksPageHandler_RenameBookmark_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_RenameBookmark_ParamsMojoType>(
    BookmarksPageHandler_RenameBookmark_ParamsSpec.$,
    'BookmarksPageHandler_RenameBookmark_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_RenameBookmark_ParamsMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_RenameBookmark_ParamsMojoType, string>(
        'newTitle', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_MoveBookmark_ParamsMojoType {
  nodeId: bigint;
  folderId: string;
}


export type BookmarksPageHandler_MoveBookmark_Params = BookmarksPageHandler_MoveBookmark_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_MoveBookmark_ParamsMojoType>(
    BookmarksPageHandler_MoveBookmark_ParamsSpec.$,
    'BookmarksPageHandler_MoveBookmark_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_MoveBookmark_ParamsMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_MoveBookmark_ParamsMojoType, string>(
        'folderId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPageHandler_RemoveBookmarks_ParamsMojoType {
  nodeIds: bigint[];
}


export type BookmarksPageHandler_RemoveBookmarks_Params = BookmarksPageHandler_RemoveBookmarks_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_RemoveBookmarks_ParamsMojoType>(
    BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,
    'BookmarksPageHandler_RemoveBookmarks_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_RemoveBookmarks_ParamsMojoType, bigint[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPageHandler_RemoveBookmarks_ResponseParamsMojoType {
}


export type BookmarksPageHandler_RemoveBookmarks_ResponseParams = BookmarksPageHandler_RemoveBookmarks_ResponseParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_RemoveBookmarks_ResponseParamsMojoType>(
    BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,
    'BookmarksPageHandler_RemoveBookmarks_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface BookmarksPageHandler_SetSortOrder_ParamsMojoType {
  sortOrder: SortOrder;
}


export type BookmarksPageHandler_SetSortOrder_Params = BookmarksPageHandler_SetSortOrder_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_SetSortOrder_ParamsMojoType>(
    BookmarksPageHandler_SetSortOrder_ParamsSpec.$,
    'BookmarksPageHandler_SetSortOrder_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_SetSortOrder_ParamsMojoType, SortOrder>(
        'sortOrder', 0,
        0,
        SortOrderSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPageHandler_SetViewType_ParamsMojoType {
  viewType: ViewType;
}


export type BookmarksPageHandler_SetViewType_Params = BookmarksPageHandler_SetViewType_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_SetViewType_ParamsMojoType>(
    BookmarksPageHandler_SetViewType_ParamsSpec.$,
    'BookmarksPageHandler_SetViewType_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_SetViewType_ParamsMojoType, ViewType>(
        'viewType', 0,
        0,
        ViewTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPageHandler_ShowContextMenu_ParamsMojoType {
  id: string;
  point: gfx_mojom_Point;
  source: ActionSource;
}


export type BookmarksPageHandler_ShowContextMenu_Params = BookmarksPageHandler_ShowContextMenu_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ShowContextMenu_ParamsMojoType>(
    BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,
    'BookmarksPageHandler_ShowContextMenu_Params',
    [
      mojo.internal.StructField<BookmarksPageHandler_ShowContextMenu_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ShowContextMenu_ParamsMojoType, gfx_mojom_Point>(
        'point', 8,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPageHandler_ShowContextMenu_ParamsMojoType, ActionSource>(
        'source', 16,
        0,
        ActionSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface BookmarksPageHandler_ShowUI_ParamsMojoType {
}


export type BookmarksPageHandler_ShowUI_Params = BookmarksPageHandler_ShowUI_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_ShowUI_ParamsMojoType>(
    BookmarksPageHandler_ShowUI_ParamsSpec.$,
    'BookmarksPageHandler_ShowUI_Params',
    [
    ],
    [[0, 8],]);





export interface BookmarksPageHandler_GetAllBookmarks_ParamsMojoType {
}


export type BookmarksPageHandler_GetAllBookmarks_Params = BookmarksPageHandler_GetAllBookmarks_ParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_GetAllBookmarks_ParamsMojoType>(
    BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,
    'BookmarksPageHandler_GetAllBookmarks_Params',
    [
    ],
    [[0, 8],]);





export interface BookmarksPageHandler_GetAllBookmarks_ResponseParamsMojoType {
  nodes: BookmarksTreeNode[];
}


export type BookmarksPageHandler_GetAllBookmarks_ResponseParams = BookmarksPageHandler_GetAllBookmarks_ResponseParamsMojoType;
mojo.internal.Struct<BookmarksPageHandler_GetAllBookmarks_ResponseParamsMojoType>(
    BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,
    'BookmarksPageHandler_GetAllBookmarks_ResponseParams',
    [
      mojo.internal.StructField<BookmarksPageHandler_GetAllBookmarks_ResponseParamsMojoType, BookmarksTreeNode[]>(
        'nodes', 0,
        0,
        mojo.internal.Array(BookmarksTreeNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPage_OnBookmarkNodeAdded_ParamsMojoType {
  node: BookmarksTreeNode;
}


export type BookmarksPage_OnBookmarkNodeAdded_Params = BookmarksPage_OnBookmarkNodeAdded_ParamsMojoType;
mojo.internal.Struct<BookmarksPage_OnBookmarkNodeAdded_ParamsMojoType>(
    BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,
    'BookmarksPage_OnBookmarkNodeAdded_Params',
    [
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeAdded_ParamsMojoType, BookmarksTreeNode>(
        'node', 0,
        0,
        BookmarksTreeNodeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPage_OnBookmarkNodesRemoved_ParamsMojoType {
  nodeIds: string[];
}


export type BookmarksPage_OnBookmarkNodesRemoved_Params = BookmarksPage_OnBookmarkNodesRemoved_ParamsMojoType;
mojo.internal.Struct<BookmarksPage_OnBookmarkNodesRemoved_ParamsMojoType>(
    BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,
    'BookmarksPage_OnBookmarkNodesRemoved_Params',
    [
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodesRemoved_ParamsMojoType, string[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsMojoType {
  folderId: string;
  childrenOrderedIds: string[];
}


export type BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params = BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsMojoType;
mojo.internal.Struct<BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsMojoType>(
    BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,
    'BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params',
    [
      mojo.internal.StructField<BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsMojoType, string>(
        'folderId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsMojoType, string[]>(
        'childrenOrderedIds', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType {
  oldParentIndex: string;
  oldNodeIndex: number;
  newNodeIndex: number;
  newParentIndex: string;
}


export type BookmarksPage_OnBookmarkNodeMoved_Params = BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType;
mojo.internal.Struct<BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType>(
    BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,
    'BookmarksPage_OnBookmarkNodeMoved_Params',
    [
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType, string>(
        'oldParentIndex', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType, number>(
        'oldNodeIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType, string>(
        'newParentIndex', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeMoved_ParamsMojoType, number>(
        'newNodeIndex', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface BookmarksPage_OnBookmarkNodeChanged_ParamsMojoType {
  id: string;
  newTitle: string;
  newUrl: string;
}


export type BookmarksPage_OnBookmarkNodeChanged_Params = BookmarksPage_OnBookmarkNodeChanged_ParamsMojoType;
mojo.internal.Struct<BookmarksPage_OnBookmarkNodeChanged_ParamsMojoType>(
    BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,
    'BookmarksPage_OnBookmarkNodeChanged_Params',
    [
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeChanged_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeChanged_ParamsMojoType, string>(
        'newTitle', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BookmarksPage_OnBookmarkNodeChanged_ParamsMojoType, string>(
        'newUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);



