// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared-internal.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-data-view.h"




namespace std {

template <>
struct hash<::side_panel::mojom::ActionSource>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::ActionSource> {};

template <>
struct hash<::side_panel::mojom::SortOrder>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::SortOrder> {};

template <>
struct hash<::side_panel::mojom::ViewType>
    : public mojo::internal::EnumHashImpl<::side_panel::mojom::ViewType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ActionSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::ActionSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::ActionSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::SortOrder, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::SortOrder, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::SortOrder>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::ViewType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::side_panel::mojom::ViewType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::side_panel::mojom::ViewType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::side_panel::mojom::BookmarksTreeNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::side_panel::mojom::BookmarksTreeNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::side_panel::mojom::internal::BookmarksTreeNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in BookmarksTreeNode struct");

    decltype(Traits::parent_id(input)) in_parent_id = Traits::parent_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parent_id)::BaseType> parent_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_parent_id,
      parent_id_fragment);

    fragment->parent_id.Set(
        parent_id_fragment.is_null() ? nullptr : parent_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parent_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_id in BookmarksTreeNode struct");

    fragment->index = Traits::index(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in BookmarksTreeNode struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::mojom::BookmarksTreeNodeDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());
    fragment->date_added_$flag = Traits::date_added(input).has_value();
    if (Traits::date_added(input).has_value()) {
      fragment->date_added_$value = Traits::date_added(input).value();
    }
    fragment->date_last_used_$flag = Traits::date_last_used(input).has_value();
    if (Traits::date_last_used(input).has_value()) {
      fragment->date_last_used_$value = Traits::date_last_used(input).value();
    }

    fragment->unmodifiable = Traits::unmodifiable(input);
  }

  static bool Deserialize(::side_panel::mojom::internal::BookmarksTreeNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::side_panel::mojom::BookmarksTreeNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace side_panel::mojom {

inline void BookmarksTreeNodeDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BookmarksTreeNodeDataView::GetParentIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->parent_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BookmarksTreeNodeDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BookmarksTreeNodeDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BookmarksTreeNodeDataView::GetChildrenDataView(
    mojo::ArrayDataView<BookmarksTreeNodeDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<BookmarksTreeNodeDataView>(pointer, message_);
}



}  // side_panel::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::ActionSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::ActionSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::SortOrder> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::SortOrder value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::side_panel::mojom::ViewType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::side_panel::mojom::ViewType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_SHARED_H_