// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared-internal.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace side_panel::mojom {
class BookmarksTreeNodeDataView;



}  // side_panel::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::side_panel::mojom::BookmarksTreeNodeDataView> {
  using Data = ::side_panel::mojom::internal::BookmarksTreeNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace side_panel::mojom {


enum class ActionSource : int32_t {
  
  kBookmark = 0,
  
  kPriceTracking = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ActionSource value);
inline bool IsKnownEnumValue(ActionSource value) {
  return internal::ActionSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SortOrder : int32_t {
  
  kNewest = 0,
  
  kOldest = 1,
  
  kLastOpened = 2,
  
  kAlphabetical = 3,
  
  kReverseAlphabetical = 4,
  
  kCount = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SortOrder value);
inline bool IsKnownEnumValue(SortOrder value) {
  return internal::SortOrder_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ViewType : int32_t {
  
  kCompact = 0,
  
  kExpanded = 1,
  
  kCount = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ViewType value);
inline bool IsKnownEnumValue(ViewType value) {
  return internal::ViewType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BookmarksPageHandlerFactoryInterfaceBase {};

using BookmarksPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<BookmarksPageHandlerFactoryInterfaceBase>;
using BookmarksPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<BookmarksPageHandlerFactoryInterfaceBase>;
using BookmarksPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BookmarksPageHandlerFactoryInterfaceBase>;
using BookmarksPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BookmarksPageHandlerFactoryInterfaceBase>;
class BookmarksPageHandlerInterfaceBase {};

using BookmarksPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<BookmarksPageHandlerInterfaceBase>;
using BookmarksPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<BookmarksPageHandlerInterfaceBase>;
using BookmarksPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BookmarksPageHandlerInterfaceBase>;
using BookmarksPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BookmarksPageHandlerInterfaceBase>;
class BookmarksPageInterfaceBase {};

using BookmarksPagePtrDataView =
    mojo::InterfacePtrDataView<BookmarksPageInterfaceBase>;
using BookmarksPageRequestDataView =
    mojo::InterfaceRequestDataView<BookmarksPageInterfaceBase>;
using BookmarksPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BookmarksPageInterfaceBase>;
using BookmarksPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BookmarksPageInterfaceBase>;


class BookmarksTreeNodeDataView {
 public:
  BookmarksTreeNodeDataView() = default;

  BookmarksTreeNodeDataView(
      internal::BookmarksTreeNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParentIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentId(UserType* output) {
    
    auto* pointer = data_->parent_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t index() const {
    return data_->index;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<BookmarksTreeNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::side_panel::mojom::BookmarksTreeNodeDataView>, UserType>(),
    "Attempting to read the optional `children` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChildren` instead "
    "of `ReadChildren if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::side_panel::mojom::BookmarksTreeNodeDataView>>(
        pointer, output, message_);
  }
  std::optional<double> date_added() const {

    return data_->date_added_$flag
        ? std::make_optional(data_->date_added_$value)
        : std::nullopt;
  }
  std::optional<double> date_last_used() const {

    return data_->date_last_used_$flag
        ? std::make_optional(data_->date_last_used_$value)
        : std::nullopt;
  }
  bool unmodifiable() const {
    return data_->unmodifiable;
  }
 private:
  internal::BookmarksTreeNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // side_panel::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_DATA_VIEW_H_